use cs_utils::{WriteFormatter, random_str, random_number};

fn main() {
    let mut formatter = WriteFormatter::new(
        50,
        "  ",
        std::io::stdout(),
    );

    formatter.caption("Start:");
    formatter.line_start("Line Start");
    formatter.underline();

    formatter.value_line("Value1", random_str(4));
    formatter.value_line("Value2", random_str(4));
    formatter.value_line("Value3", random_number(0..=u32::MAX));
    formatter.value_line("Value4", random_str(4));
    formatter.underline();
    formatter.line_end("Line End");
    
    formatter.line("");

    // OR

    struct TestStruct {}

    impl std::fmt::Debug for TestStruct {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            // f.debug_struct("TestStruct").finish()

            let mut formatter = WriteFormatter::new_from_fmt(
                50,
                "  ",
                f,
            );

            formatter.caption("Start:");
            formatter.line_start("Line Start");
            formatter.underline();

            formatter.value_line("Value1", random_str(4));
            formatter.value_line("Value2", random_str(4));
            formatter.value_line("Value3", random_number(0..=u32::MAX));
            formatter.value_line("Value4", random_str(4));
            formatter.underline();
            formatter.line_end("Line End");
            
            formatter.line("");

            return Ok(());
        }
    }

    println!("{:?}", TestStruct {});
}
