
/// Random trait allows a common way to generate
/// some random struct, usually for testing purposes.
/// 
/// ## Examples
/// ```
/// use cs_utils::traits::Random;
/// use cs_utils::{random_number, random_str};
/// 
/// #[derive(Debug)]
/// struct SomeStruct {
///     id: u16,
///     name: String,
/// }
/// 
/// impl Random for SomeStruct {
///     fn random() -> Self {
///         return SomeStruct {
///             id: random_number(0..=u16::MAX),
///             name: random_str(10),
///         };
///     }
/// }
/// 
/// let random_struct = SomeStruct::random();
/// println!("{:?}", &random_struct);
/// ```
pub trait Random {
    fn random() -> Self;
}
