use cs_utils::random_number;

/// Examples for the `random_number` utility.
/// 
/// * example1 shows how to generate a random `i64` numbers with non-inclusive range.
/// * example2 shows how to generate a random `u128` numbers with inclusive range (max is included).
fn main() {
    // - example 1

    let min: i64 = -20;
    let max: i64 = 20;

    let mut i = random_number(5..20);

    println!("\n-- `random_number` utility example ({} numbers, non-inclusive, signed int):\n", &i);

    let mut result = vec![];
    while i > 0 {
        let number = random_number(min..max);

        result.push(number);

        assert!(number >= min);
        assert!(number < max);

        i -= 1;
    }

    println!("generated: {:?}", &result);

    // - example 2

    let min: u128 = 0;
    let max: u128 = 20;

    let mut i = random_number(5..20);

    println!("\n-- `random_number` utility example ({} numbers, inclusive, unsigned int):\n", &i);

    let mut result = vec![];
    while i > 0 {
        let number = random_number(min..=max);

        result.push(number);

        assert!(number >= min);
        assert!(number <= max);

        i -= 1;
    }

    println!("generated: {:?}", &result);
    println!("\n");
}
