
/// Swap two items.
/// 
/// ### Examples
/// 
/// ```
/// use cs_utils::{swap, random_str, random_number};
/// 
/// let item1 = random_str(10);
/// let item2 = random_number(0..=u64::MAX);
/// 
/// let original_item1 = item1.clone();
/// let original_item2 = item2.clone();
/// 
/// let (item1, item2) = swap(item1, item2);
/// 
/// assert_eq!(item1, original_item2);
/// assert_eq!(item2, original_item1);
/// ```
pub fn swap<T, R>(
    stream1: T,
    stream2: R,
) -> (R, T) {
    return (stream2, stream1);
}
