// use std::fmt::{self, Write};

// /// Formatter aims to help to write nice log output.
// /// 
// /// ### Examples
// /// 
// /// ```
// /// ```
// pub struct LogFormatter<'a, 'b> {
//     formatter: &'a mut fmt::Formatter<'b>,
//     total_width: usize,
//     ident: String,
// }

// // formatter.write_fmt(format_args!("\nDNS record:"))?;

// // // TODO: use one from utils-rs
// // let mut packet_formatter = NetworkPacketFormatter::new(
// //     formatter,
// //     50,
// //     "  ",
// // );

// // packet_formatter.write("Hostname:", &self.hostname())?;
// // packet_formatter.write("IP Address:", &self.ip_address())?;
// // packet_formatter.write("TTL:", &self.ttl())?;

// // return Ok(());

// impl<'a, 'b> LogFormatter<'a, 'b> {
//     pub fn new<StrRef: AsRef<str>>(
//         formatter: &'a mut fmt::Formatter<'b>,
//         total_width: usize,
//         ident: StrRef,
//     ) -> Self {
//         let ident = ident.as_ref().to_string();

//         return LogFormatter {
//             formatter,
//             total_width,
//             ident,
//         };
//     }

//     pub fn write_line<S: AsRef<str>, T: AsRef<str>>(
//         &mut self,
//         caption: S,
//         data: T,
//     ) -> Result<(), fmt::Error> {
//         let data_str = data.as_ref();
//         let caption_str = caption.as_ref();
//         let width = self.total_width - self.ident.len() - caption_str.len();
    
//         write!(
//             self.formatter,
//             "\n{ident}{caption}{:.>width$}",
//             data_str,
//             width = width,
//             ident = &self.ident,
//             caption = caption_str,
//         )?;
    
//         return Ok(());
//     }

//     pub fn write<S: AsRef<str>>(
//         &mut self,
//         line: S,
//     ) -> Result<(), fmt::Error> {

//         let line = line.as_ref();
//         write!(
//             self.formatter,
//             "\n{ident}{line}",
//             line = line,
//             ident = &self.ident,
//         )?;
    
//         return Ok(());
//     }

//     pub fn caption<S: AsRef<str>>(
//         &mut self,
//         caption: S,
//     ) -> Result<(), fmt::Error> {
//         self.formatter
//             .write_str(&LogFormatter::make_caption(caption))?;

//         return Ok(());
//     }

//     pub fn make_caption<S: AsRef<str>>(
//         caption: S,
//     ) -> String {
//         return format!("\n## {}:", &caption.as_ref());
//     }

//     pub fn print_caption<S: AsRef<str>>(
//         caption: S,
//     ) {
//         return println!("{}", &LogFormatter::make_caption(caption));
//     }
// }


/// Formatter aims to help to write nice log output.
/// 
/// ### Examples
/// 
/// ```
/// ```
pub struct LogFormatter {
    total_width: usize,
    ident: String,
}

// formatter.write_fmt(format_args!("\nDNS record:"))?;

// // TODO: use one from utils-rs
// let mut packet_formatter = NetworkPacketFormatter::new(
//     formatter,
//     50,
//     "  ",
// );

// packet_formatter.write("Hostname:", &self.hostname())?;
// packet_formatter.write("IP Address:", &self.ip_address())?;
// packet_formatter.write("TTL:", &self.ttl())?;

// return Ok(());

use std::fmt::Display;

impl LogFormatter {
    pub fn new<StrRef: AsRef<str>>(
        total_width: usize,
        ident: StrRef,
    ) -> Self {
        let ident = ident.as_ref().to_string();

        return LogFormatter {
            total_width,
            ident,
        };
    }

    pub fn caption<S: AsRef<str>>(
        &self,
        caption: S,
    ) -> String {
        return format!("\n## {}:", &caption.as_ref());
    }

    pub fn line<S: AsRef<str>, T: Display>(
        &self,
        caption: S,
        data: T,
    ) -> String {
        let caption_str = caption.as_ref();
        let width = self.total_width - self.ident.len() - caption_str.len();
    
        return format!(
            "\n{ident}{caption}{:.>width$}",
            data,
            width = width,
            ident = &self.ident,
            caption = caption_str,
        );
    }

    pub fn ident<S: AsRef<str>>(
        &self,
        line: S,
    ) -> String {
        let line = line.as_ref();

        return format!(
            "\n{ident}{line}",
            line = line,
            ident = &self.ident,
        );
    }
}

#[cfg(test)]
mod tests {
    mod caption {
        use k9::assert_matches_snapshot;

        use crate::LogFormatter;

        #[test]
        fn creates_caption_from_str() {
            let formatter = LogFormatter::new(50, "  ");
            let test_string = "Start".to_string();

            assert_matches_snapshot!(
                formatter.caption(&test_string),
                "Must create formatted caption (str)."
            );

            assert_matches_snapshot!(
                formatter.caption(test_string.as_str()),
                "Must create formatted caption (as_str)."
            );

            assert_matches_snapshot!(
                formatter.caption("Start"),
                "Must create formatted caption (str)."
            );
        }

        #[test]
        fn creates_caption_from_string() {
            let formatter = LogFormatter::new(50, "  ");

            assert_matches_snapshot!(
                formatter.caption("Start".to_string()),
                "Must create formatted caption (string)."
            );
        }
    }

    mod line {
        use k9::assert_matches_snapshot;
        use rstest::rstest;
        use crate::LogFormatter;

        #[rstest]
        #[case(&("some-string".to_string()))]
        #[case("some-string")]
        #[test]
        fn creates_line_for_str<T: Display>(
            #[case] test_string: T,
        ) {
            let formatter = LogFormatter::new(50, "  ");

            assert_matches_snapshot!(
                formatter.line("Name", test_string),
                "Must create formatted line (str)."
            );
        }

        #[rstest]
        #[case(&("some-different-string".to_string()))]
        #[case("some-different-string")]
        #[test]
        fn creates_line_for_as_str<T: Display>(
            #[case] test_string: T,
        ) {
            let formatter = LogFormatter::new(50, "  ");
            let test_string = test_string.to_string();

            assert_matches_snapshot!(
                formatter.line("Name", test_string.as_str()),
                "Must create formatted line (as_str)."
            );
        }

        #[test]
        fn creates_line_for_string() {
            let formatter = LogFormatter::new(50, "  ");

            assert_matches_snapshot!(
                formatter.line("Name", "value".to_string()),
                "Must create formatted line (string)."
            );
        }

        use std::fmt::Display;

        struct TestStruct {}

        impl Display for TestStruct {
            fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                f.write_fmt(
                    format_args!("display output: {}", "200"),
                )?;

                return Ok(());
            }
        }

        #[rstest]
        #[case(500)]
        #[case(true)]
        #[case(false)]
        #[case(TestStruct {})]
        #[test]
        fn creates_line_for_display_items<T: Display>(
            #[case] data: T,
        ) {
            let formatter = LogFormatter::new(50, "  ");

            assert_matches_snapshot!(
                formatter.line("Name", data),
                "Must create formatted line (display)."
            );
        }
    }

    mod ident {
        use k9::assert_matches_snapshot;
        use rstest::rstest;
        use crate::LogFormatter;

        #[rstest]
        #[case(&("some-other-string".to_string()))]
        #[case("some-other-string")]
        #[test]
        fn idents_str<S: AsRef<str>>(
            #[case] test_string: S,
        ) {
            let formatter = LogFormatter::new(50, "  ");

            assert_matches_snapshot!(
                formatter.ident(test_string),
                "Must ident a line (str)."
            );
        }

        #[rstest]
        #[case(&("some-other-string".to_string()))]
        #[case("some-other-string")]
        #[test]
        fn idents_as_str<S: AsRef<str>>(
            #[case] test_string: S,
        ) {
            let formatter = LogFormatter::new(50, "  ");
            let test_string = test_string.as_ref().to_string();

            assert_matches_snapshot!(
                formatter.ident(test_string.as_str()),
                "Must ident a line (as_str)."
            );
        }

        #[test]
        fn idents_string() {
            let formatter = LogFormatter::new(50, "  ");
            let test_string = "string-for-identation".to_string();

            assert_matches_snapshot!(
                formatter.ident(test_string),
                "Must ident a line (string)."
            );
        }
    }
}
