use std::io::Error;

use bytes::BytesMut;
use serde::{Serialize, de::DeserializeOwned};
use tokio_util::codec::Decoder;

use super::GenericCodec;

impl<T: Serialize + DeserializeOwned> Decoder for GenericCodec<T> {
    type Item = T;
    type Error = Error;

    fn decode(
        &mut self,
        buf: &mut BytesMut,
    ) -> Result<Option<Self::Item>, Self::Error> {
        let maybe_bytes = Decoder::decode(
            &mut self.length_delimited_codec, 
            buf,
        )?;

        let bytes = match maybe_bytes {
            None => return Ok(None),
            Some(b) => b,
        };

        let message: T = serde_json::from_slice::<Self::Item>(&bytes[..])
            .expect("Cannot deserialize bytes to message.");

        return Ok(Some(message));
    } 
}
