
/// Test if an item implements `Sync` trait.
/// 
/// ### Examples
///
/// - Sync item:
/// 
/// ```
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_sync;
///
///     // Sync is auto implemented
///     struct TestStruct {}
/// 
///     // compiles fine
///     implements_sync(TestStruct {});
/// }
/// ```
/// 
/// - Non-Sync item:
/// 
/// ```compile_fail
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_sync;
/// 
///     struct TestStruct {
///         // make it not Sync
///         rc: std::rc::Rc<u8>,
///     }
/// 
///     // does not compile
///     implements_sync(TestStruct {});
/// }
/// ```
pub fn implements_sync<T: Sync>(item: T) -> T {
    return item;
}
