// ⚠️ Note: the \"async\" feature must be enabled to access this!
use cs_utils::futures::GenericCodec;

use cs_utils::random_str;
use futures::{StreamExt, SinkExt};
use serde::{Serialize, Deserialize};
use tokio::{io::duplex, try_join};
use tokio_util::codec::Framed;

#[derive(Serialize, Deserialize, Debug, Clone, PartialEq)]
struct TestStruct {
    id: u16,
    name: String,
    is_flag: bool,
}

/// **⚠️ Requires "async" feature to be enabled!**
#[tokio::main]
async fn main() {
    println!("\n🏷️  Generic codec example:");
    println!("\n⚠️ Note: the \"asyn\" feature must be enabled!\n");

    let (stream1, stream2) = duplex(4096);

    let message = random_str(32);

    let message1 = message.clone();
    let message2 = message.clone();

    try_join!(
        // Sender
        tokio::spawn(async move {
            let framed_stream = Framed::new(
                stream1,
                GenericCodec::<String>::new(),
            );
            let (
                mut sink,
                _source,
            ) = framed_stream.split();

            println!("> sending message: {:?}", &message1);

            sink
                .send(message1).await
                .expect("Cannot send the request.");
        }),
        // Receiver
        tokio::spawn(async move {
            let framed_stream = Framed::new(
                stream2,
                GenericCodec::<String>::new(),
            );
            let (
                _sink,
                mut source,
            ) = framed_stream.split();

            let received_message = source.next().await
                .expect("Cannot receive message.")
                .expect("Cannot receive message 2.");

            println!("< received message: {:?}", &received_message);

            assert_eq!(
                received_message,
                message2,
            );
        }),
    ).unwrap();
}
