
/// Time-related constants. Needs the `contants` or `all` features to be enabled.
/// 
/// ### Examples
/// 
/// ```
/// #[cfg(feature = "constants")]
/// {
///     use cs_utils::constants::time;
/// 
///     assert_eq!(
///         time::SECOND_MS,
///         1000,
///         "Must be 1000 milliseconds in one second."
///     );
///
///     assert_eq!(
///         time::MINUTE_MS,
///         60 * 1000,
///         "Must be 60000 milliseconds in one minute."
///     );
/// 
///     assert_eq!(
///         time::HOUR_MS,
///         60 * 60 * 1000,
///         "Must be 3600000 milliseconds in one hour."
///     );
/// 
///     assert_eq!(
///         time::DAY_MS,
///         24 * 60 * 60 * 1000,
///         "Must be 86400000 milliseconds in one day."
///     );
/// }
/// ```
pub mod time {
    /// Number of `milliseconds` in one `second`.
    pub const SECOND_MS: u128 = 1000;
    /// Number of `milliseconds` in one `minute`.
    pub const MINUTE_MS: u128 = 60 * SECOND_MS;
    /// Number of `milliseconds` in one `hour`.
    pub const HOUR_MS: u128 = 60 * MINUTE_MS;
    /// Number of `milliseconds` in one `day`.
    pub const DAY_MS: u128 = 24 * HOUR_MS;
}
