
use std::thread;

use cs_trace::Trace;

#[test]
fn can_be_send_and_sync() {
    let trace = Trace::from("add-duplex2");

    thread::spawn(move || {
        trace.info("hello world!");
    });
}

#[test]
fn child_can_be_send_and_sync() {
    let trace_parent = Trace::from("add-duplex2");
    let trace = trace_parent.child("child");

    thread::spawn(move || {
        &trace.info("hello world!");
    });
}