// the Tracer trait
pub trait Tracer: Send + Sync {
    fn name(&self) -> &str;
    // fn child(&self, child_name: &'static str) -> Box<dyn Tracer>;

    fn trace(&self, message: &str) -> &dyn Tracer;
    fn info(&self, message: &str) -> &dyn Tracer;
    fn debug(&self, message: &str) -> &dyn Tracer;
    fn warn(&self, message: &str) -> &dyn Tracer;
    fn error(&self, message: &str) -> &dyn Tracer;
}
