// `Tracer` trait
mod tracer;
pub use tracer::Tracer;

// trace object implements the `Tracer` trait
mod trace;
pub use trace::Trace;

// reexport the filter object
pub use tracing_subscriber::EnvFilter;

// export the trace listener utils
mod utils;
pub use utils::{create_trace_listener, TraceListenerOptions};

// log writers
mod writers;
pub use writers::{NoopWriter, FileWriter};

// reexport the type with better name
use tracing::Level;
pub type TraceLevel = Level;
