
use std::thread;

use cs_trace::{create_trace, child};
use cs_utils::futures::wait;
use tokio::try_join;

#[test]
fn can_be_send_and_sync() {
    let trace = create_trace!("add-duplex2");

    thread::spawn(move || {
        trace.info("hello world!");
    });
}

#[tokio::test]
async fn child_can_be_send_and_sync() {
    let trace_parent = create_trace!("trace1");
    let trace_child = child!(trace_parent, "child");

    let (trace_child2,) = try_join!(
        tokio::spawn(async move {
            trace_child.info("trace info");
    
            wait(100).await;

            trace_child.warn("trace warn");

            trace_child
        }),
    ).unwrap();

    trace_child2.trace("trace trace");
}

#[test]
fn test_for_send() {
    let trace = create_trace!("trace1");
    let child_trace = child!(trace, "child");

    let _ok_trace: Box<dyn Send> = Box::new(trace);
    let _ok_child_trace: Box<dyn Send > = Box::new(child_trace);
}

#[test]
fn test_for_sync() {
    let trace = create_trace!("trace1");
    let child_trace = child!(trace, "child");

    let _ok_trace: Box<dyn Sync> = Box::new(trace);
    let _ok_child_trace: Box<dyn Sync> = Box::new(child_trace);
}

#[test]
fn test_for_unpin() {
    let trace = create_trace!("trace1");
    let child_trace = child!(trace, "child");

    let _ok_trace: Box<dyn Unpin> = Box::new(trace);
    let _ok_child_trace: Box<dyn Unpin> = Box::new(child_trace);
}
