use cs_trace::{create_trace_listener, TraceListenerOptions, SubscriberInitExt, create_trace, child};
use cs_utils::random_str;

fn main() {
    let collector = create_trace_listener(
        TraceListenerOptions::new()
                .with_stdout(true)
                .with_thread_ids(true)
                .with_file_path("./simple-example.log", true)
                .with_env_filter("[crate-name],[child]"),
    );

    collector.init();

    // add the session id part to the traces
    let trace = create_trace!("crate-name");

    trace.trace(&format!("session id: [{}]", random_str(8)));

    trace.trace("Hello World!");
    trace.debug("Hello World!");
    trace.info("Hello World!");
    trace.warn("Hello World!");
    trace.error("Hello World!");

    let child_trace = child!(trace, "child");

    child_trace.trace("Hello World!");
    child_trace.debug("Hello World!");
    child_trace.info("Hello World!");
    child_trace.warn("Hello World!");
    child_trace.error("Hello World!");

    trace.trace("Hello World!");
}
