use crate::Span;

// the Tracer trait
pub trait Tracer: Send + Sync {
    fn trace_tree_name(&self) -> &'static str;
    fn is_silent(&self) -> bool;
    fn as_silent(self, is_silent: bool) -> Box<dyn Tracer>;

    fn trace(&self, message: &str) -> &dyn Tracer;
    fn info(&self, message: &str) -> &dyn Tracer;
    fn debug(&self, message: &str) -> &dyn Tracer;
    fn warn(&self, message: &str) -> &dyn Tracer;
    fn error(&self, message: &str) -> &dyn Tracer;
    
    fn span(&self) -> &Span;
}
