use std::io::{self, Write};

pub struct CompositeWriter {
    writers: Vec<Box<dyn Write>>,
}

impl CompositeWriter {
    pub fn new(
        writers: Vec<Box<dyn Write>>,
    ) -> Box<dyn Write> {
        return Box::new(CompositeWriter { writers });
    }
}

impl From<Vec<Box<dyn Write>>> for CompositeWriter {
    fn from(writers: Vec<Box<dyn Write>>) -> CompositeWriter {
        return CompositeWriter { writers };
    }
}

impl Write for CompositeWriter
 {
    fn write(&mut self, buf: &[u8]) -> io::Result<usize> {
        for writer in &mut self.writers {
            let _result = writer.write(&buf);
        }

        return Ok(buf.len());
    }

    fn flush(&mut self) -> io::Result<()> {
        for writer in &mut self.writers {
            let _result = writer.flush();
        }

        return Ok(());
    }
}
