// the Tracer trait
pub trait Tracer {
    fn name(&self) -> &str;
    fn child(&self, child_name: &str) -> Box<dyn Tracer>;

    fn trace(&self, message: &str) -> &dyn Tracer;
    fn info(&self, message: &str) -> &dyn Tracer;
    fn debug(&self, message: &str) -> &dyn Tracer;
    fn warn(&self, message: &str) -> &dyn Tracer;
    fn error(&self, message: &str) -> &dyn Tracer;

    // fn as_silent(self, is_silent: bool) -> Self;
}
