use std::fmt::Debug;

use crate::math::{Hit, Ray, Vec3};

pub trait Shape: Debug + Send + Sync {
    /// If self and ray intersect, return the corresponding hit.
    /// Otherwise return [`None`](None).
    fn intersects(&self, ray: Ray) -> Option<Hit>;

    fn uv_map(&self, point: Vec3) -> (f64, f64);
}
