#![cfg_attr(doc, feature(doc_cfg))]

//! # Overview
//!
//! *Crystal Ball* is a path tracing library written in Rust.
//!
//! It uses [rayon](https://github.com/rayon-rs/rayon) for parallelization
//! and can save the rendered image in various formats thanks to the [image](https://github.com/image-rs/image) crate.
//!
//! ## Example Usage
//! ```
//! use std::path::Path;
//!
//! use crystal_ball::prelude::*;
//!
//! fn main() {
//!     let objects: Vec<Box<dyn Shape>> = vec![
//!         Box::new(
//!             Sphere::new()
//!                 .with_material(Box::new(Diffuse::new(Color::new(1.0, 0.45, 0.31))))
//!         ),
//!         Box::new(
//!             Sphere::new()
//!                 .with_center(Vec3::new(0.0, -101.0, 0.0))
//!                 .with_radius(100.0)
//!         ),
//!     ];
//!
//!     let scene = Scene::new().with_objects(objects);
//!
//!     let engine = RenderEngine::new(64, 4); // Samples and max bounces
//!     let image = engine.render(&scene);
//!
//!     image
//!         .write(Path::new("example_render.png"))
//!         .expect("Error writing rendered image");
//! }
//! ```

pub mod color;
pub mod math;
pub mod prelude;
pub mod rendering;
pub mod shapes;
mod util;
