use std::fmt::Debug;

use crate::color::Color;

/// Specify a color of each pixel.
pub trait Texture: Debug + Send + Sync {
    /// Return the color at the given coordinates.
    fn get_pixel(&self, u: f64, v: f64) -> Color;
}
