use crate::color::{Color, Image};

/// Characterize optical properties of a surface.
#[derive(Copy, Clone, Debug)]
pub enum Material {
    Diffuse {
        color: Color,
    },
    Metallic {
        color: Color,
        roughness: f64,
    },
    Emissive {
        color: Color,
        intensity: f64,
    },
    Refractive {
        color: Color,
        ior: f64,
        roughness: f64,
    },
}

/// Characterize optical properties of the background.
#[derive(Clone, Debug)]
pub enum BackgroundMaterial {
    Color { color: Color },
    Texture { image: Image, intensity: f64 },
}
