use crate::math::Vec3;
use crate::shapes::Sphere;

/// The intersection of a ray with an object.
#[derive(Copy, Clone, Debug)]
pub struct Hit {
    object: Sphere,
    position: Vec3,
    normal: Vec3,
    distance: f64,
}

impl Hit {
    /// Create a new hit.
    pub fn new(object: Sphere, position: Vec3, normal: Vec3, distance: f64) -> Self {
        Hit {
            object,
            position,
            normal,
            distance,
        }
    }

    /// Return the object that is hit by the ray.
    pub fn object(&self) -> Sphere {
        self.object
    }

    /// Return the position of the intersection point.
    pub fn position(&self) -> Vec3 {
        self.position
    }

    /// Return the normal of the object at the intersection point.
    pub fn normal(&self) -> Vec3 {
        self.normal
    }

    /// Return the distance of the intersection point from the ray origin.
    pub fn distance(&self) -> f64 {
        self.distance
    }
}
