#![cfg_attr(doc, feature(doc_cfg))]

//! # Overview
//!
//! *Crystal Ball* is a path tracing library written in Rust.
//!
//! It uses [rayon](https://github.com/rayon-rs/rayon) for parallelization
//! and can save the rendered image in various formats thanks to the [image](https://github.com/image-rs/image) crate.
//!
//! ## Example Usage
//! ```
//! use std::path::Path;
//!
//! use crystal_ball::prelude::*;
//!
//! fn main() {
//!     let objects = vec![
//!         Sphere::new()
//!             .with_center(Vec3::new(0.0, 0.0, -1.0))
//!             .with_radius(0.5)
//!             .with_material(Material::Diffuse {
//!                 color: Color::new(1.0, 0.45, 0.31),
//!             }),
//!         Sphere::new()
//!             .with_center(Vec3::new(0.0, -100.5, -1.0))
//!             .with_radius(100.0)
//!             .with_material(Material::Diffuse {
//!                 color: Color::new(0.7, 0.7, 0.7),
//!             }),
//!     ];
//!
//!
//!     let scene = Scene::new()
//!         .with_camera(Camera::new())
//!         .with_objects(objects);
//!
//!     let engine = RenderEngine::new(32, 8); // Samples and max bounces
//!     let mut image = engine.render(&scene);
//!
//!     image
//!         .write(Path::new("output/example_render.png"))
//!         .expect("Error writing rendered image");
//! }
//! ```

pub mod color;
pub mod math;
pub mod prelude;
pub mod rendering;
pub mod shapes;
mod util;
