use random_fast_rng::{local_rng, Random};

/// Generate a random number between min and max.
pub fn random(min: f64, max: f64) -> f64 {
    let mut rng = local_rng();
    rng.gen::<f64>() * (max - min) + min
}

#[non_exhaustive]
pub struct IOR;

impl IOR {
    pub const ACRYLIC_GLASS: f64 = 1.491;
    pub const AIR: f64 = 1.0;
    pub const ALCOHOL: f64 = 1.36;
    pub const BEER: f64 = 1.345;
    pub const CRYSTAL: f64 = 2.0;
    pub const DIAMOND: f64 = 2.418;
    pub const EMERALD: f64 = 1.583;
    pub const GLASS: f64 = 1.5;
    pub const ICE: f64 = 1.309;
    pub const LUCITE: f64 = 1.495;
    pub const MERCURY: f64 = 1.62;
    pub const PEARL: f64 = 1.61;
    pub const VODKA: f64 = 1.363;
    pub const WATER: f64 = 1.325;
}
