use std::path::Path;

use crystal_ball::prelude::*;

fn main() {
    let colors = vec![
        Color::new(1.0, 0.04, 0.04),
        Color::new(1.0, 0.75, 0.0),
        Color::new(1.0, 1.0, 0.08),
        Color::new(0.14, 1.0, 0.05),
        Color::new(0.1, 1.0, 0.9),
        Color::new(0.0, 0.1, 1.0),
        Color::new(0.77, 0.05, 1.0),
        Color::new(0.9, 0.08, 0.9),
    ];

    let positions = vec![
        Vec3::new(0.0, 0.2, -2.0),
        Vec3::new(1.41, 0.2, -1.41),
        Vec3::new(2.0, 0.2, 0.0),
        Vec3::new(1.41, 0.2, 1.41),
        Vec3::new(0.0, 0.2, 2.0),
        Vec3::new(-1.41, 0.2, 1.41),
        Vec3::new(-2.0, 0.2, 0.0),
        Vec3::new(-1.41, 0.2, -1.41),
    ];

    let mut objects = vec![
        Sphere::new()
            .with_center(Vec3::new(0.0, -1000.0, -1.0))
            .with_radius(1000.0)
            .with_material(Material::Metallic {
                color: Color::new(1.0, 1.0, 1.0),
                roughness: 1.0,
            }),
        Sphere::new()
            .with_center(Vec3::new(0.0, 1.0, 0.0))
            .with_radius(1.0)
            .with_material(Material::Metallic {
                color: Color::new(1.0, 1.0, 1.0) * 1.5,
                roughness: 0.0,
            }),
    ];

    for i in 0..8 {
        objects.push(
            Sphere::new()
                .with_center(positions[i])
                .with_radius(0.2)
                .with_material(Material::Emissive {
                    color: colors[i],
                    intensity: 20.0,
                }),
        );
    }

    let camera_position = Vec3::new(-10.0, 0.5, 0.0);
    let camera_target = Vec3::new(0.0, 3.5, 0.0);

    let scene = Scene::new()
        .with_camera(
            Camera::new()
                .with_position(camera_position)
                .with_target(camera_target),
        )
        .with_objects(objects)
        .with_background(BackgroundMaterial::Texture {
            image: Image::from_hdr_file(Path::new("moonlit_golf_8k.hdr"), 1.0, 0.5)
                .expect("Error loading HDRI"),
            intensity: 1.0,
        });

    let engine = RenderEngine::new(32, 4);
    let mut image = engine.render(&scene);

    image
        .write(Path::new("output/image.png"))
        .expect("Error writing rendered image");

    #[cfg(feature = "oidn")]
    image
        .denoise()
        .write(Path::new("output/image_denoised.png"))
        .expect("Error writing rendered image");

    println!("\nImage saved!");
}
