#include "atcacert/atcacert_def.h"

const uint8_t g_test_cert_template_3_device[] = {
    0x20, 0x69, 0xDD, 0x8C, 0xDA, 0x99, 0xBD, 0x6E, 0x31, 0x2B, 0xC0, 0xE6, 0xDF, 0xB5, 0x69, 0x6F,
    0xCC, 0x67, 0x07, 0x65, 0xF7, 0x8F, 0x31, 0x8B, 0xD2, 0xC4, 0x99, 0x07, 0x74, 0x5E, 0x08, 0xA5,
    0xDF, 0x2C, 0x67, 0x42, 0xC8, 0x26, 0xF0, 0x75, 0xB4, 0x45, 0xD6, 0x6D, 0x39, 0x8D, 0xEE, 0xE1,
    0xFA, 0xE2, 0x6C, 0xF6, 0xDF, 0x98, 0x78, 0x8F, 0x9C, 0x45, 0x3D, 0x1C, 0xCE, 0x3D, 0xE4, 0x10,
    0x32, 0x33, 0x30, 0x31, 0x32, 0x30, 0x31, 0x38, 0x2D, 0x31, 0x32, 0x2D, 0x30, 0x37, 0x54, 0x30,
    0x30, 0x3A, 0x30, 0x30, 0x3A, 0x30, 0x30, 0x5A, 0x32, 0x30, 0x32, 0x38, 0x2D, 0x31, 0x32, 0x2D,
    0x30, 0x37, 0x54, 0x30, 0x30, 0x3A, 0x30, 0x30, 0x3A, 0x30, 0x30, 0x5A, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30,
    0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31,
    0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20,
    0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30,
    0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31,
    0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20,
    0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30,
    0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31,
    0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20,
    0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30,
    0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31,
    0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20, 0x30, 0x31, 0x20,
    0x30, 0x31, 0x20, 0x30, 0x31, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30,
    0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30,
    0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30,
    0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30, 0x33, 0x30,
    0x33, 0x30, 0x33, 0x30, 0x33, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
    0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
    0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
    0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x35, 0x35,
    0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
    0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
    0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
    0x35, 0x35, 0x35, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30,
    0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36,
    0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20, 0x30, 0x36, 0x20,
    0x30, 0x36, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37,
    0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20,
    0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30, 0x37, 0x20, 0x30,
    0x37, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
    0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x39, 0x39, 0x39,
    0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39,
    0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0xB1, 0x77, 0x89, 0x5D, 0x76, 0xD8, 0xD7, 0xA4, 0xA8,
    0xA5, 0x2D, 0x53, 0x96, 0x62, 0xA0, 0xE1, 0xDE, 0xC0, 0xC0, 0x3C, 0x04, 0x82, 0x80, 0x6C, 0x88,
    0x88, 0x8A, 0xA2, 0xCC, 0xE2, 0x92, 0x45, 0xEB, 0xAE, 0x48, 0x7D, 0x49, 0x03, 0x9A, 0xB3, 0x05,
    0x3B, 0xDE, 0xBF, 0xE1, 0x9B, 0x74, 0x21, 0x4A, 0x01, 0x42, 0xCA, 0xD7, 0xB8, 0x81, 0xB8, 0x3B,
    0xAF, 0xD8, 0xE3, 0xA1, 0x4F, 0x75, 0x13
};

atcacert_cert_element_t g_test_cert_template_3_elements[] = {
    {
        .id = "TF_REVERSE",
        .device_loc ={
            .zone      = DEVZONE_OTP,
            .slot      = 0,
            .is_genkey = FALSE,
            .offset    = 0,
            .count     = 64
        },
        .cert_loc ={
            .offset = 118,
            .count  = 191
        },
        .transforms ={
            TF_REVERSE,
            TF_BIN2HEX_SPACE_LC
        }
    },
    {
        .id = "TF_BIN2HEX_UC",
        .device_loc ={
            .zone      = DEVZONE_CONFIG,
            .slot      = 0,
            .is_genkey = FALSE,
            .offset    = 0,
            .count     = 16
        },
        .cert_loc ={
            .offset = 309,
            .count  = 32
        },
        .transforms ={
            TF_BIN2HEX_UC
        }
    },
    {
        .id = "TF_BIN2HEX_LC",
        .device_loc ={
            .zone      = DEVZONE_CONFIG,
            .slot      = 0,
            .is_genkey = FALSE,
            .offset    = 16,
            .count     = 16
        },
        .cert_loc ={
            .offset = 341,
            .count  = 32
        },
        .transforms ={
            TF_BIN2HEX_LC
        }
    },
    {
        .id = "TF_HEX2BIN_UC",
        .device_loc ={
            .zone      = DEVZONE_DATA,
            .slot      = 8,
            .is_genkey = FALSE,
            .offset    = 0,
            .count     = 114
        },
        .cert_loc ={
            .offset = 373,
            .count  = 57
        },
        .transforms ={
            TF_HEX2BIN_UC
        }
    },
    {
        .id = "TF_HEX2BIN_LC",
        .device_loc ={
            .zone      = DEVZONE_DATA,
            .slot      = 8,
            .is_genkey = FALSE,
            .offset    = 114,
            .count     = 106
        },
        .cert_loc ={
            .offset = 430,
            .count  = 53
        },
        .transforms ={
            TF_HEX2BIN_LC
        }
    },
    {
        .id = "TF_BIN2HEX_SPACE_UC",
        .device_loc ={
            .zone      = DEVZONE_CONFIG,
            .slot      = 0,
            .is_genkey = FALSE,
            .offset    = 32,
            .count     = 16
        },
        .cert_loc ={
            .offset = 483,
            .count  = 47
        },
        .transforms ={
            TF_BIN2HEX_SPACE_UC
        }
    },
    {
        .id = "TF_BIN2HEX_SPACE_LC",
        .device_loc ={
            .zone      = DEVZONE_CONFIG,
            .slot      = 0,
            .is_genkey = FALSE,
            .offset    = 48,
            .count     = 16
        },
        .cert_loc ={
            .offset = 530,
            .count  = 47
        },
        .transforms ={
            TF_BIN2HEX_SPACE_LC
        }
    },
    {
        .id = "TF_HEX2BIN_SPACE_UC",
        .device_loc ={
            .zone      = DEVZONE_DATA,
            .slot      = 8,
            .is_genkey = FALSE,
            .offset    = 220,
            .count     = 83
        },
        .cert_loc ={
            .offset = 577,
            .count  = 28
        },
        .transforms ={
            TF_HEX2BIN_SPACE_UC
        }
    },
    {
        .id = "TF_HEX2BIN_SPACE_LC",
        .device_loc ={
            .zone      = DEVZONE_DATA,
            .slot      = 8,
            .is_genkey = FALSE,
            .offset    = 303,
            .count     = 77
        },
        .cert_loc ={
            .offset = 605,
            .count  = 26
        },
        .transforms ={
            TF_HEX2BIN_SPACE_LC
        }
    }
};

const atcacert_def_t g_test_cert_def_3_device = {
    .type                = CERTTYPE_CUSTOM,
    .template_id         = 2,
    .chain_id            = 3,
    .private_key_slot    = 0,
    .sn_source           = SNSRC_DEVICE_SN,
    .cert_sn_dev_loc     = {
        .zone            = DEVZONE_NONE,
        .slot            = 0,
        .is_genkey       = 0,
        .offset          = 0,
        .count           = 0
    },
    .issue_date_format   = DATEFMT_ISO8601_SEP,
    .expire_date_format  = DATEFMT_ISO8601_SEP,
    .tbs_cert_loc        = {
        .offset          = 0,
        .count           = 631
    },
    .expire_years        = 1,
    .public_key_dev_loc  = {
        .zone            = DEVZONE_DATA,
        .slot            = 0,
        .is_genkey       = 1,
        .offset          = 0,
        .count           = 64
    },
    .comp_cert_dev_loc   = {
        .zone            = DEVZONE_DATA,
        .slot            = 10,
        .is_genkey       = 0,
        .offset          = 0,
        .count           = 72
    },
    .std_cert_elements   = {
        {   // STDCERT_PUBLIC_KEY
            .offset      = 0,
            .count       = 64
        },
        {   // STDCERT_SIGNATURE
            .offset      = 631,
            .count       = 64
        },
        {   // STDCERT_ISSUE_DATE
            .offset      = 68,
            .count       = 20
        },
        {   // STDCERT_EXPIRE_DATE
            .offset      = 88,
            .count       = 20
        },
        {   // STDCERT_SIGNER_ID
            .offset      = 64,
            .count       = 4
        },
        {   // STDCERT_CERT_SN
            .offset      = 108,
            .count       = 10
        },
        {   // STDCERT_AUTH_KEY_ID
            .offset      = 0,
            .count       = 0
        },
        {   // STDCERT_SUBJ_KEY_ID
            .offset      = 0,
            .count       = 0
        }
    },
    .cert_elements       = g_test_cert_template_3_elements,
    .cert_elements_count = sizeof(g_test_cert_template_3_elements) / sizeof(g_test_cert_template_3_elements[0]),
    .cert_template       = g_test_cert_template_3_device,
    .cert_template_size  = sizeof(g_test_cert_template_3_device),
};
