/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListWalletTransactionsRiNonFungibleTokens {
    /// Defines the tokens' converted amount value.
    #[serde(rename = "convertedAmount")]
    pub converted_amount: String,
    /// Represents token's exchange rate unit.
    #[serde(rename = "exchangeRateUnit")]
    pub exchange_rate_unit: String,
    /// Defines the token's name as a string.
    #[serde(rename = "name")]
    pub name: String,
    /// Defines the address to which the recipient receives the transferred tokens.
    #[serde(rename = "recipient")]
    pub recipient: String,
    /// Defines the address from which the sender transfers tokens.
    #[serde(rename = "sender")]
    pub sender: String,
    /// Defines the symbol of the non-fungible tokens.
    #[serde(rename = "symbol")]
    pub symbol: String,
    /// Represents tokens' unique identifier.
    #[serde(rename = "tokenId")]
    pub token_id: String,
    /// Defines the specific token type.
    #[serde(rename = "type")]
    pub _type: String,
}

impl ListWalletTransactionsRiNonFungibleTokens {
    pub fn new(converted_amount: String, exchange_rate_unit: String, name: String, recipient: String, sender: String, symbol: String, token_id: String, _type: String) -> ListWalletTransactionsRiNonFungibleTokens {
        ListWalletTransactionsRiNonFungibleTokens {
            converted_amount,
            exchange_rate_unit,
            name,
            recipient,
            sender,
            symbol,
            token_id,
            _type,
        }
    }
}


