/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListWalletTransactionsRiInternalTransactions {
    /// Defines the specific amount of the transaction.
    #[serde(rename = "amount")]
    pub amount: String,
    /// Represents the converted amount.
    #[serde(rename = "convertedAmount")]
    pub converted_amount: String,
    /// Defines the base asset symbol to get a rate for.
    #[serde(rename = "exchangeRateUnit")]
    pub exchange_rate_unit: String,
    /// Represents the unique internal transaction ID in regards to the parent transaction (type trace address).
    #[serde(rename = "operationId")]
    pub operation_id: String,
    /// Represents the recipient address with the respective amount.
    #[serde(rename = "recipient")]
    pub recipient: String,
    /// Represents the sender address with the respective amount.
    #[serde(rename = "sender")]
    pub sender: String,
    /// Represents the unique unit symbol.
    #[serde(rename = "symbol")]
    pub symbol: String,
}

impl ListWalletTransactionsRiInternalTransactions {
    pub fn new(amount: String, converted_amount: String, exchange_rate_unit: String, operation_id: String, recipient: String, sender: String, symbol: String) -> ListWalletTransactionsRiInternalTransactions {
        ListWalletTransactionsRiInternalTransactions {
            amount,
            converted_amount,
            exchange_rate_unit,
            operation_id,
            recipient,
            sender,
            symbol,
        }
    }
}


