/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListWalletTransactionsRiFungibleTokens {
    /// Defines the amount of the fungible tokens.
    #[serde(rename = "amount")]
    pub amount: String,
    /// Defines the tokens' converted amount value.
    #[serde(rename = "convertedAmount")]
    pub converted_amount: String,
    /// Represents token's exchange rate unit.
    #[serde(rename = "exchangeRateUnit")]
    pub exchange_rate_unit: String,
    /// Defines the token's name as a string.
    #[serde(rename = "name")]
    pub name: String,
    /// The address which receives this transaction. In UTXO-based protocols like Bitcoin there could be several senders while in account-based protocols like Ethereum there is always only one
    #[serde(rename = "recipient")]
    pub recipient: String,
    /// Represents the address which sends this transaction. In UTXO-based protocols like Bitcoin there could be several senders while in account-based protocols like Ethereum there is always only one sender.
    #[serde(rename = "sender")]
    pub sender: String,
    /// Defines the symbol of the fungible tokens.
    #[serde(rename = "symbol")]
    pub symbol: String,
    /// Defines the decimals of the token, i.e. the number of digits that come after the decimal coma of the token.
    #[serde(rename = "tokenDecimals")]
    pub token_decimals: i32,
    /// Defines the specific token type.
    #[serde(rename = "type")]
    pub _type: String,
}

impl ListWalletTransactionsRiFungibleTokens {
    pub fn new(amount: String, converted_amount: String, exchange_rate_unit: String, name: String, recipient: String, sender: String, symbol: String, token_decimals: i32, _type: String) -> ListWalletTransactionsRiFungibleTokens {
        ListWalletTransactionsRiFungibleTokens {
            amount,
            converted_amount,
            exchange_rate_unit,
            name,
            recipient,
            sender,
            symbol,
            token_decimals,
            _type,
        }
    }
}


