/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListUnspentTransactionOutputsByAddressRiBlockchainSpecific {
    /// Represents the virtual size of this transaction
    #[serde(rename = "vSize")]
    pub v_size: i32,
    /// It is used to enforce balance of Spend and Output transfers, in order to prevent their replay across transactions.
    #[serde(rename = "bindingSig")]
    pub binding_sig: String,
    /// Represents a block height after which the transaction will expire.
    #[serde(rename = "expiryHeight")]
    pub expiry_height: i32,
    /// Represents an encoding of a JoinSplitSig public validating key.
    #[serde(rename = "joinSplitPubKey")]
    pub join_split_pub_key: String,
    /// Is used to sign transactions that contain at least one JoinSplit description.
    #[serde(rename = "joinSplitSig")]
    pub join_split_sig: String,
    /// \"Overwinter\" is the network upgrade for the Zcash blockchain.
    #[serde(rename = "overwintered")]
    pub overwintered: bool,
    /// Represents a sequence of JoinSplit descriptions using BCTV14 proofs.
    #[serde(rename = "vJoinSplit", skip_serializing_if = "Option::is_none")]
    pub v_join_split: Option<Vec<crate::models::ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVJoinSplit>>,
    /// Object Array representation of transaction output descriptions
    #[serde(rename = "vShieldedOutput", skip_serializing_if = "Option::is_none")]
    pub v_shielded_output: Option<Vec<crate::models::GetTransactionDetailsByTransactionIdribszVShieldedOutput>>,
    /// Object Array representation of transaction spend descriptions
    #[serde(rename = "vShieldedSpend")]
    pub v_shielded_spend: Vec<crate::models::ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVShieldedSpend>,
    /// Defines the transaction value balance.
    #[serde(rename = "valueBalance")]
    pub value_balance: String,
    /// Represents the transaction version group ID.
    #[serde(rename = "versionGroupId")]
    pub version_group_id: String,
}

impl ListUnspentTransactionOutputsByAddressRiBlockchainSpecific {
    pub fn new(v_size: i32, binding_sig: String, expiry_height: i32, join_split_pub_key: String, join_split_sig: String, overwintered: bool, v_shielded_spend: Vec<crate::models::ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVShieldedSpend>, value_balance: String, version_group_id: String) -> ListUnspentTransactionOutputsByAddressRiBlockchainSpecific {
        ListUnspentTransactionOutputsByAddressRiBlockchainSpecific {
            v_size,
            binding_sig,
            expiry_height,
            join_split_pub_key,
            join_split_sig,
            overwintered,
            v_join_split: None,
            v_shielded_output: None,
            v_shielded_spend,
            value_balance,
            version_group_id,
        }
    }
}


