/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetXrpRippleTransactionDetailsByTransactionIdri {
    /// Represents additional data that may be needed.
    #[serde(rename = "additionalData")]
    pub additional_data: String,
    #[serde(rename = "destinationTag", skip_serializing_if = "Option::is_none")]
    pub destination_tag: Option<i32>,
    /// Defines the index of the transaction, i.e. the consecutive place it takes in the blockchain.
    #[serde(rename = "index")]
    pub index: String,
    /// Represents the hash of the block where this transaction was mined/confirmed for first time. The hash is defined as a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.
    #[serde(rename = "minedInBlockHash")]
    pub mined_in_block_hash: String,
    /// Represents the hight of the block where this transaction was mined/confirmed for first time. The height is defined as the number of blocks in the blockchain preceding this specific block.
    #[serde(rename = "minedInBlockHeight")]
    pub mined_in_block_height: String,
    #[serde(rename = "offer")]
    pub offer: Box<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriOffer>,
    #[serde(rename = "receive")]
    pub receive: Box<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriReceive>,
    /// Represents an object of addresses that receive the transactions.
    #[serde(rename = "recipients")]
    pub recipients: Vec<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriRecipients>,
    /// Represents an object of addresses that provide the funds.
    #[serde(rename = "senders")]
    pub senders: Vec<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriSenders>,
    /// Defines the transaction input's sequence as an integer, which is is used when transactions are replaced with newer versions before LockTime.
    #[serde(rename = "sequence")]
    pub sequence: i32,
    /// Defines the status of the transaction.
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// Defines the exact date/time in Unix Timestamp when this transaction was mined, confirmed or first seen in Mempool, if it is unconfirmed.
    #[serde(rename = "timestamp")]
    pub timestamp: i32,
    /// Represents the same as `transactionId` for account-based protocols like Ethereum, while it could be different in UTXO-based protocols like Bitcoin. E.g., in UTXO-based protocols `hash` is different from `transactionId` for SegWit transactions.
    #[serde(rename = "transactionHash")]
    pub transaction_hash: String,
    /// Defines the type of the transaction.
    #[serde(rename = "type")]
    pub _type: String,
    #[serde(rename = "fee")]
    pub fee: Box<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriFee>,
    #[serde(rename = "value")]
    pub value: Box<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriValue>,
}

impl GetXrpRippleTransactionDetailsByTransactionIdri {
    pub fn new(additional_data: String, index: String, mined_in_block_hash: String, mined_in_block_height: String, offer: crate::models::GetXrpRippleTransactionDetailsByTransactionIdriOffer, receive: crate::models::GetXrpRippleTransactionDetailsByTransactionIdriReceive, recipients: Vec<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriRecipients>, senders: Vec<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriSenders>, sequence: i32, timestamp: i32, transaction_hash: String, _type: String, fee: crate::models::GetXrpRippleTransactionDetailsByTransactionIdriFee, value: crate::models::GetXrpRippleTransactionDetailsByTransactionIdriValue) -> GetXrpRippleTransactionDetailsByTransactionIdri {
        GetXrpRippleTransactionDetailsByTransactionIdri {
            additional_data,
            destination_tag: None,
            index,
            mined_in_block_hash,
            mined_in_block_height,
            offer: Box::new(offer),
            receive: Box::new(receive),
            recipients,
            senders,
            sequence,
            status: None,
            timestamp,
            transaction_hash,
            _type,
            fee: Box::new(fee),
            value: Box::new(value),
        }
    }
}


