/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetWalletTransactionDetailsByTransactionIdribs {
    /// Represents the time at which a particular transaction can be added to the blockchain.
    #[serde(rename = "locktime")]
    pub locktime: i32,
    /// Represents the total size of this transaction.
    #[serde(rename = "size")]
    pub size: i32,
    /// Represents the virtual size of this transaction.
    #[serde(rename = "vSize")]
    pub v_size: i32,
    /// Represents the transaction version number.
    #[serde(rename = "version")]
    pub version: i32,
    /// Object Array representation of transaction inputs
    #[serde(rename = "vin")]
    pub vin: Vec<crate::models::GetWalletTransactionDetailsByTransactionIdribszVin>,
    /// Object Array representation of transaction outputs
    #[serde(rename = "vout")]
    pub vout: Vec<crate::models::ListTransactionsByBlockHeightRibszVout>,
    /// Represents the specific transaction contract
    #[serde(rename = "contract")]
    pub contract: String,
    /// Represents the amount of gas used by this specific transaction alone.
    #[serde(rename = "gasLimit")]
    pub gas_limit: String,
    #[serde(rename = "gasPrice")]
    pub gas_price: Box<crate::models::GetTransactionDetailsByTransactionIdribsbscGasPrice>,
    /// Defines the unit of the gas price amount, e.g. BTC, ETH, XRP.
    #[serde(rename = "gasUsed")]
    pub gas_used: String,
    /// Represents additional information that is required for the transaction.
    #[serde(rename = "inputData")]
    pub input_data: String,
    /// Represents the sequential running number for an address, starting from 0 for the first transaction. E.g., if the nonce of a transaction is 10, it would be the 11th transaction sent from the sender's address.
    #[serde(rename = "nonce")]
    pub nonce: i32,
    /// String representation of the transaction status
    #[serde(rename = "transactionStatus")]
    pub transaction_status: String,
    /// It is used to enforce balance of Spend and Output transfers, in order to prevent their replay across transactions.
    #[serde(rename = "bindingSig")]
    pub binding_sig: String,
    /// Represents a block height after which the transaction will expire.
    #[serde(rename = "expiryHeight")]
    pub expiry_height: i32,
    /// Represents an encoding of a JoinSplitSig public validating key.
    #[serde(rename = "joinSplitPubKey")]
    pub join_split_pub_key: String,
    /// Is used to sign transactions that contain at least one JoinSplit description.
    #[serde(rename = "joinSplitSig")]
    pub join_split_sig: String,
    /// \"Overwinter\" is the network upgrade for the Zcash blockchain.
    #[serde(rename = "overwintered")]
    pub overwintered: bool,
    /// Represents a sequence of JoinSplit descriptions using BCTV14 proofs.
    #[serde(rename = "vJoinSplit", skip_serializing_if = "Option::is_none")]
    pub v_join_split: Option<Vec<crate::models::GetTransactionDetailsByTransactionIdribszVJoinSplit>>,
    /// Object Array representation of transaction output descriptions
    #[serde(rename = "vShieldedOutput", skip_serializing_if = "Option::is_none")]
    pub v_shielded_output: Option<Vec<crate::models::GetTransactionDetailsByTransactionIdribszVShieldedOutput>>,
    /// Object Array representation of transaction spend descriptions
    #[serde(rename = "vShieldedSpend", skip_serializing_if = "Option::is_none")]
    pub v_shielded_spend: Option<Vec<crate::models::GetTransactionDetailsByTransactionIdribszVShieldedSpend>>,
    /// String representation of the transaction value balance
    #[serde(rename = "valueBalance")]
    pub value_balance: String,
    /// Represents the transaction version group ID.
    #[serde(rename = "versionGroupId")]
    pub version_group_id: String,
}

impl GetWalletTransactionDetailsByTransactionIdribs {
    pub fn new(locktime: i32, size: i32, v_size: i32, version: i32, vin: Vec<crate::models::GetWalletTransactionDetailsByTransactionIdribszVin>, vout: Vec<crate::models::ListTransactionsByBlockHeightRibszVout>, contract: String, gas_limit: String, gas_price: crate::models::GetTransactionDetailsByTransactionIdribsbscGasPrice, gas_used: String, input_data: String, nonce: i32, transaction_status: String, binding_sig: String, expiry_height: i32, join_split_pub_key: String, join_split_sig: String, overwintered: bool, value_balance: String, version_group_id: String) -> GetWalletTransactionDetailsByTransactionIdribs {
        GetWalletTransactionDetailsByTransactionIdribs {
            locktime,
            size,
            v_size,
            version,
            vin,
            vout,
            contract,
            gas_limit,
            gas_price: Box::new(gas_price),
            gas_used,
            input_data,
            nonce,
            transaction_status,
            binding_sig,
            expiry_height,
            join_split_pub_key,
            join_split_sig,
            overwintered,
            v_join_split: None,
            v_shielded_output: None,
            v_shielded_spend: None,
            value_balance,
            version_group_id,
        }
    }
}


