/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetWalletAssetDetailsRi {
    #[serde(rename = "confirmedBalance")]
    pub confirmed_balance: Box<crate::models::GetWalletAssetDetailsRiConfirmedBalance>,
    /// Specifies the count of deposit addresses in the Wallet.
    #[serde(rename = "depositAddressesCount")]
    pub deposit_addresses_count: i32,
    /// Represents fungible tokens'es detailed information
    #[serde(rename = "fungibleTokens")]
    pub fungible_tokens: Vec<crate::models::GetWalletAssetDetailsRiFungibleTokens>,
    /// Defines the name of the Wallet given to it by the user.
    #[serde(rename = "name")]
    pub name: String,
    /// Represents non-fungible tokens'es detailed information.
    #[serde(rename = "nonFungibleTokens")]
    pub non_fungible_tokens: Vec<crate::models::GetWalletAssetDetailsRiNonFungibleTokens>,
    #[serde(rename = "recievedConfirmedAmount")]
    pub recieved_confirmed_amount: Box<crate::models::GetWalletAssetDetailsRiRecievedConfirmedAmount>,
    #[serde(rename = "sentConfirmedAmount")]
    pub sent_confirmed_amount: Box<crate::models::GetWalletAssetDetailsRiSentConfirmedAmount>,
}

impl GetWalletAssetDetailsRi {
    pub fn new(confirmed_balance: crate::models::GetWalletAssetDetailsRiConfirmedBalance, deposit_addresses_count: i32, fungible_tokens: Vec<crate::models::GetWalletAssetDetailsRiFungibleTokens>, name: String, non_fungible_tokens: Vec<crate::models::GetWalletAssetDetailsRiNonFungibleTokens>, recieved_confirmed_amount: crate::models::GetWalletAssetDetailsRiRecievedConfirmedAmount, sent_confirmed_amount: crate::models::GetWalletAssetDetailsRiSentConfirmedAmount) -> GetWalletAssetDetailsRi {
        GetWalletAssetDetailsRi {
            confirmed_balance: Box::new(confirmed_balance),
            deposit_addresses_count,
            fungible_tokens,
            name,
            non_fungible_tokens,
            recieved_confirmed_amount: Box::new(recieved_confirmed_amount),
            sent_confirmed_amount: Box::new(sent_confirmed_amount),
        }
    }
}


