/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */

/// GetTransactionDetailsByTransactionIdFromCallbackRibsz2 : Zilliqa



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetTransactionDetailsByTransactionIdFromCallbackRibsz2 {
    /// Represents the maximum amount of gas allowed in the block in order to determine how many transactions it can fit.
    #[serde(rename = "gasLimit")]
    pub gas_limit: i32,
    #[serde(rename = "gasPrice")]
    pub gas_price: Box<crate::models::GetTransactionDetailsByTransactionIdFromCallbackRibsz2GasPrice>,
    /// Defines how much of the gas for the block has been used.
    #[serde(rename = "gasUsed")]
    pub gas_used: i32,
    /// Represents the sequential running number for an address, starting from 0 for the first transaction. E.g., if the nonce of a transaction is 10, it would be the 11th transaction sent from the sender's address.
    #[serde(rename = "nonce")]
    pub nonce: i32,
    /// Represents the status of this transaction.
    #[serde(rename = "transactionStatus")]
    pub transaction_status: String,
}

impl GetTransactionDetailsByTransactionIdFromCallbackRibsz2 {
    /// Zilliqa
    pub fn new(gas_limit: i32, gas_price: crate::models::GetTransactionDetailsByTransactionIdFromCallbackRibsz2GasPrice, gas_used: i32, nonce: i32, transaction_status: String) -> GetTransactionDetailsByTransactionIdFromCallbackRibsz2 {
        GetTransactionDetailsByTransactionIdFromCallbackRibsz2 {
            gas_limit,
            gas_price: Box::new(gas_price),
            gas_used,
            nonce,
            transaction_status,
        }
    }
}


