/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */

/// GetTransactionDetailsByTransactionIdFromCallbackRibsx : XRP



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetTransactionDetailsByTransactionIdFromCallbackRibsx {
    /// Represents additional data that may be needed.
    #[serde(rename = "additionalData")]
    pub additional_data: String,
    /// Defines the destination tag value.
    #[serde(rename = "destinationTag", skip_serializing_if = "Option::is_none")]
    pub destination_tag: Option<i32>,
    #[serde(rename = "offer")]
    pub offer: Box<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriOffer>,
    #[serde(rename = "receive")]
    pub receive: Box<crate::models::GetXrpRippleTransactionDetailsByTransactionIdriReceive>,
    /// Defines the transaction input's sequence as an integer, which is is used when transactions are replaced with newer versions before LockTime.
    #[serde(rename = "sequence")]
    pub sequence: i32,
    /// Defines the status of the transaction.
    #[serde(rename = "status")]
    pub status: String,
    /// Defines the type of the transaction.
    #[serde(rename = "type")]
    pub _type: String,
    #[serde(rename = "value")]
    pub value: Box<crate::models::GetTransactionDetailsByTransactionIdFromCallbackRibsxValue>,
}

impl GetTransactionDetailsByTransactionIdFromCallbackRibsx {
    /// XRP
    pub fn new(additional_data: String, offer: crate::models::GetXrpRippleTransactionDetailsByTransactionIdriOffer, receive: crate::models::GetXrpRippleTransactionDetailsByTransactionIdriReceive, sequence: i32, status: String, _type: String, value: crate::models::GetTransactionDetailsByTransactionIdFromCallbackRibsxValue) -> GetTransactionDetailsByTransactionIdFromCallbackRibsx {
        GetTransactionDetailsByTransactionIdFromCallbackRibsx {
            additional_data,
            destination_tag: None,
            offer: Box::new(offer),
            receive: Box::new(receive),
            sequence,
            status,
            _type,
            value: Box::new(value),
        }
    }
}


