/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */

/// GetAssetDetailsByAssetIdriLatestRate : Specifies the latest price of the asset.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetAssetDetailsByAssetIdriLatestRate {
    /// Represents the amount of the latest rate.
    #[serde(rename = "amount")]
    pub amount: String,
    /// Defines when the price was calculated in UNIX timestamp.
    #[serde(rename = "calculationTimestamp", skip_serializing_if = "Option::is_none")]
    pub calculation_timestamp: Option<i32>,
    /// Specifies the unit of the latest price of the asset.
    #[serde(rename = "unit")]
    pub unit: String,
}

impl GetAssetDetailsByAssetIdriLatestRate {
    /// Specifies the latest price of the asset.
    pub fn new(amount: String, unit: String) -> GetAssetDetailsByAssetIdriLatestRate {
        GetAssetDetailsByAssetIdriLatestRate {
            amount,
            calculation_timestamp: None,
            unit,
        }
    }
}


