/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetAssetDetailsByAssetIdri {
    /// Defines the unique ID of the specific asset.
    #[serde(rename = "assetId")]
    pub asset_id: String,
    #[serde(rename = "assetLogo")]
    pub asset_logo: Box<crate::models::GetAssetDetailsByAssetIdriAssetLogo>,
    /// Specifies the name of the asset in question.
    #[serde(rename = "assetName")]
    pub asset_name: String,
    /// Specifies the asset's original symbol as introduced by its founders.
    #[serde(rename = "assetOriginalSymbol")]
    pub asset_original_symbol: String,
    /// Specifies the asset's unique symbol in the Crypto APIs listings.
    #[serde(rename = "assetSymbol")]
    pub asset_symbol: String,
    /// Defines the type of the supported asset. This could be either \"crypto\" or \"fiat\".
    #[serde(rename = "assetType")]
    pub asset_type: AssetType,
    #[serde(rename = "latestRate")]
    pub latest_rate: Box<crate::models::GetAssetDetailsByAssetIdriLatestRate>,
    /// Represents the asset`s unique slug string in Crypto APIs listings.
    #[serde(rename = "slug", skip_serializing_if = "Option::is_none")]
    pub slug: Option<String>,
    #[serde(rename = "specificData")]
    pub specific_data: Box<crate::models::GetAssetDetailsByAssetIdris>,
}

impl GetAssetDetailsByAssetIdri {
    pub fn new(asset_id: String, asset_logo: crate::models::GetAssetDetailsByAssetIdriAssetLogo, asset_name: String, asset_original_symbol: String, asset_symbol: String, asset_type: AssetType, latest_rate: crate::models::GetAssetDetailsByAssetIdriLatestRate, specific_data: crate::models::GetAssetDetailsByAssetIdris) -> GetAssetDetailsByAssetIdri {
        GetAssetDetailsByAssetIdri {
            asset_id,
            asset_logo: Box::new(asset_logo),
            asset_name,
            asset_original_symbol,
            asset_symbol,
            asset_type,
            latest_rate: Box::new(latest_rate),
            slug: None,
            specific_data: Box::new(specific_data),
        }
    }
}

/// Defines the type of the supported asset. This could be either \"crypto\" or \"fiat\".
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum AssetType {
    #[serde(rename = "fiat")]
    Fiat,
    #[serde(rename = "crypto")]
    Crypto,
}

