# Rust API client for cryptoapis

Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.4.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://cryptoapis.io](https://cryptoapis.io)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
cryptoapis = { path = "./cryptoapis" }
```

## Documentation for API Endpoints

All URIs are relative to *https://rest.cryptoapis.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AssetsApi* | [**get_asset_details_by_asset_id**](docs/AssetsApi.md#get_asset_details_by_asset_id) | **GET** /market-data/assets/assetId/{assetId} | Get Asset Details By Asset ID
*AssetsApi* | [**get_asset_details_by_asset_symbol**](docs/AssetsApi.md#get_asset_details_by_asset_symbol) | **GET** /market-data/assets/{assetSymbol} | Get Asset Details By Asset Symbol
*AssetsApi* | [**list_assets_details**](docs/AssetsApi.md#list_assets_details) | **GET** /market-data/assets/details | List Assets Details
*AutomaticCoinsForwardingApi* | [**create_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#create_automatic_coins_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | Create Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**delete_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#delete_automatic_coins_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations/{referenceId} | Delete Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**list_coins_forwarding_automations**](docs/AutomaticCoinsForwardingApi.md#list_coins_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | List Coins Forwarding Automations
*AutomaticTokensForwardingApi* | [**add_tokens_to_existing_from_address**](docs/AutomaticTokensForwardingApi.md#add_tokens_to_existing_from_address) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/add-token | Add Tokens To Existing fromAddress
*AutomaticTokensForwardingApi* | [**create_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#create_automatic_tokens_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | Create Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**delete_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#delete_automatic_tokens_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/{referenceId} | Delete Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**get_fee_address_details**](docs/AutomaticTokensForwardingApi.md#get_fee_address_details) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/fee-addresses | Get Fee Address Details
*AutomaticTokensForwardingApi* | [**list_tokens_forwarding_automations**](docs/AutomaticTokensForwardingApi.md#list_tokens_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | List Tokens Forwarding Automations
*CallbackDataApi* | [**get_address_details_from_callback**](docs/CallbackDataApi.md#get_address_details_from_callback) | **GET** /blockchain-events/{blockchain}/{network}/addresses/{address} | Get Address Details From Callback
*CallbackDataApi* | [**get_block_details_by_block_hash_from_callback**](docs/CallbackDataApi.md#get_block_details_by_block_hash_from_callback) | **GET** /blockcain-events/{blockchain}/{network}/blocks/hash/{blockHash} | Get Block Details By Block Hash From Callback
*CallbackDataApi* | [**get_block_details_by_block_height_from_callback**](docs/CallbackDataApi.md#get_block_details_by_block_height_from_callback) | **GET** /blockcain-events/{blockchain}/{network}/blocks/height/{blockHeight} | Get Block Details By Block Height From Callback
*CallbackDataApi* | [**get_transaction_details_by_transaction_id_from_callback**](docs/CallbackDataApi.md#get_transaction_details_by_transaction_id_from_callback) | **GET** /blockchain-events/{blockchain}/{network}/transactions/{transactionId} | Get Transaction Details By Transaction ID From Callback
*CreateSubscriptionsForApi* | [**mined_transaction**](docs/CreateSubscriptionsForApi.md#mined_transaction) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/transaction-mined | Mined transaction
*CreateSubscriptionsForApi* | [**new_block**](docs/CreateSubscriptionsForApi.md#new_block) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/block-mined | New Block
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed | New confirmed coins transactions
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed-each-confirmation | New confirmed coins transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed | New confirmed internal transactions
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed-each-confirmation | New confirmed internal transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed | New confirmed tokens transactions
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed-each-confirmation | New confirmed tokens transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_unconfirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-unconfirmed | New unconfirmed coins transactions
*CreateSubscriptionsForApi* | [**new_unconfirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-unconfirmed | New unconfirmed tokens transactions
*ExchangeRatesApi* | [**get_exchange_rate_by_asset_symbols**](docs/ExchangeRatesApi.md#get_exchange_rate_by_asset_symbols) | **GET** /market-data/exchange-rates/by-symbols/{fromAssetSymbol}/{toAssetSymbol} | Get Exchange Rate By Asset Symbols
*ExchangeRatesApi* | [**get_exchange_rate_by_assets_ids**](docs/ExchangeRatesApi.md#get_exchange_rate_by_assets_ids) | **GET** /market-data/exchange-rates/by-asset-ids/{fromAssetId}/{toAssetId} | Get Exchange Rate By Assets IDs
*FeaturesApi* | [**broadcast_locally_signed_transaction**](docs/FeaturesApi.md#broadcast_locally_signed_transaction) | **POST** /blockchain-tools/{blockchain}/{network}/transactions/broadcast | Broadcast Locally Signed Transaction
*FeaturesApi* | [**get_eip_1559_fee_recommendations**](docs/FeaturesApi.md#get_eip_1559_fee_recommendations) | **GET** /blockchain-tools/{blockchain}/{network}/fees/eip1559 | Get EIP 1559 Fee Recommendations
*FeaturesApi* | [**validate_address**](docs/FeaturesApi.md#validate_address) | **POST** /blockchain-tools/{blockchain}/{network}/addresses/validate | Validate Address
*GeneratingApi* | [**generate_deposit_address**](docs/GeneratingApi.md#generate_deposit_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | Generate Deposit Address
*HDWalletsApi* | [**get_hd_wallet__x_pub_y_pub_z_pub_details**](docs/HDWalletsApi.md#get_hd_wallet__x_pub_y_pub_z_pub_details) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/details | Get HD Wallet (xPub, yPub, zPub) Details
*HDWalletsApi* | [**list_hd_wallet__x_pub_y_pub_z_pub_transactions**](docs/HDWalletsApi.md#list_hd_wallet__x_pub_y_pub_z_pub_transactions) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/transactions | List HD Wallet (xPub, yPub, zPub) Transactions
*HDWalletsApi* | [**sync_hd_wallet__x_pub_y_pub_z_pub**](docs/HDWalletsApi.md#sync_hd_wallet__x_pub_y_pub_z_pub) | **POST** /blockchain-data/{blockchain}/{network}/hd/sync | Sync HD Wallet (xPub, yPub, zPub)
*InformativeApi* | [**get_transaction_request_details**](docs/InformativeApi.md#get_transaction_request_details) | **GET** /wallet-as-a-service/transactionRequests/{transactionRequestId} | Get Transaction Request Details
*InformativeApi* | [**get_wallet_asset_details**](docs/InformativeApi.md#get_wallet_asset_details) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network} | Get Wallet Asset Details
*InformativeApi* | [**get_wallet_transaction_details_by_transaction_id**](docs/InformativeApi.md#get_wallet_transaction_details_by_transaction_id) | **GET** /wallet-as-a-service/wallets/{blockchain}/{network}/transactions/{transactionId} | Get Wallet Transaction Details By Transaction ID
*InformativeApi* | [**list_deposit_addresses**](docs/InformativeApi.md#list_deposit_addresses) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | List Deposit Addresses
*InformativeApi* | [**list_supported_tokens**](docs/InformativeApi.md#list_supported_tokens) | **GET** /wallet-as-a-service/info/{blockchain}/{network}/supported-tokens | List Supported Tokens
*InformativeApi* | [**list_wallet_transactions**](docs/InformativeApi.md#list_wallet_transactions) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/transactions | List Wallet Transactions
*InternalApi* | [**get_internal_transaction_by_transaction_hash_and_operation_id**](docs/InternalApi.md#get_internal_transaction_by_transaction_hash_and_operation_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal/{operationId} | Get Internal Transaction by Transaction Hash and Operation Id
*InternalApi* | [**list_internal_transaction_details_by_transaction_hash**](docs/InternalApi.md#list_internal_transaction_details_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal | List Internal Transaction Details by Transaction Hash
*InternalApi* | [**list_internal_transactions_by_address**](docs/InternalApi.md#list_internal_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/internal | List Internal Transactions By Address
*ManageSubscriptionsApi* | [**activate_blockchain_event_subscription**](docs/ManageSubscriptionsApi.md#activate_blockchain_event_subscription) | **POST** /blockchain-events/subscriptions/{referenceId}/activate | Activate Blockchain Event Subscription
*ManageSubscriptionsApi* | [**delete_blockchain_event_subscription**](docs/ManageSubscriptionsApi.md#delete_blockchain_event_subscription) | **DELETE** /blockchain-events/{blockchain}/{network}/subscriptions/{referenceId} | Delete Blockchain Event Subscription
*ManageSubscriptionsApi* | [**list_blockchain_events_subscriptions**](docs/ManageSubscriptionsApi.md#list_blockchain_events_subscriptions) | **GET** /blockchain-events/{blockchain}/{network}/subscriptions | List Blockchain Events Subscriptions
*MetadataApi* | [**list_supported_assets**](docs/MetadataApi.md#list_supported_assets) | **GET** /market-data/assets/supported | List Supported Assets
*OmniLayerApi* | [**get_omni_transaction_details_by_transaction_id__txid**](docs/OmniLayerApi.md#get_omni_transaction_details_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions/{transactionId} | Get Omni Transaction Details By Transaction ID (Txid)
*OmniLayerApi* | [**get_unconfirmed_omni_transaction_by_transaction_id__txid**](docs/OmniLayerApi.md#get_unconfirmed_omni_transaction_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions-unconfirmed/{transactionId} | Get Unconfirmed Omni Transaction By Transaction ID (Txid)
*OmniLayerApi* | [**list_omni_tokens_by_address**](docs/OmniLayerApi.md#list_omni_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address} | List Omni Tokens By Address
*OmniLayerApi* | [**list_omni_transactions_by_address**](docs/OmniLayerApi.md#list_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address}/transactions | List Omni Transactions By Address
*OmniLayerApi* | [**list_omni_transactions_by_block_hash**](docs/OmniLayerApi.md#list_omni_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/hash/{blockHash}/transactions | List Omni Transactions By Block Hash
*OmniLayerApi* | [**list_omni_transactions_by_block_height**](docs/OmniLayerApi.md#list_omni_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/height/{blockHeight}/transactions | List Omni Transactions By Block Height
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_address**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/address-transactions-unconfirmed/{address} | List Unconfirmed Omni Transactions By Address
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_property_id**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_property_id) | **GET** /blockchain-data/{blockchain}/{network}/omni/properties/{propertyId}/transactions | List Unconfirmed Omni Transactions By Property ID
*TokensApi* | [**get_token_details_by_contract_address**](docs/TokensApi.md#get_token_details_by_contract_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{contractAddress}/contract | Get Token Details by Contract Address
*TokensApi* | [**list_confirmed_tokens_transfers_by_address**](docs/TokensApi.md#list_confirmed_tokens_transfers_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens-transfers | List Confirmed Tokens Transfers By Address
*TokensApi* | [**list_tokens_by_address**](docs/TokensApi.md#list_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens | List Tokens By Address
*TokensApi* | [**list_tokens_transfers_by_transaction_hash**](docs/TokensApi.md#list_tokens_transfers_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/tokens-transfers | List Tokens Transfers By Transaction Hash
*TransactionsApi* | [**create_coins_transaction_from_address_for_whole_amount**](docs/TransactionsApi.md#create_coins_transaction_from_address_for_whole_amount) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/all-transaction-requests | Create Coins Transaction From Address For Whole Amount
*TransactionsApi* | [**create_coins_transaction_request_from_address**](docs/TransactionsApi.md#create_coins_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/transaction-requests | Create Coins Transaction Request from Address
*TransactionsApi* | [**create_coins_transaction_request_from_wallet**](docs/TransactionsApi.md#create_coins_transaction_request_from_wallet) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/transaction-requests | Create Coins Transaction Request from Wallet
*TransactionsApi* | [**create_fungible_tokens_transaction_request_from_address**](docs/TransactionsApi.md#create_fungible_tokens_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{senderAddress}/token-transaction-requests | Create Fungible Tokens Transaction Request from Address
*UTXOBasedApi* | [**list_unspent_transaction_outputs_by_address**](docs/UTXOBasedApi.md#list_unspent_transaction_outputs_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/unspent | List Unspent Transaction Outputs By Address
*UnifiedEndpointsApi* | [**get_address_details**](docs/UnifiedEndpointsApi.md#get_address_details) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address} | Get Address Details
*UnifiedEndpointsApi* | [**get_block_details_by_block_hash**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash} | Get Block Details By Block Hash
*UnifiedEndpointsApi* | [**get_block_details_by_block_height**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height} | Get Block Details By Block Height
*UnifiedEndpointsApi* | [**get_fee_recommendations**](docs/UnifiedEndpointsApi.md#get_fee_recommendations) | **GET** /blockchain-data/{blockchain}/{network}/mempool/fees | Get Fee Recommendations
*UnifiedEndpointsApi* | [**get_last_mined_block**](docs/UnifiedEndpointsApi.md#get_last_mined_block) | **GET** /blockchain-data/{blockchain}/{network}/blocks/last | Get Last Mined Block
*UnifiedEndpointsApi* | [**get_transaction_details_by_transaction_id**](docs/UnifiedEndpointsApi.md#get_transaction_details_by_transaction_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionId} | Get Transaction Details By Transaction ID
*UnifiedEndpointsApi* | [**list_all_unconfirmed_transactions**](docs/UnifiedEndpointsApi.md#list_all_unconfirmed_transactions) | **GET** /blockchain-data/{blockchain}/{network}/address-transactions-unconfirmed | List All Unconfirmed Transactions
*UnifiedEndpointsApi* | [**list_confirmed_transactions_by_address**](docs/UnifiedEndpointsApi.md#list_confirmed_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/transactions | List Confirmed Transactions By Address
*UnifiedEndpointsApi* | [**list_latest_mined_blocks**](docs/UnifiedEndpointsApi.md#list_latest_mined_blocks) | **GET** /blockchain-data/{blockchain}/{network}/blocks/last/{count} | List Latest Mined Blocks
*UnifiedEndpointsApi* | [**list_transactions_by_block_hash**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}/transactions | List Transactions by Block Hash
*UnifiedEndpointsApi* | [**list_transactions_by_block_height**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height}/transactions | List Transactions by Block Height
*UnifiedEndpointsApi* | [**list_unconfirmed_transactions_by_address**](docs/UnifiedEndpointsApi.md#list_unconfirmed_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/address-transactions-unconfirmed/{address} | List Unconfirmed Transactions by Address
*XRPRippleApi* | [**get_latest_mined_xrp__ripple_block**](docs/XRPRippleApi.md#get_latest_mined_xrp__ripple_block) | **GET** /blockchain-data/xrp-specific/{network}/blocks/last | Get Latest Mined XRP (Ripple) Block
*XRPRippleApi* | [**get_xrp__ripple_address_details**](docs/XRPRippleApi.md#get_xrp__ripple_address_details) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address} | Get XRP (Ripple) Address Details
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_hash**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash} | Get XRP (Ripple) Block Details By Block Hash
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_height**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight} | Get XRP (Ripple) Block Details By Block Height
*XRPRippleApi* | [**get_xrp__ripple_transaction_details_by_transaction_id**](docs/XRPRippleApi.md#get_xrp__ripple_transaction_details_by_transaction_id) | **GET** /blockchain-data/xrp-specific/{network}/transactions/{transactionHash} | Get XRP (Ripple) Transaction Details By Transaction ID
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_address**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_address) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address}/transactions | List XRP (Ripple) Transactions by Address
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_hash**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash}/transactions | List XRP (Ripple) Transactions By Block Hash
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_height**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight}/transactions | List XRP (Ripple) Transactions By Block Height
*ZilliqaApi* | [**get_latest_mined_zilliqa_block**](docs/ZilliqaApi.md#get_latest_mined_zilliqa_block) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/last | Get Latest Mined Zilliqa Block
*ZilliqaApi* | [**get_zilliqa_address_details**](docs/ZilliqaApi.md#get_zilliqa_address_details) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address} | Get Zilliqa Address Details
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_hash**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash} | Get Zilliqa Block Details By Block Hash
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_height**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight} | Get Zilliqa Block Details By Block Height
*ZilliqaApi* | [**get_zilliqa_transaction_details_by_transaction_id**](docs/ZilliqaApi.md#get_zilliqa_transaction_details_by_transaction_id) | **GET** /blockchain-data/zilliqa-specific/{network}/transactions/{transactionHash} | Get Zilliqa Transaction Details by Transaction ID
*ZilliqaApi* | [**list_zilliqa_transactions_by_address**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_address) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address}/transactions | List Zilliqa Transactions by Address
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_hash**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash}/transactions | List Zilliqa Transactions By Block Hash
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_height**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight}/transactions | List Zilliqa Transactions By Block Height


## Documentation For Models

 - [ActivateBlockchainEventSubscriptionE400](docs/ActivateBlockchainEventSubscriptionE400.md)
 - [ActivateBlockchainEventSubscriptionE401](docs/ActivateBlockchainEventSubscriptionE401.md)
 - [ActivateBlockchainEventSubscriptionE403](docs/ActivateBlockchainEventSubscriptionE403.md)
 - [ActivateBlockchainEventSubscriptionR](docs/ActivateBlockchainEventSubscriptionR.md)
 - [ActivateBlockchainEventSubscriptionRData](docs/ActivateBlockchainEventSubscriptionRData.md)
 - [ActivateBlockchainEventSubscriptionRb](docs/ActivateBlockchainEventSubscriptionRb.md)
 - [ActivateBlockchainEventSubscriptionRbData](docs/ActivateBlockchainEventSubscriptionRbData.md)
 - [ActivateBlockchainEventSubscriptionRi](docs/ActivateBlockchainEventSubscriptionRi.md)
 - [AddTokensToExistingFromAddressE400](docs/AddTokensToExistingFromAddressE400.md)
 - [AddTokensToExistingFromAddressE401](docs/AddTokensToExistingFromAddressE401.md)
 - [AddTokensToExistingFromAddressE403](docs/AddTokensToExistingFromAddressE403.md)
 - [AddTokensToExistingFromAddressR](docs/AddTokensToExistingFromAddressR.md)
 - [AddTokensToExistingFromAddressRData](docs/AddTokensToExistingFromAddressRData.md)
 - [AddTokensToExistingFromAddressRb](docs/AddTokensToExistingFromAddressRb.md)
 - [AddTokensToExistingFromAddressRbData](docs/AddTokensToExistingFromAddressRbData.md)
 - [AddTokensToExistingFromAddressRbDataItem](docs/AddTokensToExistingFromAddressRbDataItem.md)
 - [AddTokensToExistingFromAddressRbTokenData](docs/AddTokensToExistingFromAddressRbTokenData.md)
 - [AddTokensToExistingFromAddressRbTokenDataBitcoinOmniToken](docs/AddTokensToExistingFromAddressRbTokenDataBitcoinOmniToken.md)
 - [AddTokensToExistingFromAddressRbTokenDataEthereumToken](docs/AddTokensToExistingFromAddressRbTokenDataEthereumToken.md)
 - [AddTokensToExistingFromAddressRi](docs/AddTokensToExistingFromAddressRi.md)
 - [AddTokensToExistingFromAddressRits](docs/AddTokensToExistingFromAddressRits.md)
 - [AddTokensToExistingFromAddressRitsbot](docs/AddTokensToExistingFromAddressRitsbot.md)
 - [AddTokensToExistingFromAddressRitset](docs/AddTokensToExistingFromAddressRitset.md)
 - [AddressCoinsTransactionConfirmed](docs/AddressCoinsTransactionConfirmed.md)
 - [AddressCoinsTransactionConfirmedData](docs/AddressCoinsTransactionConfirmedData.md)
 - [AddressCoinsTransactionConfirmedDataItem](docs/AddressCoinsTransactionConfirmedDataItem.md)
 - [AddressCoinsTransactionConfirmedDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressCoinsTransactionConfirmedEachConfirmation](docs/AddressCoinsTransactionConfirmedEachConfirmation.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationData](docs/AddressCoinsTransactionConfirmedEachConfirmationData.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItem](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressCoinsTransactionUnconfirmed](docs/AddressCoinsTransactionUnconfirmed.md)
 - [AddressCoinsTransactionUnconfirmedData](docs/AddressCoinsTransactionUnconfirmedData.md)
 - [AddressCoinsTransactionUnconfirmedDataItem](docs/AddressCoinsTransactionUnconfirmedDataItem.md)
 - [AddressInternalTransactionConfirmed](docs/AddressInternalTransactionConfirmed.md)
 - [AddressInternalTransactionConfirmedData](docs/AddressInternalTransactionConfirmedData.md)
 - [AddressInternalTransactionConfirmedDataItem](docs/AddressInternalTransactionConfirmedDataItem.md)
 - [AddressInternalTransactionConfirmedDataItemMinedInBlock](docs/AddressInternalTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressInternalTransactionConfirmedEachConfirmation](docs/AddressInternalTransactionConfirmedEachConfirmation.md)
 - [AddressInternalTransactionConfirmedEachConfirmationData](docs/AddressInternalTransactionConfirmedEachConfirmationData.md)
 - [AddressInternalTransactionConfirmedEachConfirmationDataItem](docs/AddressInternalTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressInternalTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressInternalTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmed](docs/AddressTokensTransactionConfirmed.md)
 - [AddressTokensTransactionConfirmedBep20](docs/AddressTokensTransactionConfirmedBep20.md)
 - [AddressTokensTransactionConfirmedData](docs/AddressTokensTransactionConfirmedData.md)
 - [AddressTokensTransactionConfirmedDataItem](docs/AddressTokensTransactionConfirmedDataItem.md)
 - [AddressTokensTransactionConfirmedDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmation](docs/AddressTokensTransactionConfirmedEachConfirmation.md)
 - [AddressTokensTransactionConfirmedEachConfirmationBep20](docs/AddressTokensTransactionConfirmedEachConfirmationBep20.md)
 - [AddressTokensTransactionConfirmedEachConfirmationData](docs/AddressTokensTransactionConfirmedEachConfirmationData.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItem](docs/AddressTokensTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressTokensTransactionConfirmedEachConfirmationErc20](docs/AddressTokensTransactionConfirmedEachConfirmationErc20.md)
 - [AddressTokensTransactionConfirmedEachConfirmationErc721](docs/AddressTokensTransactionConfirmedEachConfirmationErc721.md)
 - [AddressTokensTransactionConfirmedEachConfirmationOmni](docs/AddressTokensTransactionConfirmedEachConfirmationOmni.md)
 - [AddressTokensTransactionConfirmedEachConfirmationToken](docs/AddressTokensTransactionConfirmedEachConfirmationToken.md)
 - [AddressTokensTransactionConfirmedErc20](docs/AddressTokensTransactionConfirmedErc20.md)
 - [AddressTokensTransactionConfirmedErc721](docs/AddressTokensTransactionConfirmedErc721.md)
 - [AddressTokensTransactionConfirmedOmni](docs/AddressTokensTransactionConfirmedOmni.md)
 - [AddressTokensTransactionConfirmedToken](docs/AddressTokensTransactionConfirmedToken.md)
 - [AddressTokensTransactionUnconfirmed](docs/AddressTokensTransactionUnconfirmed.md)
 - [AddressTokensTransactionUnconfirmedData](docs/AddressTokensTransactionUnconfirmedData.md)
 - [AddressTokensTransactionUnconfirmedDataItem](docs/AddressTokensTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionUnconfirmedErc20](docs/AddressTokensTransactionUnconfirmedErc20.md)
 - [AddressTokensTransactionUnconfirmedErc721](docs/AddressTokensTransactionUnconfirmedErc721.md)
 - [AddressTokensTransactionUnconfirmedOmni](docs/AddressTokensTransactionUnconfirmedOmni.md)
 - [AddressTokensTransactionUnconfirmedToken](docs/AddressTokensTransactionUnconfirmedToken.md)
 - [AlreadyExists](docs/AlreadyExists.md)
 - [BannedIpAddress](docs/BannedIpAddress.md)
 - [BannedIpAddressDetails](docs/BannedIpAddressDetails.md)
 - [BlockMined](docs/BlockMined.md)
 - [BlockMinedData](docs/BlockMinedData.md)
 - [BlockMinedDataItem](docs/BlockMinedDataItem.md)
 - [BlockchainDataAddressEventSubscriptionNotFound](docs/BlockchainDataAddressEventSubscriptionNotFound.md)
 - [BlockchainDataBlockNotFound](docs/BlockchainDataBlockNotFound.md)
 - [BlockchainDataInternalTransactionNotFound](docs/BlockchainDataInternalTransactionNotFound.md)
 - [BlockchainDataTransactionNotFound](docs/BlockchainDataTransactionNotFound.md)
 - [BlockchainEventsCallbacksLimitReached](docs/BlockchainEventsCallbacksLimitReached.md)
 - [BroadcastLocallySignedTransactionE400](docs/BroadcastLocallySignedTransactionE400.md)
 - [BroadcastLocallySignedTransactionE401](docs/BroadcastLocallySignedTransactionE401.md)
 - [BroadcastLocallySignedTransactionE403](docs/BroadcastLocallySignedTransactionE403.md)
 - [BroadcastLocallySignedTransactionE409](docs/BroadcastLocallySignedTransactionE409.md)
 - [BroadcastLocallySignedTransactionR](docs/BroadcastLocallySignedTransactionR.md)
 - [BroadcastLocallySignedTransactionRData](docs/BroadcastLocallySignedTransactionRData.md)
 - [BroadcastLocallySignedTransactionRb](docs/BroadcastLocallySignedTransactionRb.md)
 - [BroadcastLocallySignedTransactionRbData](docs/BroadcastLocallySignedTransactionRbData.md)
 - [BroadcastLocallySignedTransactionRbDataItem](docs/BroadcastLocallySignedTransactionRbDataItem.md)
 - [BroadcastLocallySignedTransactionRi](docs/BroadcastLocallySignedTransactionRi.md)
 - [BroadcastTransactionFail](docs/BroadcastTransactionFail.md)
 - [BroadcastTransactionFailData](docs/BroadcastTransactionFailData.md)
 - [BroadcastTransactionFailDataItem](docs/BroadcastTransactionFailDataItem.md)
 - [BroadcastTransactionSuccess](docs/BroadcastTransactionSuccess.md)
 - [BroadcastTransactionSuccessData](docs/BroadcastTransactionSuccessData.md)
 - [BroadcastTransactionSuccessDataItem](docs/BroadcastTransactionSuccessDataItem.md)
 - [CoinsForwardingAutomationsLimitReached](docs/CoinsForwardingAutomationsLimitReached.md)
 - [CoinsForwardingFail](docs/CoinsForwardingFail.md)
 - [CoinsForwardingFailData](docs/CoinsForwardingFailData.md)
 - [CoinsForwardingFailDataItem](docs/CoinsForwardingFailDataItem.md)
 - [CoinsForwardingSuccess](docs/CoinsForwardingSuccess.md)
 - [CoinsForwardingSuccessData](docs/CoinsForwardingSuccessData.md)
 - [CoinsForwardingSuccessDataItem](docs/CoinsForwardingSuccessDataItem.md)
 - [CouldNotCalculateRateForPair](docs/CouldNotCalculateRateForPair.md)
 - [CreateAutomaticCoinsForwardingE400](docs/CreateAutomaticCoinsForwardingE400.md)
 - [CreateAutomaticCoinsForwardingE401](docs/CreateAutomaticCoinsForwardingE401.md)
 - [CreateAutomaticCoinsForwardingE403](docs/CreateAutomaticCoinsForwardingE403.md)
 - [CreateAutomaticCoinsForwardingE409](docs/CreateAutomaticCoinsForwardingE409.md)
 - [CreateAutomaticCoinsForwardingR](docs/CreateAutomaticCoinsForwardingR.md)
 - [CreateAutomaticCoinsForwardingRData](docs/CreateAutomaticCoinsForwardingRData.md)
 - [CreateAutomaticCoinsForwardingRb](docs/CreateAutomaticCoinsForwardingRb.md)
 - [CreateAutomaticCoinsForwardingRbData](docs/CreateAutomaticCoinsForwardingRbData.md)
 - [CreateAutomaticCoinsForwardingRbDataItem](docs/CreateAutomaticCoinsForwardingRbDataItem.md)
 - [CreateAutomaticCoinsForwardingRi](docs/CreateAutomaticCoinsForwardingRi.md)
 - [CreateAutomaticTokensForwardingE400](docs/CreateAutomaticTokensForwardingE400.md)
 - [CreateAutomaticTokensForwardingE401](docs/CreateAutomaticTokensForwardingE401.md)
 - [CreateAutomaticTokensForwardingE403](docs/CreateAutomaticTokensForwardingE403.md)
 - [CreateAutomaticTokensForwardingR](docs/CreateAutomaticTokensForwardingR.md)
 - [CreateAutomaticTokensForwardingRData](docs/CreateAutomaticTokensForwardingRData.md)
 - [CreateAutomaticTokensForwardingRb](docs/CreateAutomaticTokensForwardingRb.md)
 - [CreateAutomaticTokensForwardingRbData](docs/CreateAutomaticTokensForwardingRbData.md)
 - [CreateAutomaticTokensForwardingRbDataItem](docs/CreateAutomaticTokensForwardingRbDataItem.md)
 - [CreateAutomaticTokensForwardingRbTokenData](docs/CreateAutomaticTokensForwardingRbTokenData.md)
 - [CreateAutomaticTokensForwardingRbTokenDataBitcoinOmniToken](docs/CreateAutomaticTokensForwardingRbTokenDataBitcoinOmniToken.md)
 - [CreateAutomaticTokensForwardingRbTokenDataEthereumToken](docs/CreateAutomaticTokensForwardingRbTokenDataEthereumToken.md)
 - [CreateAutomaticTokensForwardingRi](docs/CreateAutomaticTokensForwardingRi.md)
 - [CreateAutomaticTokensForwardingRits](docs/CreateAutomaticTokensForwardingRits.md)
 - [CreateAutomaticTokensForwardingRitsbot](docs/CreateAutomaticTokensForwardingRitsbot.md)
 - [CreateAutomaticTokensForwardingRitset](docs/CreateAutomaticTokensForwardingRitset.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountE400](docs/CreateCoinsTransactionFromAddressForWholeAmountE400.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountE401](docs/CreateCoinsTransactionFromAddressForWholeAmountE401.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountE403](docs/CreateCoinsTransactionFromAddressForWholeAmountE403.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountE409](docs/CreateCoinsTransactionFromAddressForWholeAmountE409.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountR](docs/CreateCoinsTransactionFromAddressForWholeAmountR.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRData](docs/CreateCoinsTransactionFromAddressForWholeAmountRData.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRb](docs/CreateCoinsTransactionFromAddressForWholeAmountRb.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRbData](docs/CreateCoinsTransactionFromAddressForWholeAmountRbData.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRbDataItem](docs/CreateCoinsTransactionFromAddressForWholeAmountRbDataItem.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRi](docs/CreateCoinsTransactionFromAddressForWholeAmountRi.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRiRecipients](docs/CreateCoinsTransactionFromAddressForWholeAmountRiRecipients.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRiSenders](docs/CreateCoinsTransactionFromAddressForWholeAmountRiSenders.md)
 - [CreateCoinsTransactionRequestFromAddressE400](docs/CreateCoinsTransactionRequestFromAddressE400.md)
 - [CreateCoinsTransactionRequestFromAddressE401](docs/CreateCoinsTransactionRequestFromAddressE401.md)
 - [CreateCoinsTransactionRequestFromAddressE403](docs/CreateCoinsTransactionRequestFromAddressE403.md)
 - [CreateCoinsTransactionRequestFromAddressE409](docs/CreateCoinsTransactionRequestFromAddressE409.md)
 - [CreateCoinsTransactionRequestFromAddressR](docs/CreateCoinsTransactionRequestFromAddressR.md)
 - [CreateCoinsTransactionRequestFromAddressRData](docs/CreateCoinsTransactionRequestFromAddressRData.md)
 - [CreateCoinsTransactionRequestFromAddressRb](docs/CreateCoinsTransactionRequestFromAddressRb.md)
 - [CreateCoinsTransactionRequestFromAddressRbData](docs/CreateCoinsTransactionRequestFromAddressRbData.md)
 - [CreateCoinsTransactionRequestFromAddressRbDataItem](docs/CreateCoinsTransactionRequestFromAddressRbDataItem.md)
 - [CreateCoinsTransactionRequestFromAddressRi](docs/CreateCoinsTransactionRequestFromAddressRi.md)
 - [CreateCoinsTransactionRequestFromAddressRiRecipients](docs/CreateCoinsTransactionRequestFromAddressRiRecipients.md)
 - [CreateCoinsTransactionRequestFromAddressRiSenders](docs/CreateCoinsTransactionRequestFromAddressRiSenders.md)
 - [CreateCoinsTransactionRequestFromWalletE400](docs/CreateCoinsTransactionRequestFromWalletE400.md)
 - [CreateCoinsTransactionRequestFromWalletE401](docs/CreateCoinsTransactionRequestFromWalletE401.md)
 - [CreateCoinsTransactionRequestFromWalletE403](docs/CreateCoinsTransactionRequestFromWalletE403.md)
 - [CreateCoinsTransactionRequestFromWalletE409](docs/CreateCoinsTransactionRequestFromWalletE409.md)
 - [CreateCoinsTransactionRequestFromWalletR](docs/CreateCoinsTransactionRequestFromWalletR.md)
 - [CreateCoinsTransactionRequestFromWalletRData](docs/CreateCoinsTransactionRequestFromWalletRData.md)
 - [CreateCoinsTransactionRequestFromWalletRb](docs/CreateCoinsTransactionRequestFromWalletRb.md)
 - [CreateCoinsTransactionRequestFromWalletRbData](docs/CreateCoinsTransactionRequestFromWalletRbData.md)
 - [CreateCoinsTransactionRequestFromWalletRbDataItem](docs/CreateCoinsTransactionRequestFromWalletRbDataItem.md)
 - [CreateCoinsTransactionRequestFromWalletRbDataItemRecipients](docs/CreateCoinsTransactionRequestFromWalletRbDataItemRecipients.md)
 - [CreateCoinsTransactionRequestFromWalletRi](docs/CreateCoinsTransactionRequestFromWalletRi.md)
 - [CreateCoinsTransactionRequestFromWalletRiRecipients](docs/CreateCoinsTransactionRequestFromWalletRiRecipients.md)
 - [CreateFungibleTokensTransactionRequestFromAddressE400](docs/CreateFungibleTokensTransactionRequestFromAddressE400.md)
 - [CreateFungibleTokensTransactionRequestFromAddressE401](docs/CreateFungibleTokensTransactionRequestFromAddressE401.md)
 - [CreateFungibleTokensTransactionRequestFromAddressE403](docs/CreateFungibleTokensTransactionRequestFromAddressE403.md)
 - [CreateFungibleTokensTransactionRequestFromAddressE409](docs/CreateFungibleTokensTransactionRequestFromAddressE409.md)
 - [CreateFungibleTokensTransactionRequestFromAddressR](docs/CreateFungibleTokensTransactionRequestFromAddressR.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRData](docs/CreateFungibleTokensTransactionRequestFromAddressRData.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRb](docs/CreateFungibleTokensTransactionRequestFromAddressRb.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRbData](docs/CreateFungibleTokensTransactionRequestFromAddressRbData.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRbDataItem](docs/CreateFungibleTokensTransactionRequestFromAddressRbDataItem.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRi](docs/CreateFungibleTokensTransactionRequestFromAddressRi.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRiRecipients](docs/CreateFungibleTokensTransactionRequestFromAddressRiRecipients.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRiSenders](docs/CreateFungibleTokensTransactionRequestFromAddressRiSenders.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRis](docs/CreateFungibleTokensTransactionRequestFromAddressRis.md)
 - [CreateFungibleTokensTransactionRequestFromAddressRise](docs/CreateFungibleTokensTransactionRequestFromAddressRise.md)
 - [DeleteAutomaticCoinsForwardingE400](docs/DeleteAutomaticCoinsForwardingE400.md)
 - [DeleteAutomaticCoinsForwardingE401](docs/DeleteAutomaticCoinsForwardingE401.md)
 - [DeleteAutomaticCoinsForwardingE403](docs/DeleteAutomaticCoinsForwardingE403.md)
 - [DeleteAutomaticCoinsForwardingR](docs/DeleteAutomaticCoinsForwardingR.md)
 - [DeleteAutomaticCoinsForwardingRData](docs/DeleteAutomaticCoinsForwardingRData.md)
 - [DeleteAutomaticCoinsForwardingRi](docs/DeleteAutomaticCoinsForwardingRi.md)
 - [DeleteAutomaticTokensForwardingE400](docs/DeleteAutomaticTokensForwardingE400.md)
 - [DeleteAutomaticTokensForwardingE401](docs/DeleteAutomaticTokensForwardingE401.md)
 - [DeleteAutomaticTokensForwardingE403](docs/DeleteAutomaticTokensForwardingE403.md)
 - [DeleteAutomaticTokensForwardingR](docs/DeleteAutomaticTokensForwardingR.md)
 - [DeleteAutomaticTokensForwardingRData](docs/DeleteAutomaticTokensForwardingRData.md)
 - [DeleteAutomaticTokensForwardingRi](docs/DeleteAutomaticTokensForwardingRi.md)
 - [DeleteAutomaticTokensForwardingRits](docs/DeleteAutomaticTokensForwardingRits.md)
 - [DeleteAutomaticTokensForwardingRitsbot](docs/DeleteAutomaticTokensForwardingRitsbot.md)
 - [DeleteAutomaticTokensForwardingRitset](docs/DeleteAutomaticTokensForwardingRitset.md)
 - [DeleteBlockchainEventSubscriptionE400](docs/DeleteBlockchainEventSubscriptionE400.md)
 - [DeleteBlockchainEventSubscriptionE401](docs/DeleteBlockchainEventSubscriptionE401.md)
 - [DeleteBlockchainEventSubscriptionE403](docs/DeleteBlockchainEventSubscriptionE403.md)
 - [DeleteBlockchainEventSubscriptionR](docs/DeleteBlockchainEventSubscriptionR.md)
 - [DeleteBlockchainEventSubscriptionRData](docs/DeleteBlockchainEventSubscriptionRData.md)
 - [DeleteBlockchainEventSubscriptionRi](docs/DeleteBlockchainEventSubscriptionRi.md)
 - [EndpointNotAllowedForApiKey](docs/EndpointNotAllowedForApiKey.md)
 - [EndpointNotAllowedForPlan](docs/EndpointNotAllowedForPlan.md)
 - [FeatureMainnetsNotAllowedForPlan](docs/FeatureMainnetsNotAllowedForPlan.md)
 - [GenerateDepositAddressE400](docs/GenerateDepositAddressE400.md)
 - [GenerateDepositAddressE401](docs/GenerateDepositAddressE401.md)
 - [GenerateDepositAddressE403](docs/GenerateDepositAddressE403.md)
 - [GenerateDepositAddressR](docs/GenerateDepositAddressR.md)
 - [GenerateDepositAddressRData](docs/GenerateDepositAddressRData.md)
 - [GenerateDepositAddressRb](docs/GenerateDepositAddressRb.md)
 - [GenerateDepositAddressRbData](docs/GenerateDepositAddressRbData.md)
 - [GenerateDepositAddressRbDataItem](docs/GenerateDepositAddressRbDataItem.md)
 - [GenerateDepositAddressRi](docs/GenerateDepositAddressRi.md)
 - [GetAddressDetailsE400](docs/GetAddressDetailsE400.md)
 - [GetAddressDetailsE401](docs/GetAddressDetailsE401.md)
 - [GetAddressDetailsE403](docs/GetAddressDetailsE403.md)
 - [GetAddressDetailsFromCallbackE400](docs/GetAddressDetailsFromCallbackE400.md)
 - [GetAddressDetailsFromCallbackE401](docs/GetAddressDetailsFromCallbackE401.md)
 - [GetAddressDetailsFromCallbackE403](docs/GetAddressDetailsFromCallbackE403.md)
 - [GetAddressDetailsFromCallbackR](docs/GetAddressDetailsFromCallbackR.md)
 - [GetAddressDetailsFromCallbackRData](docs/GetAddressDetailsFromCallbackRData.md)
 - [GetAddressDetailsFromCallbackRi](docs/GetAddressDetailsFromCallbackRi.md)
 - [GetAddressDetailsFromCallbackRiTotalReceived](docs/GetAddressDetailsFromCallbackRiTotalReceived.md)
 - [GetAddressDetailsFromCallbackRiTotalSpent](docs/GetAddressDetailsFromCallbackRiTotalSpent.md)
 - [GetAddressDetailsR](docs/GetAddressDetailsR.md)
 - [GetAddressDetailsRData](docs/GetAddressDetailsRData.md)
 - [GetAddressDetailsRi](docs/GetAddressDetailsRi.md)
 - [GetAddressDetailsRiConfirmedBalance](docs/GetAddressDetailsRiConfirmedBalance.md)
 - [GetAddressDetailsRiTotalReceived](docs/GetAddressDetailsRiTotalReceived.md)
 - [GetAddressDetailsRiTotalSpent](docs/GetAddressDetailsRiTotalSpent.md)
 - [GetAssetDetailsByAssetIde400](docs/GetAssetDetailsByAssetIde400.md)
 - [GetAssetDetailsByAssetIde401](docs/GetAssetDetailsByAssetIde401.md)
 - [GetAssetDetailsByAssetIde403](docs/GetAssetDetailsByAssetIde403.md)
 - [GetAssetDetailsByAssetIdr](docs/GetAssetDetailsByAssetIdr.md)
 - [GetAssetDetailsByAssetIdrData](docs/GetAssetDetailsByAssetIdrData.md)
 - [GetAssetDetailsByAssetIdri](docs/GetAssetDetailsByAssetIdri.md)
 - [GetAssetDetailsByAssetIdriAssetLogo](docs/GetAssetDetailsByAssetIdriAssetLogo.md)
 - [GetAssetDetailsByAssetIdriLatestRate](docs/GetAssetDetailsByAssetIdriLatestRate.md)
 - [GetAssetDetailsByAssetIdris](docs/GetAssetDetailsByAssetIdris.md)
 - [GetAssetDetailsByAssetIdrisc](docs/GetAssetDetailsByAssetIdrisc.md)
 - [GetAssetDetailsByAssetSymbolE400](docs/GetAssetDetailsByAssetSymbolE400.md)
 - [GetAssetDetailsByAssetSymbolE401](docs/GetAssetDetailsByAssetSymbolE401.md)
 - [GetAssetDetailsByAssetSymbolE403](docs/GetAssetDetailsByAssetSymbolE403.md)
 - [GetAssetDetailsByAssetSymbolR](docs/GetAssetDetailsByAssetSymbolR.md)
 - [GetAssetDetailsByAssetSymbolRData](docs/GetAssetDetailsByAssetSymbolRData.md)
 - [GetAssetDetailsByAssetSymbolRi](docs/GetAssetDetailsByAssetSymbolRi.md)
 - [GetAssetDetailsByAssetSymbolRis](docs/GetAssetDetailsByAssetSymbolRis.md)
 - [GetAssetDetailsByAssetSymbolRisc](docs/GetAssetDetailsByAssetSymbolRisc.md)
 - [GetBlockDetailsByBlockHashE400](docs/GetBlockDetailsByBlockHashE400.md)
 - [GetBlockDetailsByBlockHashE401](docs/GetBlockDetailsByBlockHashE401.md)
 - [GetBlockDetailsByBlockHashE403](docs/GetBlockDetailsByBlockHashE403.md)
 - [GetBlockDetailsByBlockHashFromCallbackE400](docs/GetBlockDetailsByBlockHashFromCallbackE400.md)
 - [GetBlockDetailsByBlockHashFromCallbackE401](docs/GetBlockDetailsByBlockHashFromCallbackE401.md)
 - [GetBlockDetailsByBlockHashFromCallbackE403](docs/GetBlockDetailsByBlockHashFromCallbackE403.md)
 - [GetBlockDetailsByBlockHashFromCallbackR](docs/GetBlockDetailsByBlockHashFromCallbackR.md)
 - [GetBlockDetailsByBlockHashFromCallbackRData](docs/GetBlockDetailsByBlockHashFromCallbackRData.md)
 - [GetBlockDetailsByBlockHashFromCallbackRi](docs/GetBlockDetailsByBlockHashFromCallbackRi.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibs](docs/GetBlockDetailsByBlockHashFromCallbackRibs.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsb](docs/GetBlockDetailsByBlockHashFromCallbackRibsb.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsbc](docs/GetBlockDetailsByBlockHashFromCallbackRibsbc.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsbsc](docs/GetBlockDetailsByBlockHashFromCallbackRibsbsc.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsd](docs/GetBlockDetailsByBlockHashFromCallbackRibsd.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsd2](docs/GetBlockDetailsByBlockHashFromCallbackRibsd2.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibse](docs/GetBlockDetailsByBlockHashFromCallbackRibse.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsec](docs/GetBlockDetailsByBlockHashFromCallbackRibsec.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsl](docs/GetBlockDetailsByBlockHashFromCallbackRibsl.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsx](docs/GetBlockDetailsByBlockHashFromCallbackRibsx.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsz](docs/GetBlockDetailsByBlockHashFromCallbackRibsz.md)
 - [GetBlockDetailsByBlockHashFromCallbackRibsz2](docs/GetBlockDetailsByBlockHashFromCallbackRibsz2.md)
 - [GetBlockDetailsByBlockHashR](docs/GetBlockDetailsByBlockHashR.md)
 - [GetBlockDetailsByBlockHashRData](docs/GetBlockDetailsByBlockHashRData.md)
 - [GetBlockDetailsByBlockHashRi](docs/GetBlockDetailsByBlockHashRi.md)
 - [GetBlockDetailsByBlockHashRibs](docs/GetBlockDetailsByBlockHashRibs.md)
 - [GetBlockDetailsByBlockHashRibsb](docs/GetBlockDetailsByBlockHashRibsb.md)
 - [GetBlockDetailsByBlockHashRibsbc](docs/GetBlockDetailsByBlockHashRibsbc.md)
 - [GetBlockDetailsByBlockHashRibsbsc](docs/GetBlockDetailsByBlockHashRibsbsc.md)
 - [GetBlockDetailsByBlockHashRibsd](docs/GetBlockDetailsByBlockHashRibsd.md)
 - [GetBlockDetailsByBlockHashRibsd2](docs/GetBlockDetailsByBlockHashRibsd2.md)
 - [GetBlockDetailsByBlockHashRibse](docs/GetBlockDetailsByBlockHashRibse.md)
 - [GetBlockDetailsByBlockHashRibsec](docs/GetBlockDetailsByBlockHashRibsec.md)
 - [GetBlockDetailsByBlockHashRibsl](docs/GetBlockDetailsByBlockHashRibsl.md)
 - [GetBlockDetailsByBlockHashRibsz](docs/GetBlockDetailsByBlockHashRibsz.md)
 - [GetBlockDetailsByBlockHeightE400](docs/GetBlockDetailsByBlockHeightE400.md)
 - [GetBlockDetailsByBlockHeightE401](docs/GetBlockDetailsByBlockHeightE401.md)
 - [GetBlockDetailsByBlockHeightE403](docs/GetBlockDetailsByBlockHeightE403.md)
 - [GetBlockDetailsByBlockHeightFromCallbackE400](docs/GetBlockDetailsByBlockHeightFromCallbackE400.md)
 - [GetBlockDetailsByBlockHeightFromCallbackE401](docs/GetBlockDetailsByBlockHeightFromCallbackE401.md)
 - [GetBlockDetailsByBlockHeightFromCallbackE403](docs/GetBlockDetailsByBlockHeightFromCallbackE403.md)
 - [GetBlockDetailsByBlockHeightFromCallbackR](docs/GetBlockDetailsByBlockHeightFromCallbackR.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRData](docs/GetBlockDetailsByBlockHeightFromCallbackRData.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRi](docs/GetBlockDetailsByBlockHeightFromCallbackRi.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibs](docs/GetBlockDetailsByBlockHeightFromCallbackRibs.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsb](docs/GetBlockDetailsByBlockHeightFromCallbackRibsb.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsbc](docs/GetBlockDetailsByBlockHeightFromCallbackRibsbc.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsbsc](docs/GetBlockDetailsByBlockHeightFromCallbackRibsbsc.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsd](docs/GetBlockDetailsByBlockHeightFromCallbackRibsd.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsd2](docs/GetBlockDetailsByBlockHeightFromCallbackRibsd2.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibse](docs/GetBlockDetailsByBlockHeightFromCallbackRibse.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsec](docs/GetBlockDetailsByBlockHeightFromCallbackRibsec.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsl](docs/GetBlockDetailsByBlockHeightFromCallbackRibsl.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsx](docs/GetBlockDetailsByBlockHeightFromCallbackRibsx.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsz](docs/GetBlockDetailsByBlockHeightFromCallbackRibsz.md)
 - [GetBlockDetailsByBlockHeightFromCallbackRibsz2](docs/GetBlockDetailsByBlockHeightFromCallbackRibsz2.md)
 - [GetBlockDetailsByBlockHeightR](docs/GetBlockDetailsByBlockHeightR.md)
 - [GetBlockDetailsByBlockHeightRData](docs/GetBlockDetailsByBlockHeightRData.md)
 - [GetBlockDetailsByBlockHeightRi](docs/GetBlockDetailsByBlockHeightRi.md)
 - [GetBlockDetailsByBlockHeightRibs](docs/GetBlockDetailsByBlockHeightRibs.md)
 - [GetBlockDetailsByBlockHeightRibsb](docs/GetBlockDetailsByBlockHeightRibsb.md)
 - [GetBlockDetailsByBlockHeightRibsbc](docs/GetBlockDetailsByBlockHeightRibsbc.md)
 - [GetBlockDetailsByBlockHeightRibsbsc](docs/GetBlockDetailsByBlockHeightRibsbsc.md)
 - [GetBlockDetailsByBlockHeightRibsd](docs/GetBlockDetailsByBlockHeightRibsd.md)
 - [GetBlockDetailsByBlockHeightRibsd2](docs/GetBlockDetailsByBlockHeightRibsd2.md)
 - [GetBlockDetailsByBlockHeightRibse](docs/GetBlockDetailsByBlockHeightRibse.md)
 - [GetBlockDetailsByBlockHeightRibsec](docs/GetBlockDetailsByBlockHeightRibsec.md)
 - [GetBlockDetailsByBlockHeightRibsl](docs/GetBlockDetailsByBlockHeightRibsl.md)
 - [GetBlockDetailsByBlockHeightRibsz](docs/GetBlockDetailsByBlockHeightRibsz.md)
 - [GetEip1559FeeRecommendationsE400](docs/GetEip1559FeeRecommendationsE400.md)
 - [GetEip1559FeeRecommendationsE401](docs/GetEip1559FeeRecommendationsE401.md)
 - [GetEip1559FeeRecommendationsE403](docs/GetEip1559FeeRecommendationsE403.md)
 - [GetEip1559FeeRecommendationsR](docs/GetEip1559FeeRecommendationsR.md)
 - [GetEip1559FeeRecommendationsRData](docs/GetEip1559FeeRecommendationsRData.md)
 - [GetEip1559FeeRecommendationsRi](docs/GetEip1559FeeRecommendationsRi.md)
 - [GetEip1559FeeRecommendationsRiBaseFeePerGas](docs/GetEip1559FeeRecommendationsRiBaseFeePerGas.md)
 - [GetEip1559FeeRecommendationsRiMaxFeePerGas](docs/GetEip1559FeeRecommendationsRiMaxFeePerGas.md)
 - [GetEip1559FeeRecommendationsRiMaxPriorityFeePerGas](docs/GetEip1559FeeRecommendationsRiMaxPriorityFeePerGas.md)
 - [GetExchangeRateByAssetSymbolsE400](docs/GetExchangeRateByAssetSymbolsE400.md)
 - [GetExchangeRateByAssetSymbolsE401](docs/GetExchangeRateByAssetSymbolsE401.md)
 - [GetExchangeRateByAssetSymbolsE403](docs/GetExchangeRateByAssetSymbolsE403.md)
 - [GetExchangeRateByAssetSymbolsE422](docs/GetExchangeRateByAssetSymbolsE422.md)
 - [GetExchangeRateByAssetSymbolsR](docs/GetExchangeRateByAssetSymbolsR.md)
 - [GetExchangeRateByAssetSymbolsRData](docs/GetExchangeRateByAssetSymbolsRData.md)
 - [GetExchangeRateByAssetSymbolsRi](docs/GetExchangeRateByAssetSymbolsRi.md)
 - [GetExchangeRateByAssetsIdsE400](docs/GetExchangeRateByAssetsIdsE400.md)
 - [GetExchangeRateByAssetsIdsE401](docs/GetExchangeRateByAssetsIdsE401.md)
 - [GetExchangeRateByAssetsIdsE403](docs/GetExchangeRateByAssetsIdsE403.md)
 - [GetExchangeRateByAssetsIdsE422](docs/GetExchangeRateByAssetsIdsE422.md)
 - [GetExchangeRateByAssetsIdsR](docs/GetExchangeRateByAssetsIdsR.md)
 - [GetExchangeRateByAssetsIdsRData](docs/GetExchangeRateByAssetsIdsRData.md)
 - [GetExchangeRateByAssetsIdsRi](docs/GetExchangeRateByAssetsIdsRi.md)
 - [GetFeeAddressDetailsE400](docs/GetFeeAddressDetailsE400.md)
 - [GetFeeAddressDetailsE401](docs/GetFeeAddressDetailsE401.md)
 - [GetFeeAddressDetailsE403](docs/GetFeeAddressDetailsE403.md)
 - [GetFeeAddressDetailsR](docs/GetFeeAddressDetailsR.md)
 - [GetFeeAddressDetailsRData](docs/GetFeeAddressDetailsRData.md)
 - [GetFeeAddressDetailsRi](docs/GetFeeAddressDetailsRi.md)
 - [GetFeeAddressDetailsRiBalance](docs/GetFeeAddressDetailsRiBalance.md)
 - [GetFeeRecommendationsE400](docs/GetFeeRecommendationsE400.md)
 - [GetFeeRecommendationsE401](docs/GetFeeRecommendationsE401.md)
 - [GetFeeRecommendationsE403](docs/GetFeeRecommendationsE403.md)
 - [GetFeeRecommendationsR](docs/GetFeeRecommendationsR.md)
 - [GetFeeRecommendationsRData](docs/GetFeeRecommendationsRData.md)
 - [GetFeeRecommendationsRi](docs/GetFeeRecommendationsRi.md)
 - [GetHdWalletXPubYPubZPubDetailsE400](docs/GetHdWalletXPubYPubZPubDetailsE400.md)
 - [GetHdWalletXPubYPubZPubDetailsE401](docs/GetHdWalletXPubYPubZPubDetailsE401.md)
 - [GetHdWalletXPubYPubZPubDetailsE403](docs/GetHdWalletXPubYPubZPubDetailsE403.md)
 - [GetHdWalletXPubYPubZPubDetailsE422](docs/GetHdWalletXPubYPubZPubDetailsE422.md)
 - [GetHdWalletXPubYPubZPubDetailsR](docs/GetHdWalletXPubYPubZPubDetailsR.md)
 - [GetHdWalletXPubYPubZPubDetailsRData](docs/GetHdWalletXPubYPubZPubDetailsRData.md)
 - [GetHdWalletXPubYPubZPubDetailsRi](docs/GetHdWalletXPubYPubZPubDetailsRi.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdE400](docs/GetInternalTransactionByTransactionHashAndOperationIdE400.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdE401](docs/GetInternalTransactionByTransactionHashAndOperationIdE401.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdE403](docs/GetInternalTransactionByTransactionHashAndOperationIdE403.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdR](docs/GetInternalTransactionByTransactionHashAndOperationIdR.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRData](docs/GetInternalTransactionByTransactionHashAndOperationIdRData.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRi](docs/GetInternalTransactionByTransactionHashAndOperationIdRi.md)
 - [GetLastMinedBlockE400](docs/GetLastMinedBlockE400.md)
 - [GetLastMinedBlockE401](docs/GetLastMinedBlockE401.md)
 - [GetLastMinedBlockE403](docs/GetLastMinedBlockE403.md)
 - [GetLastMinedBlockR](docs/GetLastMinedBlockR.md)
 - [GetLastMinedBlockRData](docs/GetLastMinedBlockRData.md)
 - [GetLastMinedBlockRi](docs/GetLastMinedBlockRi.md)
 - [GetLastMinedBlockRibs](docs/GetLastMinedBlockRibs.md)
 - [GetLastMinedBlockRibsb](docs/GetLastMinedBlockRibsb.md)
 - [GetLastMinedBlockRibsbc](docs/GetLastMinedBlockRibsbc.md)
 - [GetLastMinedBlockRibsbsc](docs/GetLastMinedBlockRibsbsc.md)
 - [GetLastMinedBlockRibsd](docs/GetLastMinedBlockRibsd.md)
 - [GetLastMinedBlockRibsd2](docs/GetLastMinedBlockRibsd2.md)
 - [GetLastMinedBlockRibse](docs/GetLastMinedBlockRibse.md)
 - [GetLastMinedBlockRibsec](docs/GetLastMinedBlockRibsec.md)
 - [GetLastMinedBlockRibsl](docs/GetLastMinedBlockRibsl.md)
 - [GetLastMinedBlockRibsz](docs/GetLastMinedBlockRibsz.md)
 - [GetLatestMinedXrpRippleBlockE400](docs/GetLatestMinedXrpRippleBlockE400.md)
 - [GetLatestMinedXrpRippleBlockE401](docs/GetLatestMinedXrpRippleBlockE401.md)
 - [GetLatestMinedXrpRippleBlockE403](docs/GetLatestMinedXrpRippleBlockE403.md)
 - [GetLatestMinedXrpRippleBlockR](docs/GetLatestMinedXrpRippleBlockR.md)
 - [GetLatestMinedXrpRippleBlockRData](docs/GetLatestMinedXrpRippleBlockRData.md)
 - [GetLatestMinedXrpRippleBlockRi](docs/GetLatestMinedXrpRippleBlockRi.md)
 - [GetLatestMinedXrpRippleBlockRiTotalCoins](docs/GetLatestMinedXrpRippleBlockRiTotalCoins.md)
 - [GetLatestMinedXrpRippleBlockRiTotalFees](docs/GetLatestMinedXrpRippleBlockRiTotalFees.md)
 - [GetLatestMinedZilliqaBlockE400](docs/GetLatestMinedZilliqaBlockE400.md)
 - [GetLatestMinedZilliqaBlockE401](docs/GetLatestMinedZilliqaBlockE401.md)
 - [GetLatestMinedZilliqaBlockE403](docs/GetLatestMinedZilliqaBlockE403.md)
 - [GetLatestMinedZilliqaBlockR](docs/GetLatestMinedZilliqaBlockR.md)
 - [GetLatestMinedZilliqaBlockRData](docs/GetLatestMinedZilliqaBlockRData.md)
 - [GetLatestMinedZilliqaBlockRi](docs/GetLatestMinedZilliqaBlockRi.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidE400](docs/GetOmniTransactionDetailsByTransactionIdTxidE400.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidE401](docs/GetOmniTransactionDetailsByTransactionIdTxidE401.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidE403](docs/GetOmniTransactionDetailsByTransactionIdTxidE403.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidR](docs/GetOmniTransactionDetailsByTransactionIdTxidR.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRData](docs/GetOmniTransactionDetailsByTransactionIdTxidRData.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRi](docs/GetOmniTransactionDetailsByTransactionIdTxidRi.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRiSenders](docs/GetOmniTransactionDetailsByTransactionIdTxidRiSenders.md)
 - [GetTokenDetailsByContractAddressE400](docs/GetTokenDetailsByContractAddressE400.md)
 - [GetTokenDetailsByContractAddressE401](docs/GetTokenDetailsByContractAddressE401.md)
 - [GetTokenDetailsByContractAddressE403](docs/GetTokenDetailsByContractAddressE403.md)
 - [GetTokenDetailsByContractAddressR](docs/GetTokenDetailsByContractAddressR.md)
 - [GetTokenDetailsByContractAddressRData](docs/GetTokenDetailsByContractAddressRData.md)
 - [GetTokenDetailsByContractAddressRi](docs/GetTokenDetailsByContractAddressRi.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackE400](docs/GetTransactionDetailsByTransactionIdFromCallbackE400.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackE401](docs/GetTransactionDetailsByTransactionIdFromCallbackE401.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackE403](docs/GetTransactionDetailsByTransactionIdFromCallbackE403.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackR](docs/GetTransactionDetailsByTransactionIdFromCallbackR.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRData](docs/GetTransactionDetailsByTransactionIdFromCallbackRData.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRi](docs/GetTransactionDetailsByTransactionIdFromCallbackRi.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRiFee](docs/GetTransactionDetailsByTransactionIdFromCallbackRiFee.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRiRecipients](docs/GetTransactionDetailsByTransactionIdFromCallbackRiRecipients.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRiSenders](docs/GetTransactionDetailsByTransactionIdFromCallbackRiSenders.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibs](docs/GetTransactionDetailsByTransactionIdFromCallbackRibs.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsb](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsb.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsbScriptSig](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsbScriptSig.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsbVin](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsbVin.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsbc](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsbc.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsbsc](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsbsc.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsd](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsd.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsd2](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsd2.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsd2Vin](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsd2Vin.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsd2Vout](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsd2Vout.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsdVin](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsdVin.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibse](docs/GetTransactionDetailsByTransactionIdFromCallbackRibse.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsec](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsec.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsl](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsl.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsx](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsx.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsxValue](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsxValue.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsz](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsz.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsz2](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsz2.md)
 - [GetTransactionDetailsByTransactionIdFromCallbackRibsz2GasPrice](docs/GetTransactionDetailsByTransactionIdFromCallbackRibsz2GasPrice.md)
 - [GetTransactionDetailsByTransactionIde400](docs/GetTransactionDetailsByTransactionIde400.md)
 - [GetTransactionDetailsByTransactionIde401](docs/GetTransactionDetailsByTransactionIde401.md)
 - [GetTransactionDetailsByTransactionIde403](docs/GetTransactionDetailsByTransactionIde403.md)
 - [GetTransactionDetailsByTransactionIdr](docs/GetTransactionDetailsByTransactionIdr.md)
 - [GetTransactionDetailsByTransactionIdrData](docs/GetTransactionDetailsByTransactionIdrData.md)
 - [GetTransactionDetailsByTransactionIdri](docs/GetTransactionDetailsByTransactionIdri.md)
 - [GetTransactionDetailsByTransactionIdriFee](docs/GetTransactionDetailsByTransactionIdriFee.md)
 - [GetTransactionDetailsByTransactionIdriRecipients](docs/GetTransactionDetailsByTransactionIdriRecipients.md)
 - [GetTransactionDetailsByTransactionIdriSenders](docs/GetTransactionDetailsByTransactionIdriSenders.md)
 - [GetTransactionDetailsByTransactionIdribs](docs/GetTransactionDetailsByTransactionIdribs.md)
 - [GetTransactionDetailsByTransactionIdribsb](docs/GetTransactionDetailsByTransactionIdribsb.md)
 - [GetTransactionDetailsByTransactionIdribsbScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsbScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsbScriptSig](docs/GetTransactionDetailsByTransactionIdribsbScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsbVin](docs/GetTransactionDetailsByTransactionIdribsbVin.md)
 - [GetTransactionDetailsByTransactionIdribsbVout](docs/GetTransactionDetailsByTransactionIdribsbVout.md)
 - [GetTransactionDetailsByTransactionIdribsbc](docs/GetTransactionDetailsByTransactionIdribsbc.md)
 - [GetTransactionDetailsByTransactionIdribsbcScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsbcScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsbcVin](docs/GetTransactionDetailsByTransactionIdribsbcVin.md)
 - [GetTransactionDetailsByTransactionIdribsbcVout](docs/GetTransactionDetailsByTransactionIdribsbcVout.md)
 - [GetTransactionDetailsByTransactionIdribsbsc](docs/GetTransactionDetailsByTransactionIdribsbsc.md)
 - [GetTransactionDetailsByTransactionIdribsbscGasPrice](docs/GetTransactionDetailsByTransactionIdribsbscGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsd](docs/GetTransactionDetailsByTransactionIdribsd.md)
 - [GetTransactionDetailsByTransactionIdribsd2](docs/GetTransactionDetailsByTransactionIdribsd2.md)
 - [GetTransactionDetailsByTransactionIdribsd2ScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsd2ScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsd2ScriptSig](docs/GetTransactionDetailsByTransactionIdribsd2ScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsd2Vin](docs/GetTransactionDetailsByTransactionIdribsd2Vin.md)
 - [GetTransactionDetailsByTransactionIdribsd2Vout](docs/GetTransactionDetailsByTransactionIdribsd2Vout.md)
 - [GetTransactionDetailsByTransactionIdribsdScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsdScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsdScriptSig](docs/GetTransactionDetailsByTransactionIdribsdScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsdVin](docs/GetTransactionDetailsByTransactionIdribsdVin.md)
 - [GetTransactionDetailsByTransactionIdribsdVout](docs/GetTransactionDetailsByTransactionIdribsdVout.md)
 - [GetTransactionDetailsByTransactionIdribse](docs/GetTransactionDetailsByTransactionIdribse.md)
 - [GetTransactionDetailsByTransactionIdribseGasPrice](docs/GetTransactionDetailsByTransactionIdribseGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsec](docs/GetTransactionDetailsByTransactionIdribsec.md)
 - [GetTransactionDetailsByTransactionIdribsecGasPrice](docs/GetTransactionDetailsByTransactionIdribsecGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsl](docs/GetTransactionDetailsByTransactionIdribsl.md)
 - [GetTransactionDetailsByTransactionIdribslScriptPubKey](docs/GetTransactionDetailsByTransactionIdribslScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribslScriptSig](docs/GetTransactionDetailsByTransactionIdribslScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribslVin](docs/GetTransactionDetailsByTransactionIdribslVin.md)
 - [GetTransactionDetailsByTransactionIdribslVout](docs/GetTransactionDetailsByTransactionIdribslVout.md)
 - [GetTransactionDetailsByTransactionIdribsz](docs/GetTransactionDetailsByTransactionIdribsz.md)
 - [GetTransactionDetailsByTransactionIdribszScriptPubKey](docs/GetTransactionDetailsByTransactionIdribszScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribszScriptSig](docs/GetTransactionDetailsByTransactionIdribszScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribszVJoinSplit](docs/GetTransactionDetailsByTransactionIdribszVJoinSplit.md)
 - [GetTransactionDetailsByTransactionIdribszVShieldedOutput](docs/GetTransactionDetailsByTransactionIdribszVShieldedOutput.md)
 - [GetTransactionDetailsByTransactionIdribszVShieldedSpend](docs/GetTransactionDetailsByTransactionIdribszVShieldedSpend.md)
 - [GetTransactionDetailsByTransactionIdribszVin](docs/GetTransactionDetailsByTransactionIdribszVin.md)
 - [GetTransactionDetailsByTransactionIdribszVout](docs/GetTransactionDetailsByTransactionIdribszVout.md)
 - [GetTransactionRequestDetailsE400](docs/GetTransactionRequestDetailsE400.md)
 - [GetTransactionRequestDetailsE401](docs/GetTransactionRequestDetailsE401.md)
 - [GetTransactionRequestDetailsE403](docs/GetTransactionRequestDetailsE403.md)
 - [GetTransactionRequestDetailsR](docs/GetTransactionRequestDetailsR.md)
 - [GetTransactionRequestDetailsRData](docs/GetTransactionRequestDetailsRData.md)
 - [GetTransactionRequestDetailsRi](docs/GetTransactionRequestDetailsRi.md)
 - [GetTransactionRequestDetailsRiRecipients](docs/GetTransactionRequestDetailsRiRecipients.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidE400](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidE400.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidE401](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidE401.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidE403](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidE403.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidR](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidR.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRData](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRData.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRi](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRi.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRiRecipients](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRiRecipients.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRiSenders](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRiSenders.md)
 - [GetWalletAssetDetailsE400](docs/GetWalletAssetDetailsE400.md)
 - [GetWalletAssetDetailsE401](docs/GetWalletAssetDetailsE401.md)
 - [GetWalletAssetDetailsE403](docs/GetWalletAssetDetailsE403.md)
 - [GetWalletAssetDetailsR](docs/GetWalletAssetDetailsR.md)
 - [GetWalletAssetDetailsRData](docs/GetWalletAssetDetailsRData.md)
 - [GetWalletAssetDetailsRi](docs/GetWalletAssetDetailsRi.md)
 - [GetWalletAssetDetailsRiConfirmedBalance](docs/GetWalletAssetDetailsRiConfirmedBalance.md)
 - [GetWalletAssetDetailsRiFungibleTokens](docs/GetWalletAssetDetailsRiFungibleTokens.md)
 - [GetWalletAssetDetailsRiNonFungibleTokens](docs/GetWalletAssetDetailsRiNonFungibleTokens.md)
 - [GetWalletAssetDetailsRiRecievedConfirmedAmount](docs/GetWalletAssetDetailsRiRecievedConfirmedAmount.md)
 - [GetWalletAssetDetailsRiSentConfirmedAmount](docs/GetWalletAssetDetailsRiSentConfirmedAmount.md)
 - [GetWalletTransactionDetailsByTransactionIde400](docs/GetWalletTransactionDetailsByTransactionIde400.md)
 - [GetWalletTransactionDetailsByTransactionIde401](docs/GetWalletTransactionDetailsByTransactionIde401.md)
 - [GetWalletTransactionDetailsByTransactionIde403](docs/GetWalletTransactionDetailsByTransactionIde403.md)
 - [GetWalletTransactionDetailsByTransactionIdr](docs/GetWalletTransactionDetailsByTransactionIdr.md)
 - [GetWalletTransactionDetailsByTransactionIdrData](docs/GetWalletTransactionDetailsByTransactionIdrData.md)
 - [GetWalletTransactionDetailsByTransactionIdri](docs/GetWalletTransactionDetailsByTransactionIdri.md)
 - [GetWalletTransactionDetailsByTransactionIdriFee](docs/GetWalletTransactionDetailsByTransactionIdriFee.md)
 - [GetWalletTransactionDetailsByTransactionIdriRecipients](docs/GetWalletTransactionDetailsByTransactionIdriRecipients.md)
 - [GetWalletTransactionDetailsByTransactionIdriSenders](docs/GetWalletTransactionDetailsByTransactionIdriSenders.md)
 - [GetWalletTransactionDetailsByTransactionIdribs](docs/GetWalletTransactionDetailsByTransactionIdribs.md)
 - [GetWalletTransactionDetailsByTransactionIdribsb](docs/GetWalletTransactionDetailsByTransactionIdribsb.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbScriptPubKey](docs/GetWalletTransactionDetailsByTransactionIdribsbScriptPubKey.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbScriptSig](docs/GetWalletTransactionDetailsByTransactionIdribsbScriptSig.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbVin](docs/GetWalletTransactionDetailsByTransactionIdribsbVin.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbVout](docs/GetWalletTransactionDetailsByTransactionIdribsbVout.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbc](docs/GetWalletTransactionDetailsByTransactionIdribsbc.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbcScriptPubKey](docs/GetWalletTransactionDetailsByTransactionIdribsbcScriptPubKey.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbcScriptSig](docs/GetWalletTransactionDetailsByTransactionIdribsbcScriptSig.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbcVin](docs/GetWalletTransactionDetailsByTransactionIdribsbcVin.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbcVout](docs/GetWalletTransactionDetailsByTransactionIdribsbcVout.md)
 - [GetWalletTransactionDetailsByTransactionIdribsbsc](docs/GetWalletTransactionDetailsByTransactionIdribsbsc.md)
 - [GetWalletTransactionDetailsByTransactionIdribsd](docs/GetWalletTransactionDetailsByTransactionIdribsd.md)
 - [GetWalletTransactionDetailsByTransactionIdribsd2](docs/GetWalletTransactionDetailsByTransactionIdribsd2.md)
 - [GetWalletTransactionDetailsByTransactionIdribsd2Vin](docs/GetWalletTransactionDetailsByTransactionIdribsd2Vin.md)
 - [GetWalletTransactionDetailsByTransactionIdribsdScriptSig](docs/GetWalletTransactionDetailsByTransactionIdribsdScriptSig.md)
 - [GetWalletTransactionDetailsByTransactionIdribsdVin](docs/GetWalletTransactionDetailsByTransactionIdribsdVin.md)
 - [GetWalletTransactionDetailsByTransactionIdribse](docs/GetWalletTransactionDetailsByTransactionIdribse.md)
 - [GetWalletTransactionDetailsByTransactionIdribseGasPrice](docs/GetWalletTransactionDetailsByTransactionIdribseGasPrice.md)
 - [GetWalletTransactionDetailsByTransactionIdribsec](docs/GetWalletTransactionDetailsByTransactionIdribsec.md)
 - [GetWalletTransactionDetailsByTransactionIdribsl](docs/GetWalletTransactionDetailsByTransactionIdribsl.md)
 - [GetWalletTransactionDetailsByTransactionIdribslScriptSig](docs/GetWalletTransactionDetailsByTransactionIdribslScriptSig.md)
 - [GetWalletTransactionDetailsByTransactionIdribslVin](docs/GetWalletTransactionDetailsByTransactionIdribslVin.md)
 - [GetWalletTransactionDetailsByTransactionIdribsz](docs/GetWalletTransactionDetailsByTransactionIdribsz.md)
 - [GetWalletTransactionDetailsByTransactionIdribszVin](docs/GetWalletTransactionDetailsByTransactionIdribszVin.md)
 - [GetXrpRippleAddressDetailsE400](docs/GetXrpRippleAddressDetailsE400.md)
 - [GetXrpRippleAddressDetailsE401](docs/GetXrpRippleAddressDetailsE401.md)
 - [GetXrpRippleAddressDetailsE403](docs/GetXrpRippleAddressDetailsE403.md)
 - [GetXrpRippleAddressDetailsR](docs/GetXrpRippleAddressDetailsR.md)
 - [GetXrpRippleAddressDetailsRData](docs/GetXrpRippleAddressDetailsRData.md)
 - [GetXrpRippleAddressDetailsRi](docs/GetXrpRippleAddressDetailsRi.md)
 - [GetXrpRippleAddressDetailsRiBalance](docs/GetXrpRippleAddressDetailsRiBalance.md)
 - [GetXrpRippleBlockDetailsByBlockHashE400](docs/GetXrpRippleBlockDetailsByBlockHashE400.md)
 - [GetXrpRippleBlockDetailsByBlockHashE401](docs/GetXrpRippleBlockDetailsByBlockHashE401.md)
 - [GetXrpRippleBlockDetailsByBlockHashE403](docs/GetXrpRippleBlockDetailsByBlockHashE403.md)
 - [GetXrpRippleBlockDetailsByBlockHashR](docs/GetXrpRippleBlockDetailsByBlockHashR.md)
 - [GetXrpRippleBlockDetailsByBlockHashRData](docs/GetXrpRippleBlockDetailsByBlockHashRData.md)
 - [GetXrpRippleBlockDetailsByBlockHashRi](docs/GetXrpRippleBlockDetailsByBlockHashRi.md)
 - [GetXrpRippleBlockDetailsByBlockHashRiTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHashRiTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightE400](docs/GetXrpRippleBlockDetailsByBlockHeightE400.md)
 - [GetXrpRippleBlockDetailsByBlockHeightE401](docs/GetXrpRippleBlockDetailsByBlockHeightE401.md)
 - [GetXrpRippleBlockDetailsByBlockHeightE403](docs/GetXrpRippleBlockDetailsByBlockHeightE403.md)
 - [GetXrpRippleBlockDetailsByBlockHeightR](docs/GetXrpRippleBlockDetailsByBlockHeightR.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRData](docs/GetXrpRippleBlockDetailsByBlockHeightRData.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRi](docs/GetXrpRippleBlockDetailsByBlockHeightRi.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRiTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHeightRiTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRiTotalFees](docs/GetXrpRippleBlockDetailsByBlockHeightRiTotalFees.md)
 - [GetXrpRippleTransactionDetailsByTransactionIde400](docs/GetXrpRippleTransactionDetailsByTransactionIde400.md)
 - [GetXrpRippleTransactionDetailsByTransactionIde401](docs/GetXrpRippleTransactionDetailsByTransactionIde401.md)
 - [GetXrpRippleTransactionDetailsByTransactionIde403](docs/GetXrpRippleTransactionDetailsByTransactionIde403.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdr](docs/GetXrpRippleTransactionDetailsByTransactionIdr.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdrData](docs/GetXrpRippleTransactionDetailsByTransactionIdrData.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdri](docs/GetXrpRippleTransactionDetailsByTransactionIdri.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriFee](docs/GetXrpRippleTransactionDetailsByTransactionIdriFee.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriOffer](docs/GetXrpRippleTransactionDetailsByTransactionIdriOffer.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriReceive](docs/GetXrpRippleTransactionDetailsByTransactionIdriReceive.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriRecipients](docs/GetXrpRippleTransactionDetailsByTransactionIdriRecipients.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriSenders](docs/GetXrpRippleTransactionDetailsByTransactionIdriSenders.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriValue](docs/GetXrpRippleTransactionDetailsByTransactionIdriValue.md)
 - [GetZilliqaAddressDetailsE400](docs/GetZilliqaAddressDetailsE400.md)
 - [GetZilliqaAddressDetailsE401](docs/GetZilliqaAddressDetailsE401.md)
 - [GetZilliqaAddressDetailsE403](docs/GetZilliqaAddressDetailsE403.md)
 - [GetZilliqaAddressDetailsR](docs/GetZilliqaAddressDetailsR.md)
 - [GetZilliqaAddressDetailsRData](docs/GetZilliqaAddressDetailsRData.md)
 - [GetZilliqaAddressDetailsRi](docs/GetZilliqaAddressDetailsRi.md)
 - [GetZilliqaAddressDetailsRiBalance](docs/GetZilliqaAddressDetailsRiBalance.md)
 - [GetZilliqaBlockDetailsByBlockHashE400](docs/GetZilliqaBlockDetailsByBlockHashE400.md)
 - [GetZilliqaBlockDetailsByBlockHashE401](docs/GetZilliqaBlockDetailsByBlockHashE401.md)
 - [GetZilliqaBlockDetailsByBlockHashE403](docs/GetZilliqaBlockDetailsByBlockHashE403.md)
 - [GetZilliqaBlockDetailsByBlockHashR](docs/GetZilliqaBlockDetailsByBlockHashR.md)
 - [GetZilliqaBlockDetailsByBlockHashRData](docs/GetZilliqaBlockDetailsByBlockHashRData.md)
 - [GetZilliqaBlockDetailsByBlockHashRi](docs/GetZilliqaBlockDetailsByBlockHashRi.md)
 - [GetZilliqaBlockDetailsByBlockHeightE400](docs/GetZilliqaBlockDetailsByBlockHeightE400.md)
 - [GetZilliqaBlockDetailsByBlockHeightE401](docs/GetZilliqaBlockDetailsByBlockHeightE401.md)
 - [GetZilliqaBlockDetailsByBlockHeightE403](docs/GetZilliqaBlockDetailsByBlockHeightE403.md)
 - [GetZilliqaBlockDetailsByBlockHeightR](docs/GetZilliqaBlockDetailsByBlockHeightR.md)
 - [GetZilliqaBlockDetailsByBlockHeightRData](docs/GetZilliqaBlockDetailsByBlockHeightRData.md)
 - [GetZilliqaBlockDetailsByBlockHeightRi](docs/GetZilliqaBlockDetailsByBlockHeightRi.md)
 - [GetZilliqaTransactionDetailsByTransactionIde400](docs/GetZilliqaTransactionDetailsByTransactionIde400.md)
 - [GetZilliqaTransactionDetailsByTransactionIde401](docs/GetZilliqaTransactionDetailsByTransactionIde401.md)
 - [GetZilliqaTransactionDetailsByTransactionIde403](docs/GetZilliqaTransactionDetailsByTransactionIde403.md)
 - [GetZilliqaTransactionDetailsByTransactionIdr](docs/GetZilliqaTransactionDetailsByTransactionIdr.md)
 - [GetZilliqaTransactionDetailsByTransactionIdrData](docs/GetZilliqaTransactionDetailsByTransactionIdrData.md)
 - [GetZilliqaTransactionDetailsByTransactionIdri](docs/GetZilliqaTransactionDetailsByTransactionIdri.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriFee](docs/GetZilliqaTransactionDetailsByTransactionIdriFee.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriRecipients](docs/GetZilliqaTransactionDetailsByTransactionIdriRecipients.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriSenders](docs/GetZilliqaTransactionDetailsByTransactionIdriSenders.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse4001](docs/InlineResponse4001.md)
 - [InlineResponse40010](docs/InlineResponse40010.md)
 - [InlineResponse40011](docs/InlineResponse40011.md)
 - [InlineResponse40012](docs/InlineResponse40012.md)
 - [InlineResponse40013](docs/InlineResponse40013.md)
 - [InlineResponse40014](docs/InlineResponse40014.md)
 - [InlineResponse40015](docs/InlineResponse40015.md)
 - [InlineResponse40016](docs/InlineResponse40016.md)
 - [InlineResponse40017](docs/InlineResponse40017.md)
 - [InlineResponse40018](docs/InlineResponse40018.md)
 - [InlineResponse40019](docs/InlineResponse40019.md)
 - [InlineResponse4002](docs/InlineResponse4002.md)
 - [InlineResponse40020](docs/InlineResponse40020.md)
 - [InlineResponse40021](docs/InlineResponse40021.md)
 - [InlineResponse40022](docs/InlineResponse40022.md)
 - [InlineResponse40023](docs/InlineResponse40023.md)
 - [InlineResponse40024](docs/InlineResponse40024.md)
 - [InlineResponse40025](docs/InlineResponse40025.md)
 - [InlineResponse40026](docs/InlineResponse40026.md)
 - [InlineResponse40027](docs/InlineResponse40027.md)
 - [InlineResponse40028](docs/InlineResponse40028.md)
 - [InlineResponse40029](docs/InlineResponse40029.md)
 - [InlineResponse4003](docs/InlineResponse4003.md)
 - [InlineResponse40030](docs/InlineResponse40030.md)
 - [InlineResponse40031](docs/InlineResponse40031.md)
 - [InlineResponse40032](docs/InlineResponse40032.md)
 - [InlineResponse40033](docs/InlineResponse40033.md)
 - [InlineResponse40034](docs/InlineResponse40034.md)
 - [InlineResponse40035](docs/InlineResponse40035.md)
 - [InlineResponse40036](docs/InlineResponse40036.md)
 - [InlineResponse40037](docs/InlineResponse40037.md)
 - [InlineResponse40038](docs/InlineResponse40038.md)
 - [InlineResponse40039](docs/InlineResponse40039.md)
 - [InlineResponse4004](docs/InlineResponse4004.md)
 - [InlineResponse40040](docs/InlineResponse40040.md)
 - [InlineResponse40041](docs/InlineResponse40041.md)
 - [InlineResponse40042](docs/InlineResponse40042.md)
 - [InlineResponse40043](docs/InlineResponse40043.md)
 - [InlineResponse40044](docs/InlineResponse40044.md)
 - [InlineResponse40045](docs/InlineResponse40045.md)
 - [InlineResponse40046](docs/InlineResponse40046.md)
 - [InlineResponse40047](docs/InlineResponse40047.md)
 - [InlineResponse40048](docs/InlineResponse40048.md)
 - [InlineResponse40049](docs/InlineResponse40049.md)
 - [InlineResponse4005](docs/InlineResponse4005.md)
 - [InlineResponse40050](docs/InlineResponse40050.md)
 - [InlineResponse40051](docs/InlineResponse40051.md)
 - [InlineResponse40052](docs/InlineResponse40052.md)
 - [InlineResponse40053](docs/InlineResponse40053.md)
 - [InlineResponse40054](docs/InlineResponse40054.md)
 - [InlineResponse40055](docs/InlineResponse40055.md)
 - [InlineResponse40056](docs/InlineResponse40056.md)
 - [InlineResponse40057](docs/InlineResponse40057.md)
 - [InlineResponse40058](docs/InlineResponse40058.md)
 - [InlineResponse40059](docs/InlineResponse40059.md)
 - [InlineResponse4006](docs/InlineResponse4006.md)
 - [InlineResponse40060](docs/InlineResponse40060.md)
 - [InlineResponse40061](docs/InlineResponse40061.md)
 - [InlineResponse40062](docs/InlineResponse40062.md)
 - [InlineResponse40063](docs/InlineResponse40063.md)
 - [InlineResponse40064](docs/InlineResponse40064.md)
 - [InlineResponse40065](docs/InlineResponse40065.md)
 - [InlineResponse40066](docs/InlineResponse40066.md)
 - [InlineResponse40067](docs/InlineResponse40067.md)
 - [InlineResponse40068](docs/InlineResponse40068.md)
 - [InlineResponse40069](docs/InlineResponse40069.md)
 - [InlineResponse4007](docs/InlineResponse4007.md)
 - [InlineResponse40070](docs/InlineResponse40070.md)
 - [InlineResponse40071](docs/InlineResponse40071.md)
 - [InlineResponse40072](docs/InlineResponse40072.md)
 - [InlineResponse40073](docs/InlineResponse40073.md)
 - [InlineResponse40074](docs/InlineResponse40074.md)
 - [InlineResponse40075](docs/InlineResponse40075.md)
 - [InlineResponse40076](docs/InlineResponse40076.md)
 - [InlineResponse40077](docs/InlineResponse40077.md)
 - [InlineResponse40078](docs/InlineResponse40078.md)
 - [InlineResponse40079](docs/InlineResponse40079.md)
 - [InlineResponse4008](docs/InlineResponse4008.md)
 - [InlineResponse40080](docs/InlineResponse40080.md)
 - [InlineResponse40081](docs/InlineResponse40081.md)
 - [InlineResponse40082](docs/InlineResponse40082.md)
 - [InlineResponse40083](docs/InlineResponse40083.md)
 - [InlineResponse40084](docs/InlineResponse40084.md)
 - [InlineResponse40085](docs/InlineResponse40085.md)
 - [InlineResponse40086](docs/InlineResponse40086.md)
 - [InlineResponse40087](docs/InlineResponse40087.md)
 - [InlineResponse40088](docs/InlineResponse40088.md)
 - [InlineResponse40089](docs/InlineResponse40089.md)
 - [InlineResponse4009](docs/InlineResponse4009.md)
 - [InlineResponse40090](docs/InlineResponse40090.md)
 - [InlineResponse40091](docs/InlineResponse40091.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse4011](docs/InlineResponse4011.md)
 - [InlineResponse40110](docs/InlineResponse40110.md)
 - [InlineResponse40111](docs/InlineResponse40111.md)
 - [InlineResponse40112](docs/InlineResponse40112.md)
 - [InlineResponse40113](docs/InlineResponse40113.md)
 - [InlineResponse40114](docs/InlineResponse40114.md)
 - [InlineResponse40115](docs/InlineResponse40115.md)
 - [InlineResponse40116](docs/InlineResponse40116.md)
 - [InlineResponse40117](docs/InlineResponse40117.md)
 - [InlineResponse40118](docs/InlineResponse40118.md)
 - [InlineResponse40119](docs/InlineResponse40119.md)
 - [InlineResponse4012](docs/InlineResponse4012.md)
 - [InlineResponse40120](docs/InlineResponse40120.md)
 - [InlineResponse40121](docs/InlineResponse40121.md)
 - [InlineResponse40122](docs/InlineResponse40122.md)
 - [InlineResponse40123](docs/InlineResponse40123.md)
 - [InlineResponse40124](docs/InlineResponse40124.md)
 - [InlineResponse40125](docs/InlineResponse40125.md)
 - [InlineResponse40126](docs/InlineResponse40126.md)
 - [InlineResponse40127](docs/InlineResponse40127.md)
 - [InlineResponse40128](docs/InlineResponse40128.md)
 - [InlineResponse40129](docs/InlineResponse40129.md)
 - [InlineResponse4013](docs/InlineResponse4013.md)
 - [InlineResponse40130](docs/InlineResponse40130.md)
 - [InlineResponse40131](docs/InlineResponse40131.md)
 - [InlineResponse40132](docs/InlineResponse40132.md)
 - [InlineResponse40133](docs/InlineResponse40133.md)
 - [InlineResponse40134](docs/InlineResponse40134.md)
 - [InlineResponse40135](docs/InlineResponse40135.md)
 - [InlineResponse40136](docs/InlineResponse40136.md)
 - [InlineResponse40137](docs/InlineResponse40137.md)
 - [InlineResponse40138](docs/InlineResponse40138.md)
 - [InlineResponse40139](docs/InlineResponse40139.md)
 - [InlineResponse4014](docs/InlineResponse4014.md)
 - [InlineResponse40140](docs/InlineResponse40140.md)
 - [InlineResponse40141](docs/InlineResponse40141.md)
 - [InlineResponse40142](docs/InlineResponse40142.md)
 - [InlineResponse40143](docs/InlineResponse40143.md)
 - [InlineResponse40144](docs/InlineResponse40144.md)
 - [InlineResponse40145](docs/InlineResponse40145.md)
 - [InlineResponse40146](docs/InlineResponse40146.md)
 - [InlineResponse40147](docs/InlineResponse40147.md)
 - [InlineResponse40148](docs/InlineResponse40148.md)
 - [InlineResponse40149](docs/InlineResponse40149.md)
 - [InlineResponse4015](docs/InlineResponse4015.md)
 - [InlineResponse40150](docs/InlineResponse40150.md)
 - [InlineResponse40151](docs/InlineResponse40151.md)
 - [InlineResponse40152](docs/InlineResponse40152.md)
 - [InlineResponse40153](docs/InlineResponse40153.md)
 - [InlineResponse40154](docs/InlineResponse40154.md)
 - [InlineResponse40155](docs/InlineResponse40155.md)
 - [InlineResponse40156](docs/InlineResponse40156.md)
 - [InlineResponse40157](docs/InlineResponse40157.md)
 - [InlineResponse40158](docs/InlineResponse40158.md)
 - [InlineResponse40159](docs/InlineResponse40159.md)
 - [InlineResponse4016](docs/InlineResponse4016.md)
 - [InlineResponse40160](docs/InlineResponse40160.md)
 - [InlineResponse40161](docs/InlineResponse40161.md)
 - [InlineResponse40162](docs/InlineResponse40162.md)
 - [InlineResponse40163](docs/InlineResponse40163.md)
 - [InlineResponse40164](docs/InlineResponse40164.md)
 - [InlineResponse40165](docs/InlineResponse40165.md)
 - [InlineResponse40166](docs/InlineResponse40166.md)
 - [InlineResponse40167](docs/InlineResponse40167.md)
 - [InlineResponse40168](docs/InlineResponse40168.md)
 - [InlineResponse40169](docs/InlineResponse40169.md)
 - [InlineResponse4017](docs/InlineResponse4017.md)
 - [InlineResponse40170](docs/InlineResponse40170.md)
 - [InlineResponse40171](docs/InlineResponse40171.md)
 - [InlineResponse40172](docs/InlineResponse40172.md)
 - [InlineResponse40173](docs/InlineResponse40173.md)
 - [InlineResponse40174](docs/InlineResponse40174.md)
 - [InlineResponse40175](docs/InlineResponse40175.md)
 - [InlineResponse40176](docs/InlineResponse40176.md)
 - [InlineResponse40177](docs/InlineResponse40177.md)
 - [InlineResponse40178](docs/InlineResponse40178.md)
 - [InlineResponse40179](docs/InlineResponse40179.md)
 - [InlineResponse4018](docs/InlineResponse4018.md)
 - [InlineResponse40180](docs/InlineResponse40180.md)
 - [InlineResponse40181](docs/InlineResponse40181.md)
 - [InlineResponse40182](docs/InlineResponse40182.md)
 - [InlineResponse40183](docs/InlineResponse40183.md)
 - [InlineResponse40184](docs/InlineResponse40184.md)
 - [InlineResponse40185](docs/InlineResponse40185.md)
 - [InlineResponse40186](docs/InlineResponse40186.md)
 - [InlineResponse40187](docs/InlineResponse40187.md)
 - [InlineResponse40188](docs/InlineResponse40188.md)
 - [InlineResponse40189](docs/InlineResponse40189.md)
 - [InlineResponse4019](docs/InlineResponse4019.md)
 - [InlineResponse40190](docs/InlineResponse40190.md)
 - [InlineResponse40191](docs/InlineResponse40191.md)
 - [InlineResponse402](docs/InlineResponse402.md)
 - [InlineResponse403](docs/InlineResponse403.md)
 - [InlineResponse4031](docs/InlineResponse4031.md)
 - [InlineResponse40310](docs/InlineResponse40310.md)
 - [InlineResponse40311](docs/InlineResponse40311.md)
 - [InlineResponse40312](docs/InlineResponse40312.md)
 - [InlineResponse40313](docs/InlineResponse40313.md)
 - [InlineResponse40314](docs/InlineResponse40314.md)
 - [InlineResponse40315](docs/InlineResponse40315.md)
 - [InlineResponse40316](docs/InlineResponse40316.md)
 - [InlineResponse40317](docs/InlineResponse40317.md)
 - [InlineResponse40318](docs/InlineResponse40318.md)
 - [InlineResponse40319](docs/InlineResponse40319.md)
 - [InlineResponse4032](docs/InlineResponse4032.md)
 - [InlineResponse40320](docs/InlineResponse40320.md)
 - [InlineResponse40321](docs/InlineResponse40321.md)
 - [InlineResponse40322](docs/InlineResponse40322.md)
 - [InlineResponse40323](docs/InlineResponse40323.md)
 - [InlineResponse40324](docs/InlineResponse40324.md)
 - [InlineResponse40325](docs/InlineResponse40325.md)
 - [InlineResponse40326](docs/InlineResponse40326.md)
 - [InlineResponse40327](docs/InlineResponse40327.md)
 - [InlineResponse40328](docs/InlineResponse40328.md)
 - [InlineResponse40329](docs/InlineResponse40329.md)
 - [InlineResponse4033](docs/InlineResponse4033.md)
 - [InlineResponse40330](docs/InlineResponse40330.md)
 - [InlineResponse40331](docs/InlineResponse40331.md)
 - [InlineResponse40332](docs/InlineResponse40332.md)
 - [InlineResponse40333](docs/InlineResponse40333.md)
 - [InlineResponse40334](docs/InlineResponse40334.md)
 - [InlineResponse40335](docs/InlineResponse40335.md)
 - [InlineResponse40336](docs/InlineResponse40336.md)
 - [InlineResponse40337](docs/InlineResponse40337.md)
 - [InlineResponse40338](docs/InlineResponse40338.md)
 - [InlineResponse40339](docs/InlineResponse40339.md)
 - [InlineResponse4034](docs/InlineResponse4034.md)
 - [InlineResponse40340](docs/InlineResponse40340.md)
 - [InlineResponse40341](docs/InlineResponse40341.md)
 - [InlineResponse40342](docs/InlineResponse40342.md)
 - [InlineResponse40343](docs/InlineResponse40343.md)
 - [InlineResponse40344](docs/InlineResponse40344.md)
 - [InlineResponse40345](docs/InlineResponse40345.md)
 - [InlineResponse40346](docs/InlineResponse40346.md)
 - [InlineResponse40347](docs/InlineResponse40347.md)
 - [InlineResponse40348](docs/InlineResponse40348.md)
 - [InlineResponse40349](docs/InlineResponse40349.md)
 - [InlineResponse4035](docs/InlineResponse4035.md)
 - [InlineResponse40350](docs/InlineResponse40350.md)
 - [InlineResponse40351](docs/InlineResponse40351.md)
 - [InlineResponse40352](docs/InlineResponse40352.md)
 - [InlineResponse40353](docs/InlineResponse40353.md)
 - [InlineResponse40354](docs/InlineResponse40354.md)
 - [InlineResponse40355](docs/InlineResponse40355.md)
 - [InlineResponse40356](docs/InlineResponse40356.md)
 - [InlineResponse40357](docs/InlineResponse40357.md)
 - [InlineResponse40358](docs/InlineResponse40358.md)
 - [InlineResponse40359](docs/InlineResponse40359.md)
 - [InlineResponse4036](docs/InlineResponse4036.md)
 - [InlineResponse40360](docs/InlineResponse40360.md)
 - [InlineResponse40361](docs/InlineResponse40361.md)
 - [InlineResponse40362](docs/InlineResponse40362.md)
 - [InlineResponse40363](docs/InlineResponse40363.md)
 - [InlineResponse40364](docs/InlineResponse40364.md)
 - [InlineResponse40365](docs/InlineResponse40365.md)
 - [InlineResponse40366](docs/InlineResponse40366.md)
 - [InlineResponse40367](docs/InlineResponse40367.md)
 - [InlineResponse40368](docs/InlineResponse40368.md)
 - [InlineResponse40369](docs/InlineResponse40369.md)
 - [InlineResponse4037](docs/InlineResponse4037.md)
 - [InlineResponse40370](docs/InlineResponse40370.md)
 - [InlineResponse40371](docs/InlineResponse40371.md)
 - [InlineResponse40372](docs/InlineResponse40372.md)
 - [InlineResponse40373](docs/InlineResponse40373.md)
 - [InlineResponse40374](docs/InlineResponse40374.md)
 - [InlineResponse40375](docs/InlineResponse40375.md)
 - [InlineResponse40376](docs/InlineResponse40376.md)
 - [InlineResponse40377](docs/InlineResponse40377.md)
 - [InlineResponse40378](docs/InlineResponse40378.md)
 - [InlineResponse40379](docs/InlineResponse40379.md)
 - [InlineResponse4038](docs/InlineResponse4038.md)
 - [InlineResponse40380](docs/InlineResponse40380.md)
 - [InlineResponse40381](docs/InlineResponse40381.md)
 - [InlineResponse40382](docs/InlineResponse40382.md)
 - [InlineResponse40383](docs/InlineResponse40383.md)
 - [InlineResponse40384](docs/InlineResponse40384.md)
 - [InlineResponse40385](docs/InlineResponse40385.md)
 - [InlineResponse40386](docs/InlineResponse40386.md)
 - [InlineResponse40387](docs/InlineResponse40387.md)
 - [InlineResponse40388](docs/InlineResponse40388.md)
 - [InlineResponse40389](docs/InlineResponse40389.md)
 - [InlineResponse4039](docs/InlineResponse4039.md)
 - [InlineResponse40390](docs/InlineResponse40390.md)
 - [InlineResponse40391](docs/InlineResponse40391.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InlineResponse4041](docs/InlineResponse4041.md)
 - [InlineResponse4042](docs/InlineResponse4042.md)
 - [InlineResponse4043](docs/InlineResponse4043.md)
 - [InlineResponse4044](docs/InlineResponse4044.md)
 - [InlineResponse409](docs/InlineResponse409.md)
 - [InlineResponse4091](docs/InlineResponse4091.md)
 - [InlineResponse40910](docs/InlineResponse40910.md)
 - [InlineResponse40911](docs/InlineResponse40911.md)
 - [InlineResponse40912](docs/InlineResponse40912.md)
 - [InlineResponse40913](docs/InlineResponse40913.md)
 - [InlineResponse40914](docs/InlineResponse40914.md)
 - [InlineResponse40915](docs/InlineResponse40915.md)
 - [InlineResponse40916](docs/InlineResponse40916.md)
 - [InlineResponse40917](docs/InlineResponse40917.md)
 - [InlineResponse4092](docs/InlineResponse4092.md)
 - [InlineResponse4093](docs/InlineResponse4093.md)
 - [InlineResponse4094](docs/InlineResponse4094.md)
 - [InlineResponse4095](docs/InlineResponse4095.md)
 - [InlineResponse4096](docs/InlineResponse4096.md)
 - [InlineResponse4097](docs/InlineResponse4097.md)
 - [InlineResponse4098](docs/InlineResponse4098.md)
 - [InlineResponse4099](docs/InlineResponse4099.md)
 - [InlineResponse415](docs/InlineResponse415.md)
 - [InlineResponse422](docs/InlineResponse422.md)
 - [InlineResponse4221](docs/InlineResponse4221.md)
 - [InlineResponse4222](docs/InlineResponse4222.md)
 - [InlineResponse4223](docs/InlineResponse4223.md)
 - [InlineResponse4224](docs/InlineResponse4224.md)
 - [InlineResponse4225](docs/InlineResponse4225.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InsufficientCredits](docs/InsufficientCredits.md)
 - [InvalidApiKey](docs/InvalidApiKey.md)
 - [InvalidBlockchain](docs/InvalidBlockchain.md)
 - [InvalidData](docs/InvalidData.md)
 - [InvalidNetwork](docs/InvalidNetwork.md)
 - [InvalidPagination](docs/InvalidPagination.md)
 - [InvalidRequestBodyStructure](docs/InvalidRequestBodyStructure.md)
 - [InvalidXpub](docs/InvalidXpub.md)
 - [LimitGreaterThanAllowed](docs/LimitGreaterThanAllowed.md)
 - [ListAllUnconfirmedTransactionsE400](docs/ListAllUnconfirmedTransactionsE400.md)
 - [ListAllUnconfirmedTransactionsE401](docs/ListAllUnconfirmedTransactionsE401.md)
 - [ListAllUnconfirmedTransactionsE403](docs/ListAllUnconfirmedTransactionsE403.md)
 - [ListAllUnconfirmedTransactionsR](docs/ListAllUnconfirmedTransactionsR.md)
 - [ListAllUnconfirmedTransactionsRData](docs/ListAllUnconfirmedTransactionsRData.md)
 - [ListAllUnconfirmedTransactionsRi](docs/ListAllUnconfirmedTransactionsRi.md)
 - [ListAllUnconfirmedTransactionsRibs](docs/ListAllUnconfirmedTransactionsRibs.md)
 - [ListAllUnconfirmedTransactionsRibsb](docs/ListAllUnconfirmedTransactionsRibsb.md)
 - [ListAllUnconfirmedTransactionsRibsbScriptSig](docs/ListAllUnconfirmedTransactionsRibsbScriptSig.md)
 - [ListAllUnconfirmedTransactionsRibsbVin](docs/ListAllUnconfirmedTransactionsRibsbVin.md)
 - [ListAllUnconfirmedTransactionsRibsbc](docs/ListAllUnconfirmedTransactionsRibsbc.md)
 - [ListAllUnconfirmedTransactionsRibsbcVin](docs/ListAllUnconfirmedTransactionsRibsbcVin.md)
 - [ListAllUnconfirmedTransactionsRibsbcVout](docs/ListAllUnconfirmedTransactionsRibsbcVout.md)
 - [ListAllUnconfirmedTransactionsRibsbsc](docs/ListAllUnconfirmedTransactionsRibsbsc.md)
 - [ListAllUnconfirmedTransactionsRibsd](docs/ListAllUnconfirmedTransactionsRibsd.md)
 - [ListAllUnconfirmedTransactionsRibsd2](docs/ListAllUnconfirmedTransactionsRibsd2.md)
 - [ListAllUnconfirmedTransactionsRibsd2Vin](docs/ListAllUnconfirmedTransactionsRibsd2Vin.md)
 - [ListAllUnconfirmedTransactionsRibsdVin](docs/ListAllUnconfirmedTransactionsRibsdVin.md)
 - [ListAllUnconfirmedTransactionsRibse](docs/ListAllUnconfirmedTransactionsRibse.md)
 - [ListAllUnconfirmedTransactionsRibseFee](docs/ListAllUnconfirmedTransactionsRibseFee.md)
 - [ListAllUnconfirmedTransactionsRibseGasPrice](docs/ListAllUnconfirmedTransactionsRibseGasPrice.md)
 - [ListAllUnconfirmedTransactionsRibsec](docs/ListAllUnconfirmedTransactionsRibsec.md)
 - [ListAllUnconfirmedTransactionsRibsecFee](docs/ListAllUnconfirmedTransactionsRibsecFee.md)
 - [ListAllUnconfirmedTransactionsRibsecGasPrice](docs/ListAllUnconfirmedTransactionsRibsecGasPrice.md)
 - [ListAllUnconfirmedTransactionsRibsl](docs/ListAllUnconfirmedTransactionsRibsl.md)
 - [ListAllUnconfirmedTransactionsRibslVin](docs/ListAllUnconfirmedTransactionsRibslVin.md)
 - [ListAllUnconfirmedTransactionsRibsz](docs/ListAllUnconfirmedTransactionsRibsz.md)
 - [ListAssetsDetailsE400](docs/ListAssetsDetailsE400.md)
 - [ListAssetsDetailsE401](docs/ListAssetsDetailsE401.md)
 - [ListAssetsDetailsE403](docs/ListAssetsDetailsE403.md)
 - [ListAssetsDetailsR](docs/ListAssetsDetailsR.md)
 - [ListAssetsDetailsRData](docs/ListAssetsDetailsRData.md)
 - [ListAssetsDetailsRi](docs/ListAssetsDetailsRi.md)
 - [ListAssetsDetailsRiAssetLogo](docs/ListAssetsDetailsRiAssetLogo.md)
 - [ListAssetsDetailsRiLatestRate](docs/ListAssetsDetailsRiLatestRate.md)
 - [ListAssetsDetailsRis](docs/ListAssetsDetailsRis.md)
 - [ListAssetsDetailsRisc](docs/ListAssetsDetailsRisc.md)
 - [ListBlockchainEventsSubscriptionsE400](docs/ListBlockchainEventsSubscriptionsE400.md)
 - [ListBlockchainEventsSubscriptionsE401](docs/ListBlockchainEventsSubscriptionsE401.md)
 - [ListBlockchainEventsSubscriptionsE403](docs/ListBlockchainEventsSubscriptionsE403.md)
 - [ListBlockchainEventsSubscriptionsR](docs/ListBlockchainEventsSubscriptionsR.md)
 - [ListBlockchainEventsSubscriptionsRData](docs/ListBlockchainEventsSubscriptionsRData.md)
 - [ListBlockchainEventsSubscriptionsRi](docs/ListBlockchainEventsSubscriptionsRi.md)
 - [ListCoinsForwardingAutomationsE400](docs/ListCoinsForwardingAutomationsE400.md)
 - [ListCoinsForwardingAutomationsE401](docs/ListCoinsForwardingAutomationsE401.md)
 - [ListCoinsForwardingAutomationsE403](docs/ListCoinsForwardingAutomationsE403.md)
 - [ListCoinsForwardingAutomationsR](docs/ListCoinsForwardingAutomationsR.md)
 - [ListCoinsForwardingAutomationsRData](docs/ListCoinsForwardingAutomationsRData.md)
 - [ListCoinsForwardingAutomationsRi](docs/ListCoinsForwardingAutomationsRi.md)
 - [ListConfirmedTokensTransfersByAddressE400](docs/ListConfirmedTokensTransfersByAddressE400.md)
 - [ListConfirmedTokensTransfersByAddressE401](docs/ListConfirmedTokensTransfersByAddressE401.md)
 - [ListConfirmedTokensTransfersByAddressE403](docs/ListConfirmedTokensTransfersByAddressE403.md)
 - [ListConfirmedTokensTransfersByAddressR](docs/ListConfirmedTokensTransfersByAddressR.md)
 - [ListConfirmedTokensTransfersByAddressRData](docs/ListConfirmedTokensTransfersByAddressRData.md)
 - [ListConfirmedTokensTransfersByAddressRi](docs/ListConfirmedTokensTransfersByAddressRi.md)
 - [ListConfirmedTransactionsByAddressE400](docs/ListConfirmedTransactionsByAddressE400.md)
 - [ListConfirmedTransactionsByAddressE401](docs/ListConfirmedTransactionsByAddressE401.md)
 - [ListConfirmedTransactionsByAddressE403](docs/ListConfirmedTransactionsByAddressE403.md)
 - [ListConfirmedTransactionsByAddressR](docs/ListConfirmedTransactionsByAddressR.md)
 - [ListConfirmedTransactionsByAddressRData](docs/ListConfirmedTransactionsByAddressRData.md)
 - [ListConfirmedTransactionsByAddressRi](docs/ListConfirmedTransactionsByAddressRi.md)
 - [ListConfirmedTransactionsByAddressRiFee](docs/ListConfirmedTransactionsByAddressRiFee.md)
 - [ListConfirmedTransactionsByAddressRibs](docs/ListConfirmedTransactionsByAddressRibs.md)
 - [ListConfirmedTransactionsByAddressRibsb](docs/ListConfirmedTransactionsByAddressRibsb.md)
 - [ListConfirmedTransactionsByAddressRibsbScriptPubKey](docs/ListConfirmedTransactionsByAddressRibsbScriptPubKey.md)
 - [ListConfirmedTransactionsByAddressRibsbVin](docs/ListConfirmedTransactionsByAddressRibsbVin.md)
 - [ListConfirmedTransactionsByAddressRibsbVout](docs/ListConfirmedTransactionsByAddressRibsbVout.md)
 - [ListConfirmedTransactionsByAddressRibsbc](docs/ListConfirmedTransactionsByAddressRibsbc.md)
 - [ListConfirmedTransactionsByAddressRibsbcVin](docs/ListConfirmedTransactionsByAddressRibsbcVin.md)
 - [ListConfirmedTransactionsByAddressRibsbsc](docs/ListConfirmedTransactionsByAddressRibsbsc.md)
 - [ListConfirmedTransactionsByAddressRibsbscGasPrice](docs/ListConfirmedTransactionsByAddressRibsbscGasPrice.md)
 - [ListConfirmedTransactionsByAddressRibsd](docs/ListConfirmedTransactionsByAddressRibsd.md)
 - [ListConfirmedTransactionsByAddressRibsd2](docs/ListConfirmedTransactionsByAddressRibsd2.md)
 - [ListConfirmedTransactionsByAddressRibsd2ScriptPubKey](docs/ListConfirmedTransactionsByAddressRibsd2ScriptPubKey.md)
 - [ListConfirmedTransactionsByAddressRibsd2ScriptSig](docs/ListConfirmedTransactionsByAddressRibsd2ScriptSig.md)
 - [ListConfirmedTransactionsByAddressRibsd2Vin](docs/ListConfirmedTransactionsByAddressRibsd2Vin.md)
 - [ListConfirmedTransactionsByAddressRibsd2Vout](docs/ListConfirmedTransactionsByAddressRibsd2Vout.md)
 - [ListConfirmedTransactionsByAddressRibsdScriptSig](docs/ListConfirmedTransactionsByAddressRibsdScriptSig.md)
 - [ListConfirmedTransactionsByAddressRibsdVin](docs/ListConfirmedTransactionsByAddressRibsdVin.md)
 - [ListConfirmedTransactionsByAddressRibse](docs/ListConfirmedTransactionsByAddressRibse.md)
 - [ListConfirmedTransactionsByAddressRibseGasPrice](docs/ListConfirmedTransactionsByAddressRibseGasPrice.md)
 - [ListConfirmedTransactionsByAddressRibsec](docs/ListConfirmedTransactionsByAddressRibsec.md)
 - [ListConfirmedTransactionsByAddressRibsecGasPrice](docs/ListConfirmedTransactionsByAddressRibsecGasPrice.md)
 - [ListConfirmedTransactionsByAddressRibsl](docs/ListConfirmedTransactionsByAddressRibsl.md)
 - [ListConfirmedTransactionsByAddressRibslScriptSig](docs/ListConfirmedTransactionsByAddressRibslScriptSig.md)
 - [ListConfirmedTransactionsByAddressRibslVin](docs/ListConfirmedTransactionsByAddressRibslVin.md)
 - [ListConfirmedTransactionsByAddressRibsz](docs/ListConfirmedTransactionsByAddressRibsz.md)
 - [ListConfirmedTransactionsByAddressRibszVJoinSplit](docs/ListConfirmedTransactionsByAddressRibszVJoinSplit.md)
 - [ListConfirmedTransactionsByAddressRibszVin](docs/ListConfirmedTransactionsByAddressRibszVin.md)
 - [ListDepositAddressesE400](docs/ListDepositAddressesE400.md)
 - [ListDepositAddressesE401](docs/ListDepositAddressesE401.md)
 - [ListDepositAddressesE403](docs/ListDepositAddressesE403.md)
 - [ListDepositAddressesR](docs/ListDepositAddressesR.md)
 - [ListDepositAddressesRData](docs/ListDepositAddressesRData.md)
 - [ListDepositAddressesRi](docs/ListDepositAddressesRi.md)
 - [ListDepositAddressesRiConfirmedBalance](docs/ListDepositAddressesRiConfirmedBalance.md)
 - [ListDepositAddressesRiFungibleTokens](docs/ListDepositAddressesRiFungibleTokens.md)
 - [ListDepositAddressesRiNonFungibleTokens](docs/ListDepositAddressesRiNonFungibleTokens.md)
 - [ListHdWalletXPubYPubZPubTransactionsE400](docs/ListHdWalletXPubYPubZPubTransactionsE400.md)
 - [ListHdWalletXPubYPubZPubTransactionsE401](docs/ListHdWalletXPubYPubZPubTransactionsE401.md)
 - [ListHdWalletXPubYPubZPubTransactionsE403](docs/ListHdWalletXPubYPubZPubTransactionsE403.md)
 - [ListHdWalletXPubYPubZPubTransactionsE422](docs/ListHdWalletXPubYPubZPubTransactionsE422.md)
 - [ListHdWalletXPubYPubZPubTransactionsR](docs/ListHdWalletXPubYPubZPubTransactionsR.md)
 - [ListHdWalletXPubYPubZPubTransactionsRData](docs/ListHdWalletXPubYPubZPubTransactionsRData.md)
 - [ListHdWalletXPubYPubZPubTransactionsRi](docs/ListHdWalletXPubYPubZPubTransactionsRi.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiFee](docs/ListHdWalletXPubYPubZPubTransactionsRiFee.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiRecipients](docs/ListHdWalletXPubYPubZPubTransactionsRiRecipients.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiSenders](docs/ListHdWalletXPubYPubZPubTransactionsRiSenders.md)
 - [ListInternalTransactionDetailsByTransactionHashE400](docs/ListInternalTransactionDetailsByTransactionHashE400.md)
 - [ListInternalTransactionDetailsByTransactionHashE401](docs/ListInternalTransactionDetailsByTransactionHashE401.md)
 - [ListInternalTransactionDetailsByTransactionHashE403](docs/ListInternalTransactionDetailsByTransactionHashE403.md)
 - [ListInternalTransactionDetailsByTransactionHashR](docs/ListInternalTransactionDetailsByTransactionHashR.md)
 - [ListInternalTransactionDetailsByTransactionHashRData](docs/ListInternalTransactionDetailsByTransactionHashRData.md)
 - [ListInternalTransactionDetailsByTransactionHashRi](docs/ListInternalTransactionDetailsByTransactionHashRi.md)
 - [ListInternalTransactionsByAddressE400](docs/ListInternalTransactionsByAddressE400.md)
 - [ListInternalTransactionsByAddressE401](docs/ListInternalTransactionsByAddressE401.md)
 - [ListInternalTransactionsByAddressE403](docs/ListInternalTransactionsByAddressE403.md)
 - [ListInternalTransactionsByAddressR](docs/ListInternalTransactionsByAddressR.md)
 - [ListInternalTransactionsByAddressRData](docs/ListInternalTransactionsByAddressRData.md)
 - [ListInternalTransactionsByAddressRi](docs/ListInternalTransactionsByAddressRi.md)
 - [ListLatestMinedBlocksE400](docs/ListLatestMinedBlocksE400.md)
 - [ListLatestMinedBlocksE401](docs/ListLatestMinedBlocksE401.md)
 - [ListLatestMinedBlocksE403](docs/ListLatestMinedBlocksE403.md)
 - [ListLatestMinedBlocksR](docs/ListLatestMinedBlocksR.md)
 - [ListLatestMinedBlocksRData](docs/ListLatestMinedBlocksRData.md)
 - [ListLatestMinedBlocksRi](docs/ListLatestMinedBlocksRi.md)
 - [ListLatestMinedBlocksRiTotalCoins](docs/ListLatestMinedBlocksRiTotalCoins.md)
 - [ListLatestMinedBlocksRiTotalFees](docs/ListLatestMinedBlocksRiTotalFees.md)
 - [ListLatestMinedBlocksRibs](docs/ListLatestMinedBlocksRibs.md)
 - [ListLatestMinedBlocksRibsb](docs/ListLatestMinedBlocksRibsb.md)
 - [ListLatestMinedBlocksRibsbc](docs/ListLatestMinedBlocksRibsbc.md)
 - [ListLatestMinedBlocksRibsbsc](docs/ListLatestMinedBlocksRibsbsc.md)
 - [ListLatestMinedBlocksRibsd](docs/ListLatestMinedBlocksRibsd.md)
 - [ListLatestMinedBlocksRibsd2](docs/ListLatestMinedBlocksRibsd2.md)
 - [ListLatestMinedBlocksRibse](docs/ListLatestMinedBlocksRibse.md)
 - [ListLatestMinedBlocksRibsec](docs/ListLatestMinedBlocksRibsec.md)
 - [ListLatestMinedBlocksRibsl](docs/ListLatestMinedBlocksRibsl.md)
 - [ListLatestMinedBlocksRibsz](docs/ListLatestMinedBlocksRibsz.md)
 - [ListLatestMinedBlocksRibsz2](docs/ListLatestMinedBlocksRibsz2.md)
 - [ListOmniTokensByAddressE400](docs/ListOmniTokensByAddressE400.md)
 - [ListOmniTokensByAddressE401](docs/ListOmniTokensByAddressE401.md)
 - [ListOmniTokensByAddressE403](docs/ListOmniTokensByAddressE403.md)
 - [ListOmniTokensByAddressR](docs/ListOmniTokensByAddressR.md)
 - [ListOmniTokensByAddressRData](docs/ListOmniTokensByAddressRData.md)
 - [ListOmniTokensByAddressRi](docs/ListOmniTokensByAddressRi.md)
 - [ListOmniTransactionsByAddressE400](docs/ListOmniTransactionsByAddressE400.md)
 - [ListOmniTransactionsByAddressE401](docs/ListOmniTransactionsByAddressE401.md)
 - [ListOmniTransactionsByAddressE403](docs/ListOmniTransactionsByAddressE403.md)
 - [ListOmniTransactionsByAddressR](docs/ListOmniTransactionsByAddressR.md)
 - [ListOmniTransactionsByAddressRData](docs/ListOmniTransactionsByAddressRData.md)
 - [ListOmniTransactionsByAddressRi](docs/ListOmniTransactionsByAddressRi.md)
 - [ListOmniTransactionsByAddressRiFee](docs/ListOmniTransactionsByAddressRiFee.md)
 - [ListOmniTransactionsByAddressRiRecipients](docs/ListOmniTransactionsByAddressRiRecipients.md)
 - [ListOmniTransactionsByAddressRiSenders](docs/ListOmniTransactionsByAddressRiSenders.md)
 - [ListOmniTransactionsByBlockHashE400](docs/ListOmniTransactionsByBlockHashE400.md)
 - [ListOmniTransactionsByBlockHashE401](docs/ListOmniTransactionsByBlockHashE401.md)
 - [ListOmniTransactionsByBlockHashE403](docs/ListOmniTransactionsByBlockHashE403.md)
 - [ListOmniTransactionsByBlockHashR](docs/ListOmniTransactionsByBlockHashR.md)
 - [ListOmniTransactionsByBlockHashRData](docs/ListOmniTransactionsByBlockHashRData.md)
 - [ListOmniTransactionsByBlockHashRi](docs/ListOmniTransactionsByBlockHashRi.md)
 - [ListOmniTransactionsByBlockHashRiFee](docs/ListOmniTransactionsByBlockHashRiFee.md)
 - [ListOmniTransactionsByBlockHeightE400](docs/ListOmniTransactionsByBlockHeightE400.md)
 - [ListOmniTransactionsByBlockHeightE401](docs/ListOmniTransactionsByBlockHeightE401.md)
 - [ListOmniTransactionsByBlockHeightE403](docs/ListOmniTransactionsByBlockHeightE403.md)
 - [ListOmniTransactionsByBlockHeightR](docs/ListOmniTransactionsByBlockHeightR.md)
 - [ListOmniTransactionsByBlockHeightRData](docs/ListOmniTransactionsByBlockHeightRData.md)
 - [ListOmniTransactionsByBlockHeightRi](docs/ListOmniTransactionsByBlockHeightRi.md)
 - [ListOmniTransactionsByBlockHeightRiFee](docs/ListOmniTransactionsByBlockHeightRiFee.md)
 - [ListOmniTransactionsByBlockHeightRiRecipients](docs/ListOmniTransactionsByBlockHeightRiRecipients.md)
 - [ListOmniTransactionsByBlockHeightRiSenders](docs/ListOmniTransactionsByBlockHeightRiSenders.md)
 - [ListSupportedAssetsE400](docs/ListSupportedAssetsE400.md)
 - [ListSupportedAssetsE401](docs/ListSupportedAssetsE401.md)
 - [ListSupportedAssetsE403](docs/ListSupportedAssetsE403.md)
 - [ListSupportedAssetsR](docs/ListSupportedAssetsR.md)
 - [ListSupportedAssetsRData](docs/ListSupportedAssetsRData.md)
 - [ListSupportedAssetsRi](docs/ListSupportedAssetsRi.md)
 - [ListSupportedTokensE400](docs/ListSupportedTokensE400.md)
 - [ListSupportedTokensE401](docs/ListSupportedTokensE401.md)
 - [ListSupportedTokensE403](docs/ListSupportedTokensE403.md)
 - [ListSupportedTokensR](docs/ListSupportedTokensR.md)
 - [ListSupportedTokensRData](docs/ListSupportedTokensRData.md)
 - [ListSupportedTokensRi](docs/ListSupportedTokensRi.md)
 - [ListTokensByAddressE400](docs/ListTokensByAddressE400.md)
 - [ListTokensByAddressE401](docs/ListTokensByAddressE401.md)
 - [ListTokensByAddressE403](docs/ListTokensByAddressE403.md)
 - [ListTokensByAddressR](docs/ListTokensByAddressR.md)
 - [ListTokensByAddressRData](docs/ListTokensByAddressRData.md)
 - [ListTokensByAddressRi](docs/ListTokensByAddressRi.md)
 - [ListTokensForwardingAutomationsE400](docs/ListTokensForwardingAutomationsE400.md)
 - [ListTokensForwardingAutomationsE401](docs/ListTokensForwardingAutomationsE401.md)
 - [ListTokensForwardingAutomationsE403](docs/ListTokensForwardingAutomationsE403.md)
 - [ListTokensForwardingAutomationsR](docs/ListTokensForwardingAutomationsR.md)
 - [ListTokensForwardingAutomationsRData](docs/ListTokensForwardingAutomationsRData.md)
 - [ListTokensForwardingAutomationsRi](docs/ListTokensForwardingAutomationsRi.md)
 - [ListTokensForwardingAutomationsRits](docs/ListTokensForwardingAutomationsRits.md)
 - [ListTokensForwardingAutomationsRitsbot](docs/ListTokensForwardingAutomationsRitsbot.md)
 - [ListTokensForwardingAutomationsRitset](docs/ListTokensForwardingAutomationsRitset.md)
 - [ListTokensTransfersByTransactionHashE400](docs/ListTokensTransfersByTransactionHashE400.md)
 - [ListTokensTransfersByTransactionHashE401](docs/ListTokensTransfersByTransactionHashE401.md)
 - [ListTokensTransfersByTransactionHashE403](docs/ListTokensTransfersByTransactionHashE403.md)
 - [ListTokensTransfersByTransactionHashR](docs/ListTokensTransfersByTransactionHashR.md)
 - [ListTokensTransfersByTransactionHashRData](docs/ListTokensTransfersByTransactionHashRData.md)
 - [ListTokensTransfersByTransactionHashRi](docs/ListTokensTransfersByTransactionHashRi.md)
 - [ListTransactionsByBlockHashE400](docs/ListTransactionsByBlockHashE400.md)
 - [ListTransactionsByBlockHashE401](docs/ListTransactionsByBlockHashE401.md)
 - [ListTransactionsByBlockHashE403](docs/ListTransactionsByBlockHashE403.md)
 - [ListTransactionsByBlockHashR](docs/ListTransactionsByBlockHashR.md)
 - [ListTransactionsByBlockHashRData](docs/ListTransactionsByBlockHashRData.md)
 - [ListTransactionsByBlockHashRi](docs/ListTransactionsByBlockHashRi.md)
 - [ListTransactionsByBlockHashRiFee](docs/ListTransactionsByBlockHashRiFee.md)
 - [ListTransactionsByBlockHashRiRecipients](docs/ListTransactionsByBlockHashRiRecipients.md)
 - [ListTransactionsByBlockHashRiSenders](docs/ListTransactionsByBlockHashRiSenders.md)
 - [ListTransactionsByBlockHashRibs](docs/ListTransactionsByBlockHashRibs.md)
 - [ListTransactionsByBlockHashRibsb](docs/ListTransactionsByBlockHashRibsb.md)
 - [ListTransactionsByBlockHashRibsbScriptPubKey](docs/ListTransactionsByBlockHashRibsbScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsbVin](docs/ListTransactionsByBlockHashRibsbVin.md)
 - [ListTransactionsByBlockHashRibsbVout](docs/ListTransactionsByBlockHashRibsbVout.md)
 - [ListTransactionsByBlockHashRibsbc](docs/ListTransactionsByBlockHashRibsbc.md)
 - [ListTransactionsByBlockHashRibsbcScriptPubKey](docs/ListTransactionsByBlockHashRibsbcScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsbcVin](docs/ListTransactionsByBlockHashRibsbcVin.md)
 - [ListTransactionsByBlockHashRibsbcVout](docs/ListTransactionsByBlockHashRibsbcVout.md)
 - [ListTransactionsByBlockHashRibsbsc](docs/ListTransactionsByBlockHashRibsbsc.md)
 - [ListTransactionsByBlockHashRibsbscGasPrice](docs/ListTransactionsByBlockHashRibsbscGasPrice.md)
 - [ListTransactionsByBlockHashRibsd](docs/ListTransactionsByBlockHashRibsd.md)
 - [ListTransactionsByBlockHashRibsd2](docs/ListTransactionsByBlockHashRibsd2.md)
 - [ListTransactionsByBlockHashRibsd2ScriptPubKey](docs/ListTransactionsByBlockHashRibsd2ScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsd2ScriptSig](docs/ListTransactionsByBlockHashRibsd2ScriptSig.md)
 - [ListTransactionsByBlockHashRibsd2Vin](docs/ListTransactionsByBlockHashRibsd2Vin.md)
 - [ListTransactionsByBlockHashRibsd2Vout](docs/ListTransactionsByBlockHashRibsd2Vout.md)
 - [ListTransactionsByBlockHashRibsdScriptPubKey](docs/ListTransactionsByBlockHashRibsdScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsdVin](docs/ListTransactionsByBlockHashRibsdVin.md)
 - [ListTransactionsByBlockHashRibsdVout](docs/ListTransactionsByBlockHashRibsdVout.md)
 - [ListTransactionsByBlockHashRibse](docs/ListTransactionsByBlockHashRibse.md)
 - [ListTransactionsByBlockHashRibseGasPrice](docs/ListTransactionsByBlockHashRibseGasPrice.md)
 - [ListTransactionsByBlockHashRibsec](docs/ListTransactionsByBlockHashRibsec.md)
 - [ListTransactionsByBlockHashRibsl](docs/ListTransactionsByBlockHashRibsl.md)
 - [ListTransactionsByBlockHashRibslScriptPubKey](docs/ListTransactionsByBlockHashRibslScriptPubKey.md)
 - [ListTransactionsByBlockHashRibslScriptSig](docs/ListTransactionsByBlockHashRibslScriptSig.md)
 - [ListTransactionsByBlockHashRibslVin](docs/ListTransactionsByBlockHashRibslVin.md)
 - [ListTransactionsByBlockHashRibslVout](docs/ListTransactionsByBlockHashRibslVout.md)
 - [ListTransactionsByBlockHashRibsz](docs/ListTransactionsByBlockHashRibsz.md)
 - [ListTransactionsByBlockHashRibszScriptSig](docs/ListTransactionsByBlockHashRibszScriptSig.md)
 - [ListTransactionsByBlockHashRibszVJoinSplit](docs/ListTransactionsByBlockHashRibszVJoinSplit.md)
 - [ListTransactionsByBlockHashRibszVin](docs/ListTransactionsByBlockHashRibszVin.md)
 - [ListTransactionsByBlockHeightE400](docs/ListTransactionsByBlockHeightE400.md)
 - [ListTransactionsByBlockHeightE401](docs/ListTransactionsByBlockHeightE401.md)
 - [ListTransactionsByBlockHeightE403](docs/ListTransactionsByBlockHeightE403.md)
 - [ListTransactionsByBlockHeightR](docs/ListTransactionsByBlockHeightR.md)
 - [ListTransactionsByBlockHeightRData](docs/ListTransactionsByBlockHeightRData.md)
 - [ListTransactionsByBlockHeightRi](docs/ListTransactionsByBlockHeightRi.md)
 - [ListTransactionsByBlockHeightRiFee](docs/ListTransactionsByBlockHeightRiFee.md)
 - [ListTransactionsByBlockHeightRibs](docs/ListTransactionsByBlockHeightRibs.md)
 - [ListTransactionsByBlockHeightRibsb](docs/ListTransactionsByBlockHeightRibsb.md)
 - [ListTransactionsByBlockHeightRibsbScriptPubKey](docs/ListTransactionsByBlockHeightRibsbScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibsbVout](docs/ListTransactionsByBlockHeightRibsbVout.md)
 - [ListTransactionsByBlockHeightRibsbc](docs/ListTransactionsByBlockHeightRibsbc.md)
 - [ListTransactionsByBlockHeightRibsbsc](docs/ListTransactionsByBlockHeightRibsbsc.md)
 - [ListTransactionsByBlockHeightRibsbscGasPrice](docs/ListTransactionsByBlockHeightRibsbscGasPrice.md)
 - [ListTransactionsByBlockHeightRibsd](docs/ListTransactionsByBlockHeightRibsd.md)
 - [ListTransactionsByBlockHeightRibsd2](docs/ListTransactionsByBlockHeightRibsd2.md)
 - [ListTransactionsByBlockHeightRibsd2Vin](docs/ListTransactionsByBlockHeightRibsd2Vin.md)
 - [ListTransactionsByBlockHeightRibsdScriptPubKey](docs/ListTransactionsByBlockHeightRibsdScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibsdScriptSig](docs/ListTransactionsByBlockHeightRibsdScriptSig.md)
 - [ListTransactionsByBlockHeightRibsdVin](docs/ListTransactionsByBlockHeightRibsdVin.md)
 - [ListTransactionsByBlockHeightRibsdVout](docs/ListTransactionsByBlockHeightRibsdVout.md)
 - [ListTransactionsByBlockHeightRibse](docs/ListTransactionsByBlockHeightRibse.md)
 - [ListTransactionsByBlockHeightRibsec](docs/ListTransactionsByBlockHeightRibsec.md)
 - [ListTransactionsByBlockHeightRibsecGasPrice](docs/ListTransactionsByBlockHeightRibsecGasPrice.md)
 - [ListTransactionsByBlockHeightRibsl](docs/ListTransactionsByBlockHeightRibsl.md)
 - [ListTransactionsByBlockHeightRibslScriptPubKey](docs/ListTransactionsByBlockHeightRibslScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibslScriptSig](docs/ListTransactionsByBlockHeightRibslScriptSig.md)
 - [ListTransactionsByBlockHeightRibslVin](docs/ListTransactionsByBlockHeightRibslVin.md)
 - [ListTransactionsByBlockHeightRibslVout](docs/ListTransactionsByBlockHeightRibslVout.md)
 - [ListTransactionsByBlockHeightRibsz](docs/ListTransactionsByBlockHeightRibsz.md)
 - [ListTransactionsByBlockHeightRibszScriptPubKey](docs/ListTransactionsByBlockHeightRibszScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibszScriptSig](docs/ListTransactionsByBlockHeightRibszScriptSig.md)
 - [ListTransactionsByBlockHeightRibszVJoinSplit](docs/ListTransactionsByBlockHeightRibszVJoinSplit.md)
 - [ListTransactionsByBlockHeightRibszVShieldedOutput](docs/ListTransactionsByBlockHeightRibszVShieldedOutput.md)
 - [ListTransactionsByBlockHeightRibszVin](docs/ListTransactionsByBlockHeightRibszVin.md)
 - [ListTransactionsByBlockHeightRibszVout](docs/ListTransactionsByBlockHeightRibszVout.md)
 - [ListUnconfirmedOmniTransactionsByAddressE400](docs/ListUnconfirmedOmniTransactionsByAddressE400.md)
 - [ListUnconfirmedOmniTransactionsByAddressE401](docs/ListUnconfirmedOmniTransactionsByAddressE401.md)
 - [ListUnconfirmedOmniTransactionsByAddressE403](docs/ListUnconfirmedOmniTransactionsByAddressE403.md)
 - [ListUnconfirmedOmniTransactionsByAddressR](docs/ListUnconfirmedOmniTransactionsByAddressR.md)
 - [ListUnconfirmedOmniTransactionsByAddressRData](docs/ListUnconfirmedOmniTransactionsByAddressRData.md)
 - [ListUnconfirmedOmniTransactionsByAddressRi](docs/ListUnconfirmedOmniTransactionsByAddressRi.md)
 - [ListUnconfirmedOmniTransactionsByAddressRiFee](docs/ListUnconfirmedOmniTransactionsByAddressRiFee.md)
 - [ListUnconfirmedOmniTransactionsByAddressRiSenders](docs/ListUnconfirmedOmniTransactionsByAddressRiSenders.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIde400](docs/ListUnconfirmedOmniTransactionsByPropertyIde400.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIde401](docs/ListUnconfirmedOmniTransactionsByPropertyIde401.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIde403](docs/ListUnconfirmedOmniTransactionsByPropertyIde403.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdr](docs/ListUnconfirmedOmniTransactionsByPropertyIdr.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdrData](docs/ListUnconfirmedOmniTransactionsByPropertyIdrData.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdri](docs/ListUnconfirmedOmniTransactionsByPropertyIdri.md)
 - [ListUnconfirmedTransactionsByAddressE400](docs/ListUnconfirmedTransactionsByAddressE400.md)
 - [ListUnconfirmedTransactionsByAddressE401](docs/ListUnconfirmedTransactionsByAddressE401.md)
 - [ListUnconfirmedTransactionsByAddressE403](docs/ListUnconfirmedTransactionsByAddressE403.md)
 - [ListUnconfirmedTransactionsByAddressR](docs/ListUnconfirmedTransactionsByAddressR.md)
 - [ListUnconfirmedTransactionsByAddressRData](docs/ListUnconfirmedTransactionsByAddressRData.md)
 - [ListUnconfirmedTransactionsByAddressRi](docs/ListUnconfirmedTransactionsByAddressRi.md)
 - [ListUnconfirmedTransactionsByAddressRiRecipients](docs/ListUnconfirmedTransactionsByAddressRiRecipients.md)
 - [ListUnconfirmedTransactionsByAddressRiSenders](docs/ListUnconfirmedTransactionsByAddressRiSenders.md)
 - [ListUnconfirmedTransactionsByAddressRibs](docs/ListUnconfirmedTransactionsByAddressRibs.md)
 - [ListUnconfirmedTransactionsByAddressRibsb](docs/ListUnconfirmedTransactionsByAddressRibsb.md)
 - [ListUnconfirmedTransactionsByAddressRibsbScriptPubKey](docs/ListUnconfirmedTransactionsByAddressRibsbScriptPubKey.md)
 - [ListUnconfirmedTransactionsByAddressRibsbScriptSig](docs/ListUnconfirmedTransactionsByAddressRibsbScriptSig.md)
 - [ListUnconfirmedTransactionsByAddressRibsbVin](docs/ListUnconfirmedTransactionsByAddressRibsbVin.md)
 - [ListUnconfirmedTransactionsByAddressRibsbVout](docs/ListUnconfirmedTransactionsByAddressRibsbVout.md)
 - [ListUnconfirmedTransactionsByAddressRibsbc](docs/ListUnconfirmedTransactionsByAddressRibsbc.md)
 - [ListUnconfirmedTransactionsByAddressRibsbcScriptPubKey](docs/ListUnconfirmedTransactionsByAddressRibsbcScriptPubKey.md)
 - [ListUnconfirmedTransactionsByAddressRibsbcVin](docs/ListUnconfirmedTransactionsByAddressRibsbcVin.md)
 - [ListUnconfirmedTransactionsByAddressRibsbcVout](docs/ListUnconfirmedTransactionsByAddressRibsbcVout.md)
 - [ListUnconfirmedTransactionsByAddressRibsbsc](docs/ListUnconfirmedTransactionsByAddressRibsbsc.md)
 - [ListUnconfirmedTransactionsByAddressRibsd](docs/ListUnconfirmedTransactionsByAddressRibsd.md)
 - [ListUnconfirmedTransactionsByAddressRibsd2](docs/ListUnconfirmedTransactionsByAddressRibsd2.md)
 - [ListUnconfirmedTransactionsByAddressRibsd2Vin](docs/ListUnconfirmedTransactionsByAddressRibsd2Vin.md)
 - [ListUnconfirmedTransactionsByAddressRibsd2Vout](docs/ListUnconfirmedTransactionsByAddressRibsd2Vout.md)
 - [ListUnconfirmedTransactionsByAddressRibsdVin](docs/ListUnconfirmedTransactionsByAddressRibsdVin.md)
 - [ListUnconfirmedTransactionsByAddressRibse](docs/ListUnconfirmedTransactionsByAddressRibse.md)
 - [ListUnconfirmedTransactionsByAddressRibseFee](docs/ListUnconfirmedTransactionsByAddressRibseFee.md)
 - [ListUnconfirmedTransactionsByAddressRibsec](docs/ListUnconfirmedTransactionsByAddressRibsec.md)
 - [ListUnconfirmedTransactionsByAddressRibsecFee](docs/ListUnconfirmedTransactionsByAddressRibsecFee.md)
 - [ListUnconfirmedTransactionsByAddressRibsecGasPrice](docs/ListUnconfirmedTransactionsByAddressRibsecGasPrice.md)
 - [ListUnconfirmedTransactionsByAddressRibsl](docs/ListUnconfirmedTransactionsByAddressRibsl.md)
 - [ListUnconfirmedTransactionsByAddressRibslScriptSig](docs/ListUnconfirmedTransactionsByAddressRibslScriptSig.md)
 - [ListUnconfirmedTransactionsByAddressRibslVin](docs/ListUnconfirmedTransactionsByAddressRibslVin.md)
 - [ListUnconfirmedTransactionsByAddressRibslVout](docs/ListUnconfirmedTransactionsByAddressRibslVout.md)
 - [ListUnconfirmedTransactionsByAddressRibsz](docs/ListUnconfirmedTransactionsByAddressRibsz.md)
 - [ListUnspentTransactionOutputsByAddressE400](docs/ListUnspentTransactionOutputsByAddressE400.md)
 - [ListUnspentTransactionOutputsByAddressE401](docs/ListUnspentTransactionOutputsByAddressE401.md)
 - [ListUnspentTransactionOutputsByAddressE403](docs/ListUnspentTransactionOutputsByAddressE403.md)
 - [ListUnspentTransactionOutputsByAddressR](docs/ListUnspentTransactionOutputsByAddressR.md)
 - [ListUnspentTransactionOutputsByAddressRData](docs/ListUnspentTransactionOutputsByAddressRData.md)
 - [ListUnspentTransactionOutputsByAddressRi](docs/ListUnspentTransactionOutputsByAddressRi.md)
 - [ListUnspentTransactionOutputsByAddressRiBlockchainSpecific](docs/ListUnspentTransactionOutputsByAddressRiBlockchainSpecific.md)
 - [ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVJoinSplit](docs/ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVJoinSplit.md)
 - [ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVShieldedSpend](docs/ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVShieldedSpend.md)
 - [ListUnspentTransactionOutputsByAddressRiFee](docs/ListUnspentTransactionOutputsByAddressRiFee.md)
 - [ListUnspentTransactionOutputsByAddressRiSenders](docs/ListUnspentTransactionOutputsByAddressRiSenders.md)
 - [ListUnspentTransactionOutputsByAddressRiVin](docs/ListUnspentTransactionOutputsByAddressRiVin.md)
 - [ListWalletTransactionsE400](docs/ListWalletTransactionsE400.md)
 - [ListWalletTransactionsE401](docs/ListWalletTransactionsE401.md)
 - [ListWalletTransactionsE403](docs/ListWalletTransactionsE403.md)
 - [ListWalletTransactionsR](docs/ListWalletTransactionsR.md)
 - [ListWalletTransactionsRData](docs/ListWalletTransactionsRData.md)
 - [ListWalletTransactionsRi](docs/ListWalletTransactionsRi.md)
 - [ListWalletTransactionsRiFee](docs/ListWalletTransactionsRiFee.md)
 - [ListWalletTransactionsRiFungibleTokens](docs/ListWalletTransactionsRiFungibleTokens.md)
 - [ListWalletTransactionsRiInternalTransactions](docs/ListWalletTransactionsRiInternalTransactions.md)
 - [ListWalletTransactionsRiNonFungibleTokens](docs/ListWalletTransactionsRiNonFungibleTokens.md)
 - [ListWalletTransactionsRiRecipients](docs/ListWalletTransactionsRiRecipients.md)
 - [ListWalletTransactionsRiSenders](docs/ListWalletTransactionsRiSenders.md)
 - [ListWalletTransactionsRiValue](docs/ListWalletTransactionsRiValue.md)
 - [ListXrpRippleTransactionsByAddressE400](docs/ListXrpRippleTransactionsByAddressE400.md)
 - [ListXrpRippleTransactionsByAddressE401](docs/ListXrpRippleTransactionsByAddressE401.md)
 - [ListXrpRippleTransactionsByAddressE403](docs/ListXrpRippleTransactionsByAddressE403.md)
 - [ListXrpRippleTransactionsByAddressR](docs/ListXrpRippleTransactionsByAddressR.md)
 - [ListXrpRippleTransactionsByAddressRData](docs/ListXrpRippleTransactionsByAddressRData.md)
 - [ListXrpRippleTransactionsByAddressRi](docs/ListXrpRippleTransactionsByAddressRi.md)
 - [ListXrpRippleTransactionsByAddressRiFee](docs/ListXrpRippleTransactionsByAddressRiFee.md)
 - [ListXrpRippleTransactionsByAddressRiOffer](docs/ListXrpRippleTransactionsByAddressRiOffer.md)
 - [ListXrpRippleTransactionsByAddressRiReceive](docs/ListXrpRippleTransactionsByAddressRiReceive.md)
 - [ListXrpRippleTransactionsByAddressRiValue](docs/ListXrpRippleTransactionsByAddressRiValue.md)
 - [ListXrpRippleTransactionsByBlockHashE400](docs/ListXrpRippleTransactionsByBlockHashE400.md)
 - [ListXrpRippleTransactionsByBlockHashE401](docs/ListXrpRippleTransactionsByBlockHashE401.md)
 - [ListXrpRippleTransactionsByBlockHashE403](docs/ListXrpRippleTransactionsByBlockHashE403.md)
 - [ListXrpRippleTransactionsByBlockHashR](docs/ListXrpRippleTransactionsByBlockHashR.md)
 - [ListXrpRippleTransactionsByBlockHashRData](docs/ListXrpRippleTransactionsByBlockHashRData.md)
 - [ListXrpRippleTransactionsByBlockHashRi](docs/ListXrpRippleTransactionsByBlockHashRi.md)
 - [ListXrpRippleTransactionsByBlockHashRiFee](docs/ListXrpRippleTransactionsByBlockHashRiFee.md)
 - [ListXrpRippleTransactionsByBlockHashRiOffer](docs/ListXrpRippleTransactionsByBlockHashRiOffer.md)
 - [ListXrpRippleTransactionsByBlockHashRiReceive](docs/ListXrpRippleTransactionsByBlockHashRiReceive.md)
 - [ListXrpRippleTransactionsByBlockHashRiRecipients](docs/ListXrpRippleTransactionsByBlockHashRiRecipients.md)
 - [ListXrpRippleTransactionsByBlockHashRiSenders](docs/ListXrpRippleTransactionsByBlockHashRiSenders.md)
 - [ListXrpRippleTransactionsByBlockHashRiValue](docs/ListXrpRippleTransactionsByBlockHashRiValue.md)
 - [ListXrpRippleTransactionsByBlockHeightE400](docs/ListXrpRippleTransactionsByBlockHeightE400.md)
 - [ListXrpRippleTransactionsByBlockHeightE401](docs/ListXrpRippleTransactionsByBlockHeightE401.md)
 - [ListXrpRippleTransactionsByBlockHeightE403](docs/ListXrpRippleTransactionsByBlockHeightE403.md)
 - [ListXrpRippleTransactionsByBlockHeightR](docs/ListXrpRippleTransactionsByBlockHeightR.md)
 - [ListXrpRippleTransactionsByBlockHeightRData](docs/ListXrpRippleTransactionsByBlockHeightRData.md)
 - [ListXrpRippleTransactionsByBlockHeightRi](docs/ListXrpRippleTransactionsByBlockHeightRi.md)
 - [ListXrpRippleTransactionsByBlockHeightRiFee](docs/ListXrpRippleTransactionsByBlockHeightRiFee.md)
 - [ListXrpRippleTransactionsByBlockHeightRiOffer](docs/ListXrpRippleTransactionsByBlockHeightRiOffer.md)
 - [ListXrpRippleTransactionsByBlockHeightRiReceive](docs/ListXrpRippleTransactionsByBlockHeightRiReceive.md)
 - [ListXrpRippleTransactionsByBlockHeightRiRecipients](docs/ListXrpRippleTransactionsByBlockHeightRiRecipients.md)
 - [ListXrpRippleTransactionsByBlockHeightRiSenders](docs/ListXrpRippleTransactionsByBlockHeightRiSenders.md)
 - [ListXrpRippleTransactionsByBlockHeightRiValue](docs/ListXrpRippleTransactionsByBlockHeightRiValue.md)
 - [ListZilliqaTransactionsByAddressE400](docs/ListZilliqaTransactionsByAddressE400.md)
 - [ListZilliqaTransactionsByAddressE401](docs/ListZilliqaTransactionsByAddressE401.md)
 - [ListZilliqaTransactionsByAddressE403](docs/ListZilliqaTransactionsByAddressE403.md)
 - [ListZilliqaTransactionsByAddressR](docs/ListZilliqaTransactionsByAddressR.md)
 - [ListZilliqaTransactionsByAddressRData](docs/ListZilliqaTransactionsByAddressRData.md)
 - [ListZilliqaTransactionsByAddressRi](docs/ListZilliqaTransactionsByAddressRi.md)
 - [ListZilliqaTransactionsByAddressRiRecipients](docs/ListZilliqaTransactionsByAddressRiRecipients.md)
 - [ListZilliqaTransactionsByAddressRiSenders](docs/ListZilliqaTransactionsByAddressRiSenders.md)
 - [ListZilliqaTransactionsByBlockHashE400](docs/ListZilliqaTransactionsByBlockHashE400.md)
 - [ListZilliqaTransactionsByBlockHashE401](docs/ListZilliqaTransactionsByBlockHashE401.md)
 - [ListZilliqaTransactionsByBlockHashE403](docs/ListZilliqaTransactionsByBlockHashE403.md)
 - [ListZilliqaTransactionsByBlockHashR](docs/ListZilliqaTransactionsByBlockHashR.md)
 - [ListZilliqaTransactionsByBlockHashRData](docs/ListZilliqaTransactionsByBlockHashRData.md)
 - [ListZilliqaTransactionsByBlockHashRi](docs/ListZilliqaTransactionsByBlockHashRi.md)
 - [ListZilliqaTransactionsByBlockHeightE400](docs/ListZilliqaTransactionsByBlockHeightE400.md)
 - [ListZilliqaTransactionsByBlockHeightE401](docs/ListZilliqaTransactionsByBlockHeightE401.md)
 - [ListZilliqaTransactionsByBlockHeightE403](docs/ListZilliqaTransactionsByBlockHeightE403.md)
 - [ListZilliqaTransactionsByBlockHeightR](docs/ListZilliqaTransactionsByBlockHeightR.md)
 - [ListZilliqaTransactionsByBlockHeightRData](docs/ListZilliqaTransactionsByBlockHeightRData.md)
 - [ListZilliqaTransactionsByBlockHeightRi](docs/ListZilliqaTransactionsByBlockHeightRi.md)
 - [MinedTransactionE400](docs/MinedTransactionE400.md)
 - [MinedTransactionE401](docs/MinedTransactionE401.md)
 - [MinedTransactionE403](docs/MinedTransactionE403.md)
 - [MinedTransactionE409](docs/MinedTransactionE409.md)
 - [MinedTransactionR](docs/MinedTransactionR.md)
 - [MinedTransactionRData](docs/MinedTransactionRData.md)
 - [MinedTransactionRb](docs/MinedTransactionRb.md)
 - [MinedTransactionRbData](docs/MinedTransactionRbData.md)
 - [MinedTransactionRbDataItem](docs/MinedTransactionRbDataItem.md)
 - [MinedTransactionRi](docs/MinedTransactionRi.md)
 - [MissingApiKey](docs/MissingApiKey.md)
 - [NewBlockE400](docs/NewBlockE400.md)
 - [NewBlockE401](docs/NewBlockE401.md)
 - [NewBlockE403](docs/NewBlockE403.md)
 - [NewBlockE409](docs/NewBlockE409.md)
 - [NewBlockR](docs/NewBlockR.md)
 - [NewBlockRData](docs/NewBlockRData.md)
 - [NewBlockRb](docs/NewBlockRb.md)
 - [NewBlockRbData](docs/NewBlockRbData.md)
 - [NewBlockRbDataItem](docs/NewBlockRbDataItem.md)
 - [NewBlockRi](docs/NewBlockRi.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationE400](docs/NewConfirmedCoinsTransactionsAndEachConfirmationE400.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationE401](docs/NewConfirmedCoinsTransactionsAndEachConfirmationE401.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationE403](docs/NewConfirmedCoinsTransactionsAndEachConfirmationE403.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationE409](docs/NewConfirmedCoinsTransactionsAndEachConfirmationE409.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationR](docs/NewConfirmedCoinsTransactionsAndEachConfirmationR.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRb](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRbData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRi](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedCoinsTransactionsE400](docs/NewConfirmedCoinsTransactionsE400.md)
 - [NewConfirmedCoinsTransactionsE401](docs/NewConfirmedCoinsTransactionsE401.md)
 - [NewConfirmedCoinsTransactionsE403](docs/NewConfirmedCoinsTransactionsE403.md)
 - [NewConfirmedCoinsTransactionsE409](docs/NewConfirmedCoinsTransactionsE409.md)
 - [NewConfirmedCoinsTransactionsR](docs/NewConfirmedCoinsTransactionsR.md)
 - [NewConfirmedCoinsTransactionsRData](docs/NewConfirmedCoinsTransactionsRData.md)
 - [NewConfirmedCoinsTransactionsRb](docs/NewConfirmedCoinsTransactionsRb.md)
 - [NewConfirmedCoinsTransactionsRbData](docs/NewConfirmedCoinsTransactionsRbData.md)
 - [NewConfirmedCoinsTransactionsRbDataItem](docs/NewConfirmedCoinsTransactionsRbDataItem.md)
 - [NewConfirmedCoinsTransactionsRi](docs/NewConfirmedCoinsTransactionsRi.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationE400](docs/NewConfirmedInternalTransactionsAndEachConfirmationE400.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationE401](docs/NewConfirmedInternalTransactionsAndEachConfirmationE401.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationE403](docs/NewConfirmedInternalTransactionsAndEachConfirmationE403.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationE409](docs/NewConfirmedInternalTransactionsAndEachConfirmationE409.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationR](docs/NewConfirmedInternalTransactionsAndEachConfirmationR.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRb](docs/NewConfirmedInternalTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRbData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedInternalTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRi](docs/NewConfirmedInternalTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedInternalTransactionsE400](docs/NewConfirmedInternalTransactionsE400.md)
 - [NewConfirmedInternalTransactionsE401](docs/NewConfirmedInternalTransactionsE401.md)
 - [NewConfirmedInternalTransactionsE403](docs/NewConfirmedInternalTransactionsE403.md)
 - [NewConfirmedInternalTransactionsE409](docs/NewConfirmedInternalTransactionsE409.md)
 - [NewConfirmedInternalTransactionsR](docs/NewConfirmedInternalTransactionsR.md)
 - [NewConfirmedInternalTransactionsRData](docs/NewConfirmedInternalTransactionsRData.md)
 - [NewConfirmedInternalTransactionsRb](docs/NewConfirmedInternalTransactionsRb.md)
 - [NewConfirmedInternalTransactionsRbData](docs/NewConfirmedInternalTransactionsRbData.md)
 - [NewConfirmedInternalTransactionsRbDataItem](docs/NewConfirmedInternalTransactionsRbDataItem.md)
 - [NewConfirmedInternalTransactionsRi](docs/NewConfirmedInternalTransactionsRi.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationE400](docs/NewConfirmedTokensTransactionsAndEachConfirmationE400.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationE401](docs/NewConfirmedTokensTransactionsAndEachConfirmationE401.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationE403](docs/NewConfirmedTokensTransactionsAndEachConfirmationE403.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationE409](docs/NewConfirmedTokensTransactionsAndEachConfirmationE409.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationR](docs/NewConfirmedTokensTransactionsAndEachConfirmationR.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRb](docs/NewConfirmedTokensTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRbData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedTokensTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRi](docs/NewConfirmedTokensTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedTokensTransactionsE400](docs/NewConfirmedTokensTransactionsE400.md)
 - [NewConfirmedTokensTransactionsE401](docs/NewConfirmedTokensTransactionsE401.md)
 - [NewConfirmedTokensTransactionsE403](docs/NewConfirmedTokensTransactionsE403.md)
 - [NewConfirmedTokensTransactionsE409](docs/NewConfirmedTokensTransactionsE409.md)
 - [NewConfirmedTokensTransactionsR](docs/NewConfirmedTokensTransactionsR.md)
 - [NewConfirmedTokensTransactionsRData](docs/NewConfirmedTokensTransactionsRData.md)
 - [NewConfirmedTokensTransactionsRb](docs/NewConfirmedTokensTransactionsRb.md)
 - [NewConfirmedTokensTransactionsRbData](docs/NewConfirmedTokensTransactionsRbData.md)
 - [NewConfirmedTokensTransactionsRbDataItem](docs/NewConfirmedTokensTransactionsRbDataItem.md)
 - [NewConfirmedTokensTransactionsRi](docs/NewConfirmedTokensTransactionsRi.md)
 - [NewUnconfirmedCoinsTransactionsE400](docs/NewUnconfirmedCoinsTransactionsE400.md)
 - [NewUnconfirmedCoinsTransactionsE401](docs/NewUnconfirmedCoinsTransactionsE401.md)
 - [NewUnconfirmedCoinsTransactionsE403](docs/NewUnconfirmedCoinsTransactionsE403.md)
 - [NewUnconfirmedCoinsTransactionsE409](docs/NewUnconfirmedCoinsTransactionsE409.md)
 - [NewUnconfirmedCoinsTransactionsR](docs/NewUnconfirmedCoinsTransactionsR.md)
 - [NewUnconfirmedCoinsTransactionsRData](docs/NewUnconfirmedCoinsTransactionsRData.md)
 - [NewUnconfirmedCoinsTransactionsRb](docs/NewUnconfirmedCoinsTransactionsRb.md)
 - [NewUnconfirmedCoinsTransactionsRbData](docs/NewUnconfirmedCoinsTransactionsRbData.md)
 - [NewUnconfirmedCoinsTransactionsRbDataItem](docs/NewUnconfirmedCoinsTransactionsRbDataItem.md)
 - [NewUnconfirmedCoinsTransactionsRi](docs/NewUnconfirmedCoinsTransactionsRi.md)
 - [NewUnconfirmedTokensTransactionsE400](docs/NewUnconfirmedTokensTransactionsE400.md)
 - [NewUnconfirmedTokensTransactionsE401](docs/NewUnconfirmedTokensTransactionsE401.md)
 - [NewUnconfirmedTokensTransactionsE403](docs/NewUnconfirmedTokensTransactionsE403.md)
 - [NewUnconfirmedTokensTransactionsE409](docs/NewUnconfirmedTokensTransactionsE409.md)
 - [NewUnconfirmedTokensTransactionsR](docs/NewUnconfirmedTokensTransactionsR.md)
 - [NewUnconfirmedTokensTransactionsRData](docs/NewUnconfirmedTokensTransactionsRData.md)
 - [NewUnconfirmedTokensTransactionsRb](docs/NewUnconfirmedTokensTransactionsRb.md)
 - [NewUnconfirmedTokensTransactionsRbData](docs/NewUnconfirmedTokensTransactionsRbData.md)
 - [NewUnconfirmedTokensTransactionsRbDataItem](docs/NewUnconfirmedTokensTransactionsRbDataItem.md)
 - [NewUnconfirmedTokensTransactionsRi](docs/NewUnconfirmedTokensTransactionsRi.md)
 - [RequestLimitReached](docs/RequestLimitReached.md)
 - [ResourceNotFound](docs/ResourceNotFound.md)
 - [SyncHdWalletXPubYPubZPubE400](docs/SyncHdWalletXPubYPubZPubE400.md)
 - [SyncHdWalletXPubYPubZPubE401](docs/SyncHdWalletXPubYPubZPubE401.md)
 - [SyncHdWalletXPubYPubZPubE403](docs/SyncHdWalletXPubYPubZPubE403.md)
 - [SyncHdWalletXPubYPubZPubE409](docs/SyncHdWalletXPubYPubZPubE409.md)
 - [SyncHdWalletXPubYPubZPubE422](docs/SyncHdWalletXPubYPubZPubE422.md)
 - [SyncHdWalletXPubYPubZPubR](docs/SyncHdWalletXPubYPubZPubR.md)
 - [SyncHdWalletXPubYPubZPubRData](docs/SyncHdWalletXPubYPubZPubRData.md)
 - [SyncHdWalletXPubYPubZPubRb](docs/SyncHdWalletXPubYPubZPubRb.md)
 - [SyncHdWalletXPubYPubZPubRbData](docs/SyncHdWalletXPubYPubZPubRbData.md)
 - [SyncHdWalletXPubYPubZPubRbDataItem](docs/SyncHdWalletXPubYPubZPubRbDataItem.md)
 - [SyncHdWalletXPubYPubZPubRi](docs/SyncHdWalletXPubYPubZPubRi.md)
 - [TokensForwardingAutomationsLimitReached](docs/TokensForwardingAutomationsLimitReached.md)
 - [TokensForwardingFail](docs/TokensForwardingFail.md)
 - [TokensForwardingFailData](docs/TokensForwardingFailData.md)
 - [TokensForwardingFailDataItem](docs/TokensForwardingFailDataItem.md)
 - [TokensForwardingSuccess](docs/TokensForwardingSuccess.md)
 - [TokensForwardingSuccessData](docs/TokensForwardingSuccessData.md)
 - [TokensForwardingSuccessDataItem](docs/TokensForwardingSuccessDataItem.md)
 - [TokensForwardingSuccessErc20](docs/TokensForwardingSuccessErc20.md)
 - [TokensForwardingSuccessErc721](docs/TokensForwardingSuccessErc721.md)
 - [TokensForwardingSuccessOmni](docs/TokensForwardingSuccessOmni.md)
 - [TokensForwardingSuccessToken](docs/TokensForwardingSuccessToken.md)
 - [TransactionMined](docs/TransactionMined.md)
 - [TransactionMinedData](docs/TransactionMinedData.md)
 - [TransactionMinedDataItem](docs/TransactionMinedDataItem.md)
 - [TransactionMinedDataItemMinedInBlock](docs/TransactionMinedDataItemMinedInBlock.md)
 - [TransactionRequestApproval](docs/TransactionRequestApproval.md)
 - [TransactionRequestApprovalData](docs/TransactionRequestApprovalData.md)
 - [TransactionRequestApprovalDataItem](docs/TransactionRequestApprovalDataItem.md)
 - [TransactionRequestBroadcasted](docs/TransactionRequestBroadcasted.md)
 - [TransactionRequestBroadcastedData](docs/TransactionRequestBroadcastedData.md)
 - [TransactionRequestBroadcastedDataItem](docs/TransactionRequestBroadcastedDataItem.md)
 - [TransactionRequestFail](docs/TransactionRequestFail.md)
 - [TransactionRequestFailData](docs/TransactionRequestFailData.md)
 - [TransactionRequestFailDataItem](docs/TransactionRequestFailDataItem.md)
 - [TransactionRequestMined](docs/TransactionRequestMined.md)
 - [TransactionRequestMinedData](docs/TransactionRequestMinedData.md)
 - [TransactionRequestRejection](docs/TransactionRequestRejection.md)
 - [TransactionRequestRejectionData](docs/TransactionRequestRejectionData.md)
 - [TransactionRequestRejectionDataItem](docs/TransactionRequestRejectionDataItem.md)
 - [UnexpectedServerError](docs/UnexpectedServerError.md)
 - [UnsupportedMediaType](docs/UnsupportedMediaType.md)
 - [UriNotFound](docs/UriNotFound.md)
 - [ValidateAddressE400](docs/ValidateAddressE400.md)
 - [ValidateAddressE401](docs/ValidateAddressE401.md)
 - [ValidateAddressE403](docs/ValidateAddressE403.md)
 - [ValidateAddressR](docs/ValidateAddressR.md)
 - [ValidateAddressRData](docs/ValidateAddressRData.md)
 - [ValidateAddressRb](docs/ValidateAddressRb.md)
 - [ValidateAddressRbData](docs/ValidateAddressRbData.md)
 - [ValidateAddressRbDataItem](docs/ValidateAddressRbDataItem.md)
 - [ValidateAddressRi](docs/ValidateAddressRi.md)
 - [WalletAsAServiceAddressBalanceNotEnough](docs/WalletAsAServiceAddressBalanceNotEnough.md)
 - [WalletAsAServiceDepositAddressesLimitReached](docs/WalletAsAServiceDepositAddressesLimitReached.md)
 - [WalletAsAServiceNoDepositAddressesFound](docs/WalletAsAServiceNoDepositAddressesFound.md)
 - [WalletAsAServiceTokenNotSupported](docs/WalletAsAServiceTokenNotSupported.md)
 - [WalletAsAServiceWalletBalanceNotEnough](docs/WalletAsAServiceWalletBalanceNotEnough.md)
 - [XpubNotSynced](docs/XpubNotSynced.md)
 - [XpubSyncInProgress](docs/XpubSyncInProgress.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

developers@cryptoapis.io

