/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListWalletTransactionsRiValue {
    /// Defines the transaction amount.
    #[serde(rename = "amount")]
    pub amount: String,
    /// Defines the converted amount of the transaction as a string.
    #[serde(rename = "convertedAmount")]
    pub converted_amount: String,
    /// Defines the exchange rate's unit.
    #[serde(rename = "exchangeRateUnit")]
    pub exchange_rate_unit: String,
    /// Defines the unit of the transaction's amount.
    #[serde(rename = "symbol")]
    pub symbol: String,
    /// Defines the token's identifier of the transaction's amount.
    #[serde(rename = "tokenIdentifier", skip_serializing_if = "Option::is_none")]
    pub token_identifier: Option<String>,
}

impl ListWalletTransactionsRiValue {
    pub fn new(amount: String, converted_amount: String, exchange_rate_unit: String, symbol: String) -> ListWalletTransactionsRiValue {
        ListWalletTransactionsRiValue {
            amount,
            converted_amount,
            exchange_rate_unit,
            symbol,
            token_identifier: None,
        }
    }
}


