/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenerateAddressRi {
    #[serde(rename = "addresses")]
    pub addresses: Vec<crate::models::GenerateAddressRiAddresses>,
    /// Represents the privately known secret key used for authentication and encryption of the address.
    #[serde(rename = "privateKey")]
    pub private_key: String,
    /// Represents the publicly known key used for identification of the address.
    #[serde(rename = "publicKey")]
    pub public_key: String,
    /// Represents the Wallet Import Format which dictates the encoding that allows the copy of the private ECDSA key easily.
    #[serde(rename = "wif")]
    pub wif: String,
}

impl GenerateAddressRi {
    pub fn new(addresses: Vec<crate::models::GenerateAddressRiAddresses>, private_key: String, public_key: String, wif: String) -> GenerateAddressRi {
        GenerateAddressRi {
            addresses,
            private_key,
            public_key,
            wif,
        }
    }
}


