# Rust API client for cryptoapis

Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.3.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://cryptoapis.io](https://cryptoapis.io)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
cryptoapis = { path = "./cryptoapis" }
```

## Documentation for API Endpoints

All URIs are relative to *https://rest.cryptoapis.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AssetsApi* | [**list_assets_details**](docs/AssetsApi.md#list_assets_details) | **GET** /market-data/assets/details | List Assets Details
*AutomaticCoinsForwardingApi* | [**create_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#create_automatic_coins_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | Create Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**delete_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#delete_automatic_coins_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations/{referenceId} | Delete Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**list_coins_forwarding_automations**](docs/AutomaticCoinsForwardingApi.md#list_coins_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | List Coins Forwarding Automations
*AutomaticTokensForwardingApi* | [**add_tokens_to_existing_from_address**](docs/AutomaticTokensForwardingApi.md#add_tokens_to_existing_from_address) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/add-token | Add Tokens To Existing fromAddress
*AutomaticTokensForwardingApi* | [**create_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#create_automatic_tokens_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | Create Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**delete_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#delete_automatic_tokens_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/{referenceId} | Delete Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**get_fee_address_details**](docs/AutomaticTokensForwardingApi.md#get_fee_address_details) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/fee-addresses | Get Fee Address Details
*AutomaticTokensForwardingApi* | [**list_tokens_forwarding_automations**](docs/AutomaticTokensForwardingApi.md#list_tokens_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | List Tokens Forwarding Automations
*CreateSubscriptionsForApi* | [**mined_transaction**](docs/CreateSubscriptionsForApi.md#mined_transaction) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/transaction-mined | Mined transaction
*CreateSubscriptionsForApi* | [**new_block**](docs/CreateSubscriptionsForApi.md#new_block) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/block-mined | New Block
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed | New confirmed coins transactions
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed-each-confirmation | New confirmed coins transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed | New confirmed internal transactions
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed-each-confirmation | New confirmed internal transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed | New confirmed tokens transactions
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed-each-confirmation | New confirmed tokens transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_unconfirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-unconfirmed | New unconfirmed coins transactions
*CreateSubscriptionsForApi* | [**new_unconfirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-unconfirmed | New unconfirmed tokens transactions
*ExchangeRatesApi* | [**get_exchange_rate_by_asset_symbols**](docs/ExchangeRatesApi.md#get_exchange_rate_by_asset_symbols) | **GET** /market-data/exchange-rates/by-symbols/{fromAssetSymbol}/{toAssetSymbol} | Get Exchange Rate By Asset Symbols
*ExchangeRatesApi* | [**get_exchange_rate_by_assets_ids**](docs/ExchangeRatesApi.md#get_exchange_rate_by_assets_ids) | **GET** /market-data/exchange-rates/by-asset-ids/{fromAssetId}/{toAssetId} | Get Exchange Rate By Assets IDs
*FeaturesApi* | [**broadcast_locally_signed_transaction**](docs/FeaturesApi.md#broadcast_locally_signed_transaction) | **POST** /blockchain-tools/{blockchain}/{network}/transactions/broadcast | Broadcast Locally Signed Transaction
*FeaturesApi* | [**generate_address**](docs/FeaturesApi.md#generate_address) | **POST** /blockchain-tools/{blockchain}/{network}/addresses/generate | Generate Address
*FeaturesApi* | [**get_eip_1559_fee_recommendations**](docs/FeaturesApi.md#get_eip_1559_fee_recommendations) | **GET** /blockchain-tools/{blockchain}/{network}/fees/eip1559 | Get EIP 1559 Fee Recommendations
*FeaturesApi* | [**validate_address**](docs/FeaturesApi.md#validate_address) | **POST** /blockchain-tools/{blockchain}/{network}/addresses/validate | Validate Address
*GeneratingApi* | [**generate_deposit_address**](docs/GeneratingApi.md#generate_deposit_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | Generate Deposit Address
*HDWalletsApi* | [**get_hd_wallet__x_pub_y_pub_z_pub_details**](docs/HDWalletsApi.md#get_hd_wallet__x_pub_y_pub_z_pub_details) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/details | Get HD Wallet (xPub, yPub, zPub) Details
*HDWalletsApi* | [**list_hd_wallet__x_pub_y_pub_z_pub_transactions**](docs/HDWalletsApi.md#list_hd_wallet__x_pub_y_pub_z_pub_transactions) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/transactions | List HD Wallet (xPub, yPub, zPub) Transactions
*HDWalletsApi* | [**sync_hd_wallet__x_pub_y_pub_z_pub**](docs/HDWalletsApi.md#sync_hd_wallet__x_pub_y_pub_z_pub) | **POST** /blockchain-data/{blockchain}/{network}/hd/sync | Sync HD Wallet (xPub, yPub, zPub)
*InformativeApi* | [**get_transaction_request_details**](docs/InformativeApi.md#get_transaction_request_details) | **GET** /wallet-as-a-service/transactionRequests/{transactionRequestId} | Get Transaction Request Details
*InformativeApi* | [**get_wallet_asset_details**](docs/InformativeApi.md#get_wallet_asset_details) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network} | Get Wallet Asset Details
*InformativeApi* | [**list_deposit_addresses**](docs/InformativeApi.md#list_deposit_addresses) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | List Deposit Addresses
*InformativeApi* | [**list_supported_tokens**](docs/InformativeApi.md#list_supported_tokens) | **GET** /wallet-as-a-service/info/{blockchain}/{network}/supported-tokens | List Supported Tokens
*InformativeApi* | [**list_wallet_transactions**](docs/InformativeApi.md#list_wallet_transactions) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/transactions | List Wallet Transactions
*InternalApi* | [**get_internal_transaction_by_transaction_hash_and_operation_id**](docs/InternalApi.md#get_internal_transaction_by_transaction_hash_and_operation_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal/{operationId} | Get Internal Transaction by Transaction Hash and Operation Id
*InternalApi* | [**list_internal_transaction_details_by_transaction_hash**](docs/InternalApi.md#list_internal_transaction_details_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal | List Internal Transaction Details by Transaction Hash
*InternalApi* | [**list_internal_transactions_by_address**](docs/InternalApi.md#list_internal_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/internal | List Internal Transactions By Address
*ManageSubscriptionsApi* | [**delete_blockchain_event_subscription**](docs/ManageSubscriptionsApi.md#delete_blockchain_event_subscription) | **DELETE** /blockchain-events/{blockchain}/{network}/subscriptions/{referenceId} | Delete Blockchain Event Subscription
*ManageSubscriptionsApi* | [**list_blockchain_events_subscriptions**](docs/ManageSubscriptionsApi.md#list_blockchain_events_subscriptions) | **GET** /blockchain-events/{blockchain}/{network}/subscriptions | List Blockchain Events Subscriptions
*MetadataApi* | [**list_supported_assets**](docs/MetadataApi.md#list_supported_assets) | **GET** /market-data/assets/supported | List Supported Assets
*OmniLayerApi* | [**get_omni_transaction_details_by_transaction_id__txid**](docs/OmniLayerApi.md#get_omni_transaction_details_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions/{transactionId} | Get Omni Transaction Details By Transaction ID (Txid)
*OmniLayerApi* | [**get_unconfirmed_omni_transaction_by_transaction_id__txid**](docs/OmniLayerApi.md#get_unconfirmed_omni_transaction_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions-unconfirmed/{transactionId} | Get Unconfirmed Omni Transaction By Transaction ID (Txid)
*OmniLayerApi* | [**list_omni_tokens_by_address**](docs/OmniLayerApi.md#list_omni_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address} | List Omni Tokens By Address
*OmniLayerApi* | [**list_omni_transactions_by_address**](docs/OmniLayerApi.md#list_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address}/transactions | List Omni Transactions By Address
*OmniLayerApi* | [**list_omni_transactions_by_block_hash**](docs/OmniLayerApi.md#list_omni_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/hash/{blockHash}/transactions | List Omni Transactions By Block Hash
*OmniLayerApi* | [**list_omni_transactions_by_block_height**](docs/OmniLayerApi.md#list_omni_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/height/{blockHeight}/transactions | List Omni Transactions By Block Height
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_address**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/address-transactions-unconfirmed/{address} | List Unconfirmed Omni Transactions By Address
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_property_id**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_property_id) | **GET** /blockchain-data/{blockchain}/{network}/omni/properties/{propertyId}/transactions | List Unconfirmed Omni Transactions By Property ID
*TokensApi* | [**get_token_details_by_contract_address**](docs/TokensApi.md#get_token_details_by_contract_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{contractAddress}/contract | Get Token Details by Contract Address
*TokensApi* | [**list_confirmed_tokens_transfers_by_address**](docs/TokensApi.md#list_confirmed_tokens_transfers_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens-transfers | List Confirmed Tokens Transfers By Address
*TokensApi* | [**list_tokens_by_address**](docs/TokensApi.md#list_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens | List Tokens By Address
*TokensApi* | [**list_tokens_transfers_by_transaction_hash**](docs/TokensApi.md#list_tokens_transfers_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/tokens-transfers | List Tokens Transfers By Transaction Hash
*TransactionsApi* | [**create_coins_transaction_from_address_for_whole_amount**](docs/TransactionsApi.md#create_coins_transaction_from_address_for_whole_amount) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/all-transaction-requests | Create Coins Transaction From Address For Whole Amount
*TransactionsApi* | [**create_coins_transaction_request_from_address**](docs/TransactionsApi.md#create_coins_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/transaction-requests | Create Coins Transaction Request from Address
*TransactionsApi* | [**create_coins_transaction_request_from_wallet**](docs/TransactionsApi.md#create_coins_transaction_request_from_wallet) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/transaction-requests | Create Coins Transaction Request from Wallet
*TransactionsApi* | [**create_tokens_transaction_request_from_address**](docs/TransactionsApi.md#create_tokens_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{senderAddress}/token-transaction-requests | Create Tokens Transaction Request from Address
*UTXOBasedApi* | [**list_unspent_transaction_outputs_by_address**](docs/UTXOBasedApi.md#list_unspent_transaction_outputs_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/unspent | List Unspent Transaction Outputs By Address
*UnifiedEndpointsApi* | [**get_address_details**](docs/UnifiedEndpointsApi.md#get_address_details) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address} | Get Address Details
*UnifiedEndpointsApi* | [**get_block_details_by_block_hash**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash} | Get Block Details By Block Hash
*UnifiedEndpointsApi* | [**get_block_details_by_block_height**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height} | Get Block Details By Block Height
*UnifiedEndpointsApi* | [**get_fee_recommendations**](docs/UnifiedEndpointsApi.md#get_fee_recommendations) | **GET** /blockchain-data/{blockchain}/{network}/mempool/fees | Get Fee Recommendations
*UnifiedEndpointsApi* | [**get_last_mined_block**](docs/UnifiedEndpointsApi.md#get_last_mined_block) | **GET** /blockchain-data/{blockchain}/{network}/blocks/last | Get Last Mined Block
*UnifiedEndpointsApi* | [**get_transaction_details_by_transaction_id**](docs/UnifiedEndpointsApi.md#get_transaction_details_by_transaction_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionId} | Get Transaction Details By Transaction ID
*UnifiedEndpointsApi* | [**list_all_unconfirmed_transactions**](docs/UnifiedEndpointsApi.md#list_all_unconfirmed_transactions) | **GET** /blockchain-data/{blockchain}/{network}/address-transactions-unconfirmed | List All Unconfirmed Transactions
*UnifiedEndpointsApi* | [**list_confirmed_transactions_by_address**](docs/UnifiedEndpointsApi.md#list_confirmed_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/transactions | List Confirmed Transactions By Address
*UnifiedEndpointsApi* | [**list_latest_mined_blocks**](docs/UnifiedEndpointsApi.md#list_latest_mined_blocks) | **GET** /blockchain-data/{blockchain}/{network}/blocks/last/{count} | List Latest Mined Blocks
*UnifiedEndpointsApi* | [**list_transactions_by_block_hash**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}/transactions | List Transactions by Block Hash
*UnifiedEndpointsApi* | [**list_transactions_by_block_height**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height}/transactions | List Transactions by Block Height
*UnifiedEndpointsApi* | [**list_unconfirmed_transactions_by_address**](docs/UnifiedEndpointsApi.md#list_unconfirmed_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/address-transactions-unconfirmed/{address} | List Unconfirmed Transactions by Address
*XRPRippleApi* | [**get_latest_mined_xrp__ripple_block**](docs/XRPRippleApi.md#get_latest_mined_xrp__ripple_block) | **GET** /blockchain-data/xrp-specific/{network}/blocks/last | Get Latest Mined XRP (Ripple) Block
*XRPRippleApi* | [**get_xrp__ripple_address_details**](docs/XRPRippleApi.md#get_xrp__ripple_address_details) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address} | Get XRP (Ripple) Address Details
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_hash**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash} | Get XRP (Ripple) Block Details By Block Hash
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_height**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight} | Get XRP (Ripple) Block Details By Block Height
*XRPRippleApi* | [**get_xrp__ripple_transaction_details_by_transaction_id**](docs/XRPRippleApi.md#get_xrp__ripple_transaction_details_by_transaction_id) | **GET** /blockchain-data/xrp-specific/{network}/transactions/{transactionHash} | Get XRP (Ripple) Transaction Details By Transaction ID
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_address**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_address) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address}/transactions | List XRP (Ripple) Transactions by Address
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_hash**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash}/transactions | List XRP (Ripple) Transactions By Block Hash
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_height**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight}/transactions | List XRP (Ripple) Transactions By Block Height
*ZilliqaApi* | [**get_latest_mined_zilliqa_block**](docs/ZilliqaApi.md#get_latest_mined_zilliqa_block) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/last | Get Latest Mined Zilliqa Block
*ZilliqaApi* | [**get_zilliqa_address_details**](docs/ZilliqaApi.md#get_zilliqa_address_details) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address} | Get Zilliqa Address Details
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_hash**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash} | Get Zilliqa Block Details By Block Hash
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_height**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight} | Get Zilliqa Block Details By Block Height
*ZilliqaApi* | [**get_zilliqa_transaction_details_by_transaction_id**](docs/ZilliqaApi.md#get_zilliqa_transaction_details_by_transaction_id) | **GET** /blockchain-data/zilliqa-specific/{network}/transactions/{transactionHash} | Get Zilliqa Transaction Details by Transaction ID
*ZilliqaApi* | [**list_zilliqa_transactions_by_address**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_address) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address}/transactions | List Zilliqa Transactions by Address
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_hash**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash}/transactions | List Zilliqa Transactions By Block Hash
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_height**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight}/transactions | List Zilliqa Transactions By Block Height


## Documentation For Models

 - [AddTokensToExistingFromAddressR](docs/AddTokensToExistingFromAddressR.md)
 - [AddTokensToExistingFromAddressRData](docs/AddTokensToExistingFromAddressRData.md)
 - [AddTokensToExistingFromAddressRb](docs/AddTokensToExistingFromAddressRb.md)
 - [AddTokensToExistingFromAddressRbData](docs/AddTokensToExistingFromAddressRbData.md)
 - [AddTokensToExistingFromAddressRbDataItem](docs/AddTokensToExistingFromAddressRbDataItem.md)
 - [AddTokensToExistingFromAddressRbTokenData](docs/AddTokensToExistingFromAddressRbTokenData.md)
 - [AddTokensToExistingFromAddressRbTokenDataBitcoinOmniToken](docs/AddTokensToExistingFromAddressRbTokenDataBitcoinOmniToken.md)
 - [AddTokensToExistingFromAddressRbTokenDataEthereumToken](docs/AddTokensToExistingFromAddressRbTokenDataEthereumToken.md)
 - [AddTokensToExistingFromAddressRi](docs/AddTokensToExistingFromAddressRi.md)
 - [AddTokensToExistingFromAddressRits](docs/AddTokensToExistingFromAddressRits.md)
 - [AddTokensToExistingFromAddressRitsbot](docs/AddTokensToExistingFromAddressRitsbot.md)
 - [AddTokensToExistingFromAddressRitset](docs/AddTokensToExistingFromAddressRitset.md)
 - [AddressCoinsTransactionConfirmed](docs/AddressCoinsTransactionConfirmed.md)
 - [AddressCoinsTransactionConfirmedData](docs/AddressCoinsTransactionConfirmedData.md)
 - [AddressCoinsTransactionConfirmedDataItem](docs/AddressCoinsTransactionConfirmedDataItem.md)
 - [AddressCoinsTransactionConfirmedDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressCoinsTransactionConfirmedEachConfirmation](docs/AddressCoinsTransactionConfirmedEachConfirmation.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationData](docs/AddressCoinsTransactionConfirmedEachConfirmationData.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItem](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressCoinsTransactionUnconfirmed](docs/AddressCoinsTransactionUnconfirmed.md)
 - [AddressCoinsTransactionUnconfirmedData](docs/AddressCoinsTransactionUnconfirmedData.md)
 - [AddressCoinsTransactionUnconfirmedDataItem](docs/AddressCoinsTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionConfirmed](docs/AddressTokensTransactionConfirmed.md)
 - [AddressTokensTransactionConfirmedBep20](docs/AddressTokensTransactionConfirmedBep20.md)
 - [AddressTokensTransactionConfirmedData](docs/AddressTokensTransactionConfirmedData.md)
 - [AddressTokensTransactionConfirmedDataItem](docs/AddressTokensTransactionConfirmedDataItem.md)
 - [AddressTokensTransactionConfirmedDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmation](docs/AddressTokensTransactionConfirmedEachConfirmation.md)
 - [AddressTokensTransactionConfirmedEachConfirmationBep20](docs/AddressTokensTransactionConfirmedEachConfirmationBep20.md)
 - [AddressTokensTransactionConfirmedEachConfirmationData](docs/AddressTokensTransactionConfirmedEachConfirmationData.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItem](docs/AddressTokensTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressTokensTransactionConfirmedEachConfirmationErc20](docs/AddressTokensTransactionConfirmedEachConfirmationErc20.md)
 - [AddressTokensTransactionConfirmedEachConfirmationErc721](docs/AddressTokensTransactionConfirmedEachConfirmationErc721.md)
 - [AddressTokensTransactionConfirmedEachConfirmationOmni](docs/AddressTokensTransactionConfirmedEachConfirmationOmni.md)
 - [AddressTokensTransactionConfirmedEachConfirmationToken](docs/AddressTokensTransactionConfirmedEachConfirmationToken.md)
 - [AddressTokensTransactionConfirmedErc20](docs/AddressTokensTransactionConfirmedErc20.md)
 - [AddressTokensTransactionConfirmedErc721](docs/AddressTokensTransactionConfirmedErc721.md)
 - [AddressTokensTransactionConfirmedOmni](docs/AddressTokensTransactionConfirmedOmni.md)
 - [AddressTokensTransactionConfirmedToken](docs/AddressTokensTransactionConfirmedToken.md)
 - [AddressTokensTransactionUnconfirmed](docs/AddressTokensTransactionUnconfirmed.md)
 - [AddressTokensTransactionUnconfirmedData](docs/AddressTokensTransactionUnconfirmedData.md)
 - [AddressTokensTransactionUnconfirmedDataItem](docs/AddressTokensTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionUnconfirmedErc20](docs/AddressTokensTransactionUnconfirmedErc20.md)
 - [AddressTokensTransactionUnconfirmedErc721](docs/AddressTokensTransactionUnconfirmedErc721.md)
 - [AddressTokensTransactionUnconfirmedOmni](docs/AddressTokensTransactionUnconfirmedOmni.md)
 - [AddressTokensTransactionUnconfirmedToken](docs/AddressTokensTransactionUnconfirmedToken.md)
 - [AlreadyExists](docs/AlreadyExists.md)
 - [AlreadyExistsError](docs/AlreadyExistsError.md)
 - [BannedIpAddress](docs/BannedIpAddress.md)
 - [BannedIpAddressError](docs/BannedIpAddressError.md)
 - [BannedIpAddressErrorDetails](docs/BannedIpAddressErrorDetails.md)
 - [BlockMined](docs/BlockMined.md)
 - [BlockMinedData](docs/BlockMinedData.md)
 - [BlockMinedDataItem](docs/BlockMinedDataItem.md)
 - [BlockchainDataBlockNotFound](docs/BlockchainDataBlockNotFound.md)
 - [BlockchainDataBlockNotFoundError](docs/BlockchainDataBlockNotFoundError.md)
 - [BlockchainDataInternalTransactionNotFound](docs/BlockchainDataInternalTransactionNotFound.md)
 - [BlockchainDataInternalTransactionNotFoundError](docs/BlockchainDataInternalTransactionNotFoundError.md)
 - [BlockchainDataTransactionNotFound](docs/BlockchainDataTransactionNotFound.md)
 - [BlockchainDataTransactionNotFoundError](docs/BlockchainDataTransactionNotFoundError.md)
 - [BlockchainEventsCallbacksLimitReached](docs/BlockchainEventsCallbacksLimitReached.md)
 - [BlockchainEventsCallbacksLimitReachedError](docs/BlockchainEventsCallbacksLimitReachedError.md)
 - [BroadcastLocallySignedTransactionR](docs/BroadcastLocallySignedTransactionR.md)
 - [BroadcastLocallySignedTransactionRData](docs/BroadcastLocallySignedTransactionRData.md)
 - [BroadcastLocallySignedTransactionRb](docs/BroadcastLocallySignedTransactionRb.md)
 - [BroadcastLocallySignedTransactionRbData](docs/BroadcastLocallySignedTransactionRbData.md)
 - [BroadcastLocallySignedTransactionRbDataItem](docs/BroadcastLocallySignedTransactionRbDataItem.md)
 - [BroadcastLocallySignedTransactionRi](docs/BroadcastLocallySignedTransactionRi.md)
 - [BroadcastTransactionFail](docs/BroadcastTransactionFail.md)
 - [BroadcastTransactionFailData](docs/BroadcastTransactionFailData.md)
 - [BroadcastTransactionFailDataItem](docs/BroadcastTransactionFailDataItem.md)
 - [BroadcastTransactionSuccess](docs/BroadcastTransactionSuccess.md)
 - [BroadcastTransactionSuccessData](docs/BroadcastTransactionSuccessData.md)
 - [BroadcastTransactionSuccessDataItem](docs/BroadcastTransactionSuccessDataItem.md)
 - [CoinsForwardingAutomationsLimitReached](docs/CoinsForwardingAutomationsLimitReached.md)
 - [CoinsForwardingAutomationsLimitReachedError](docs/CoinsForwardingAutomationsLimitReachedError.md)
 - [CoinsForwardingFail](docs/CoinsForwardingFail.md)
 - [CoinsForwardingFailData](docs/CoinsForwardingFailData.md)
 - [CoinsForwardingFailDataItem](docs/CoinsForwardingFailDataItem.md)
 - [CoinsForwardingSuccess](docs/CoinsForwardingSuccess.md)
 - [CoinsForwardingSuccessData](docs/CoinsForwardingSuccessData.md)
 - [CoinsForwardingSuccessDataItem](docs/CoinsForwardingSuccessDataItem.md)
 - [CouldNotCalculateRateForPair](docs/CouldNotCalculateRateForPair.md)
 - [CouldNotCalculateRateForPairError](docs/CouldNotCalculateRateForPairError.md)
 - [CreateAutomaticCoinsForwardingR](docs/CreateAutomaticCoinsForwardingR.md)
 - [CreateAutomaticCoinsForwardingRData](docs/CreateAutomaticCoinsForwardingRData.md)
 - [CreateAutomaticCoinsForwardingRb](docs/CreateAutomaticCoinsForwardingRb.md)
 - [CreateAutomaticCoinsForwardingRbData](docs/CreateAutomaticCoinsForwardingRbData.md)
 - [CreateAutomaticCoinsForwardingRbDataItem](docs/CreateAutomaticCoinsForwardingRbDataItem.md)
 - [CreateAutomaticCoinsForwardingRi](docs/CreateAutomaticCoinsForwardingRi.md)
 - [CreateAutomaticTokensForwardingR](docs/CreateAutomaticTokensForwardingR.md)
 - [CreateAutomaticTokensForwardingRData](docs/CreateAutomaticTokensForwardingRData.md)
 - [CreateAutomaticTokensForwardingRb](docs/CreateAutomaticTokensForwardingRb.md)
 - [CreateAutomaticTokensForwardingRbData](docs/CreateAutomaticTokensForwardingRbData.md)
 - [CreateAutomaticTokensForwardingRbDataItem](docs/CreateAutomaticTokensForwardingRbDataItem.md)
 - [CreateAutomaticTokensForwardingRbTokenData](docs/CreateAutomaticTokensForwardingRbTokenData.md)
 - [CreateAutomaticTokensForwardingRbTokenDataBitcoinOmniToken](docs/CreateAutomaticTokensForwardingRbTokenDataBitcoinOmniToken.md)
 - [CreateAutomaticTokensForwardingRbTokenDataEthereumToken](docs/CreateAutomaticTokensForwardingRbTokenDataEthereumToken.md)
 - [CreateAutomaticTokensForwardingRi](docs/CreateAutomaticTokensForwardingRi.md)
 - [CreateAutomaticTokensForwardingRits](docs/CreateAutomaticTokensForwardingRits.md)
 - [CreateAutomaticTokensForwardingRitsbot](docs/CreateAutomaticTokensForwardingRitsbot.md)
 - [CreateAutomaticTokensForwardingRitset](docs/CreateAutomaticTokensForwardingRitset.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountR](docs/CreateCoinsTransactionFromAddressForWholeAmountR.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRData](docs/CreateCoinsTransactionFromAddressForWholeAmountRData.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRb](docs/CreateCoinsTransactionFromAddressForWholeAmountRb.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRbData](docs/CreateCoinsTransactionFromAddressForWholeAmountRbData.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRbDataItem](docs/CreateCoinsTransactionFromAddressForWholeAmountRbDataItem.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRi](docs/CreateCoinsTransactionFromAddressForWholeAmountRi.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRiRecipients](docs/CreateCoinsTransactionFromAddressForWholeAmountRiRecipients.md)
 - [CreateCoinsTransactionFromAddressForWholeAmountRiSenders](docs/CreateCoinsTransactionFromAddressForWholeAmountRiSenders.md)
 - [CreateCoinsTransactionRequestFromAddressR](docs/CreateCoinsTransactionRequestFromAddressR.md)
 - [CreateCoinsTransactionRequestFromAddressRData](docs/CreateCoinsTransactionRequestFromAddressRData.md)
 - [CreateCoinsTransactionRequestFromAddressRb](docs/CreateCoinsTransactionRequestFromAddressRb.md)
 - [CreateCoinsTransactionRequestFromAddressRbData](docs/CreateCoinsTransactionRequestFromAddressRbData.md)
 - [CreateCoinsTransactionRequestFromAddressRbDataItem](docs/CreateCoinsTransactionRequestFromAddressRbDataItem.md)
 - [CreateCoinsTransactionRequestFromAddressRi](docs/CreateCoinsTransactionRequestFromAddressRi.md)
 - [CreateCoinsTransactionRequestFromAddressRiRecipients](docs/CreateCoinsTransactionRequestFromAddressRiRecipients.md)
 - [CreateCoinsTransactionRequestFromAddressRiSenders](docs/CreateCoinsTransactionRequestFromAddressRiSenders.md)
 - [CreateCoinsTransactionRequestFromWalletR](docs/CreateCoinsTransactionRequestFromWalletR.md)
 - [CreateCoinsTransactionRequestFromWalletRData](docs/CreateCoinsTransactionRequestFromWalletRData.md)
 - [CreateCoinsTransactionRequestFromWalletRb](docs/CreateCoinsTransactionRequestFromWalletRb.md)
 - [CreateCoinsTransactionRequestFromWalletRbData](docs/CreateCoinsTransactionRequestFromWalletRbData.md)
 - [CreateCoinsTransactionRequestFromWalletRbDataItem](docs/CreateCoinsTransactionRequestFromWalletRbDataItem.md)
 - [CreateCoinsTransactionRequestFromWalletRbDataItemRecipients](docs/CreateCoinsTransactionRequestFromWalletRbDataItemRecipients.md)
 - [CreateCoinsTransactionRequestFromWalletRi](docs/CreateCoinsTransactionRequestFromWalletRi.md)
 - [CreateCoinsTransactionRequestFromWalletRiRecipients](docs/CreateCoinsTransactionRequestFromWalletRiRecipients.md)
 - [CreateTokensTransactionRequestFromAddressR](docs/CreateTokensTransactionRequestFromAddressR.md)
 - [CreateTokensTransactionRequestFromAddressRData](docs/CreateTokensTransactionRequestFromAddressRData.md)
 - [CreateTokensTransactionRequestFromAddressRb](docs/CreateTokensTransactionRequestFromAddressRb.md)
 - [CreateTokensTransactionRequestFromAddressRbData](docs/CreateTokensTransactionRequestFromAddressRbData.md)
 - [CreateTokensTransactionRequestFromAddressRbDataItem](docs/CreateTokensTransactionRequestFromAddressRbDataItem.md)
 - [CreateTokensTransactionRequestFromAddressRi](docs/CreateTokensTransactionRequestFromAddressRi.md)
 - [CreateTokensTransactionRequestFromAddressRiRecipients](docs/CreateTokensTransactionRequestFromAddressRiRecipients.md)
 - [CreateTokensTransactionRequestFromAddressRiSenders](docs/CreateTokensTransactionRequestFromAddressRiSenders.md)
 - [CreateTokensTransactionRequestFromAddressRis](docs/CreateTokensTransactionRequestFromAddressRis.md)
 - [CreateTokensTransactionRequestFromAddressRise](docs/CreateTokensTransactionRequestFromAddressRise.md)
 - [DeleteAutomaticCoinsForwardingR](docs/DeleteAutomaticCoinsForwardingR.md)
 - [DeleteAutomaticCoinsForwardingRData](docs/DeleteAutomaticCoinsForwardingRData.md)
 - [DeleteAutomaticCoinsForwardingRi](docs/DeleteAutomaticCoinsForwardingRi.md)
 - [DeleteAutomaticTokensForwardingR](docs/DeleteAutomaticTokensForwardingR.md)
 - [DeleteAutomaticTokensForwardingRData](docs/DeleteAutomaticTokensForwardingRData.md)
 - [DeleteAutomaticTokensForwardingRi](docs/DeleteAutomaticTokensForwardingRi.md)
 - [DeleteAutomaticTokensForwardingRits](docs/DeleteAutomaticTokensForwardingRits.md)
 - [DeleteAutomaticTokensForwardingRitsbot](docs/DeleteAutomaticTokensForwardingRitsbot.md)
 - [DeleteAutomaticTokensForwardingRitset](docs/DeleteAutomaticTokensForwardingRitset.md)
 - [DeleteBlockchainEventSubscriptionR](docs/DeleteBlockchainEventSubscriptionR.md)
 - [DeleteBlockchainEventSubscriptionRData](docs/DeleteBlockchainEventSubscriptionRData.md)
 - [DeleteBlockchainEventSubscriptionRi](docs/DeleteBlockchainEventSubscriptionRi.md)
 - [EndpointNotAllowedForApiKey](docs/EndpointNotAllowedForApiKey.md)
 - [EndpointNotAllowedForApiKeyError](docs/EndpointNotAllowedForApiKeyError.md)
 - [EndpointNotAllowedForPlan](docs/EndpointNotAllowedForPlan.md)
 - [EndpointNotAllowedForPlanError](docs/EndpointNotAllowedForPlanError.md)
 - [FeatureMainnetsNotAllowedForPlan](docs/FeatureMainnetsNotAllowedForPlan.md)
 - [FeatureMainnetsNotAllowedForPlanError](docs/FeatureMainnetsNotAllowedForPlanError.md)
 - [GenerateAddressR](docs/GenerateAddressR.md)
 - [GenerateAddressRData](docs/GenerateAddressRData.md)
 - [GenerateAddressRb](docs/GenerateAddressRb.md)
 - [GenerateAddressRbData](docs/GenerateAddressRbData.md)
 - [GenerateAddressRi](docs/GenerateAddressRi.md)
 - [GenerateAddressRiAddresses](docs/GenerateAddressRiAddresses.md)
 - [GenerateDepositAddressR](docs/GenerateDepositAddressR.md)
 - [GenerateDepositAddressRData](docs/GenerateDepositAddressRData.md)
 - [GenerateDepositAddressRb](docs/GenerateDepositAddressRb.md)
 - [GenerateDepositAddressRbData](docs/GenerateDepositAddressRbData.md)
 - [GenerateDepositAddressRbDataItem](docs/GenerateDepositAddressRbDataItem.md)
 - [GenerateDepositAddressRi](docs/GenerateDepositAddressRi.md)
 - [GetAddressDetailsR](docs/GetAddressDetailsR.md)
 - [GetAddressDetailsRData](docs/GetAddressDetailsRData.md)
 - [GetAddressDetailsRi](docs/GetAddressDetailsRi.md)
 - [GetAddressDetailsRiConfirmedBalance](docs/GetAddressDetailsRiConfirmedBalance.md)
 - [GetAddressDetailsRiTotalReceived](docs/GetAddressDetailsRiTotalReceived.md)
 - [GetAddressDetailsRiTotalSpent](docs/GetAddressDetailsRiTotalSpent.md)
 - [GetBlockDetailsByBlockHashR](docs/GetBlockDetailsByBlockHashR.md)
 - [GetBlockDetailsByBlockHashRData](docs/GetBlockDetailsByBlockHashRData.md)
 - [GetBlockDetailsByBlockHashRi](docs/GetBlockDetailsByBlockHashRi.md)
 - [GetBlockDetailsByBlockHashRibs](docs/GetBlockDetailsByBlockHashRibs.md)
 - [GetBlockDetailsByBlockHashRibsb](docs/GetBlockDetailsByBlockHashRibsb.md)
 - [GetBlockDetailsByBlockHashRibsbc](docs/GetBlockDetailsByBlockHashRibsbc.md)
 - [GetBlockDetailsByBlockHashRibsbsc](docs/GetBlockDetailsByBlockHashRibsbsc.md)
 - [GetBlockDetailsByBlockHashRibsd](docs/GetBlockDetailsByBlockHashRibsd.md)
 - [GetBlockDetailsByBlockHashRibsd2](docs/GetBlockDetailsByBlockHashRibsd2.md)
 - [GetBlockDetailsByBlockHashRibse](docs/GetBlockDetailsByBlockHashRibse.md)
 - [GetBlockDetailsByBlockHashRibsec](docs/GetBlockDetailsByBlockHashRibsec.md)
 - [GetBlockDetailsByBlockHashRibsl](docs/GetBlockDetailsByBlockHashRibsl.md)
 - [GetBlockDetailsByBlockHashRibsz](docs/GetBlockDetailsByBlockHashRibsz.md)
 - [GetBlockDetailsByBlockHeightR](docs/GetBlockDetailsByBlockHeightR.md)
 - [GetBlockDetailsByBlockHeightRData](docs/GetBlockDetailsByBlockHeightRData.md)
 - [GetBlockDetailsByBlockHeightRi](docs/GetBlockDetailsByBlockHeightRi.md)
 - [GetBlockDetailsByBlockHeightRibs](docs/GetBlockDetailsByBlockHeightRibs.md)
 - [GetBlockDetailsByBlockHeightRibsb](docs/GetBlockDetailsByBlockHeightRibsb.md)
 - [GetBlockDetailsByBlockHeightRibsbc](docs/GetBlockDetailsByBlockHeightRibsbc.md)
 - [GetBlockDetailsByBlockHeightRibsbsc](docs/GetBlockDetailsByBlockHeightRibsbsc.md)
 - [GetBlockDetailsByBlockHeightRibsd](docs/GetBlockDetailsByBlockHeightRibsd.md)
 - [GetBlockDetailsByBlockHeightRibsd2](docs/GetBlockDetailsByBlockHeightRibsd2.md)
 - [GetBlockDetailsByBlockHeightRibse](docs/GetBlockDetailsByBlockHeightRibse.md)
 - [GetBlockDetailsByBlockHeightRibsec](docs/GetBlockDetailsByBlockHeightRibsec.md)
 - [GetBlockDetailsByBlockHeightRibsl](docs/GetBlockDetailsByBlockHeightRibsl.md)
 - [GetBlockDetailsByBlockHeightRibsz](docs/GetBlockDetailsByBlockHeightRibsz.md)
 - [GetEip1559FeeRecommendationsR](docs/GetEip1559FeeRecommendationsR.md)
 - [GetEip1559FeeRecommendationsRData](docs/GetEip1559FeeRecommendationsRData.md)
 - [GetEip1559FeeRecommendationsRi](docs/GetEip1559FeeRecommendationsRi.md)
 - [GetEip1559FeeRecommendationsRiBaseFeePerGas](docs/GetEip1559FeeRecommendationsRiBaseFeePerGas.md)
 - [GetEip1559FeeRecommendationsRiMaxFeePerGas](docs/GetEip1559FeeRecommendationsRiMaxFeePerGas.md)
 - [GetEip1559FeeRecommendationsRiMaxPriorityFeePerGas](docs/GetEip1559FeeRecommendationsRiMaxPriorityFeePerGas.md)
 - [GetExchangeRateByAssetSymbolsR](docs/GetExchangeRateByAssetSymbolsR.md)
 - [GetExchangeRateByAssetSymbolsRData](docs/GetExchangeRateByAssetSymbolsRData.md)
 - [GetExchangeRateByAssetSymbolsRi](docs/GetExchangeRateByAssetSymbolsRi.md)
 - [GetExchangeRateByAssetsIdsR](docs/GetExchangeRateByAssetsIdsR.md)
 - [GetExchangeRateByAssetsIdsRData](docs/GetExchangeRateByAssetsIdsRData.md)
 - [GetExchangeRateByAssetsIdsRi](docs/GetExchangeRateByAssetsIdsRi.md)
 - [GetFeeAddressDetailsR](docs/GetFeeAddressDetailsR.md)
 - [GetFeeAddressDetailsRData](docs/GetFeeAddressDetailsRData.md)
 - [GetFeeAddressDetailsRi](docs/GetFeeAddressDetailsRi.md)
 - [GetFeeAddressDetailsRiBalance](docs/GetFeeAddressDetailsRiBalance.md)
 - [GetFeeRecommendationsR](docs/GetFeeRecommendationsR.md)
 - [GetFeeRecommendationsRData](docs/GetFeeRecommendationsRData.md)
 - [GetFeeRecommendationsRi](docs/GetFeeRecommendationsRi.md)
 - [GetHdWalletXPubYPubZPubDetailsR](docs/GetHdWalletXPubYPubZPubDetailsR.md)
 - [GetHdWalletXPubYPubZPubDetailsRData](docs/GetHdWalletXPubYPubZPubDetailsRData.md)
 - [GetHdWalletXPubYPubZPubDetailsRi](docs/GetHdWalletXPubYPubZPubDetailsRi.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdR](docs/GetInternalTransactionByTransactionHashAndOperationIdR.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRData](docs/GetInternalTransactionByTransactionHashAndOperationIdRData.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRi](docs/GetInternalTransactionByTransactionHashAndOperationIdRi.md)
 - [GetLastMinedBlockR](docs/GetLastMinedBlockR.md)
 - [GetLastMinedBlockRData](docs/GetLastMinedBlockRData.md)
 - [GetLastMinedBlockRi](docs/GetLastMinedBlockRi.md)
 - [GetLastMinedBlockRibs](docs/GetLastMinedBlockRibs.md)
 - [GetLastMinedBlockRibsb](docs/GetLastMinedBlockRibsb.md)
 - [GetLastMinedBlockRibsbc](docs/GetLastMinedBlockRibsbc.md)
 - [GetLastMinedBlockRibsbsc](docs/GetLastMinedBlockRibsbsc.md)
 - [GetLastMinedBlockRibsd](docs/GetLastMinedBlockRibsd.md)
 - [GetLastMinedBlockRibsd2](docs/GetLastMinedBlockRibsd2.md)
 - [GetLastMinedBlockRibse](docs/GetLastMinedBlockRibse.md)
 - [GetLastMinedBlockRibsec](docs/GetLastMinedBlockRibsec.md)
 - [GetLastMinedBlockRibsl](docs/GetLastMinedBlockRibsl.md)
 - [GetLastMinedBlockRibsz](docs/GetLastMinedBlockRibsz.md)
 - [GetLatestMinedXrpRippleBlockR](docs/GetLatestMinedXrpRippleBlockR.md)
 - [GetLatestMinedXrpRippleBlockRData](docs/GetLatestMinedXrpRippleBlockRData.md)
 - [GetLatestMinedXrpRippleBlockRi](docs/GetLatestMinedXrpRippleBlockRi.md)
 - [GetLatestMinedXrpRippleBlockRiTotalCoins](docs/GetLatestMinedXrpRippleBlockRiTotalCoins.md)
 - [GetLatestMinedXrpRippleBlockRiTotalFees](docs/GetLatestMinedXrpRippleBlockRiTotalFees.md)
 - [GetLatestMinedZilliqaBlockR](docs/GetLatestMinedZilliqaBlockR.md)
 - [GetLatestMinedZilliqaBlockRData](docs/GetLatestMinedZilliqaBlockRData.md)
 - [GetLatestMinedZilliqaBlockRi](docs/GetLatestMinedZilliqaBlockRi.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidR](docs/GetOmniTransactionDetailsByTransactionIdTxidR.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRData](docs/GetOmniTransactionDetailsByTransactionIdTxidRData.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRi](docs/GetOmniTransactionDetailsByTransactionIdTxidRi.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRiSenders](docs/GetOmniTransactionDetailsByTransactionIdTxidRiSenders.md)
 - [GetTokenDetailsByContractAddressR](docs/GetTokenDetailsByContractAddressR.md)
 - [GetTokenDetailsByContractAddressRData](docs/GetTokenDetailsByContractAddressRData.md)
 - [GetTokenDetailsByContractAddressRi](docs/GetTokenDetailsByContractAddressRi.md)
 - [GetTransactionDetailsByTransactionIdr](docs/GetTransactionDetailsByTransactionIdr.md)
 - [GetTransactionDetailsByTransactionIdrData](docs/GetTransactionDetailsByTransactionIdrData.md)
 - [GetTransactionDetailsByTransactionIdri](docs/GetTransactionDetailsByTransactionIdri.md)
 - [GetTransactionDetailsByTransactionIdriFee](docs/GetTransactionDetailsByTransactionIdriFee.md)
 - [GetTransactionDetailsByTransactionIdriRecipients](docs/GetTransactionDetailsByTransactionIdriRecipients.md)
 - [GetTransactionDetailsByTransactionIdriSenders](docs/GetTransactionDetailsByTransactionIdriSenders.md)
 - [GetTransactionDetailsByTransactionIdribs](docs/GetTransactionDetailsByTransactionIdribs.md)
 - [GetTransactionDetailsByTransactionIdribsb](docs/GetTransactionDetailsByTransactionIdribsb.md)
 - [GetTransactionDetailsByTransactionIdribsbScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsbScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsbScriptSig](docs/GetTransactionDetailsByTransactionIdribsbScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsbVin](docs/GetTransactionDetailsByTransactionIdribsbVin.md)
 - [GetTransactionDetailsByTransactionIdribsbVout](docs/GetTransactionDetailsByTransactionIdribsbVout.md)
 - [GetTransactionDetailsByTransactionIdribsbc](docs/GetTransactionDetailsByTransactionIdribsbc.md)
 - [GetTransactionDetailsByTransactionIdribsbcScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsbcScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsbcVin](docs/GetTransactionDetailsByTransactionIdribsbcVin.md)
 - [GetTransactionDetailsByTransactionIdribsbcVout](docs/GetTransactionDetailsByTransactionIdribsbcVout.md)
 - [GetTransactionDetailsByTransactionIdribsbsc](docs/GetTransactionDetailsByTransactionIdribsbsc.md)
 - [GetTransactionDetailsByTransactionIdribsbscGasPrice](docs/GetTransactionDetailsByTransactionIdribsbscGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsd](docs/GetTransactionDetailsByTransactionIdribsd.md)
 - [GetTransactionDetailsByTransactionIdribsd2](docs/GetTransactionDetailsByTransactionIdribsd2.md)
 - [GetTransactionDetailsByTransactionIdribsd2ScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsd2ScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsd2ScriptSig](docs/GetTransactionDetailsByTransactionIdribsd2ScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsd2Vin](docs/GetTransactionDetailsByTransactionIdribsd2Vin.md)
 - [GetTransactionDetailsByTransactionIdribsd2Vout](docs/GetTransactionDetailsByTransactionIdribsd2Vout.md)
 - [GetTransactionDetailsByTransactionIdribsdScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsdScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsdScriptSig](docs/GetTransactionDetailsByTransactionIdribsdScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsdVin](docs/GetTransactionDetailsByTransactionIdribsdVin.md)
 - [GetTransactionDetailsByTransactionIdribsdVout](docs/GetTransactionDetailsByTransactionIdribsdVout.md)
 - [GetTransactionDetailsByTransactionIdribse](docs/GetTransactionDetailsByTransactionIdribse.md)
 - [GetTransactionDetailsByTransactionIdribseGasPrice](docs/GetTransactionDetailsByTransactionIdribseGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsec](docs/GetTransactionDetailsByTransactionIdribsec.md)
 - [GetTransactionDetailsByTransactionIdribsecGasPrice](docs/GetTransactionDetailsByTransactionIdribsecGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsl](docs/GetTransactionDetailsByTransactionIdribsl.md)
 - [GetTransactionDetailsByTransactionIdribslScriptPubKey](docs/GetTransactionDetailsByTransactionIdribslScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribslScriptSig](docs/GetTransactionDetailsByTransactionIdribslScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribslVin](docs/GetTransactionDetailsByTransactionIdribslVin.md)
 - [GetTransactionDetailsByTransactionIdribslVout](docs/GetTransactionDetailsByTransactionIdribslVout.md)
 - [GetTransactionRequestDetailsR](docs/GetTransactionRequestDetailsR.md)
 - [GetTransactionRequestDetailsRData](docs/GetTransactionRequestDetailsRData.md)
 - [GetTransactionRequestDetailsRi](docs/GetTransactionRequestDetailsRi.md)
 - [GetTransactionRequestDetailsRiRecipients](docs/GetTransactionRequestDetailsRiRecipients.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidR](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidR.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRData](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRData.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRi](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRi.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRiRecipients](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRiRecipients.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRiSenders](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRiSenders.md)
 - [GetWalletAssetDetailsR](docs/GetWalletAssetDetailsR.md)
 - [GetWalletAssetDetailsRData](docs/GetWalletAssetDetailsRData.md)
 - [GetWalletAssetDetailsRi](docs/GetWalletAssetDetailsRi.md)
 - [GetWalletAssetDetailsRiConfirmedBalance](docs/GetWalletAssetDetailsRiConfirmedBalance.md)
 - [GetWalletAssetDetailsRiRecievedConfirmedAmount](docs/GetWalletAssetDetailsRiRecievedConfirmedAmount.md)
 - [GetWalletAssetDetailsRiSentConfirmedAmount](docs/GetWalletAssetDetailsRiSentConfirmedAmount.md)
 - [GetXrpRippleAddressDetailsR](docs/GetXrpRippleAddressDetailsR.md)
 - [GetXrpRippleAddressDetailsRData](docs/GetXrpRippleAddressDetailsRData.md)
 - [GetXrpRippleAddressDetailsRi](docs/GetXrpRippleAddressDetailsRi.md)
 - [GetXrpRippleAddressDetailsRiBalance](docs/GetXrpRippleAddressDetailsRiBalance.md)
 - [GetXrpRippleBlockDetailsByBlockHashR](docs/GetXrpRippleBlockDetailsByBlockHashR.md)
 - [GetXrpRippleBlockDetailsByBlockHashRData](docs/GetXrpRippleBlockDetailsByBlockHashRData.md)
 - [GetXrpRippleBlockDetailsByBlockHashRi](docs/GetXrpRippleBlockDetailsByBlockHashRi.md)
 - [GetXrpRippleBlockDetailsByBlockHashRiTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHashRiTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightR](docs/GetXrpRippleBlockDetailsByBlockHeightR.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRData](docs/GetXrpRippleBlockDetailsByBlockHeightRData.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRi](docs/GetXrpRippleBlockDetailsByBlockHeightRi.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRiTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHeightRiTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRiTotalFees](docs/GetXrpRippleBlockDetailsByBlockHeightRiTotalFees.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdr](docs/GetXrpRippleTransactionDetailsByTransactionIdr.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdrData](docs/GetXrpRippleTransactionDetailsByTransactionIdrData.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdri](docs/GetXrpRippleTransactionDetailsByTransactionIdri.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriFee](docs/GetXrpRippleTransactionDetailsByTransactionIdriFee.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriOffer](docs/GetXrpRippleTransactionDetailsByTransactionIdriOffer.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriReceive](docs/GetXrpRippleTransactionDetailsByTransactionIdriReceive.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriRecipients](docs/GetXrpRippleTransactionDetailsByTransactionIdriRecipients.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriSenders](docs/GetXrpRippleTransactionDetailsByTransactionIdriSenders.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriValue](docs/GetXrpRippleTransactionDetailsByTransactionIdriValue.md)
 - [GetZilliqaAddressDetailsR](docs/GetZilliqaAddressDetailsR.md)
 - [GetZilliqaAddressDetailsRData](docs/GetZilliqaAddressDetailsRData.md)
 - [GetZilliqaAddressDetailsRi](docs/GetZilliqaAddressDetailsRi.md)
 - [GetZilliqaAddressDetailsRiBalance](docs/GetZilliqaAddressDetailsRiBalance.md)
 - [GetZilliqaBlockDetailsByBlockHashR](docs/GetZilliqaBlockDetailsByBlockHashR.md)
 - [GetZilliqaBlockDetailsByBlockHashRData](docs/GetZilliqaBlockDetailsByBlockHashRData.md)
 - [GetZilliqaBlockDetailsByBlockHashRi](docs/GetZilliqaBlockDetailsByBlockHashRi.md)
 - [GetZilliqaBlockDetailsByBlockHeightR](docs/GetZilliqaBlockDetailsByBlockHeightR.md)
 - [GetZilliqaBlockDetailsByBlockHeightRData](docs/GetZilliqaBlockDetailsByBlockHeightRData.md)
 - [GetZilliqaBlockDetailsByBlockHeightRi](docs/GetZilliqaBlockDetailsByBlockHeightRi.md)
 - [GetZilliqaTransactionDetailsByTransactionIdr](docs/GetZilliqaTransactionDetailsByTransactionIdr.md)
 - [GetZilliqaTransactionDetailsByTransactionIdrData](docs/GetZilliqaTransactionDetailsByTransactionIdrData.md)
 - [GetZilliqaTransactionDetailsByTransactionIdri](docs/GetZilliqaTransactionDetailsByTransactionIdri.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriFee](docs/GetZilliqaTransactionDetailsByTransactionIdriFee.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriRecipients](docs/GetZilliqaTransactionDetailsByTransactionIdriRecipients.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriSenders](docs/GetZilliqaTransactionDetailsByTransactionIdriSenders.md)
 - [InsufficientCredits](docs/InsufficientCredits.md)
 - [InsufficientCreditsError](docs/InsufficientCreditsError.md)
 - [InvalidApiKey](docs/InvalidApiKey.md)
 - [InvalidApiKeyError](docs/InvalidApiKeyError.md)
 - [InvalidBlockchain](docs/InvalidBlockchain.md)
 - [InvalidBlockchainError](docs/InvalidBlockchainError.md)
 - [InvalidData](docs/InvalidData.md)
 - [InvalidDataError](docs/InvalidDataError.md)
 - [InvalidNetwork](docs/InvalidNetwork.md)
 - [InvalidNetworkError](docs/InvalidNetworkError.md)
 - [InvalidPagination](docs/InvalidPagination.md)
 - [InvalidPaginationError](docs/InvalidPaginationError.md)
 - [InvalidRequestBodyStructure](docs/InvalidRequestBodyStructure.md)
 - [InvalidRequestBodyStructureError](docs/InvalidRequestBodyStructureError.md)
 - [InvalidXpub](docs/InvalidXpub.md)
 - [InvalidXpubError](docs/InvalidXpubError.md)
 - [LimitGreaterThanAllowed](docs/LimitGreaterThanAllowed.md)
 - [LimitGreaterThanAllowedError](docs/LimitGreaterThanAllowedError.md)
 - [ListAllUnconfirmedTransactionsR](docs/ListAllUnconfirmedTransactionsR.md)
 - [ListAllUnconfirmedTransactionsRData](docs/ListAllUnconfirmedTransactionsRData.md)
 - [ListAllUnconfirmedTransactionsRi](docs/ListAllUnconfirmedTransactionsRi.md)
 - [ListAllUnconfirmedTransactionsRibs](docs/ListAllUnconfirmedTransactionsRibs.md)
 - [ListAllUnconfirmedTransactionsRibsb](docs/ListAllUnconfirmedTransactionsRibsb.md)
 - [ListAllUnconfirmedTransactionsRibsbScriptSig](docs/ListAllUnconfirmedTransactionsRibsbScriptSig.md)
 - [ListAllUnconfirmedTransactionsRibsbVin](docs/ListAllUnconfirmedTransactionsRibsbVin.md)
 - [ListAllUnconfirmedTransactionsRibsbc](docs/ListAllUnconfirmedTransactionsRibsbc.md)
 - [ListAllUnconfirmedTransactionsRibsbcVin](docs/ListAllUnconfirmedTransactionsRibsbcVin.md)
 - [ListAllUnconfirmedTransactionsRibsbcVout](docs/ListAllUnconfirmedTransactionsRibsbcVout.md)
 - [ListAllUnconfirmedTransactionsRibsbsc](docs/ListAllUnconfirmedTransactionsRibsbsc.md)
 - [ListAllUnconfirmedTransactionsRibsd](docs/ListAllUnconfirmedTransactionsRibsd.md)
 - [ListAllUnconfirmedTransactionsRibsd2](docs/ListAllUnconfirmedTransactionsRibsd2.md)
 - [ListAllUnconfirmedTransactionsRibsd2Vin](docs/ListAllUnconfirmedTransactionsRibsd2Vin.md)
 - [ListAllUnconfirmedTransactionsRibsdVin](docs/ListAllUnconfirmedTransactionsRibsdVin.md)
 - [ListAllUnconfirmedTransactionsRibse](docs/ListAllUnconfirmedTransactionsRibse.md)
 - [ListAllUnconfirmedTransactionsRibseFee](docs/ListAllUnconfirmedTransactionsRibseFee.md)
 - [ListAllUnconfirmedTransactionsRibseGasPrice](docs/ListAllUnconfirmedTransactionsRibseGasPrice.md)
 - [ListAllUnconfirmedTransactionsRibsec](docs/ListAllUnconfirmedTransactionsRibsec.md)
 - [ListAllUnconfirmedTransactionsRibsecFee](docs/ListAllUnconfirmedTransactionsRibsecFee.md)
 - [ListAllUnconfirmedTransactionsRibsecGasPrice](docs/ListAllUnconfirmedTransactionsRibsecGasPrice.md)
 - [ListAllUnconfirmedTransactionsRibsl](docs/ListAllUnconfirmedTransactionsRibsl.md)
 - [ListAllUnconfirmedTransactionsRibslScriptPubKey](docs/ListAllUnconfirmedTransactionsRibslScriptPubKey.md)
 - [ListAllUnconfirmedTransactionsRibslVin](docs/ListAllUnconfirmedTransactionsRibslVin.md)
 - [ListAllUnconfirmedTransactionsRibslVout](docs/ListAllUnconfirmedTransactionsRibslVout.md)
 - [ListAllUnconfirmedTransactionsRibsz](docs/ListAllUnconfirmedTransactionsRibsz.md)
 - [ListAssetsDetailsR](docs/ListAssetsDetailsR.md)
 - [ListAssetsDetailsRData](docs/ListAssetsDetailsRData.md)
 - [ListAssetsDetailsRi](docs/ListAssetsDetailsRi.md)
 - [ListAssetsDetailsRiAssetLogo](docs/ListAssetsDetailsRiAssetLogo.md)
 - [ListAssetsDetailsRiLatestRate](docs/ListAssetsDetailsRiLatestRate.md)
 - [ListAssetsDetailsRis](docs/ListAssetsDetailsRis.md)
 - [ListAssetsDetailsRisc](docs/ListAssetsDetailsRisc.md)
 - [ListBlockchainEventsSubscriptionsR](docs/ListBlockchainEventsSubscriptionsR.md)
 - [ListBlockchainEventsSubscriptionsRData](docs/ListBlockchainEventsSubscriptionsRData.md)
 - [ListBlockchainEventsSubscriptionsRi](docs/ListBlockchainEventsSubscriptionsRi.md)
 - [ListCoinsForwardingAutomationsR](docs/ListCoinsForwardingAutomationsR.md)
 - [ListCoinsForwardingAutomationsRData](docs/ListCoinsForwardingAutomationsRData.md)
 - [ListCoinsForwardingAutomationsRi](docs/ListCoinsForwardingAutomationsRi.md)
 - [ListConfirmedTokensTransfersByAddressR](docs/ListConfirmedTokensTransfersByAddressR.md)
 - [ListConfirmedTokensTransfersByAddressRData](docs/ListConfirmedTokensTransfersByAddressRData.md)
 - [ListConfirmedTokensTransfersByAddressRi](docs/ListConfirmedTokensTransfersByAddressRi.md)
 - [ListConfirmedTransactionsByAddressR](docs/ListConfirmedTransactionsByAddressR.md)
 - [ListConfirmedTransactionsByAddressRData](docs/ListConfirmedTransactionsByAddressRData.md)
 - [ListConfirmedTransactionsByAddressRi](docs/ListConfirmedTransactionsByAddressRi.md)
 - [ListConfirmedTransactionsByAddressRiFee](docs/ListConfirmedTransactionsByAddressRiFee.md)
 - [ListConfirmedTransactionsByAddressRibs](docs/ListConfirmedTransactionsByAddressRibs.md)
 - [ListConfirmedTransactionsByAddressRibsb](docs/ListConfirmedTransactionsByAddressRibsb.md)
 - [ListConfirmedTransactionsByAddressRibsbScriptPubKey](docs/ListConfirmedTransactionsByAddressRibsbScriptPubKey.md)
 - [ListConfirmedTransactionsByAddressRibsbVin](docs/ListConfirmedTransactionsByAddressRibsbVin.md)
 - [ListConfirmedTransactionsByAddressRibsbVout](docs/ListConfirmedTransactionsByAddressRibsbVout.md)
 - [ListConfirmedTransactionsByAddressRibsbc](docs/ListConfirmedTransactionsByAddressRibsbc.md)
 - [ListConfirmedTransactionsByAddressRibsbcVin](docs/ListConfirmedTransactionsByAddressRibsbcVin.md)
 - [ListConfirmedTransactionsByAddressRibsbsc](docs/ListConfirmedTransactionsByAddressRibsbsc.md)
 - [ListConfirmedTransactionsByAddressRibsbscGasPrice](docs/ListConfirmedTransactionsByAddressRibsbscGasPrice.md)
 - [ListConfirmedTransactionsByAddressRibsd](docs/ListConfirmedTransactionsByAddressRibsd.md)
 - [ListConfirmedTransactionsByAddressRibsd2](docs/ListConfirmedTransactionsByAddressRibsd2.md)
 - [ListConfirmedTransactionsByAddressRibsd2ScriptPubKey](docs/ListConfirmedTransactionsByAddressRibsd2ScriptPubKey.md)
 - [ListConfirmedTransactionsByAddressRibsd2ScriptSig](docs/ListConfirmedTransactionsByAddressRibsd2ScriptSig.md)
 - [ListConfirmedTransactionsByAddressRibsd2Vin](docs/ListConfirmedTransactionsByAddressRibsd2Vin.md)
 - [ListConfirmedTransactionsByAddressRibsd2Vout](docs/ListConfirmedTransactionsByAddressRibsd2Vout.md)
 - [ListConfirmedTransactionsByAddressRibsdScriptSig](docs/ListConfirmedTransactionsByAddressRibsdScriptSig.md)
 - [ListConfirmedTransactionsByAddressRibsdVin](docs/ListConfirmedTransactionsByAddressRibsdVin.md)
 - [ListConfirmedTransactionsByAddressRibse](docs/ListConfirmedTransactionsByAddressRibse.md)
 - [ListConfirmedTransactionsByAddressRibseGasPrice](docs/ListConfirmedTransactionsByAddressRibseGasPrice.md)
 - [ListConfirmedTransactionsByAddressRibsec](docs/ListConfirmedTransactionsByAddressRibsec.md)
 - [ListConfirmedTransactionsByAddressRibsecGasPrice](docs/ListConfirmedTransactionsByAddressRibsecGasPrice.md)
 - [ListConfirmedTransactionsByAddressRibsl](docs/ListConfirmedTransactionsByAddressRibsl.md)
 - [ListConfirmedTransactionsByAddressRibslScriptSig](docs/ListConfirmedTransactionsByAddressRibslScriptSig.md)
 - [ListConfirmedTransactionsByAddressRibslVin](docs/ListConfirmedTransactionsByAddressRibslVin.md)
 - [ListConfirmedTransactionsByAddressRibsz](docs/ListConfirmedTransactionsByAddressRibsz.md)
 - [ListConfirmedTransactionsByAddressRibszScriptPubKey](docs/ListConfirmedTransactionsByAddressRibszScriptPubKey.md)
 - [ListConfirmedTransactionsByAddressRibszScriptSig](docs/ListConfirmedTransactionsByAddressRibszScriptSig.md)
 - [ListConfirmedTransactionsByAddressRibszVJoinSplit](docs/ListConfirmedTransactionsByAddressRibszVJoinSplit.md)
 - [ListConfirmedTransactionsByAddressRibszVShieldedOutput](docs/ListConfirmedTransactionsByAddressRibszVShieldedOutput.md)
 - [ListConfirmedTransactionsByAddressRibszVShieldedSpend](docs/ListConfirmedTransactionsByAddressRibszVShieldedSpend.md)
 - [ListConfirmedTransactionsByAddressRibszVin](docs/ListConfirmedTransactionsByAddressRibszVin.md)
 - [ListConfirmedTransactionsByAddressRibszVout](docs/ListConfirmedTransactionsByAddressRibszVout.md)
 - [ListDepositAddressesR](docs/ListDepositAddressesR.md)
 - [ListDepositAddressesRData](docs/ListDepositAddressesRData.md)
 - [ListDepositAddressesRi](docs/ListDepositAddressesRi.md)
 - [ListHdWalletXPubYPubZPubTransactionsR](docs/ListHdWalletXPubYPubZPubTransactionsR.md)
 - [ListHdWalletXPubYPubZPubTransactionsRData](docs/ListHdWalletXPubYPubZPubTransactionsRData.md)
 - [ListHdWalletXPubYPubZPubTransactionsRi](docs/ListHdWalletXPubYPubZPubTransactionsRi.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiFee](docs/ListHdWalletXPubYPubZPubTransactionsRiFee.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiRecipients](docs/ListHdWalletXPubYPubZPubTransactionsRiRecipients.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiSenders](docs/ListHdWalletXPubYPubZPubTransactionsRiSenders.md)
 - [ListInternalTransactionDetailsByTransactionHashR](docs/ListInternalTransactionDetailsByTransactionHashR.md)
 - [ListInternalTransactionDetailsByTransactionHashRData](docs/ListInternalTransactionDetailsByTransactionHashRData.md)
 - [ListInternalTransactionDetailsByTransactionHashRi](docs/ListInternalTransactionDetailsByTransactionHashRi.md)
 - [ListInternalTransactionsByAddressR](docs/ListInternalTransactionsByAddressR.md)
 - [ListInternalTransactionsByAddressRData](docs/ListInternalTransactionsByAddressRData.md)
 - [ListInternalTransactionsByAddressRi](docs/ListInternalTransactionsByAddressRi.md)
 - [ListLatestMinedBlocksR](docs/ListLatestMinedBlocksR.md)
 - [ListLatestMinedBlocksRData](docs/ListLatestMinedBlocksRData.md)
 - [ListLatestMinedBlocksRi](docs/ListLatestMinedBlocksRi.md)
 - [ListLatestMinedBlocksRibs](docs/ListLatestMinedBlocksRibs.md)
 - [ListLatestMinedBlocksRibsb](docs/ListLatestMinedBlocksRibsb.md)
 - [ListLatestMinedBlocksRibsbc](docs/ListLatestMinedBlocksRibsbc.md)
 - [ListLatestMinedBlocksRibsbsc](docs/ListLatestMinedBlocksRibsbsc.md)
 - [ListLatestMinedBlocksRibsd](docs/ListLatestMinedBlocksRibsd.md)
 - [ListLatestMinedBlocksRibsd2](docs/ListLatestMinedBlocksRibsd2.md)
 - [ListLatestMinedBlocksRibse](docs/ListLatestMinedBlocksRibse.md)
 - [ListLatestMinedBlocksRibsec](docs/ListLatestMinedBlocksRibsec.md)
 - [ListLatestMinedBlocksRibsl](docs/ListLatestMinedBlocksRibsl.md)
 - [ListLatestMinedBlocksRibsz](docs/ListLatestMinedBlocksRibsz.md)
 - [ListLatestMinedBlocksRibsz2](docs/ListLatestMinedBlocksRibsz2.md)
 - [ListOmniTokensByAddressR](docs/ListOmniTokensByAddressR.md)
 - [ListOmniTokensByAddressRData](docs/ListOmniTokensByAddressRData.md)
 - [ListOmniTokensByAddressRi](docs/ListOmniTokensByAddressRi.md)
 - [ListOmniTransactionsByAddressR](docs/ListOmniTransactionsByAddressR.md)
 - [ListOmniTransactionsByAddressRData](docs/ListOmniTransactionsByAddressRData.md)
 - [ListOmniTransactionsByAddressRi](docs/ListOmniTransactionsByAddressRi.md)
 - [ListOmniTransactionsByAddressRiFee](docs/ListOmniTransactionsByAddressRiFee.md)
 - [ListOmniTransactionsByAddressRiRecipients](docs/ListOmniTransactionsByAddressRiRecipients.md)
 - [ListOmniTransactionsByAddressRiSenders](docs/ListOmniTransactionsByAddressRiSenders.md)
 - [ListOmniTransactionsByBlockHashR](docs/ListOmniTransactionsByBlockHashR.md)
 - [ListOmniTransactionsByBlockHashRData](docs/ListOmniTransactionsByBlockHashRData.md)
 - [ListOmniTransactionsByBlockHashRi](docs/ListOmniTransactionsByBlockHashRi.md)
 - [ListOmniTransactionsByBlockHashRiFee](docs/ListOmniTransactionsByBlockHashRiFee.md)
 - [ListOmniTransactionsByBlockHeightR](docs/ListOmniTransactionsByBlockHeightR.md)
 - [ListOmniTransactionsByBlockHeightRData](docs/ListOmniTransactionsByBlockHeightRData.md)
 - [ListOmniTransactionsByBlockHeightRi](docs/ListOmniTransactionsByBlockHeightRi.md)
 - [ListOmniTransactionsByBlockHeightRiFee](docs/ListOmniTransactionsByBlockHeightRiFee.md)
 - [ListOmniTransactionsByBlockHeightRiRecipients](docs/ListOmniTransactionsByBlockHeightRiRecipients.md)
 - [ListOmniTransactionsByBlockHeightRiSenders](docs/ListOmniTransactionsByBlockHeightRiSenders.md)
 - [ListSupportedAssetsR](docs/ListSupportedAssetsR.md)
 - [ListSupportedAssetsRData](docs/ListSupportedAssetsRData.md)
 - [ListSupportedAssetsRi](docs/ListSupportedAssetsRi.md)
 - [ListSupportedTokensR](docs/ListSupportedTokensR.md)
 - [ListSupportedTokensRData](docs/ListSupportedTokensRData.md)
 - [ListSupportedTokensRi](docs/ListSupportedTokensRi.md)
 - [ListTokensByAddressR](docs/ListTokensByAddressR.md)
 - [ListTokensByAddressRData](docs/ListTokensByAddressRData.md)
 - [ListTokensByAddressRi](docs/ListTokensByAddressRi.md)
 - [ListTokensForwardingAutomationsR](docs/ListTokensForwardingAutomationsR.md)
 - [ListTokensForwardingAutomationsRData](docs/ListTokensForwardingAutomationsRData.md)
 - [ListTokensForwardingAutomationsRi](docs/ListTokensForwardingAutomationsRi.md)
 - [ListTokensForwardingAutomationsRits](docs/ListTokensForwardingAutomationsRits.md)
 - [ListTokensForwardingAutomationsRitsbot](docs/ListTokensForwardingAutomationsRitsbot.md)
 - [ListTokensForwardingAutomationsRitset](docs/ListTokensForwardingAutomationsRitset.md)
 - [ListTokensTransfersByTransactionHashR](docs/ListTokensTransfersByTransactionHashR.md)
 - [ListTokensTransfersByTransactionHashRData](docs/ListTokensTransfersByTransactionHashRData.md)
 - [ListTokensTransfersByTransactionHashRi](docs/ListTokensTransfersByTransactionHashRi.md)
 - [ListTransactionsByBlockHashR](docs/ListTransactionsByBlockHashR.md)
 - [ListTransactionsByBlockHashRData](docs/ListTransactionsByBlockHashRData.md)
 - [ListTransactionsByBlockHashRi](docs/ListTransactionsByBlockHashRi.md)
 - [ListTransactionsByBlockHashRiFee](docs/ListTransactionsByBlockHashRiFee.md)
 - [ListTransactionsByBlockHashRiRecipients](docs/ListTransactionsByBlockHashRiRecipients.md)
 - [ListTransactionsByBlockHashRiSenders](docs/ListTransactionsByBlockHashRiSenders.md)
 - [ListTransactionsByBlockHashRibs](docs/ListTransactionsByBlockHashRibs.md)
 - [ListTransactionsByBlockHashRibsb](docs/ListTransactionsByBlockHashRibsb.md)
 - [ListTransactionsByBlockHashRibsbVin](docs/ListTransactionsByBlockHashRibsbVin.md)
 - [ListTransactionsByBlockHashRibsbc](docs/ListTransactionsByBlockHashRibsbc.md)
 - [ListTransactionsByBlockHashRibsbcScriptPubKey](docs/ListTransactionsByBlockHashRibsbcScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsbcVin](docs/ListTransactionsByBlockHashRibsbcVin.md)
 - [ListTransactionsByBlockHashRibsbcVout](docs/ListTransactionsByBlockHashRibsbcVout.md)
 - [ListTransactionsByBlockHashRibsbsc](docs/ListTransactionsByBlockHashRibsbsc.md)
 - [ListTransactionsByBlockHashRibsbscGasPrice](docs/ListTransactionsByBlockHashRibsbscGasPrice.md)
 - [ListTransactionsByBlockHashRibsd](docs/ListTransactionsByBlockHashRibsd.md)
 - [ListTransactionsByBlockHashRibsd2](docs/ListTransactionsByBlockHashRibsd2.md)
 - [ListTransactionsByBlockHashRibsd2ScriptPubKey](docs/ListTransactionsByBlockHashRibsd2ScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsd2ScriptSig](docs/ListTransactionsByBlockHashRibsd2ScriptSig.md)
 - [ListTransactionsByBlockHashRibsd2Vin](docs/ListTransactionsByBlockHashRibsd2Vin.md)
 - [ListTransactionsByBlockHashRibsd2Vout](docs/ListTransactionsByBlockHashRibsd2Vout.md)
 - [ListTransactionsByBlockHashRibsdScriptPubKey](docs/ListTransactionsByBlockHashRibsdScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsdVin](docs/ListTransactionsByBlockHashRibsdVin.md)
 - [ListTransactionsByBlockHashRibsdVout](docs/ListTransactionsByBlockHashRibsdVout.md)
 - [ListTransactionsByBlockHashRibse](docs/ListTransactionsByBlockHashRibse.md)
 - [ListTransactionsByBlockHashRibseGasPrice](docs/ListTransactionsByBlockHashRibseGasPrice.md)
 - [ListTransactionsByBlockHashRibsec](docs/ListTransactionsByBlockHashRibsec.md)
 - [ListTransactionsByBlockHashRibsl](docs/ListTransactionsByBlockHashRibsl.md)
 - [ListTransactionsByBlockHashRibslScriptPubKey](docs/ListTransactionsByBlockHashRibslScriptPubKey.md)
 - [ListTransactionsByBlockHashRibslVin](docs/ListTransactionsByBlockHashRibslVin.md)
 - [ListTransactionsByBlockHashRibslVout](docs/ListTransactionsByBlockHashRibslVout.md)
 - [ListTransactionsByBlockHashRibsz](docs/ListTransactionsByBlockHashRibsz.md)
 - [ListTransactionsByBlockHashRibszScriptSig](docs/ListTransactionsByBlockHashRibszScriptSig.md)
 - [ListTransactionsByBlockHashRibszVJoinSplit](docs/ListTransactionsByBlockHashRibszVJoinSplit.md)
 - [ListTransactionsByBlockHashRibszVin](docs/ListTransactionsByBlockHashRibszVin.md)
 - [ListTransactionsByBlockHeightR](docs/ListTransactionsByBlockHeightR.md)
 - [ListTransactionsByBlockHeightRData](docs/ListTransactionsByBlockHeightRData.md)
 - [ListTransactionsByBlockHeightRi](docs/ListTransactionsByBlockHeightRi.md)
 - [ListTransactionsByBlockHeightRiFee](docs/ListTransactionsByBlockHeightRiFee.md)
 - [ListTransactionsByBlockHeightRibs](docs/ListTransactionsByBlockHeightRibs.md)
 - [ListTransactionsByBlockHeightRibsb](docs/ListTransactionsByBlockHeightRibsb.md)
 - [ListTransactionsByBlockHeightRibsbScriptPubKey](docs/ListTransactionsByBlockHeightRibsbScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibsbVout](docs/ListTransactionsByBlockHeightRibsbVout.md)
 - [ListTransactionsByBlockHeightRibsbc](docs/ListTransactionsByBlockHeightRibsbc.md)
 - [ListTransactionsByBlockHeightRibsbsc](docs/ListTransactionsByBlockHeightRibsbsc.md)
 - [ListTransactionsByBlockHeightRibsbscGasPrice](docs/ListTransactionsByBlockHeightRibsbscGasPrice.md)
 - [ListTransactionsByBlockHeightRibsd](docs/ListTransactionsByBlockHeightRibsd.md)
 - [ListTransactionsByBlockHeightRibsd2](docs/ListTransactionsByBlockHeightRibsd2.md)
 - [ListTransactionsByBlockHeightRibsd2Vin](docs/ListTransactionsByBlockHeightRibsd2Vin.md)
 - [ListTransactionsByBlockHeightRibsdScriptPubKey](docs/ListTransactionsByBlockHeightRibsdScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibsdScriptSig](docs/ListTransactionsByBlockHeightRibsdScriptSig.md)
 - [ListTransactionsByBlockHeightRibsdVin](docs/ListTransactionsByBlockHeightRibsdVin.md)
 - [ListTransactionsByBlockHeightRibsdVout](docs/ListTransactionsByBlockHeightRibsdVout.md)
 - [ListTransactionsByBlockHeightRibse](docs/ListTransactionsByBlockHeightRibse.md)
 - [ListTransactionsByBlockHeightRibsec](docs/ListTransactionsByBlockHeightRibsec.md)
 - [ListTransactionsByBlockHeightRibsecGasPrice](docs/ListTransactionsByBlockHeightRibsecGasPrice.md)
 - [ListTransactionsByBlockHeightRibsl](docs/ListTransactionsByBlockHeightRibsl.md)
 - [ListTransactionsByBlockHeightRibslScriptPubKey](docs/ListTransactionsByBlockHeightRibslScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibslScriptSig](docs/ListTransactionsByBlockHeightRibslScriptSig.md)
 - [ListTransactionsByBlockHeightRibslVin](docs/ListTransactionsByBlockHeightRibslVin.md)
 - [ListTransactionsByBlockHeightRibslVout](docs/ListTransactionsByBlockHeightRibslVout.md)
 - [ListTransactionsByBlockHeightRibsz](docs/ListTransactionsByBlockHeightRibsz.md)
 - [ListTransactionsByBlockHeightRibszScriptPubKey](docs/ListTransactionsByBlockHeightRibszScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibszScriptSig](docs/ListTransactionsByBlockHeightRibszScriptSig.md)
 - [ListTransactionsByBlockHeightRibszVJoinSplit](docs/ListTransactionsByBlockHeightRibszVJoinSplit.md)
 - [ListTransactionsByBlockHeightRibszVShieldedOutput](docs/ListTransactionsByBlockHeightRibszVShieldedOutput.md)
 - [ListTransactionsByBlockHeightRibszVin](docs/ListTransactionsByBlockHeightRibszVin.md)
 - [ListTransactionsByBlockHeightRibszVout](docs/ListTransactionsByBlockHeightRibszVout.md)
 - [ListUnconfirmedOmniTransactionsByAddressR](docs/ListUnconfirmedOmniTransactionsByAddressR.md)
 - [ListUnconfirmedOmniTransactionsByAddressRData](docs/ListUnconfirmedOmniTransactionsByAddressRData.md)
 - [ListUnconfirmedOmniTransactionsByAddressRi](docs/ListUnconfirmedOmniTransactionsByAddressRi.md)
 - [ListUnconfirmedOmniTransactionsByAddressRiFee](docs/ListUnconfirmedOmniTransactionsByAddressRiFee.md)
 - [ListUnconfirmedOmniTransactionsByAddressRiSenders](docs/ListUnconfirmedOmniTransactionsByAddressRiSenders.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdr](docs/ListUnconfirmedOmniTransactionsByPropertyIdr.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdrData](docs/ListUnconfirmedOmniTransactionsByPropertyIdrData.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdri](docs/ListUnconfirmedOmniTransactionsByPropertyIdri.md)
 - [ListUnconfirmedTransactionsByAddressR](docs/ListUnconfirmedTransactionsByAddressR.md)
 - [ListUnconfirmedTransactionsByAddressRData](docs/ListUnconfirmedTransactionsByAddressRData.md)
 - [ListUnconfirmedTransactionsByAddressRi](docs/ListUnconfirmedTransactionsByAddressRi.md)
 - [ListUnconfirmedTransactionsByAddressRiRecipients](docs/ListUnconfirmedTransactionsByAddressRiRecipients.md)
 - [ListUnconfirmedTransactionsByAddressRiSenders](docs/ListUnconfirmedTransactionsByAddressRiSenders.md)
 - [ListUnconfirmedTransactionsByAddressRibs](docs/ListUnconfirmedTransactionsByAddressRibs.md)
 - [ListUnconfirmedTransactionsByAddressRibsb](docs/ListUnconfirmedTransactionsByAddressRibsb.md)
 - [ListUnconfirmedTransactionsByAddressRibsbScriptPubKey](docs/ListUnconfirmedTransactionsByAddressRibsbScriptPubKey.md)
 - [ListUnconfirmedTransactionsByAddressRibsbScriptSig](docs/ListUnconfirmedTransactionsByAddressRibsbScriptSig.md)
 - [ListUnconfirmedTransactionsByAddressRibsbVin](docs/ListUnconfirmedTransactionsByAddressRibsbVin.md)
 - [ListUnconfirmedTransactionsByAddressRibsbVout](docs/ListUnconfirmedTransactionsByAddressRibsbVout.md)
 - [ListUnconfirmedTransactionsByAddressRibsbc](docs/ListUnconfirmedTransactionsByAddressRibsbc.md)
 - [ListUnconfirmedTransactionsByAddressRibsbcScriptPubKey](docs/ListUnconfirmedTransactionsByAddressRibsbcScriptPubKey.md)
 - [ListUnconfirmedTransactionsByAddressRibsbcVin](docs/ListUnconfirmedTransactionsByAddressRibsbcVin.md)
 - [ListUnconfirmedTransactionsByAddressRibsbcVout](docs/ListUnconfirmedTransactionsByAddressRibsbcVout.md)
 - [ListUnconfirmedTransactionsByAddressRibsbsc](docs/ListUnconfirmedTransactionsByAddressRibsbsc.md)
 - [ListUnconfirmedTransactionsByAddressRibsd](docs/ListUnconfirmedTransactionsByAddressRibsd.md)
 - [ListUnconfirmedTransactionsByAddressRibsd2](docs/ListUnconfirmedTransactionsByAddressRibsd2.md)
 - [ListUnconfirmedTransactionsByAddressRibsd2Vin](docs/ListUnconfirmedTransactionsByAddressRibsd2Vin.md)
 - [ListUnconfirmedTransactionsByAddressRibsd2Vout](docs/ListUnconfirmedTransactionsByAddressRibsd2Vout.md)
 - [ListUnconfirmedTransactionsByAddressRibsdVin](docs/ListUnconfirmedTransactionsByAddressRibsdVin.md)
 - [ListUnconfirmedTransactionsByAddressRibse](docs/ListUnconfirmedTransactionsByAddressRibse.md)
 - [ListUnconfirmedTransactionsByAddressRibseFee](docs/ListUnconfirmedTransactionsByAddressRibseFee.md)
 - [ListUnconfirmedTransactionsByAddressRibsec](docs/ListUnconfirmedTransactionsByAddressRibsec.md)
 - [ListUnconfirmedTransactionsByAddressRibsecFee](docs/ListUnconfirmedTransactionsByAddressRibsecFee.md)
 - [ListUnconfirmedTransactionsByAddressRibsecGasPrice](docs/ListUnconfirmedTransactionsByAddressRibsecGasPrice.md)
 - [ListUnconfirmedTransactionsByAddressRibsl](docs/ListUnconfirmedTransactionsByAddressRibsl.md)
 - [ListUnconfirmedTransactionsByAddressRibslScriptSig](docs/ListUnconfirmedTransactionsByAddressRibslScriptSig.md)
 - [ListUnconfirmedTransactionsByAddressRibslVin](docs/ListUnconfirmedTransactionsByAddressRibslVin.md)
 - [ListUnconfirmedTransactionsByAddressRibslVout](docs/ListUnconfirmedTransactionsByAddressRibslVout.md)
 - [ListUnconfirmedTransactionsByAddressRibsz](docs/ListUnconfirmedTransactionsByAddressRibsz.md)
 - [ListUnconfirmedTransactionsByAddressRibszVin](docs/ListUnconfirmedTransactionsByAddressRibszVin.md)
 - [ListUnspentTransactionOutputsByAddressR](docs/ListUnspentTransactionOutputsByAddressR.md)
 - [ListUnspentTransactionOutputsByAddressRData](docs/ListUnspentTransactionOutputsByAddressRData.md)
 - [ListUnspentTransactionOutputsByAddressRi](docs/ListUnspentTransactionOutputsByAddressRi.md)
 - [ListUnspentTransactionOutputsByAddressRiBlockchainSpecific](docs/ListUnspentTransactionOutputsByAddressRiBlockchainSpecific.md)
 - [ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVJoinSplit](docs/ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVJoinSplit.md)
 - [ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVShieldedSpend](docs/ListUnspentTransactionOutputsByAddressRiBlockchainSpecificVShieldedSpend.md)
 - [ListUnspentTransactionOutputsByAddressRiFee](docs/ListUnspentTransactionOutputsByAddressRiFee.md)
 - [ListUnspentTransactionOutputsByAddressRiSenders](docs/ListUnspentTransactionOutputsByAddressRiSenders.md)
 - [ListUnspentTransactionOutputsByAddressRiVin](docs/ListUnspentTransactionOutputsByAddressRiVin.md)
 - [ListWalletTransactionsR](docs/ListWalletTransactionsR.md)
 - [ListWalletTransactionsRData](docs/ListWalletTransactionsRData.md)
 - [ListWalletTransactionsRi](docs/ListWalletTransactionsRi.md)
 - [ListWalletTransactionsRiFee](docs/ListWalletTransactionsRiFee.md)
 - [ListWalletTransactionsRiRecipients](docs/ListWalletTransactionsRiRecipients.md)
 - [ListWalletTransactionsRiSenders](docs/ListWalletTransactionsRiSenders.md)
 - [ListWalletTransactionsRiValue](docs/ListWalletTransactionsRiValue.md)
 - [ListXrpRippleTransactionsByAddressR](docs/ListXrpRippleTransactionsByAddressR.md)
 - [ListXrpRippleTransactionsByAddressRData](docs/ListXrpRippleTransactionsByAddressRData.md)
 - [ListXrpRippleTransactionsByAddressRi](docs/ListXrpRippleTransactionsByAddressRi.md)
 - [ListXrpRippleTransactionsByAddressRiFee](docs/ListXrpRippleTransactionsByAddressRiFee.md)
 - [ListXrpRippleTransactionsByAddressRiOffer](docs/ListXrpRippleTransactionsByAddressRiOffer.md)
 - [ListXrpRippleTransactionsByAddressRiReceive](docs/ListXrpRippleTransactionsByAddressRiReceive.md)
 - [ListXrpRippleTransactionsByAddressRiValue](docs/ListXrpRippleTransactionsByAddressRiValue.md)
 - [ListXrpRippleTransactionsByBlockHashR](docs/ListXrpRippleTransactionsByBlockHashR.md)
 - [ListXrpRippleTransactionsByBlockHashRData](docs/ListXrpRippleTransactionsByBlockHashRData.md)
 - [ListXrpRippleTransactionsByBlockHashRi](docs/ListXrpRippleTransactionsByBlockHashRi.md)
 - [ListXrpRippleTransactionsByBlockHashRiFee](docs/ListXrpRippleTransactionsByBlockHashRiFee.md)
 - [ListXrpRippleTransactionsByBlockHashRiOffer](docs/ListXrpRippleTransactionsByBlockHashRiOffer.md)
 - [ListXrpRippleTransactionsByBlockHashRiReceive](docs/ListXrpRippleTransactionsByBlockHashRiReceive.md)
 - [ListXrpRippleTransactionsByBlockHashRiRecipients](docs/ListXrpRippleTransactionsByBlockHashRiRecipients.md)
 - [ListXrpRippleTransactionsByBlockHashRiSenders](docs/ListXrpRippleTransactionsByBlockHashRiSenders.md)
 - [ListXrpRippleTransactionsByBlockHashRiValue](docs/ListXrpRippleTransactionsByBlockHashRiValue.md)
 - [ListXrpRippleTransactionsByBlockHeightR](docs/ListXrpRippleTransactionsByBlockHeightR.md)
 - [ListXrpRippleTransactionsByBlockHeightRData](docs/ListXrpRippleTransactionsByBlockHeightRData.md)
 - [ListXrpRippleTransactionsByBlockHeightRi](docs/ListXrpRippleTransactionsByBlockHeightRi.md)
 - [ListXrpRippleTransactionsByBlockHeightRiFee](docs/ListXrpRippleTransactionsByBlockHeightRiFee.md)
 - [ListXrpRippleTransactionsByBlockHeightRiOffer](docs/ListXrpRippleTransactionsByBlockHeightRiOffer.md)
 - [ListXrpRippleTransactionsByBlockHeightRiReceive](docs/ListXrpRippleTransactionsByBlockHeightRiReceive.md)
 - [ListXrpRippleTransactionsByBlockHeightRiRecipients](docs/ListXrpRippleTransactionsByBlockHeightRiRecipients.md)
 - [ListXrpRippleTransactionsByBlockHeightRiSenders](docs/ListXrpRippleTransactionsByBlockHeightRiSenders.md)
 - [ListXrpRippleTransactionsByBlockHeightRiValue](docs/ListXrpRippleTransactionsByBlockHeightRiValue.md)
 - [ListZilliqaTransactionsByAddressR](docs/ListZilliqaTransactionsByAddressR.md)
 - [ListZilliqaTransactionsByAddressRData](docs/ListZilliqaTransactionsByAddressRData.md)
 - [ListZilliqaTransactionsByAddressRi](docs/ListZilliqaTransactionsByAddressRi.md)
 - [ListZilliqaTransactionsByAddressRiRecipients](docs/ListZilliqaTransactionsByAddressRiRecipients.md)
 - [ListZilliqaTransactionsByAddressRiSenders](docs/ListZilliqaTransactionsByAddressRiSenders.md)
 - [ListZilliqaTransactionsByBlockHashR](docs/ListZilliqaTransactionsByBlockHashR.md)
 - [ListZilliqaTransactionsByBlockHashRData](docs/ListZilliqaTransactionsByBlockHashRData.md)
 - [ListZilliqaTransactionsByBlockHashRi](docs/ListZilliqaTransactionsByBlockHashRi.md)
 - [ListZilliqaTransactionsByBlockHeightR](docs/ListZilliqaTransactionsByBlockHeightR.md)
 - [ListZilliqaTransactionsByBlockHeightRData](docs/ListZilliqaTransactionsByBlockHeightRData.md)
 - [ListZilliqaTransactionsByBlockHeightRi](docs/ListZilliqaTransactionsByBlockHeightRi.md)
 - [MinedTransactionR](docs/MinedTransactionR.md)
 - [MinedTransactionRData](docs/MinedTransactionRData.md)
 - [MinedTransactionRb](docs/MinedTransactionRb.md)
 - [MinedTransactionRbData](docs/MinedTransactionRbData.md)
 - [MinedTransactionRbDataItem](docs/MinedTransactionRbDataItem.md)
 - [MinedTransactionRi](docs/MinedTransactionRi.md)
 - [MissingApiKey](docs/MissingApiKey.md)
 - [MissingApiKeyError](docs/MissingApiKeyError.md)
 - [NewBlockR](docs/NewBlockR.md)
 - [NewBlockRData](docs/NewBlockRData.md)
 - [NewBlockRb](docs/NewBlockRb.md)
 - [NewBlockRbData](docs/NewBlockRbData.md)
 - [NewBlockRbDataItem](docs/NewBlockRbDataItem.md)
 - [NewBlockRi](docs/NewBlockRi.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationR](docs/NewConfirmedCoinsTransactionsAndEachConfirmationR.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRb](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRbData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRi](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedCoinsTransactionsR](docs/NewConfirmedCoinsTransactionsR.md)
 - [NewConfirmedCoinsTransactionsRData](docs/NewConfirmedCoinsTransactionsRData.md)
 - [NewConfirmedCoinsTransactionsRb](docs/NewConfirmedCoinsTransactionsRb.md)
 - [NewConfirmedCoinsTransactionsRbData](docs/NewConfirmedCoinsTransactionsRbData.md)
 - [NewConfirmedCoinsTransactionsRbDataItem](docs/NewConfirmedCoinsTransactionsRbDataItem.md)
 - [NewConfirmedCoinsTransactionsRi](docs/NewConfirmedCoinsTransactionsRi.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationR](docs/NewConfirmedInternalTransactionsAndEachConfirmationR.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRb](docs/NewConfirmedInternalTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRbData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedInternalTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRi](docs/NewConfirmedInternalTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedInternalTransactionsR](docs/NewConfirmedInternalTransactionsR.md)
 - [NewConfirmedInternalTransactionsRData](docs/NewConfirmedInternalTransactionsRData.md)
 - [NewConfirmedInternalTransactionsRb](docs/NewConfirmedInternalTransactionsRb.md)
 - [NewConfirmedInternalTransactionsRbData](docs/NewConfirmedInternalTransactionsRbData.md)
 - [NewConfirmedInternalTransactionsRbDataItem](docs/NewConfirmedInternalTransactionsRbDataItem.md)
 - [NewConfirmedInternalTransactionsRi](docs/NewConfirmedInternalTransactionsRi.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationR](docs/NewConfirmedTokensTransactionsAndEachConfirmationR.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRb](docs/NewConfirmedTokensTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRbData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedTokensTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRi](docs/NewConfirmedTokensTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedTokensTransactionsR](docs/NewConfirmedTokensTransactionsR.md)
 - [NewConfirmedTokensTransactionsRData](docs/NewConfirmedTokensTransactionsRData.md)
 - [NewConfirmedTokensTransactionsRb](docs/NewConfirmedTokensTransactionsRb.md)
 - [NewConfirmedTokensTransactionsRbData](docs/NewConfirmedTokensTransactionsRbData.md)
 - [NewConfirmedTokensTransactionsRbDataItem](docs/NewConfirmedTokensTransactionsRbDataItem.md)
 - [NewConfirmedTokensTransactionsRi](docs/NewConfirmedTokensTransactionsRi.md)
 - [NewUnconfirmedCoinsTransactionsR](docs/NewUnconfirmedCoinsTransactionsR.md)
 - [NewUnconfirmedCoinsTransactionsRData](docs/NewUnconfirmedCoinsTransactionsRData.md)
 - [NewUnconfirmedCoinsTransactionsRb](docs/NewUnconfirmedCoinsTransactionsRb.md)
 - [NewUnconfirmedCoinsTransactionsRbData](docs/NewUnconfirmedCoinsTransactionsRbData.md)
 - [NewUnconfirmedCoinsTransactionsRbDataItem](docs/NewUnconfirmedCoinsTransactionsRbDataItem.md)
 - [NewUnconfirmedCoinsTransactionsRi](docs/NewUnconfirmedCoinsTransactionsRi.md)
 - [NewUnconfirmedTokensTransactionsR](docs/NewUnconfirmedTokensTransactionsR.md)
 - [NewUnconfirmedTokensTransactionsRData](docs/NewUnconfirmedTokensTransactionsRData.md)
 - [NewUnconfirmedTokensTransactionsRb](docs/NewUnconfirmedTokensTransactionsRb.md)
 - [NewUnconfirmedTokensTransactionsRbData](docs/NewUnconfirmedTokensTransactionsRbData.md)
 - [NewUnconfirmedTokensTransactionsRbDataItem](docs/NewUnconfirmedTokensTransactionsRbDataItem.md)
 - [NewUnconfirmedTokensTransactionsRi](docs/NewUnconfirmedTokensTransactionsRi.md)
 - [RequestLimitReached](docs/RequestLimitReached.md)
 - [RequestLimitReachedError](docs/RequestLimitReachedError.md)
 - [ResourceNotFound](docs/ResourceNotFound.md)
 - [ResourceNotFoundError](docs/ResourceNotFoundError.md)
 - [SyncHdWalletXPubYPubZPubR](docs/SyncHdWalletXPubYPubZPubR.md)
 - [SyncHdWalletXPubYPubZPubRData](docs/SyncHdWalletXPubYPubZPubRData.md)
 - [SyncHdWalletXPubYPubZPubRb](docs/SyncHdWalletXPubYPubZPubRb.md)
 - [SyncHdWalletXPubYPubZPubRbData](docs/SyncHdWalletXPubYPubZPubRbData.md)
 - [SyncHdWalletXPubYPubZPubRbDataItem](docs/SyncHdWalletXPubYPubZPubRbDataItem.md)
 - [SyncHdWalletXPubYPubZPubRi](docs/SyncHdWalletXPubYPubZPubRi.md)
 - [TokensForwardingAutomationsLimitReached](docs/TokensForwardingAutomationsLimitReached.md)
 - [TokensForwardingAutomationsLimitReachedError](docs/TokensForwardingAutomationsLimitReachedError.md)
 - [TokensForwardingFail](docs/TokensForwardingFail.md)
 - [TokensForwardingFailData](docs/TokensForwardingFailData.md)
 - [TokensForwardingFailDataItem](docs/TokensForwardingFailDataItem.md)
 - [TokensForwardingSuccess](docs/TokensForwardingSuccess.md)
 - [TokensForwardingSuccessData](docs/TokensForwardingSuccessData.md)
 - [TokensForwardingSuccessDataItem](docs/TokensForwardingSuccessDataItem.md)
 - [TokensForwardingSuccessErc20](docs/TokensForwardingSuccessErc20.md)
 - [TokensForwardingSuccessErc721](docs/TokensForwardingSuccessErc721.md)
 - [TokensForwardingSuccessOmni](docs/TokensForwardingSuccessOmni.md)
 - [TokensForwardingSuccessToken](docs/TokensForwardingSuccessToken.md)
 - [TransactionMined](docs/TransactionMined.md)
 - [TransactionMinedData](docs/TransactionMinedData.md)
 - [TransactionMinedDataItem](docs/TransactionMinedDataItem.md)
 - [TransactionMinedDataItemMinedInBlock](docs/TransactionMinedDataItemMinedInBlock.md)
 - [TransactionRequestApproval](docs/TransactionRequestApproval.md)
 - [TransactionRequestApprovalData](docs/TransactionRequestApprovalData.md)
 - [TransactionRequestApprovalDataItem](docs/TransactionRequestApprovalDataItem.md)
 - [TransactionRequestBroadcasted](docs/TransactionRequestBroadcasted.md)
 - [TransactionRequestBroadcastedData](docs/TransactionRequestBroadcastedData.md)
 - [TransactionRequestBroadcastedDataItem](docs/TransactionRequestBroadcastedDataItem.md)
 - [TransactionRequestFail](docs/TransactionRequestFail.md)
 - [TransactionRequestFailData](docs/TransactionRequestFailData.md)
 - [TransactionRequestFailDataItem](docs/TransactionRequestFailDataItem.md)
 - [TransactionRequestMined](docs/TransactionRequestMined.md)
 - [TransactionRequestMinedData](docs/TransactionRequestMinedData.md)
 - [TransactionRequestRejection](docs/TransactionRequestRejection.md)
 - [TransactionRequestRejectionData](docs/TransactionRequestRejectionData.md)
 - [TransactionRequestRejectionDataItem](docs/TransactionRequestRejectionDataItem.md)
 - [UnexpectedServerError](docs/UnexpectedServerError.md)
 - [UnexpectedServerErrorError](docs/UnexpectedServerErrorError.md)
 - [UnsupportedMediaType](docs/UnsupportedMediaType.md)
 - [UnsupportedMediaTypeError](docs/UnsupportedMediaTypeError.md)
 - [UriNotFound](docs/UriNotFound.md)
 - [UriNotFoundError](docs/UriNotFoundError.md)
 - [ValidateAddressR](docs/ValidateAddressR.md)
 - [ValidateAddressRData](docs/ValidateAddressRData.md)
 - [ValidateAddressRb](docs/ValidateAddressRb.md)
 - [ValidateAddressRbData](docs/ValidateAddressRbData.md)
 - [ValidateAddressRbDataItem](docs/ValidateAddressRbDataItem.md)
 - [ValidateAddressRi](docs/ValidateAddressRi.md)
 - [WalletAsAServiceAddressBalanceNotEnough](docs/WalletAsAServiceAddressBalanceNotEnough.md)
 - [WalletAsAServiceAddressBalanceNotEnoughError](docs/WalletAsAServiceAddressBalanceNotEnoughError.md)
 - [WalletAsAServiceDepositAddressesLimitReached](docs/WalletAsAServiceDepositAddressesLimitReached.md)
 - [WalletAsAServiceDepositAddressesLimitReachedError](docs/WalletAsAServiceDepositAddressesLimitReachedError.md)
 - [WalletAsAServiceNoDepositAddressesFound](docs/WalletAsAServiceNoDepositAddressesFound.md)
 - [WalletAsAServiceNoDepositAddressesFoundError](docs/WalletAsAServiceNoDepositAddressesFoundError.md)
 - [WalletAsAServiceTokenNotSupported](docs/WalletAsAServiceTokenNotSupported.md)
 - [WalletAsAServiceTokenNotSupportedError](docs/WalletAsAServiceTokenNotSupportedError.md)
 - [WalletAsAServiceWalletBalanceNotEnough](docs/WalletAsAServiceWalletBalanceNotEnough.md)
 - [WalletAsAServiceWalletBalanceNotEnoughError](docs/WalletAsAServiceWalletBalanceNotEnoughError.md)
 - [XpubNotSynced](docs/XpubNotSynced.md)
 - [XpubNotSyncedError](docs/XpubNotSyncedError.md)
 - [XpubSyncInProgress](docs/XpubSyncInProgress.md)
 - [XpubSyncInProgressError](docs/XpubSyncInProgressError.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

developers@cryptoapis.io

