/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListXrpRippleTransactionsByBlockHeightRi {
    #[serde(rename = "additionalData", skip_serializing_if = "Option::is_none")]
    pub additional_data: Option<String>,
    #[serde(rename = "index")]
    pub index: i32,
    #[serde(rename = "minedInBlockHash")]
    pub mined_in_block_hash: String,
    /// Object Array representation of transaction receivers
    #[serde(rename = "recipients")]
    pub recipients: Vec<crate::models::ListXrpRippleTransactionsByBlockHeightRiRecipients>,
    /// Object Array representation of transaction senders
    #[serde(rename = "senders")]
    pub senders: Vec<crate::models::ListXrpRippleTransactionsByBlockHeightRiSenders>,
    #[serde(rename = "sequence")]
    pub sequence: i32,
    #[serde(rename = "status")]
    pub status: String,
    /// Defines the exact date/time in Unix Timestamp when this transaction was mined, confirmed or first seen in Mempool, if it is unconfirmed.
    #[serde(rename = "timestamp")]
    pub timestamp: i32,
    #[serde(rename = "transactionHash")]
    pub transaction_hash: String,
    #[serde(rename = "type")]
    pub _type: String,
    #[serde(rename = "fee")]
    pub fee: Box<crate::models::ListXrpRippleTransactionsByBlockHeightRiFee>,
    #[serde(rename = "offer")]
    pub offer: Box<crate::models::ListXrpRippleTransactionsByBlockHeightRiOffer>,
    #[serde(rename = "receive")]
    pub receive: Box<crate::models::ListXrpRippleTransactionsByBlockHeightRiReceive>,
    #[serde(rename = "value")]
    pub value: Box<crate::models::ListXrpRippleTransactionsByBlockHeightRiValue>,
}

impl ListXrpRippleTransactionsByBlockHeightRi {
    pub fn new(index: i32, mined_in_block_hash: String, recipients: Vec<crate::models::ListXrpRippleTransactionsByBlockHeightRiRecipients>, senders: Vec<crate::models::ListXrpRippleTransactionsByBlockHeightRiSenders>, sequence: i32, status: String, timestamp: i32, transaction_hash: String, _type: String, fee: crate::models::ListXrpRippleTransactionsByBlockHeightRiFee, offer: crate::models::ListXrpRippleTransactionsByBlockHeightRiOffer, receive: crate::models::ListXrpRippleTransactionsByBlockHeightRiReceive, value: crate::models::ListXrpRippleTransactionsByBlockHeightRiValue) -> ListXrpRippleTransactionsByBlockHeightRi {
        ListXrpRippleTransactionsByBlockHeightRi {
            additional_data: None,
            index,
            mined_in_block_hash,
            recipients,
            senders,
            sequence,
            status,
            timestamp,
            transaction_hash,
            _type,
            fee: Box::new(fee),
            offer: Box::new(offer),
            receive: Box::new(receive),
            value: Box::new(value),
        }
    }
}


