/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListSupportedTokensRi {
    /// Defines the token's decimal number or all of its points after the zero.
    #[serde(rename = "decimals")]
    pub decimals: i32,
    /// Represents a unique identifier for the specific blockchain and network, e.g. smart contract address, property ID, etc.
    #[serde(rename = "identifier")]
    pub identifier: String,
    /// Defines the token name.
    #[serde(rename = "name")]
    pub name: String,
    /// Defines the token's unique symbol in the Crypto APIs listings.
    #[serde(rename = "symbol")]
    pub symbol: String,
    /// Represents the token's type representation, e.g. ERC-20, Omni, etc.
    #[serde(rename = "type")]
    pub _type: String,
}

impl ListSupportedTokensRi {
    pub fn new(decimals: i32, identifier: String, name: String, symbol: String, _type: String) -> ListSupportedTokensRi {
        ListSupportedTokensRi {
            decimals,
            identifier,
            name,
            symbol,
            _type,
        }
    }
}


