/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetContractDetailsByAddressRi {
    /// Defines the number of decimals that the token possesses.
    #[serde(rename = "tokenDecimals")]
    pub token_decimals: String,
    /// Specifies the token's name.
    #[serde(rename = "tokenName", skip_serializing_if = "Option::is_none")]
    pub token_name: Option<String>,
    /// Defines the unique symbol of the token.
    #[serde(rename = "tokenSymbol", skip_serializing_if = "Option::is_none")]
    pub token_symbol: Option<String>,
    /// Defines the type of the token.
    #[serde(rename = "tokenType")]
    pub token_type: String,
    /// Defines the total number of tokens created that exist on the market minus the ones that have been burned.
    #[serde(rename = "totalSupply")]
    pub total_supply: String,
}

impl GetContractDetailsByAddressRi {
    pub fn new(token_decimals: String, token_type: String, total_supply: String) -> GetContractDetailsByAddressRi {
        GetContractDetailsByAddressRi {
            token_decimals,
            token_name: None,
            token_symbol: None,
            token_type,
            total_supply,
        }
    }
}


