/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetInternalTransactionByTransactionHashAndOperationIdRi {
    /// Defines the specific amount of the transaction.
    #[serde(rename = "amount")]
    pub amount: String,
    /// Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.
    #[serde(rename = "blockHash")]
    pub block_hash: String,
    /// Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".
    #[serde(rename = "blockHeight")]
    pub block_height: i32,
    /// Defines the specific type of the operation.
    #[serde(rename = "operationType")]
    pub operation_type: String,
    /// Defines the specific hash of the parent transaction.
    #[serde(rename = "parentHash")]
    pub parent_hash: String,
    /// Represents the recipient address with the respective amount.
    #[serde(rename = "recipient")]
    pub recipient: String,
    /// Represents the sender address with the respective amount.
    #[serde(rename = "sender")]
    pub sender: String,
    /// Defines the exact date/time in Unix Timestamp when this transaction was mined, confirmed or first seen in Mempool, if it is unconfirmed.
    #[serde(rename = "timestamp")]
    pub timestamp: i32,
}

impl GetInternalTransactionByTransactionHashAndOperationIdRi {
    pub fn new(amount: String, block_hash: String, block_height: i32, operation_type: String, parent_hash: String, recipient: String, sender: String, timestamp: i32) -> GetInternalTransactionByTransactionHashAndOperationIdRi {
        GetInternalTransactionByTransactionHashAndOperationIdRi {
            amount,
            block_hash,
            block_height,
            operation_type,
            parent_hash,
            recipient,
            sender,
            timestamp,
        }
    }
}


