/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateCoinsTransactionRequestFromWalletRbDataItem {
    /// Defines the destination of the transaction, whether it is incoming or outgoing.
    #[serde(rename = "destinations")]
    pub destinations: Vec<crate::models::CreateCoinsTransactionRequestFromWalletRbDataItemDestinations>,
    /// Represents the fee priority of the automation, whether it is \"slow\", \"standard\" or \"fast\".
    #[serde(rename = "feePriority")]
    pub fee_priority: FeePriority,
}

impl CreateCoinsTransactionRequestFromWalletRbDataItem {
    pub fn new(destinations: Vec<crate::models::CreateCoinsTransactionRequestFromWalletRbDataItemDestinations>, fee_priority: FeePriority) -> CreateCoinsTransactionRequestFromWalletRbDataItem {
        CreateCoinsTransactionRequestFromWalletRbDataItem {
            destinations,
            fee_priority,
        }
    }
}

/// Represents the fee priority of the automation, whether it is \"slow\", \"standard\" or \"fast\".
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum FeePriority {
    #[serde(rename = "slow")]
    Slow,
    #[serde(rename = "standard")]
    Standard,
    #[serde(rename = "fast")]
    Fast,
}

