/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AddTokensToExistingFromAddressRbDataItem {
    /// Represents the Secret Key value provided by the customer. This field is used for security purposes during the callback notification, in order to prove the sender of the callback as Crypto APIs.
    #[serde(rename = "callbackSecretKey", skip_serializing_if = "Option::is_none")]
    pub callback_secret_key: Option<String>,
    /// Represents the URL that is set by the customer where the callback will be received at. The callback notification will be received only if and when the event occurs.
    #[serde(rename = "callbackUrl")]
    pub callback_url: String,
    /// Represents the number of confirmations, i.e. the amount of blocks that have been built on top of this block.
    #[serde(rename = "confirmationsCount")]
    pub confirmations_count: i32,
    /// Represents the fee priority of the automation, whether it is \"SLOW\", \"STANDARD\" or \"FAST\".
    #[serde(rename = "feePriority")]
    pub fee_priority: FeePriority,
    /// Represents the hash of the address that forwards the tokens.
    #[serde(rename = "fromAddress")]
    pub from_address: String,
    /// Represents the minimum transfer amount of the currency in the `fromAddress` that can be allowed for an automatic forwarding.
    #[serde(rename = "minimumTransferAmount")]
    pub minimum_transfer_amount: String,
    /// Represents the hash of the address the currency is forwarded to.
    #[serde(rename = "toAddress")]
    pub to_address: String,
    #[serde(rename = "tokenData")]
    pub token_data: Box<crate::models::AddTokensToExistingFromAddressRbTokenData>,
}

impl AddTokensToExistingFromAddressRbDataItem {
    pub fn new(callback_url: String, confirmations_count: i32, fee_priority: FeePriority, from_address: String, minimum_transfer_amount: String, to_address: String, token_data: crate::models::AddTokensToExistingFromAddressRbTokenData) -> AddTokensToExistingFromAddressRbDataItem {
        AddTokensToExistingFromAddressRbDataItem {
            callback_secret_key: None,
            callback_url,
            confirmations_count,
            fee_priority,
            from_address,
            minimum_transfer_amount,
            to_address,
            token_data: Box::new(token_data),
        }
    }
}

/// Represents the fee priority of the automation, whether it is \"SLOW\", \"STANDARD\" or \"FAST\".
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum FeePriority {
    #[serde(rename = "slow")]
    Slow,
    #[serde(rename = "standard")]
    Standard,
    #[serde(rename = "fast")]
    Fast,
}

