# Rust API client for cryptoapis

Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.1.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://cryptoapis.io](https://cryptoapis.io)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://rest.cryptoapis.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AssetsApi* | [**list_assets_details**](docs/AssetsApi.md#list_assets_details) | **GET** /market-data/assets/details | List Assets Details
*AutomaticCoinsForwardingApi* | [**create_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#create_automatic_coins_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | Create Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**delete_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#delete_automatic_coins_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations/{referenceId} | Delete Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**list_coins_forwarding_automations**](docs/AutomaticCoinsForwardingApi.md#list_coins_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | List Coins Forwarding Automations
*AutomaticTokensForwardingApi* | [**add_tokens_to_existing_from_address**](docs/AutomaticTokensForwardingApi.md#add_tokens_to_existing_from_address) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/add-token | Add Tokens To Existing fromAddress
*AutomaticTokensForwardingApi* | [**create_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#create_automatic_tokens_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | Create Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**delete_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#delete_automatic_tokens_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/{referenceId} | Delete Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**get_fee_address_details**](docs/AutomaticTokensForwardingApi.md#get_fee_address_details) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/fee-addresses | Get Fee Address Details
*AutomaticTokensForwardingApi* | [**list_tokens_forwarding_automations**](docs/AutomaticTokensForwardingApi.md#list_tokens_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | List Tokens Forwarding Automations
*CreateSubscriptionsForApi* | [**mined_transaction**](docs/CreateSubscriptionsForApi.md#mined_transaction) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/transaction-mined | Mined transaction
*CreateSubscriptionsForApi* | [**new_block**](docs/CreateSubscriptionsForApi.md#new_block) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/block-mined | New Block
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed | New confirmed coins transactions
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed-each-confirmation | New confirmed coins transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed | New confirmed internal transactions
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed-each-confirmation | New confirmed internal transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed | New confirmed tokens transactions
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed-each-confirmation | New confirmed tokens transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_unconfirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-unconfirmed | New unconfirmed coins transactions
*CreateSubscriptionsForApi* | [**new_unconfirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-unconfirmed | New unconfirmed tokens transactions
*ExchangeRatesApi* | [**get_exchange_rate_by_asset_symbols**](docs/ExchangeRatesApi.md#get_exchange_rate_by_asset_symbols) | **GET** /market-data/exchange-rates/by-symbols/{fromAssetSymbol}/{toAssetSymbol} | Get Exchange Rate By Asset Symbols
*ExchangeRatesApi* | [**get_exchange_rate_by_assets_ids**](docs/ExchangeRatesApi.md#get_exchange_rate_by_assets_ids) | **GET** /market-data/exchange-rates/by-asset-ids/{fromAssetId}/{toAssetId} | Get Exchange Rate By Assets IDs
*GeneratingApi* | [**generate_receiving_address**](docs/GeneratingApi.md#generate_receiving_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | Generate Receiving Address
*InformativeApi* | [**get_wallet_asset_details**](docs/InformativeApi.md#get_wallet_asset_details) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network} | Get Wallet Asset Details
*InformativeApi* | [**list_receiving_addresses**](docs/InformativeApi.md#list_receiving_addresses) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | List Receiving Addresses
*InformativeApi* | [**list_supported_tokens**](docs/InformativeApi.md#list_supported_tokens) | **GET** /wallet-as-a-service/info/{blockchain}/{network}/supported-tokens | List Supported Tokens
*InternalApi* | [**get_internal_transaction_by_transaction_hash_and_operation_id**](docs/InternalApi.md#get_internal_transaction_by_transaction_hash_and_operation_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal/{operationId} | Get Internal Transaction by Transaction Hash and Operation Id
*InternalApi* | [**list_internal_transaction_details_by_transaction_hash**](docs/InternalApi.md#list_internal_transaction_details_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal | List Internal Transaction Details by Transaction Hash
*ManageSubscriptionsApi* | [**delete_blockchain_event_subscription**](docs/ManageSubscriptionsApi.md#delete_blockchain_event_subscription) | **DELETE** /blockchain-events/{blockchain}/{network}/subscriptions/{referenceId} | Delete Blockchain Event Subscription
*ManageSubscriptionsApi* | [**list_blockchain_events_subscriptions**](docs/ManageSubscriptionsApi.md#list_blockchain_events_subscriptions) | **GET** /blockchain-events/{blockchain}/{network}/subscriptions | List Blockchain Events Subscriptions
*MetadataApi* | [**list_supported_assets**](docs/MetadataApi.md#list_supported_assets) | **GET** /market-data/assets/supported | List Supported Assets
*OmniLayerApi* | [**get_omni_transaction_details_by_transaction_id__txid**](docs/OmniLayerApi.md#get_omni_transaction_details_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions/{transactionId} | Get Omni Transaction Details By Transaction ID (Txid)
*OmniLayerApi* | [**get_unconfirmed_omni_transaction_by_transaction_id__txid**](docs/OmniLayerApi.md#get_unconfirmed_omni_transaction_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions-unconfirmed/{transactionId} | Get Unconfirmed Omni Transaction By Transaction ID (Txid)
*OmniLayerApi* | [**list_omni_tokens_by_address**](docs/OmniLayerApi.md#list_omni_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address} | List Omni Tokens By Address
*OmniLayerApi* | [**list_omni_transactions_by_address**](docs/OmniLayerApi.md#list_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address}/transactions | List Omni Transactions By Address
*OmniLayerApi* | [**list_omni_transactions_by_block_hash**](docs/OmniLayerApi.md#list_omni_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/hash/{blockHash}/transactions | List Omni Transactions By Block Hash
*OmniLayerApi* | [**list_omni_transactions_by_block_height**](docs/OmniLayerApi.md#list_omni_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/height/{blockHeight}/transactions | List Omni Transactions By Block Height
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_address**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/address-transactions-unconfirmed/{address} | List Unconfirmed Omni Transactions By Address
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_property_id**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_property_id) | **GET** /blockchain-data/{blockchain}/{network}/omni/properties/{propertyId}/transactions | List Unconfirmed Omni Transactions By Property ID
*TokensApi* | [**get_contract_details_by_address**](docs/TokensApi.md#get_contract_details_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{contractAddress}/contract | Get Contract Details by Address
*TokensApi* | [**list_tokens_by_address**](docs/TokensApi.md#list_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens | List Tokens By Address
*TokensApi* | [**list_tokens_transfers_by_address**](docs/TokensApi.md#list_tokens_transfers_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens-transfers | List Tokens Transfers By Address
*TokensApi* | [**list_tokens_transfers_by_transaction_hash**](docs/TokensApi.md#list_tokens_transfers_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/tokens-transfers | List Tokens Transfers By Transaction Hash
*TransactionsApi* | [**create_coins_transaction_request_from_address**](docs/TransactionsApi.md#create_coins_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/transaction-requests | Create Coins Transaction Request from Address
*TransactionsApi* | [**create_coins_transaction_request_from_wallet**](docs/TransactionsApi.md#create_coins_transaction_request_from_wallet) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/transaction-requests | Create Coins Transaction Request from Wallet
*TransactionsApi* | [**create_tokens_transaction_request_from_address**](docs/TransactionsApi.md#create_tokens_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/token-transaction-requests | Create Tokens Transaction Request from Address
*UTXOBasedApi* | [**get_hd_wallet__x_pub_y_pub_z_pub_details**](docs/UTXOBasedApi.md#get_hd_wallet__x_pub_y_pub_z_pub_details) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/details | Get HD Wallet (xPub, yPub, zPub) Details
*UTXOBasedApi* | [**list_hd_wallet__x_pub_y_pub_z_pub_transactions**](docs/UTXOBasedApi.md#list_hd_wallet__x_pub_y_pub_z_pub_transactions) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/transactions | List HD Wallet (xPub, yPub, zPub) Transactions
*UTXOBasedApi* | [**sync_hd_wallet__x_pub_y_pub_z_pub**](docs/UTXOBasedApi.md#sync_hd_wallet__x_pub_y_pub_z_pub) | **POST** /blockchain-data/{blockchain}/{network}/hd/sync | Sync HD Wallet (xPub, yPub, zPub)
*UnifiedEndpointsApi* | [**get_address_details**](docs/UnifiedEndpointsApi.md#get_address_details) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address} | Get Address Details
*UnifiedEndpointsApi* | [**get_block_details_by_block_hash**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash} | Get Block Details By Block Hash
*UnifiedEndpointsApi* | [**get_block_details_by_block_height**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height} | Get Block Details By Block Height
*UnifiedEndpointsApi* | [**get_fee_recommendations**](docs/UnifiedEndpointsApi.md#get_fee_recommendations) | **GET** /blockchain-data/{blockchain}/{network}/mempool/fees | Get Fee Recommendations
*UnifiedEndpointsApi* | [**get_latest_mined_block**](docs/UnifiedEndpointsApi.md#get_latest_mined_block) | **GET** /blockchain-data/{blockchain}/{network}/blocks/last | Get Latest Mined Block
*UnifiedEndpointsApi* | [**get_transaction_details_by_transaction_id**](docs/UnifiedEndpointsApi.md#get_transaction_details_by_transaction_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionId} | Get Transaction Details By Transaction ID
*UnifiedEndpointsApi* | [**list_transactions_by_address**](docs/UnifiedEndpointsApi.md#list_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/transactions | List Transactions By Address
*UnifiedEndpointsApi* | [**list_transactions_by_block_hash**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}/transactions | List Transactions by Block Hash
*UnifiedEndpointsApi* | [**list_transactions_by_block_height**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height}/transactions | List Transactions by Block Height
*ValidatingApi* | [**validate_address**](docs/ValidatingApi.md#validate_address) | **POST** /blockchain-tools/{blockchain}/{network}/addresses/validate | Validate Address
*XRPRippleApi* | [**get_latest_mined_xrp__ripple_block**](docs/XRPRippleApi.md#get_latest_mined_xrp__ripple_block) | **GET** /blockchain-data/xrp-specific/{network}/blocks/last | Get Latest Mined XRP (Ripple) Block
*XRPRippleApi* | [**get_xrp__ripple_address_details**](docs/XRPRippleApi.md#get_xrp__ripple_address_details) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address} | Get XRP (Ripple) Address Details
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_hash**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash} | Get XRP (Ripple) Block Details By Block Hash
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_height**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight} | Get XRP (Ripple) Block Details By Block Height
*XRPRippleApi* | [**get_xrp__ripple_transaction_details_by_transaction_id**](docs/XRPRippleApi.md#get_xrp__ripple_transaction_details_by_transaction_id) | **GET** /blockchain-data/xrp-specific/{network}/transactions/{transactionHash} | Get XRP (Ripple) Transaction Details By Transaction ID
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_address**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_address) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address}/transactions | List XRP (Ripple) Transactions by Address
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_hash**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash}/transactions | List XRP (Ripple) Transactions By Block Hash
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_height**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight}/transactions | List XRP (Ripple) Transactions By Block Height
*ZilliqaApi* | [**get_latest_mined_zilliqa_block**](docs/ZilliqaApi.md#get_latest_mined_zilliqa_block) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/last | Get Latest Mined Zilliqa Block
*ZilliqaApi* | [**get_zilliqa_address_details**](docs/ZilliqaApi.md#get_zilliqa_address_details) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address} | Get Zilliqa Address Details
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_hash**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash} | Get Zilliqa Block Details By Block Hash
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_height**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight} | Get Zilliqa Block Details By Block Height
*ZilliqaApi* | [**get_zilliqa_transaction_details_by_transaction_id**](docs/ZilliqaApi.md#get_zilliqa_transaction_details_by_transaction_id) | **GET** /blockchain-data/zilliqa-specific/{network}/transactions/{transactionHash} | Get Zilliqa Transaction Details by Transaction ID
*ZilliqaApi* | [**list_zilliqa_transactions_by_address**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_address) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address}/transactions | List Zilliqa Transactions by Address
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_hash**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash}/transactions | List Zilliqa Transactions By Block Hash
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_height**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight}/transactions | List Zilliqa Transactions By Block Height


## Documentation For Models

 - [AddTokensToExistingFromAddressR](docs/AddTokensToExistingFromAddressR.md)
 - [AddTokensToExistingFromAddressRData](docs/AddTokensToExistingFromAddressRData.md)
 - [AddTokensToExistingFromAddressRb](docs/AddTokensToExistingFromAddressRb.md)
 - [AddTokensToExistingFromAddressRbData](docs/AddTokensToExistingFromAddressRbData.md)
 - [AddTokensToExistingFromAddressRbDataItem](docs/AddTokensToExistingFromAddressRbDataItem.md)
 - [AddTokensToExistingFromAddressRbTokenData](docs/AddTokensToExistingFromAddressRbTokenData.md)
 - [AddTokensToExistingFromAddressRbTokenDataBitcoinOmniToken](docs/AddTokensToExistingFromAddressRbTokenDataBitcoinOmniToken.md)
 - [AddTokensToExistingFromAddressRbTokenDataEthereumErc20Token](docs/AddTokensToExistingFromAddressRbTokenDataEthereumErc20Token.md)
 - [AddTokensToExistingFromAddressRi](docs/AddTokensToExistingFromAddressRi.md)
 - [AddTokensToExistingFromAddressRits](docs/AddTokensToExistingFromAddressRits.md)
 - [AddTokensToExistingFromAddressRitsbot](docs/AddTokensToExistingFromAddressRitsbot.md)
 - [AddTokensToExistingFromAddressRitseet](docs/AddTokensToExistingFromAddressRitseet.md)
 - [AddressCoinsTransactionConfirmed](docs/AddressCoinsTransactionConfirmed.md)
 - [AddressCoinsTransactionConfirmedData](docs/AddressCoinsTransactionConfirmedData.md)
 - [AddressCoinsTransactionConfirmedDataItem](docs/AddressCoinsTransactionConfirmedDataItem.md)
 - [AddressCoinsTransactionConfirmedDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressCoinsTransactionConfirmedEachConfirmation](docs/AddressCoinsTransactionConfirmedEachConfirmation.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationData](docs/AddressCoinsTransactionConfirmedEachConfirmationData.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItem](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressCoinsTransactionUnconfirmed](docs/AddressCoinsTransactionUnconfirmed.md)
 - [AddressCoinsTransactionUnconfirmedData](docs/AddressCoinsTransactionUnconfirmedData.md)
 - [AddressCoinsTransactionUnconfirmedDataItem](docs/AddressCoinsTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionConfirmed](docs/AddressTokensTransactionConfirmed.md)
 - [AddressTokensTransactionConfirmedData](docs/AddressTokensTransactionConfirmedData.md)
 - [AddressTokensTransactionConfirmedDataItem](docs/AddressTokensTransactionConfirmedDataItem.md)
 - [AddressTokensTransactionConfirmedDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmation](docs/AddressTokensTransactionConfirmedEachConfirmation.md)
 - [AddressTokensTransactionConfirmedEachConfirmationData](docs/AddressTokensTransactionConfirmedEachConfirmationData.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItem](docs/AddressTokensTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmationEthereumerc20token](docs/AddressTokensTransactionConfirmedEachConfirmationEthereumerc20token.md)
 - [AddressTokensTransactionConfirmedEachConfirmationEthereumerc721token](docs/AddressTokensTransactionConfirmedEachConfirmationEthereumerc721token.md)
 - [AddressTokensTransactionConfirmedEachConfirmationOmnilayertoken](docs/AddressTokensTransactionConfirmedEachConfirmationOmnilayertoken.md)
 - [AddressTokensTransactionConfirmedEachConfirmationToken](docs/AddressTokensTransactionConfirmedEachConfirmationToken.md)
 - [AddressTokensTransactionConfirmedEthereumerc20token](docs/AddressTokensTransactionConfirmedEthereumerc20token.md)
 - [AddressTokensTransactionConfirmedEthereumerc721token](docs/AddressTokensTransactionConfirmedEthereumerc721token.md)
 - [AddressTokensTransactionConfirmedOmnilayertoken](docs/AddressTokensTransactionConfirmedOmnilayertoken.md)
 - [AddressTokensTransactionConfirmedToken](docs/AddressTokensTransactionConfirmedToken.md)
 - [AddressTokensTransactionUnconfirmed](docs/AddressTokensTransactionUnconfirmed.md)
 - [AddressTokensTransactionUnconfirmedData](docs/AddressTokensTransactionUnconfirmedData.md)
 - [AddressTokensTransactionUnconfirmedDataItem](docs/AddressTokensTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionUnconfirmedEthereumerc20token](docs/AddressTokensTransactionUnconfirmedEthereumerc20token.md)
 - [AddressTokensTransactionUnconfirmedEthereumerc721token](docs/AddressTokensTransactionUnconfirmedEthereumerc721token.md)
 - [AddressTokensTransactionUnconfirmedOmnilayertoken](docs/AddressTokensTransactionUnconfirmedOmnilayertoken.md)
 - [AddressTokensTransactionUnconfirmedToken](docs/AddressTokensTransactionUnconfirmedToken.md)
 - [AlreadyExists](docs/AlreadyExists.md)
 - [AlreadyExistsError](docs/AlreadyExistsError.md)
 - [BannedIpAddress](docs/BannedIpAddress.md)
 - [BannedIpAddressError](docs/BannedIpAddressError.md)
 - [BannedIpAddressErrorDetails](docs/BannedIpAddressErrorDetails.md)
 - [BlockMined](docs/BlockMined.md)
 - [BlockMinedData](docs/BlockMinedData.md)
 - [BlockMinedDataItem](docs/BlockMinedDataItem.md)
 - [BlockchainDataBlockNotFound](docs/BlockchainDataBlockNotFound.md)
 - [BlockchainDataBlockNotFoundError](docs/BlockchainDataBlockNotFoundError.md)
 - [BlockchainDataInternalTransactionNotFound](docs/BlockchainDataInternalTransactionNotFound.md)
 - [BlockchainDataInternalTransactionNotFoundError](docs/BlockchainDataInternalTransactionNotFoundError.md)
 - [BlockchainDataTransactionNotFound](docs/BlockchainDataTransactionNotFound.md)
 - [BlockchainDataTransactionNotFoundError](docs/BlockchainDataTransactionNotFoundError.md)
 - [BlockchainEventsCallbacksLimitReached](docs/BlockchainEventsCallbacksLimitReached.md)
 - [BlockchainEventsCallbacksLimitReachedError](docs/BlockchainEventsCallbacksLimitReachedError.md)
 - [CoinsForwardingAutomationsLimitReached](docs/CoinsForwardingAutomationsLimitReached.md)
 - [CoinsForwardingAutomationsLimitReachedError](docs/CoinsForwardingAutomationsLimitReachedError.md)
 - [CoinsForwardingFail](docs/CoinsForwardingFail.md)
 - [CoinsForwardingFailData](docs/CoinsForwardingFailData.md)
 - [CoinsForwardingFailDataItem](docs/CoinsForwardingFailDataItem.md)
 - [CoinsForwardingSuccess](docs/CoinsForwardingSuccess.md)
 - [CoinsForwardingSuccessData](docs/CoinsForwardingSuccessData.md)
 - [CoinsForwardingSuccessDataItem](docs/CoinsForwardingSuccessDataItem.md)
 - [CouldNotCalculateRateForPair](docs/CouldNotCalculateRateForPair.md)
 - [CouldNotCalculateRateForPairError](docs/CouldNotCalculateRateForPairError.md)
 - [CreateAutomaticCoinsForwardingR](docs/CreateAutomaticCoinsForwardingR.md)
 - [CreateAutomaticCoinsForwardingRData](docs/CreateAutomaticCoinsForwardingRData.md)
 - [CreateAutomaticCoinsForwardingRb](docs/CreateAutomaticCoinsForwardingRb.md)
 - [CreateAutomaticCoinsForwardingRbData](docs/CreateAutomaticCoinsForwardingRbData.md)
 - [CreateAutomaticCoinsForwardingRbDataItem](docs/CreateAutomaticCoinsForwardingRbDataItem.md)
 - [CreateAutomaticCoinsForwardingRi](docs/CreateAutomaticCoinsForwardingRi.md)
 - [CreateAutomaticTokensForwardingR](docs/CreateAutomaticTokensForwardingR.md)
 - [CreateAutomaticTokensForwardingRData](docs/CreateAutomaticTokensForwardingRData.md)
 - [CreateAutomaticTokensForwardingRb](docs/CreateAutomaticTokensForwardingRb.md)
 - [CreateAutomaticTokensForwardingRbData](docs/CreateAutomaticTokensForwardingRbData.md)
 - [CreateAutomaticTokensForwardingRbDataItem](docs/CreateAutomaticTokensForwardingRbDataItem.md)
 - [CreateAutomaticTokensForwardingRbTokenData](docs/CreateAutomaticTokensForwardingRbTokenData.md)
 - [CreateAutomaticTokensForwardingRbTokenDataBitcoinOmniToken](docs/CreateAutomaticTokensForwardingRbTokenDataBitcoinOmniToken.md)
 - [CreateAutomaticTokensForwardingRbTokenDataEthereumToken](docs/CreateAutomaticTokensForwardingRbTokenDataEthereumToken.md)
 - [CreateAutomaticTokensForwardingRi](docs/CreateAutomaticTokensForwardingRi.md)
 - [CreateAutomaticTokensForwardingRits](docs/CreateAutomaticTokensForwardingRits.md)
 - [CreateAutomaticTokensForwardingRitsbot](docs/CreateAutomaticTokensForwardingRitsbot.md)
 - [CreateAutomaticTokensForwardingRitset](docs/CreateAutomaticTokensForwardingRitset.md)
 - [CreateCoinsTransactionRequestFromAddressR](docs/CreateCoinsTransactionRequestFromAddressR.md)
 - [CreateCoinsTransactionRequestFromAddressRData](docs/CreateCoinsTransactionRequestFromAddressRData.md)
 - [CreateCoinsTransactionRequestFromAddressRb](docs/CreateCoinsTransactionRequestFromAddressRb.md)
 - [CreateCoinsTransactionRequestFromAddressRbData](docs/CreateCoinsTransactionRequestFromAddressRbData.md)
 - [CreateCoinsTransactionRequestFromAddressRbDataItem](docs/CreateCoinsTransactionRequestFromAddressRbDataItem.md)
 - [CreateCoinsTransactionRequestFromAddressRi](docs/CreateCoinsTransactionRequestFromAddressRi.md)
 - [CreateCoinsTransactionRequestFromAddressRiRecipients](docs/CreateCoinsTransactionRequestFromAddressRiRecipients.md)
 - [CreateCoinsTransactionRequestFromAddressRiSenders](docs/CreateCoinsTransactionRequestFromAddressRiSenders.md)
 - [CreateCoinsTransactionRequestFromWalletR](docs/CreateCoinsTransactionRequestFromWalletR.md)
 - [CreateCoinsTransactionRequestFromWalletRData](docs/CreateCoinsTransactionRequestFromWalletRData.md)
 - [CreateCoinsTransactionRequestFromWalletRb](docs/CreateCoinsTransactionRequestFromWalletRb.md)
 - [CreateCoinsTransactionRequestFromWalletRbData](docs/CreateCoinsTransactionRequestFromWalletRbData.md)
 - [CreateCoinsTransactionRequestFromWalletRbDataItem](docs/CreateCoinsTransactionRequestFromWalletRbDataItem.md)
 - [CreateCoinsTransactionRequestFromWalletRbDataItemDestinations](docs/CreateCoinsTransactionRequestFromWalletRbDataItemDestinations.md)
 - [CreateCoinsTransactionRequestFromWalletRi](docs/CreateCoinsTransactionRequestFromWalletRi.md)
 - [CreateCoinsTransactionRequestFromWalletRiRecipients](docs/CreateCoinsTransactionRequestFromWalletRiRecipients.md)
 - [CreateTokensTransactionRequestFromAddressR](docs/CreateTokensTransactionRequestFromAddressR.md)
 - [CreateTokensTransactionRequestFromAddressRData](docs/CreateTokensTransactionRequestFromAddressRData.md)
 - [CreateTokensTransactionRequestFromAddressRb](docs/CreateTokensTransactionRequestFromAddressRb.md)
 - [CreateTokensTransactionRequestFromAddressRbData](docs/CreateTokensTransactionRequestFromAddressRbData.md)
 - [CreateTokensTransactionRequestFromAddressRbDataItem](docs/CreateTokensTransactionRequestFromAddressRbDataItem.md)
 - [CreateTokensTransactionRequestFromAddressRi](docs/CreateTokensTransactionRequestFromAddressRi.md)
 - [CreateTokensTransactionRequestFromAddressRiRecipients](docs/CreateTokensTransactionRequestFromAddressRiRecipients.md)
 - [CreateTokensTransactionRequestFromAddressRiSenders](docs/CreateTokensTransactionRequestFromAddressRiSenders.md)
 - [CreateTokensTransactionRequestFromAddressRiTokenTypeSpecificData](docs/CreateTokensTransactionRequestFromAddressRiTokenTypeSpecificData.md)
 - [CreateTokensTransactionRequestFromAddressRiTokenTypeSpecificDataBitcoinOmniToken](docs/CreateTokensTransactionRequestFromAddressRiTokenTypeSpecificDataBitcoinOmniToken.md)
 - [CreateTokensTransactionRequestFromAddressRiTokenTypeSpecificDataEthereumErc20Token](docs/CreateTokensTransactionRequestFromAddressRiTokenTypeSpecificDataEthereumErc20Token.md)
 - [DeleteAutomaticCoinsForwardingR](docs/DeleteAutomaticCoinsForwardingR.md)
 - [DeleteAutomaticCoinsForwardingRData](docs/DeleteAutomaticCoinsForwardingRData.md)
 - [DeleteAutomaticCoinsForwardingRi](docs/DeleteAutomaticCoinsForwardingRi.md)
 - [DeleteAutomaticTokensForwardingR](docs/DeleteAutomaticTokensForwardingR.md)
 - [DeleteAutomaticTokensForwardingRData](docs/DeleteAutomaticTokensForwardingRData.md)
 - [DeleteAutomaticTokensForwardingRi](docs/DeleteAutomaticTokensForwardingRi.md)
 - [DeleteAutomaticTokensForwardingRits](docs/DeleteAutomaticTokensForwardingRits.md)
 - [DeleteAutomaticTokensForwardingRitsbot](docs/DeleteAutomaticTokensForwardingRitsbot.md)
 - [DeleteAutomaticTokensForwardingRitset](docs/DeleteAutomaticTokensForwardingRitset.md)
 - [DeleteBlockchainEventSubscriptionR](docs/DeleteBlockchainEventSubscriptionR.md)
 - [DeleteBlockchainEventSubscriptionRData](docs/DeleteBlockchainEventSubscriptionRData.md)
 - [DeleteBlockchainEventSubscriptionRi](docs/DeleteBlockchainEventSubscriptionRi.md)
 - [EndpointNotAllowedForApiKey](docs/EndpointNotAllowedForApiKey.md)
 - [EndpointNotAllowedForApiKeyError](docs/EndpointNotAllowedForApiKeyError.md)
 - [EndpointNotAllowedForPlan](docs/EndpointNotAllowedForPlan.md)
 - [EndpointNotAllowedForPlanError](docs/EndpointNotAllowedForPlanError.md)
 - [FeatureMainnetsNotAllowedForPlan](docs/FeatureMainnetsNotAllowedForPlan.md)
 - [FeatureMainnetsNotAllowedForPlanError](docs/FeatureMainnetsNotAllowedForPlanError.md)
 - [GenerateReceivingAddressR](docs/GenerateReceivingAddressR.md)
 - [GenerateReceivingAddressRData](docs/GenerateReceivingAddressRData.md)
 - [GenerateReceivingAddressRb](docs/GenerateReceivingAddressRb.md)
 - [GenerateReceivingAddressRbData](docs/GenerateReceivingAddressRbData.md)
 - [GenerateReceivingAddressRbDataItem](docs/GenerateReceivingAddressRbDataItem.md)
 - [GenerateReceivingAddressRi](docs/GenerateReceivingAddressRi.md)
 - [GetAddressDetailsR](docs/GetAddressDetailsR.md)
 - [GetAddressDetailsRData](docs/GetAddressDetailsRData.md)
 - [GetAddressDetailsRi](docs/GetAddressDetailsRi.md)
 - [GetAddressDetailsRiConfirmedBalance](docs/GetAddressDetailsRiConfirmedBalance.md)
 - [GetAddressDetailsRiTotalReceived](docs/GetAddressDetailsRiTotalReceived.md)
 - [GetAddressDetailsRiTotalSpent](docs/GetAddressDetailsRiTotalSpent.md)
 - [GetBlockDetailsByBlockHashR](docs/GetBlockDetailsByBlockHashR.md)
 - [GetBlockDetailsByBlockHashRData](docs/GetBlockDetailsByBlockHashRData.md)
 - [GetBlockDetailsByBlockHashRi](docs/GetBlockDetailsByBlockHashRi.md)
 - [GetBlockDetailsByBlockHashRibs](docs/GetBlockDetailsByBlockHashRibs.md)
 - [GetBlockDetailsByBlockHashRibsb](docs/GetBlockDetailsByBlockHashRibsb.md)
 - [GetBlockDetailsByBlockHashRibsbc](docs/GetBlockDetailsByBlockHashRibsbc.md)
 - [GetBlockDetailsByBlockHashRibsd](docs/GetBlockDetailsByBlockHashRibsd.md)
 - [GetBlockDetailsByBlockHashRibsd2](docs/GetBlockDetailsByBlockHashRibsd2.md)
 - [GetBlockDetailsByBlockHashRibse](docs/GetBlockDetailsByBlockHashRibse.md)
 - [GetBlockDetailsByBlockHashRibsec](docs/GetBlockDetailsByBlockHashRibsec.md)
 - [GetBlockDetailsByBlockHashRibsl](docs/GetBlockDetailsByBlockHashRibsl.md)
 - [GetBlockDetailsByBlockHeightR](docs/GetBlockDetailsByBlockHeightR.md)
 - [GetBlockDetailsByBlockHeightRData](docs/GetBlockDetailsByBlockHeightRData.md)
 - [GetBlockDetailsByBlockHeightRi](docs/GetBlockDetailsByBlockHeightRi.md)
 - [GetBlockDetailsByBlockHeightRibs](docs/GetBlockDetailsByBlockHeightRibs.md)
 - [GetBlockDetailsByBlockHeightRibsb](docs/GetBlockDetailsByBlockHeightRibsb.md)
 - [GetBlockDetailsByBlockHeightRibsbc](docs/GetBlockDetailsByBlockHeightRibsbc.md)
 - [GetBlockDetailsByBlockHeightRibsd](docs/GetBlockDetailsByBlockHeightRibsd.md)
 - [GetBlockDetailsByBlockHeightRibsd2](docs/GetBlockDetailsByBlockHeightRibsd2.md)
 - [GetBlockDetailsByBlockHeightRibse](docs/GetBlockDetailsByBlockHeightRibse.md)
 - [GetBlockDetailsByBlockHeightRibsec](docs/GetBlockDetailsByBlockHeightRibsec.md)
 - [GetBlockDetailsByBlockHeightRibsl](docs/GetBlockDetailsByBlockHeightRibsl.md)
 - [GetContractDetailsByAddressR](docs/GetContractDetailsByAddressR.md)
 - [GetContractDetailsByAddressRData](docs/GetContractDetailsByAddressRData.md)
 - [GetContractDetailsByAddressRi](docs/GetContractDetailsByAddressRi.md)
 - [GetExchangeRateByAssetSymbolsR](docs/GetExchangeRateByAssetSymbolsR.md)
 - [GetExchangeRateByAssetSymbolsRData](docs/GetExchangeRateByAssetSymbolsRData.md)
 - [GetExchangeRateByAssetSymbolsRi](docs/GetExchangeRateByAssetSymbolsRi.md)
 - [GetExchangeRateByAssetsIdsR](docs/GetExchangeRateByAssetsIdsR.md)
 - [GetExchangeRateByAssetsIdsRData](docs/GetExchangeRateByAssetsIdsRData.md)
 - [GetExchangeRateByAssetsIdsRi](docs/GetExchangeRateByAssetsIdsRi.md)
 - [GetFeeAddressDetailsR](docs/GetFeeAddressDetailsR.md)
 - [GetFeeAddressDetailsRData](docs/GetFeeAddressDetailsRData.md)
 - [GetFeeAddressDetailsRi](docs/GetFeeAddressDetailsRi.md)
 - [GetFeeAddressDetailsRiBalance](docs/GetFeeAddressDetailsRiBalance.md)
 - [GetFeeRecommendationsR](docs/GetFeeRecommendationsR.md)
 - [GetFeeRecommendationsRData](docs/GetFeeRecommendationsRData.md)
 - [GetFeeRecommendationsRi](docs/GetFeeRecommendationsRi.md)
 - [GetHdWalletXPubYPubZPubDetailsR](docs/GetHdWalletXPubYPubZPubDetailsR.md)
 - [GetHdWalletXPubYPubZPubDetailsRData](docs/GetHdWalletXPubYPubZPubDetailsRData.md)
 - [GetHdWalletXPubYPubZPubDetailsRi](docs/GetHdWalletXPubYPubZPubDetailsRi.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdR](docs/GetInternalTransactionByTransactionHashAndOperationIdR.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRData](docs/GetInternalTransactionByTransactionHashAndOperationIdRData.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRi](docs/GetInternalTransactionByTransactionHashAndOperationIdRi.md)
 - [GetLatestMinedBlockR](docs/GetLatestMinedBlockR.md)
 - [GetLatestMinedBlockRData](docs/GetLatestMinedBlockRData.md)
 - [GetLatestMinedBlockRi](docs/GetLatestMinedBlockRi.md)
 - [GetLatestMinedBlockRibs](docs/GetLatestMinedBlockRibs.md)
 - [GetLatestMinedBlockRibsb](docs/GetLatestMinedBlockRibsb.md)
 - [GetLatestMinedBlockRibsbc](docs/GetLatestMinedBlockRibsbc.md)
 - [GetLatestMinedBlockRibsd](docs/GetLatestMinedBlockRibsd.md)
 - [GetLatestMinedBlockRibsd2](docs/GetLatestMinedBlockRibsd2.md)
 - [GetLatestMinedBlockRibse](docs/GetLatestMinedBlockRibse.md)
 - [GetLatestMinedBlockRibsec](docs/GetLatestMinedBlockRibsec.md)
 - [GetLatestMinedBlockRibsl](docs/GetLatestMinedBlockRibsl.md)
 - [GetLatestMinedXrpRippleBlockR](docs/GetLatestMinedXrpRippleBlockR.md)
 - [GetLatestMinedXrpRippleBlockRData](docs/GetLatestMinedXrpRippleBlockRData.md)
 - [GetLatestMinedXrpRippleBlockRi](docs/GetLatestMinedXrpRippleBlockRi.md)
 - [GetLatestMinedXrpRippleBlockRiTotalCoins](docs/GetLatestMinedXrpRippleBlockRiTotalCoins.md)
 - [GetLatestMinedXrpRippleBlockRiTotalFees](docs/GetLatestMinedXrpRippleBlockRiTotalFees.md)
 - [GetLatestMinedZilliqaBlockR](docs/GetLatestMinedZilliqaBlockR.md)
 - [GetLatestMinedZilliqaBlockRData](docs/GetLatestMinedZilliqaBlockRData.md)
 - [GetLatestMinedZilliqaBlockRi](docs/GetLatestMinedZilliqaBlockRi.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidR](docs/GetOmniTransactionDetailsByTransactionIdTxidR.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRData](docs/GetOmniTransactionDetailsByTransactionIdTxidRData.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRi](docs/GetOmniTransactionDetailsByTransactionIdTxidRi.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidRiSenders](docs/GetOmniTransactionDetailsByTransactionIdTxidRiSenders.md)
 - [GetTransactionDetailsByTransactionIdr](docs/GetTransactionDetailsByTransactionIdr.md)
 - [GetTransactionDetailsByTransactionIdrData](docs/GetTransactionDetailsByTransactionIdrData.md)
 - [GetTransactionDetailsByTransactionIdri](docs/GetTransactionDetailsByTransactionIdri.md)
 - [GetTransactionDetailsByTransactionIdriFee](docs/GetTransactionDetailsByTransactionIdriFee.md)
 - [GetTransactionDetailsByTransactionIdriRecipients](docs/GetTransactionDetailsByTransactionIdriRecipients.md)
 - [GetTransactionDetailsByTransactionIdriSenders](docs/GetTransactionDetailsByTransactionIdriSenders.md)
 - [GetTransactionDetailsByTransactionIdribs](docs/GetTransactionDetailsByTransactionIdribs.md)
 - [GetTransactionDetailsByTransactionIdribsb](docs/GetTransactionDetailsByTransactionIdribsb.md)
 - [GetTransactionDetailsByTransactionIdribsbScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsbScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsbScriptSig](docs/GetTransactionDetailsByTransactionIdribsbScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsbVin](docs/GetTransactionDetailsByTransactionIdribsbVin.md)
 - [GetTransactionDetailsByTransactionIdribsbVout](docs/GetTransactionDetailsByTransactionIdribsbVout.md)
 - [GetTransactionDetailsByTransactionIdribsbc](docs/GetTransactionDetailsByTransactionIdribsbc.md)
 - [GetTransactionDetailsByTransactionIdribsbcScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsbcScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsbcVin](docs/GetTransactionDetailsByTransactionIdribsbcVin.md)
 - [GetTransactionDetailsByTransactionIdribsbcVout](docs/GetTransactionDetailsByTransactionIdribsbcVout.md)
 - [GetTransactionDetailsByTransactionIdribsd](docs/GetTransactionDetailsByTransactionIdribsd.md)
 - [GetTransactionDetailsByTransactionIdribsd2](docs/GetTransactionDetailsByTransactionIdribsd2.md)
 - [GetTransactionDetailsByTransactionIdribsd2ScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsd2ScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsd2ScriptSig](docs/GetTransactionDetailsByTransactionIdribsd2ScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsd2Vin](docs/GetTransactionDetailsByTransactionIdribsd2Vin.md)
 - [GetTransactionDetailsByTransactionIdribsd2Vout](docs/GetTransactionDetailsByTransactionIdribsd2Vout.md)
 - [GetTransactionDetailsByTransactionIdribsdScriptPubKey](docs/GetTransactionDetailsByTransactionIdribsdScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribsdScriptSig](docs/GetTransactionDetailsByTransactionIdribsdScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribsdVin](docs/GetTransactionDetailsByTransactionIdribsdVin.md)
 - [GetTransactionDetailsByTransactionIdribsdVout](docs/GetTransactionDetailsByTransactionIdribsdVout.md)
 - [GetTransactionDetailsByTransactionIdribse](docs/GetTransactionDetailsByTransactionIdribse.md)
 - [GetTransactionDetailsByTransactionIdribseGasPrice](docs/GetTransactionDetailsByTransactionIdribseGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsec](docs/GetTransactionDetailsByTransactionIdribsec.md)
 - [GetTransactionDetailsByTransactionIdribsecGasPrice](docs/GetTransactionDetailsByTransactionIdribsecGasPrice.md)
 - [GetTransactionDetailsByTransactionIdribsl](docs/GetTransactionDetailsByTransactionIdribsl.md)
 - [GetTransactionDetailsByTransactionIdribslScriptPubKey](docs/GetTransactionDetailsByTransactionIdribslScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdribslScriptSig](docs/GetTransactionDetailsByTransactionIdribslScriptSig.md)
 - [GetTransactionDetailsByTransactionIdribslVin](docs/GetTransactionDetailsByTransactionIdribslVin.md)
 - [GetTransactionDetailsByTransactionIdribslVout](docs/GetTransactionDetailsByTransactionIdribslVout.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidR](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidR.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRData](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRData.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRi](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRi.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRiRecipients](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRiRecipients.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidRiSenders](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidRiSenders.md)
 - [GetWalletAssetDetailsR](docs/GetWalletAssetDetailsR.md)
 - [GetWalletAssetDetailsRData](docs/GetWalletAssetDetailsRData.md)
 - [GetWalletAssetDetailsRi](docs/GetWalletAssetDetailsRi.md)
 - [GetWalletAssetDetailsRiConfirmedBalance](docs/GetWalletAssetDetailsRiConfirmedBalance.md)
 - [GetWalletAssetDetailsRiRecievedConfirmedAmount](docs/GetWalletAssetDetailsRiRecievedConfirmedAmount.md)
 - [GetWalletAssetDetailsRiSentConfirmedAmount](docs/GetWalletAssetDetailsRiSentConfirmedAmount.md)
 - [GetXrpRippleAddressDetailsR](docs/GetXrpRippleAddressDetailsR.md)
 - [GetXrpRippleAddressDetailsRData](docs/GetXrpRippleAddressDetailsRData.md)
 - [GetXrpRippleAddressDetailsRi](docs/GetXrpRippleAddressDetailsRi.md)
 - [GetXrpRippleAddressDetailsRiBalance](docs/GetXrpRippleAddressDetailsRiBalance.md)
 - [GetXrpRippleBlockDetailsByBlockHashR](docs/GetXrpRippleBlockDetailsByBlockHashR.md)
 - [GetXrpRippleBlockDetailsByBlockHashRData](docs/GetXrpRippleBlockDetailsByBlockHashRData.md)
 - [GetXrpRippleBlockDetailsByBlockHashRi](docs/GetXrpRippleBlockDetailsByBlockHashRi.md)
 - [GetXrpRippleBlockDetailsByBlockHashRiTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHashRiTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightR](docs/GetXrpRippleBlockDetailsByBlockHeightR.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRData](docs/GetXrpRippleBlockDetailsByBlockHeightRData.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRi](docs/GetXrpRippleBlockDetailsByBlockHeightRi.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRiTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHeightRiTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightRiTotalFees](docs/GetXrpRippleBlockDetailsByBlockHeightRiTotalFees.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdr](docs/GetXrpRippleTransactionDetailsByTransactionIdr.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdrData](docs/GetXrpRippleTransactionDetailsByTransactionIdrData.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdri](docs/GetXrpRippleTransactionDetailsByTransactionIdri.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriFee](docs/GetXrpRippleTransactionDetailsByTransactionIdriFee.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriOffer](docs/GetXrpRippleTransactionDetailsByTransactionIdriOffer.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriReceive](docs/GetXrpRippleTransactionDetailsByTransactionIdriReceive.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriRecipients](docs/GetXrpRippleTransactionDetailsByTransactionIdriRecipients.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriSenders](docs/GetXrpRippleTransactionDetailsByTransactionIdriSenders.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdriValue](docs/GetXrpRippleTransactionDetailsByTransactionIdriValue.md)
 - [GetZilliqaAddressDetailsR](docs/GetZilliqaAddressDetailsR.md)
 - [GetZilliqaAddressDetailsRData](docs/GetZilliqaAddressDetailsRData.md)
 - [GetZilliqaAddressDetailsRi](docs/GetZilliqaAddressDetailsRi.md)
 - [GetZilliqaAddressDetailsRiBalance](docs/GetZilliqaAddressDetailsRiBalance.md)
 - [GetZilliqaBlockDetailsByBlockHashR](docs/GetZilliqaBlockDetailsByBlockHashR.md)
 - [GetZilliqaBlockDetailsByBlockHashRData](docs/GetZilliqaBlockDetailsByBlockHashRData.md)
 - [GetZilliqaBlockDetailsByBlockHashRi](docs/GetZilliqaBlockDetailsByBlockHashRi.md)
 - [GetZilliqaBlockDetailsByBlockHeightR](docs/GetZilliqaBlockDetailsByBlockHeightR.md)
 - [GetZilliqaBlockDetailsByBlockHeightRData](docs/GetZilliqaBlockDetailsByBlockHeightRData.md)
 - [GetZilliqaBlockDetailsByBlockHeightRi](docs/GetZilliqaBlockDetailsByBlockHeightRi.md)
 - [GetZilliqaTransactionDetailsByTransactionIdr](docs/GetZilliqaTransactionDetailsByTransactionIdr.md)
 - [GetZilliqaTransactionDetailsByTransactionIdrData](docs/GetZilliqaTransactionDetailsByTransactionIdrData.md)
 - [GetZilliqaTransactionDetailsByTransactionIdri](docs/GetZilliqaTransactionDetailsByTransactionIdri.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriFee](docs/GetZilliqaTransactionDetailsByTransactionIdriFee.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriRecipients](docs/GetZilliqaTransactionDetailsByTransactionIdriRecipients.md)
 - [GetZilliqaTransactionDetailsByTransactionIdriSenders](docs/GetZilliqaTransactionDetailsByTransactionIdriSenders.md)
 - [InsufficientCredits](docs/InsufficientCredits.md)
 - [InsufficientCreditsError](docs/InsufficientCreditsError.md)
 - [InvalidApiKey](docs/InvalidApiKey.md)
 - [InvalidApiKeyError](docs/InvalidApiKeyError.md)
 - [InvalidBlockchain](docs/InvalidBlockchain.md)
 - [InvalidBlockchainError](docs/InvalidBlockchainError.md)
 - [InvalidData](docs/InvalidData.md)
 - [InvalidDataError](docs/InvalidDataError.md)
 - [InvalidNetwork](docs/InvalidNetwork.md)
 - [InvalidNetworkError](docs/InvalidNetworkError.md)
 - [InvalidPagination](docs/InvalidPagination.md)
 - [InvalidPaginationError](docs/InvalidPaginationError.md)
 - [InvalidRequestBodyStructure](docs/InvalidRequestBodyStructure.md)
 - [InvalidRequestBodyStructureError](docs/InvalidRequestBodyStructureError.md)
 - [InvalidXpub](docs/InvalidXpub.md)
 - [InvalidXpubError](docs/InvalidXpubError.md)
 - [LimitGreaterThanAllowed](docs/LimitGreaterThanAllowed.md)
 - [LimitGreaterThanAllowedError](docs/LimitGreaterThanAllowedError.md)
 - [ListAssetsDetailsR](docs/ListAssetsDetailsR.md)
 - [ListAssetsDetailsRData](docs/ListAssetsDetailsRData.md)
 - [ListAssetsDetailsRi](docs/ListAssetsDetailsRi.md)
 - [ListAssetsDetailsRiAssetLogo](docs/ListAssetsDetailsRiAssetLogo.md)
 - [ListAssetsDetailsRiLatestRate](docs/ListAssetsDetailsRiLatestRate.md)
 - [ListAssetsDetailsRiSpecificData](docs/ListAssetsDetailsRiSpecificData.md)
 - [ListAssetsDetailsRiSpecificDataCryptoTypeData](docs/ListAssetsDetailsRiSpecificDataCryptoTypeData.md)
 - [ListBlockchainEventsSubscriptionsR](docs/ListBlockchainEventsSubscriptionsR.md)
 - [ListBlockchainEventsSubscriptionsRData](docs/ListBlockchainEventsSubscriptionsRData.md)
 - [ListBlockchainEventsSubscriptionsRi](docs/ListBlockchainEventsSubscriptionsRi.md)
 - [ListCoinsForwardingAutomationsR](docs/ListCoinsForwardingAutomationsR.md)
 - [ListCoinsForwardingAutomationsRData](docs/ListCoinsForwardingAutomationsRData.md)
 - [ListCoinsForwardingAutomationsRi](docs/ListCoinsForwardingAutomationsRi.md)
 - [ListHdWalletXPubYPubZPubTransactionsR](docs/ListHdWalletXPubYPubZPubTransactionsR.md)
 - [ListHdWalletXPubYPubZPubTransactionsRData](docs/ListHdWalletXPubYPubZPubTransactionsRData.md)
 - [ListHdWalletXPubYPubZPubTransactionsRi](docs/ListHdWalletXPubYPubZPubTransactionsRi.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiFee](docs/ListHdWalletXPubYPubZPubTransactionsRiFee.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiRecipients](docs/ListHdWalletXPubYPubZPubTransactionsRiRecipients.md)
 - [ListHdWalletXPubYPubZPubTransactionsRiSenders](docs/ListHdWalletXPubYPubZPubTransactionsRiSenders.md)
 - [ListInternalTransactionDetailsByTransactionHashR](docs/ListInternalTransactionDetailsByTransactionHashR.md)
 - [ListInternalTransactionDetailsByTransactionHashRData](docs/ListInternalTransactionDetailsByTransactionHashRData.md)
 - [ListInternalTransactionDetailsByTransactionHashRi](docs/ListInternalTransactionDetailsByTransactionHashRi.md)
 - [ListOmniTokensByAddressR](docs/ListOmniTokensByAddressR.md)
 - [ListOmniTokensByAddressRData](docs/ListOmniTokensByAddressRData.md)
 - [ListOmniTokensByAddressRi](docs/ListOmniTokensByAddressRi.md)
 - [ListOmniTransactionsByAddressR](docs/ListOmniTransactionsByAddressR.md)
 - [ListOmniTransactionsByAddressRData](docs/ListOmniTransactionsByAddressRData.md)
 - [ListOmniTransactionsByAddressRi](docs/ListOmniTransactionsByAddressRi.md)
 - [ListOmniTransactionsByAddressRiFee](docs/ListOmniTransactionsByAddressRiFee.md)
 - [ListOmniTransactionsByAddressRiRecipients](docs/ListOmniTransactionsByAddressRiRecipients.md)
 - [ListOmniTransactionsByAddressRiSenders](docs/ListOmniTransactionsByAddressRiSenders.md)
 - [ListOmniTransactionsByBlockHashR](docs/ListOmniTransactionsByBlockHashR.md)
 - [ListOmniTransactionsByBlockHashRData](docs/ListOmniTransactionsByBlockHashRData.md)
 - [ListOmniTransactionsByBlockHashRi](docs/ListOmniTransactionsByBlockHashRi.md)
 - [ListOmniTransactionsByBlockHashRiFee](docs/ListOmniTransactionsByBlockHashRiFee.md)
 - [ListOmniTransactionsByBlockHeightR](docs/ListOmniTransactionsByBlockHeightR.md)
 - [ListOmniTransactionsByBlockHeightRData](docs/ListOmniTransactionsByBlockHeightRData.md)
 - [ListOmniTransactionsByBlockHeightRi](docs/ListOmniTransactionsByBlockHeightRi.md)
 - [ListOmniTransactionsByBlockHeightRiFee](docs/ListOmniTransactionsByBlockHeightRiFee.md)
 - [ListOmniTransactionsByBlockHeightRiRecipients](docs/ListOmniTransactionsByBlockHeightRiRecipients.md)
 - [ListOmniTransactionsByBlockHeightRiSenders](docs/ListOmniTransactionsByBlockHeightRiSenders.md)
 - [ListReceivingAddressesR](docs/ListReceivingAddressesR.md)
 - [ListReceivingAddressesRData](docs/ListReceivingAddressesRData.md)
 - [ListReceivingAddressesRi](docs/ListReceivingAddressesRi.md)
 - [ListSupportedAssetsR](docs/ListSupportedAssetsR.md)
 - [ListSupportedAssetsRData](docs/ListSupportedAssetsRData.md)
 - [ListSupportedAssetsRi](docs/ListSupportedAssetsRi.md)
 - [ListSupportedTokensR](docs/ListSupportedTokensR.md)
 - [ListSupportedTokensRData](docs/ListSupportedTokensRData.md)
 - [ListSupportedTokensRi](docs/ListSupportedTokensRi.md)
 - [ListTokensByAddressR](docs/ListTokensByAddressR.md)
 - [ListTokensByAddressRData](docs/ListTokensByAddressRData.md)
 - [ListTokensByAddressRi](docs/ListTokensByAddressRi.md)
 - [ListTokensForwardingAutomationsR](docs/ListTokensForwardingAutomationsR.md)
 - [ListTokensForwardingAutomationsRData](docs/ListTokensForwardingAutomationsRData.md)
 - [ListTokensForwardingAutomationsRi](docs/ListTokensForwardingAutomationsRi.md)
 - [ListTokensForwardingAutomationsRits](docs/ListTokensForwardingAutomationsRits.md)
 - [ListTokensForwardingAutomationsRitsbot](docs/ListTokensForwardingAutomationsRitsbot.md)
 - [ListTokensForwardingAutomationsRitset](docs/ListTokensForwardingAutomationsRitset.md)
 - [ListTokensTransfersByAddressR](docs/ListTokensTransfersByAddressR.md)
 - [ListTokensTransfersByAddressRData](docs/ListTokensTransfersByAddressRData.md)
 - [ListTokensTransfersByAddressRi](docs/ListTokensTransfersByAddressRi.md)
 - [ListTokensTransfersByTransactionHashR](docs/ListTokensTransfersByTransactionHashR.md)
 - [ListTokensTransfersByTransactionHashRData](docs/ListTokensTransfersByTransactionHashRData.md)
 - [ListTokensTransfersByTransactionHashRi](docs/ListTokensTransfersByTransactionHashRi.md)
 - [ListTransactionsByAddressR](docs/ListTransactionsByAddressR.md)
 - [ListTransactionsByAddressRData](docs/ListTransactionsByAddressRData.md)
 - [ListTransactionsByAddressRi](docs/ListTransactionsByAddressRi.md)
 - [ListTransactionsByAddressRibs](docs/ListTransactionsByAddressRibs.md)
 - [ListTransactionsByAddressRibsb](docs/ListTransactionsByAddressRibsb.md)
 - [ListTransactionsByAddressRibsbScriptPubKey](docs/ListTransactionsByAddressRibsbScriptPubKey.md)
 - [ListTransactionsByAddressRibsbVin](docs/ListTransactionsByAddressRibsbVin.md)
 - [ListTransactionsByAddressRibsbVout](docs/ListTransactionsByAddressRibsbVout.md)
 - [ListTransactionsByAddressRibsbc](docs/ListTransactionsByAddressRibsbc.md)
 - [ListTransactionsByAddressRibsbcVin](docs/ListTransactionsByAddressRibsbcVin.md)
 - [ListTransactionsByAddressRibsd](docs/ListTransactionsByAddressRibsd.md)
 - [ListTransactionsByAddressRibsd2](docs/ListTransactionsByAddressRibsd2.md)
 - [ListTransactionsByAddressRibsd2ScriptPubKey](docs/ListTransactionsByAddressRibsd2ScriptPubKey.md)
 - [ListTransactionsByAddressRibsd2ScriptSig](docs/ListTransactionsByAddressRibsd2ScriptSig.md)
 - [ListTransactionsByAddressRibsd2Vin](docs/ListTransactionsByAddressRibsd2Vin.md)
 - [ListTransactionsByAddressRibsd2Vout](docs/ListTransactionsByAddressRibsd2Vout.md)
 - [ListTransactionsByAddressRibsdScriptSig](docs/ListTransactionsByAddressRibsdScriptSig.md)
 - [ListTransactionsByAddressRibsdVin](docs/ListTransactionsByAddressRibsdVin.md)
 - [ListTransactionsByAddressRibse](docs/ListTransactionsByAddressRibse.md)
 - [ListTransactionsByAddressRibseGasPrice](docs/ListTransactionsByAddressRibseGasPrice.md)
 - [ListTransactionsByAddressRibsec](docs/ListTransactionsByAddressRibsec.md)
 - [ListTransactionsByAddressRibsecGasPrice](docs/ListTransactionsByAddressRibsecGasPrice.md)
 - [ListTransactionsByAddressRibsl](docs/ListTransactionsByAddressRibsl.md)
 - [ListTransactionsByAddressRibslScriptSig](docs/ListTransactionsByAddressRibslScriptSig.md)
 - [ListTransactionsByAddressRibslVin](docs/ListTransactionsByAddressRibslVin.md)
 - [ListTransactionsByBlockHashR](docs/ListTransactionsByBlockHashR.md)
 - [ListTransactionsByBlockHashRData](docs/ListTransactionsByBlockHashRData.md)
 - [ListTransactionsByBlockHashRi](docs/ListTransactionsByBlockHashRi.md)
 - [ListTransactionsByBlockHashRiFee](docs/ListTransactionsByBlockHashRiFee.md)
 - [ListTransactionsByBlockHashRiRecipients](docs/ListTransactionsByBlockHashRiRecipients.md)
 - [ListTransactionsByBlockHashRiSenders](docs/ListTransactionsByBlockHashRiSenders.md)
 - [ListTransactionsByBlockHashRibs](docs/ListTransactionsByBlockHashRibs.md)
 - [ListTransactionsByBlockHashRibsb](docs/ListTransactionsByBlockHashRibsb.md)
 - [ListTransactionsByBlockHashRibsbVin](docs/ListTransactionsByBlockHashRibsbVin.md)
 - [ListTransactionsByBlockHashRibsbc](docs/ListTransactionsByBlockHashRibsbc.md)
 - [ListTransactionsByBlockHashRibsbcScriptPubKey](docs/ListTransactionsByBlockHashRibsbcScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsbcVin](docs/ListTransactionsByBlockHashRibsbcVin.md)
 - [ListTransactionsByBlockHashRibsbcVout](docs/ListTransactionsByBlockHashRibsbcVout.md)
 - [ListTransactionsByBlockHashRibsd](docs/ListTransactionsByBlockHashRibsd.md)
 - [ListTransactionsByBlockHashRibsd2](docs/ListTransactionsByBlockHashRibsd2.md)
 - [ListTransactionsByBlockHashRibsd2ScriptPubKey](docs/ListTransactionsByBlockHashRibsd2ScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsd2ScriptSig](docs/ListTransactionsByBlockHashRibsd2ScriptSig.md)
 - [ListTransactionsByBlockHashRibsd2Vin](docs/ListTransactionsByBlockHashRibsd2Vin.md)
 - [ListTransactionsByBlockHashRibsd2Vout](docs/ListTransactionsByBlockHashRibsd2Vout.md)
 - [ListTransactionsByBlockHashRibsdScriptPubKey](docs/ListTransactionsByBlockHashRibsdScriptPubKey.md)
 - [ListTransactionsByBlockHashRibsdVin](docs/ListTransactionsByBlockHashRibsdVin.md)
 - [ListTransactionsByBlockHashRibsdVout](docs/ListTransactionsByBlockHashRibsdVout.md)
 - [ListTransactionsByBlockHashRibse](docs/ListTransactionsByBlockHashRibse.md)
 - [ListTransactionsByBlockHashRibseGasPrice](docs/ListTransactionsByBlockHashRibseGasPrice.md)
 - [ListTransactionsByBlockHashRibsec](docs/ListTransactionsByBlockHashRibsec.md)
 - [ListTransactionsByBlockHashRibsl](docs/ListTransactionsByBlockHashRibsl.md)
 - [ListTransactionsByBlockHashRibslScriptPubKey](docs/ListTransactionsByBlockHashRibslScriptPubKey.md)
 - [ListTransactionsByBlockHashRibslVin](docs/ListTransactionsByBlockHashRibslVin.md)
 - [ListTransactionsByBlockHashRibslVout](docs/ListTransactionsByBlockHashRibslVout.md)
 - [ListTransactionsByBlockHeightR](docs/ListTransactionsByBlockHeightR.md)
 - [ListTransactionsByBlockHeightRData](docs/ListTransactionsByBlockHeightRData.md)
 - [ListTransactionsByBlockHeightRi](docs/ListTransactionsByBlockHeightRi.md)
 - [ListTransactionsByBlockHeightRiFee](docs/ListTransactionsByBlockHeightRiFee.md)
 - [ListTransactionsByBlockHeightRibs](docs/ListTransactionsByBlockHeightRibs.md)
 - [ListTransactionsByBlockHeightRibsb](docs/ListTransactionsByBlockHeightRibsb.md)
 - [ListTransactionsByBlockHeightRibsbScriptPubKey](docs/ListTransactionsByBlockHeightRibsbScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibsbVout](docs/ListTransactionsByBlockHeightRibsbVout.md)
 - [ListTransactionsByBlockHeightRibsbc](docs/ListTransactionsByBlockHeightRibsbc.md)
 - [ListTransactionsByBlockHeightRibsd](docs/ListTransactionsByBlockHeightRibsd.md)
 - [ListTransactionsByBlockHeightRibsd2](docs/ListTransactionsByBlockHeightRibsd2.md)
 - [ListTransactionsByBlockHeightRibsd2Vin](docs/ListTransactionsByBlockHeightRibsd2Vin.md)
 - [ListTransactionsByBlockHeightRibsdScriptPubKey](docs/ListTransactionsByBlockHeightRibsdScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibsdScriptSig](docs/ListTransactionsByBlockHeightRibsdScriptSig.md)
 - [ListTransactionsByBlockHeightRibsdVin](docs/ListTransactionsByBlockHeightRibsdVin.md)
 - [ListTransactionsByBlockHeightRibsdVout](docs/ListTransactionsByBlockHeightRibsdVout.md)
 - [ListTransactionsByBlockHeightRibse](docs/ListTransactionsByBlockHeightRibse.md)
 - [ListTransactionsByBlockHeightRibsec](docs/ListTransactionsByBlockHeightRibsec.md)
 - [ListTransactionsByBlockHeightRibsecGasPrice](docs/ListTransactionsByBlockHeightRibsecGasPrice.md)
 - [ListTransactionsByBlockHeightRibsl](docs/ListTransactionsByBlockHeightRibsl.md)
 - [ListTransactionsByBlockHeightRibslScriptPubKey](docs/ListTransactionsByBlockHeightRibslScriptPubKey.md)
 - [ListTransactionsByBlockHeightRibslScriptSig](docs/ListTransactionsByBlockHeightRibslScriptSig.md)
 - [ListTransactionsByBlockHeightRibslVin](docs/ListTransactionsByBlockHeightRibslVin.md)
 - [ListTransactionsByBlockHeightRibslVout](docs/ListTransactionsByBlockHeightRibslVout.md)
 - [ListUnconfirmedOmniTransactionsByAddressR](docs/ListUnconfirmedOmniTransactionsByAddressR.md)
 - [ListUnconfirmedOmniTransactionsByAddressRData](docs/ListUnconfirmedOmniTransactionsByAddressRData.md)
 - [ListUnconfirmedOmniTransactionsByAddressRi](docs/ListUnconfirmedOmniTransactionsByAddressRi.md)
 - [ListUnconfirmedOmniTransactionsByAddressRiFee](docs/ListUnconfirmedOmniTransactionsByAddressRiFee.md)
 - [ListUnconfirmedOmniTransactionsByAddressRiSenders](docs/ListUnconfirmedOmniTransactionsByAddressRiSenders.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdr](docs/ListUnconfirmedOmniTransactionsByPropertyIdr.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdrData](docs/ListUnconfirmedOmniTransactionsByPropertyIdrData.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdri](docs/ListUnconfirmedOmniTransactionsByPropertyIdri.md)
 - [ListXrpRippleTransactionsByAddressR](docs/ListXrpRippleTransactionsByAddressR.md)
 - [ListXrpRippleTransactionsByAddressRData](docs/ListXrpRippleTransactionsByAddressRData.md)
 - [ListXrpRippleTransactionsByAddressRi](docs/ListXrpRippleTransactionsByAddressRi.md)
 - [ListXrpRippleTransactionsByAddressRiFee](docs/ListXrpRippleTransactionsByAddressRiFee.md)
 - [ListXrpRippleTransactionsByAddressRiOffer](docs/ListXrpRippleTransactionsByAddressRiOffer.md)
 - [ListXrpRippleTransactionsByAddressRiReceive](docs/ListXrpRippleTransactionsByAddressRiReceive.md)
 - [ListXrpRippleTransactionsByAddressRiValue](docs/ListXrpRippleTransactionsByAddressRiValue.md)
 - [ListXrpRippleTransactionsByBlockHashR](docs/ListXrpRippleTransactionsByBlockHashR.md)
 - [ListXrpRippleTransactionsByBlockHashRData](docs/ListXrpRippleTransactionsByBlockHashRData.md)
 - [ListXrpRippleTransactionsByBlockHashRi](docs/ListXrpRippleTransactionsByBlockHashRi.md)
 - [ListXrpRippleTransactionsByBlockHashRiFee](docs/ListXrpRippleTransactionsByBlockHashRiFee.md)
 - [ListXrpRippleTransactionsByBlockHashRiOffer](docs/ListXrpRippleTransactionsByBlockHashRiOffer.md)
 - [ListXrpRippleTransactionsByBlockHashRiReceive](docs/ListXrpRippleTransactionsByBlockHashRiReceive.md)
 - [ListXrpRippleTransactionsByBlockHashRiRecipients](docs/ListXrpRippleTransactionsByBlockHashRiRecipients.md)
 - [ListXrpRippleTransactionsByBlockHashRiSenders](docs/ListXrpRippleTransactionsByBlockHashRiSenders.md)
 - [ListXrpRippleTransactionsByBlockHashRiValue](docs/ListXrpRippleTransactionsByBlockHashRiValue.md)
 - [ListXrpRippleTransactionsByBlockHeightR](docs/ListXrpRippleTransactionsByBlockHeightR.md)
 - [ListXrpRippleTransactionsByBlockHeightRData](docs/ListXrpRippleTransactionsByBlockHeightRData.md)
 - [ListXrpRippleTransactionsByBlockHeightRi](docs/ListXrpRippleTransactionsByBlockHeightRi.md)
 - [ListXrpRippleTransactionsByBlockHeightRiFee](docs/ListXrpRippleTransactionsByBlockHeightRiFee.md)
 - [ListXrpRippleTransactionsByBlockHeightRiOffer](docs/ListXrpRippleTransactionsByBlockHeightRiOffer.md)
 - [ListXrpRippleTransactionsByBlockHeightRiReceive](docs/ListXrpRippleTransactionsByBlockHeightRiReceive.md)
 - [ListXrpRippleTransactionsByBlockHeightRiRecipients](docs/ListXrpRippleTransactionsByBlockHeightRiRecipients.md)
 - [ListXrpRippleTransactionsByBlockHeightRiSenders](docs/ListXrpRippleTransactionsByBlockHeightRiSenders.md)
 - [ListXrpRippleTransactionsByBlockHeightRiValue](docs/ListXrpRippleTransactionsByBlockHeightRiValue.md)
 - [ListZilliqaTransactionsByAddressR](docs/ListZilliqaTransactionsByAddressR.md)
 - [ListZilliqaTransactionsByAddressRData](docs/ListZilliqaTransactionsByAddressRData.md)
 - [ListZilliqaTransactionsByAddressRi](docs/ListZilliqaTransactionsByAddressRi.md)
 - [ListZilliqaTransactionsByAddressRiRecipients](docs/ListZilliqaTransactionsByAddressRiRecipients.md)
 - [ListZilliqaTransactionsByAddressRiSenders](docs/ListZilliqaTransactionsByAddressRiSenders.md)
 - [ListZilliqaTransactionsByBlockHashR](docs/ListZilliqaTransactionsByBlockHashR.md)
 - [ListZilliqaTransactionsByBlockHashRData](docs/ListZilliqaTransactionsByBlockHashRData.md)
 - [ListZilliqaTransactionsByBlockHashRi](docs/ListZilliqaTransactionsByBlockHashRi.md)
 - [ListZilliqaTransactionsByBlockHeightR](docs/ListZilliqaTransactionsByBlockHeightR.md)
 - [ListZilliqaTransactionsByBlockHeightRData](docs/ListZilliqaTransactionsByBlockHeightRData.md)
 - [ListZilliqaTransactionsByBlockHeightRi](docs/ListZilliqaTransactionsByBlockHeightRi.md)
 - [MinedTransactionR](docs/MinedTransactionR.md)
 - [MinedTransactionRData](docs/MinedTransactionRData.md)
 - [MinedTransactionRb](docs/MinedTransactionRb.md)
 - [MinedTransactionRbData](docs/MinedTransactionRbData.md)
 - [MinedTransactionRbDataItem](docs/MinedTransactionRbDataItem.md)
 - [MinedTransactionRi](docs/MinedTransactionRi.md)
 - [MissingApiKey](docs/MissingApiKey.md)
 - [MissingApiKeyError](docs/MissingApiKeyError.md)
 - [NewBlockR](docs/NewBlockR.md)
 - [NewBlockRData](docs/NewBlockRData.md)
 - [NewBlockRb](docs/NewBlockRb.md)
 - [NewBlockRbData](docs/NewBlockRbData.md)
 - [NewBlockRbDataItem](docs/NewBlockRbDataItem.md)
 - [NewBlockRi](docs/NewBlockRi.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationR](docs/NewConfirmedCoinsTransactionsAndEachConfirmationR.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRb](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRbData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRi](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedCoinsTransactionsR](docs/NewConfirmedCoinsTransactionsR.md)
 - [NewConfirmedCoinsTransactionsRData](docs/NewConfirmedCoinsTransactionsRData.md)
 - [NewConfirmedCoinsTransactionsRb](docs/NewConfirmedCoinsTransactionsRb.md)
 - [NewConfirmedCoinsTransactionsRbData](docs/NewConfirmedCoinsTransactionsRbData.md)
 - [NewConfirmedCoinsTransactionsRbDataItem](docs/NewConfirmedCoinsTransactionsRbDataItem.md)
 - [NewConfirmedCoinsTransactionsRi](docs/NewConfirmedCoinsTransactionsRi.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationR](docs/NewConfirmedInternalTransactionsAndEachConfirmationR.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRb](docs/NewConfirmedInternalTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRbData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedInternalTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRi](docs/NewConfirmedInternalTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedInternalTransactionsR](docs/NewConfirmedInternalTransactionsR.md)
 - [NewConfirmedInternalTransactionsRData](docs/NewConfirmedInternalTransactionsRData.md)
 - [NewConfirmedInternalTransactionsRb](docs/NewConfirmedInternalTransactionsRb.md)
 - [NewConfirmedInternalTransactionsRbData](docs/NewConfirmedInternalTransactionsRbData.md)
 - [NewConfirmedInternalTransactionsRbDataItem](docs/NewConfirmedInternalTransactionsRbDataItem.md)
 - [NewConfirmedInternalTransactionsRi](docs/NewConfirmedInternalTransactionsRi.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationR](docs/NewConfirmedTokensTransactionsAndEachConfirmationR.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRb](docs/NewConfirmedTokensTransactionsAndEachConfirmationRb.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRbData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRbData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRbDataItem](docs/NewConfirmedTokensTransactionsAndEachConfirmationRbDataItem.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRi](docs/NewConfirmedTokensTransactionsAndEachConfirmationRi.md)
 - [NewConfirmedTokensTransactionsR](docs/NewConfirmedTokensTransactionsR.md)
 - [NewConfirmedTokensTransactionsRData](docs/NewConfirmedTokensTransactionsRData.md)
 - [NewConfirmedTokensTransactionsRb](docs/NewConfirmedTokensTransactionsRb.md)
 - [NewConfirmedTokensTransactionsRi](docs/NewConfirmedTokensTransactionsRi.md)
 - [NewUnconfirmedCoinsTransactionsR](docs/NewUnconfirmedCoinsTransactionsR.md)
 - [NewUnconfirmedCoinsTransactionsRData](docs/NewUnconfirmedCoinsTransactionsRData.md)
 - [NewUnconfirmedCoinsTransactionsRb](docs/NewUnconfirmedCoinsTransactionsRb.md)
 - [NewUnconfirmedCoinsTransactionsRbData](docs/NewUnconfirmedCoinsTransactionsRbData.md)
 - [NewUnconfirmedCoinsTransactionsRbDataItem](docs/NewUnconfirmedCoinsTransactionsRbDataItem.md)
 - [NewUnconfirmedCoinsTransactionsRi](docs/NewUnconfirmedCoinsTransactionsRi.md)
 - [NewUnconfirmedTokensTransactionsR](docs/NewUnconfirmedTokensTransactionsR.md)
 - [NewUnconfirmedTokensTransactionsRData](docs/NewUnconfirmedTokensTransactionsRData.md)
 - [NewUnconfirmedTokensTransactionsRb](docs/NewUnconfirmedTokensTransactionsRb.md)
 - [NewUnconfirmedTokensTransactionsRbData](docs/NewUnconfirmedTokensTransactionsRbData.md)
 - [NewUnconfirmedTokensTransactionsRbDataItem](docs/NewUnconfirmedTokensTransactionsRbDataItem.md)
 - [NewUnconfirmedTokensTransactionsRi](docs/NewUnconfirmedTokensTransactionsRi.md)
 - [RequestLimitReached](docs/RequestLimitReached.md)
 - [RequestLimitReachedError](docs/RequestLimitReachedError.md)
 - [ResourceNotFound](docs/ResourceNotFound.md)
 - [ResourceNotFoundError](docs/ResourceNotFoundError.md)
 - [SyncHdWalletXPubYPubZPubR](docs/SyncHdWalletXPubYPubZPubR.md)
 - [SyncHdWalletXPubYPubZPubRData](docs/SyncHdWalletXPubYPubZPubRData.md)
 - [SyncHdWalletXPubYPubZPubRb](docs/SyncHdWalletXPubYPubZPubRb.md)
 - [SyncHdWalletXPubYPubZPubRbData](docs/SyncHdWalletXPubYPubZPubRbData.md)
 - [SyncHdWalletXPubYPubZPubRbDataItem](docs/SyncHdWalletXPubYPubZPubRbDataItem.md)
 - [SyncHdWalletXPubYPubZPubRi](docs/SyncHdWalletXPubYPubZPubRi.md)
 - [TokensForwardingAutomationsLimitReached](docs/TokensForwardingAutomationsLimitReached.md)
 - [TokensForwardingAutomationsLimitReachedError](docs/TokensForwardingAutomationsLimitReachedError.md)
 - [TokensForwardingFail](docs/TokensForwardingFail.md)
 - [TokensForwardingFailData](docs/TokensForwardingFailData.md)
 - [TokensForwardingFailDataItem](docs/TokensForwardingFailDataItem.md)
 - [TokensForwardingSuccess](docs/TokensForwardingSuccess.md)
 - [TokensForwardingSuccessData](docs/TokensForwardingSuccessData.md)
 - [TokensForwardingSuccessDataItem](docs/TokensForwardingSuccessDataItem.md)
 - [TokensForwardingSuccessEthereumerc20token](docs/TokensForwardingSuccessEthereumerc20token.md)
 - [TokensForwardingSuccessEthereumerc721token](docs/TokensForwardingSuccessEthereumerc721token.md)
 - [TokensForwardingSuccessOmnilayertoken](docs/TokensForwardingSuccessOmnilayertoken.md)
 - [TokensForwardingSuccessToken](docs/TokensForwardingSuccessToken.md)
 - [TransactionMined](docs/TransactionMined.md)
 - [TransactionMinedData](docs/TransactionMinedData.md)
 - [TransactionMinedDataItem](docs/TransactionMinedDataItem.md)
 - [TransactionMinedDataItemMinedInBlock](docs/TransactionMinedDataItemMinedInBlock.md)
 - [TransactionRequestApprove](docs/TransactionRequestApprove.md)
 - [TransactionRequestApproveData](docs/TransactionRequestApproveData.md)
 - [TransactionRequestApproveDataItem](docs/TransactionRequestApproveDataItem.md)
 - [TransactionRequestBroadcasted](docs/TransactionRequestBroadcasted.md)
 - [TransactionRequestBroadcastedData](docs/TransactionRequestBroadcastedData.md)
 - [TransactionRequestBroadcastedDataItem](docs/TransactionRequestBroadcastedDataItem.md)
 - [TransactionRequestMined](docs/TransactionRequestMined.md)
 - [TransactionRequestMinedData](docs/TransactionRequestMinedData.md)
 - [TransactionRequestReject](docs/TransactionRequestReject.md)
 - [TransactionRequestRejectData](docs/TransactionRequestRejectData.md)
 - [TransactionRequestRejectDataItem](docs/TransactionRequestRejectDataItem.md)
 - [UnexpectedServerError](docs/UnexpectedServerError.md)
 - [UnexpectedServerErrorError](docs/UnexpectedServerErrorError.md)
 - [UnsupportedMediaType](docs/UnsupportedMediaType.md)
 - [UnsupportedMediaTypeError](docs/UnsupportedMediaTypeError.md)
 - [UriNotFound](docs/UriNotFound.md)
 - [UriNotFoundError](docs/UriNotFoundError.md)
 - [ValidateAddressR](docs/ValidateAddressR.md)
 - [ValidateAddressRData](docs/ValidateAddressRData.md)
 - [ValidateAddressRb](docs/ValidateAddressRb.md)
 - [ValidateAddressRbData](docs/ValidateAddressRbData.md)
 - [ValidateAddressRbDataItem](docs/ValidateAddressRbDataItem.md)
 - [ValidateAddressRi](docs/ValidateAddressRi.md)
 - [WalletAsAServiceDepositAddressesLimitReached](docs/WalletAsAServiceDepositAddressesLimitReached.md)
 - [WalletAsAServiceDepositAddressesLimitReachedError](docs/WalletAsAServiceDepositAddressesLimitReachedError.md)
 - [WalletAsAServiceNoDepositAddressesFound](docs/WalletAsAServiceNoDepositAddressesFound.md)
 - [WalletAsAServiceNoDepositAddressesFoundError](docs/WalletAsAServiceNoDepositAddressesFoundError.md)
 - [WalletAsAServiceTokenNotSupported](docs/WalletAsAServiceTokenNotSupported.md)
 - [WalletAsAServiceTokenNotSupportedError](docs/WalletAsAServiceTokenNotSupportedError.md)
 - [WalletAsAServiceWalletBalanceNotEnough](docs/WalletAsAServiceWalletBalanceNotEnough.md)
 - [WalletAsAServiceWalletBalanceNotEnoughError](docs/WalletAsAServiceWalletBalanceNotEnoughError.md)
 - [XpubNotSynced](docs/XpubNotSynced.md)
 - [XpubNotSyncedError](docs/XpubNotSyncedError.md)
 - [XpubSyncInProgress](docs/XpubSyncInProgress.md)
 - [XpubSyncInProgressError](docs/XpubSyncInProgressError.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

developers@cryptoapis.io

