/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NewConfirmedTokensTransactionsAndEachConfirmationResponseItem {
    /// Represents the address of the transaction, per which the result is returned.
    #[serde(rename = "address")]
    pub address: String,
    /// Represents the URL that is set by the customer where the callback will be received at. The callback notification will be received only if and when the event occurs.
    #[serde(rename = "callbackUrl")]
    pub callback_url: String,
    /// Defines the specific time/date when the subscription was created in Unix Timestamp.
    #[serde(rename = "createdTimestamp")]
    pub created_timestamp: i32,
    /// Defines the type of the specific event available for the customer to subscribe to for callback notification.
    #[serde(rename = "eventType")]
    pub event_type: String,
    /// Represents a unique ID used to reference the specific callback subscription.
    #[serde(rename = "referenceId")]
    pub reference_id: String,
}

impl NewConfirmedTokensTransactionsAndEachConfirmationResponseItem {
    pub fn new(address: String, callback_url: String, created_timestamp: i32, event_type: String, reference_id: String) -> NewConfirmedTokensTransactionsAndEachConfirmationResponseItem {
        NewConfirmedTokensTransactionsAndEachConfirmationResponseItem {
            address,
            callback_url,
            created_timestamp,
            event_type,
            reference_id,
        }
    }
}


