/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListTokensByAddressResponseItem {
    /// Defines the token balance that has been confirmed.
    #[serde(rename = "confirmedBalance")]
    pub confirmed_balance: String,
    /// Represents the contract address of the token, which controls its logic. It is not the address that holds the tokens.
    #[serde(rename = "contractAddress")]
    pub contract_address: String,
    /// Defines the token's name as a string.
    #[serde(rename = "name")]
    pub name: String,
    /// Defines the token symbol by which the token contract is known. It is usually 3-4 characters in length.
    #[serde(rename = "symbol")]
    pub symbol: String,
    /// Defines the specific token type.
    #[serde(rename = "type")]
    pub _type: String,
}

impl ListTokensByAddressResponseItem {
    pub fn new(confirmed_balance: String, contract_address: String, name: String, symbol: String, _type: String) -> ListTokensByAddressResponseItem {
        ListTokensByAddressResponseItem {
            confirmed_balance,
            contract_address,
            name,
            symbol,
            _type,
        }
    }
}


